/***** This code was generated by Yaggo. Do not edit ******/

#ifndef __HASH_FASTQ_MERGE_ARGS_HPP__
#define __HASH_FASTQ_MERGE_ARGS_HPP__

#include <jellyfish/yaggo.hpp>

class hash_fastq_merge_args {
public:
  uint64_t                       size_arg;
  bool                           size_given;
  uint32_t                       mer_len_arg;
  bool                           mer_len_given;
  const char *                   output_arg;
  bool                           output_given;
  uint32_t                       reprobes_arg;
  bool                           reprobes_given;
  uint64_t                       out_buffer_size_arg;
  bool                           out_buffer_size_given;
  std::vector<const char *>      db_arg;
  typedef std::vector<const char *>::iterator db_arg_it;
  typedef std::vector<const char *>::const_iterator db_arg_const_it;

  enum {
    USAGE_OPT = 1000,
    FULL_HELP_OPT,
    OUT_BUFFER_SIZE_OPT
  };

  hash_fastq_merge_args() : 
    size_arg(), size_given(false),
    mer_len_arg(), mer_len_given(false),
    output_arg("merged.jf"), output_given(false),
    reprobes_arg(62), reprobes_given(false),
    out_buffer_size_arg(20000000), out_buffer_size_given(false)
  { }

  hash_fastq_merge_args(int argc, char* argv[]) :
    size_arg(), size_given(false),
    mer_len_arg(), mer_len_given(false),
    output_arg("merged.jf"), output_given(false),
    reprobes_arg(62), reprobes_given(false),
    out_buffer_size_arg(20000000), out_buffer_size_given(false)
  { parse(argc, argv); }

  void parse(int argc, char* argv[]) {
    static struct option long_options[] = {
      {"size", 1, 0, 's'},
      {"mer-len", 1, 0, 'm'},
      {"output", 1, 0, 'o'},
      {"reprobes", 1, 0, 'p'},
      {"out-buffer-size", 1, 0, OUT_BUFFER_SIZE_OPT},
      {"help", 0, 0, 'h'},
      {"full-help", 0, 0, FULL_HELP_OPT},
      {"usage", 0, 0, USAGE_OPT},
      {"version", 0, 0, 'V'},
      {0, 0, 0, 0}
    };
    static const char *short_options = "hVs:m:o:p:";

    std::string err;
#define CHECK_ERR(type,val,which) if(!err.empty()) { std::cerr << "Invalid " #type " '" << val << "' for [" which "]: " << err << "\n"; exit(1); }
    while(true) { 
      int index = -1;
      int c = getopt_long(argc, argv, short_options, long_options, &index);
      if(c == -1) break;
      switch(c) {
      case ':': 
        std::cerr << "Missing required argument for "
                  << (index == -1 ? std::string(1, (char)optopt) : std::string(long_options[index].name))
                  << std::endl;
        exit(1);
      case 'h':
        std::cout << usage() << "\n\n" << help() << std::endl;
        exit(0);
      case USAGE_OPT:
        std::cout << usage() << "\nUse --help for more information." << std::endl;
        exit(0);
      case 'V':
        print_version();
        exit(0);
      case '?':
        std::cerr << "Use --usage or --help for some help\n";
        exit(1);
      case FULL_HELP_OPT:
        std::cout << usage() << "\n\n" << help() << "\n\n" << hidden() << std::endl;
        exit(0);
      case 's':
        size_given = true;
        size_arg = yaggo::conv_uint<uint64_t>((const char *)optarg, err, false);
        CHECK_ERR(uint64_t, optarg, "-s, --size=uint64")
        break;
      case 'm':
        mer_len_given = true;
        mer_len_arg = yaggo::conv_uint<uint32_t>((const char *)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-m, --mer-len=uint32")
        break;
      case 'o':
        output_given = true;
        output_arg = optarg;
        break;
      case 'p':
        reprobes_given = true;
        reprobes_arg = yaggo::conv_uint<uint32_t>((const char *)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-p, --reprobes=uint32")
        break;
      case OUT_BUFFER_SIZE_OPT:
        out_buffer_size_given = true;
        out_buffer_size_arg = yaggo::conv_uint<uint64_t>((const char *)optarg, err, false);
        CHECK_ERR(uint64_t, optarg, "    --out-buffer-size=uint64")
        break;
      }
    }

    // Check that required switches are present
    if(!size_given)
      error("[-s, --size=uint64] required switch");
    if(!mer_len_given)
      error("[-m, --mer-len=uint32] required switch");

    // Parse arguments
    if(argc - optind < 2)
      error("Requires at least 2 arguments.");
    for( ; optind < argc; ++optind) {
      db_arg.push_back(argv[optind]);
    }
  }

#define hash_fastq_merge_args_USAGE "Usage: jellyfish merge [options] db:string+"
  const char * usage() const { return hash_fastq_merge_args_USAGE; }
  void error(const char *msg) { 
    std::cerr << "Error: " << msg << "\n" << usage()
              << "\nUse --help for more information"
              << std::endl;
    exit(1);
  }

#define hash_fastq_merge_args_HELP "Merge quake databases\n\n" \
  "Options (default value in (), *required):\n" \
  " -s, --size=uint64                       *Merged hash table size\n" \
  " -m, --mer-len=uint32                    *Mer length\n" \
  " -o, --output=string                      Output file (merged.jf)\n" \
  " -p, --reprobes=uint32                    Maximum number of reprobes (62)\n" \
  "     --usage                              Usage\n" \
  " -h, --help                               This message\n" \
  "     --full-help                          Detailed help\n" \
  " -V, --version                            Version"

  const char * help() const { return hash_fastq_merge_args_HELP; }
#define hash_fastq_merge_args_HIDDEN "Hidden options:\n" \
  "     --out-buffer-size=uint64             Size of output buffer per thread (20000000)"

  const char * hidden() const { return hash_fastq_merge_args_HIDDEN; }
  void print_version(std::ostream &os = std::cout) const {
#ifndef PACKAGE_VERSION
#define PACKAGE_VERSION "0.0.0"
#endif
    os << PACKAGE_VERSION << "\n";
  }
  void dump(std::ostream &os = std::cout) {
    os << "size_given:" << size_given << " size_arg:" << size_arg << "\n";
    os << "mer_len_given:" << mer_len_given << " mer_len_arg:" << mer_len_arg << "\n";
    os << "output_given:" << output_given << " output_arg:" << output_arg << "\n";
    os << "reprobes_given:" << reprobes_given << " reprobes_arg:" << reprobes_arg << "\n";
    os << "out_buffer_size_given:" << out_buffer_size_given << " out_buffer_size_arg:" << out_buffer_size_arg << "\n";
    os << "db_arg:" << yaggo::vec_str(db_arg) << "\n";
  }
private:
};

#endif // __HASH_FASTQ_MERGE_ARGS_HPP__"
