/* $Id$
 *
 * Copyright (C) 2009 Sippy Software, Inc., http://www.sippysoft.com
 *
 * This file is part of SIP-Router, a free SIP server.
 *
 * SIP-Router is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * SIP-Router is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#ifndef _PYTHON_SUPPORT_H
#define  _PYTHON_SUPPORT_H

#include <Python.h>
#include <stdarg.h>

PyObject *format_exc_obj;

void python_handle_exception(const char *, ...);
char *make_message(const char *fmt, ...);

PyObject *InitTracebackModule(void);
char *get_class_name(PyObject *);
char *get_instance_class_name(PyObject *);

#endif
