/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "client_home.h"

ClientHome::ClientHome(QTextEdit *textBrowser, QList<RemoteComputerInfo*> clientsList)
    : textEdit(textBrowser), remote_info_list(clientsList)
{
    image = new QLabel(this);
    resolver = new DnsResolver();
    this->setAttribute(
            Qt::WA_TranslucentBackground, false);

    groupBox = new QGroupBox(tr("Host information"), this);
    QGridLayout *gridBox = new QGridLayout;
#ifdef WIN32
    QFont font("Arial", 8, true);
    image->setPixmap(QPixmap(":/images/windows-computer.png"));
    QString os = QString("Microsoft Windows");
#elif defined __APPLE__
    QFont font = QFont();
    image->setPixmap(QPixmap(":/images/mac-computer.png"));
    QString os = QString("Mac OS X");
#else
    QFont font("Arial", 10, true);
    image->setPixmap(QPixmap(":/images/linux-computer.png"));
    QString os = QString("GNU/Linux based OS");
#endif
    groupBox->setFont(font);
    int cpt = 1;
    foreach(QNetworkInterface interface, QNetworkInterface::allInterfaces()) {
        if (interface.flags().testFlag(QNetworkInterface::IsRunning))
            foreach (QNetworkAddressEntry entry, interface.addressEntries()) {
            if ( interface.hardwareAddress() != "00:00:00:00:00:00" &&     entry.ip().toString().contains(".")) {
                cpt ++;
                QLabel *adressLabel = new QLabel(interface.name() + " : " + entry.ip().toString());
                adressLabel->setFont(font);
                gridBox->addWidget(adressLabel, cpt, 0);
            }
        }
    }
    textEdit->resize(QSize(250, 300));

    QPushButton *dnsButton = new QPushButton(tr("DNS Resolver"));
    dnsButton->setIcon(QIcon(":/images/dns.png"));
    dnsButton->setMinimumHeight(40);

    addComputerButton = new QPushButton(tr("Connect computer"));
    addComputerButton->setIcon(QIcon(":/images/add.png"));
    addComputerButton->setMinimumHeight(40);

    QLabel *os_label = new QLabel(os);
    os_label->setFont(font);
    gridBox->addWidget(image, 0, 0);
    gridBox->addWidget(os_label, 1, 0);
    gridBox->addWidget(new QLabel("", this), cpt++, 0);
    gridBox->addWidget(addComputerButton, cpt++, 0);
    gridBox->addWidget(dnsButton, cpt++, 0);
    gridBox->addWidget(new QLabel("", this), cpt++, 0);
    gridBox->addWidget(new QLabel("", this), cpt++, 0);
    gridBox->addWidget(new QLabel("", this), cpt++, 0);
    groupBox->setLayout(gridBox);

    list = new QListView;
    this->refreshCLientsList(remote_info_list);

    QSplitter *splitter_left = new QSplitter(this);
    splitter_left->addWidget(textEdit);
    splitter_left->addWidget(list);
    splitter_left->setOrientation(Qt::Vertical);
    splitter_left->setStretchFactor(1, 75);

    QSplitter *splitter = new QSplitter(this);
    splitter->addWidget(groupBox);
    splitter->addWidget(splitter_left);
    splitter->setStretchFactor(1, 25);

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(splitter);
    setLayout(layout);

    connect(list, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(doubleClicSelection()));
    connect(dnsButton, SIGNAL(clicked()), this, SLOT(showDNSResolver()));
}

void ClientHome::showDNSResolver()
{
    resolver->exec();
}

void ClientHome::doubleClicSelection()
{
    QItemSelectionModel *selection = list->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)list->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    QString selectedDocument = elementSelectionne.toString();
    QStringList list = selectedDocument.split(DELIMITER_DATABASE);
    if (list.size() == 4)
        emit connect_remote_clients(list.at(1), list.at(2), list.at(3));
}

void ClientHome::refreshCLientsList(QList<RemoteComputerInfo*> remote_info_list)
{
    QStandardItemModel *model = new QStandardItemModel(this);
    for (int k = 0; k < remote_info_list.size(); k++) {
        RemoteComputerInfo *remoteInfo = remote_info_list.at(k);
        QStandardItem *item = new QStandardItem(remoteInfo->hostname + "    " + remoteInfo->ip + "    " + QString::number(remoteInfo->port) + "    " + QString::number(remoteInfo->port_file));
        if (remoteInfo->system.startsWith(QString(LINUX), Qt::CaseSensitive)) {
            item->setIcon(QIcon(":/images/linux.png"));
        } else if (remoteInfo->system.startsWith(WINDOWS, Qt::CaseSensitive)) {
            item->setIcon(QIcon(":/images/windows.png"));
        } else if (remoteInfo->system.startsWith(MACOSX, Qt::CaseSensitive)) {
            item->setIcon(QIcon(":/images/finder.png"));
        } else {
            item->setIcon(QIcon(":/images/linux.png"));
        }
        item->setEditable(false);
        model->appendRow(item);
    }
    if (remote_info_list.isEmpty()) {
        QStandardItem *item = new QStandardItem(tr("Any remote computer in the database"));
        item->setEditable(false);
        model->appendRow(item);
    }
    list->setModel(model);
    list->setIconSize(QSize(22, 22));
}

