
module Lambdabot.Plugin.Dummy.DocAssocs (docAssocs) where

import qualified Data.Map as M
import qualified Data.ByteString.Char8 as P

-- pack all these strings

base :: P.ByteString
base = P.pack "base"
stm :: P.ByteString
stm  = P.pack "stm"
mtl :: P.ByteString
mtl  = P.pack "mtl"
fgl :: P.ByteString
fgl  = P.pack "fgl"
qc  :: P.ByteString
qc   = P.pack "QuickCheck"
hunit  :: P.ByteString
hunit = P.pack "bytestring"
parsec  :: P.ByteString
parsec = P.pack "parsec"
unix  :: P.ByteString
unix   = P.pack "unix"
haskeline :: P.ByteString
haskeline = P.pack "haskeline"
network :: P.ByteString
network  = P.pack "network"
th :: P.ByteString
th       = P.pack "template-haskell"
hs :: P.ByteString
hs       = P.pack "1"
cabal :: P.ByteString
cabal    = P.pack "Cabal"
hgl :: P.ByteString
hgl      = P.pack "3"
glut :: P.ByteString
glut     = P.pack "GLUT"
x11 :: P.ByteString
x11      = P.pack "3"
opengl :: P.ByteString
opengl   = P.pack "OpenGL"
containers :: P.ByteString
containers = P.pack "containers"

docAssocs :: M.Map P.ByteString P.ByteString
docAssocs = {-# SCC "Dummy.DocAssocs" #-} M.fromList [
  (P.pack "control.arrow", base),
  (P.pack "control.concurrent", base),
  (P.pack "control.concurrent.chan", base),
  (P.pack "control.concurrent.mvar", base),
  (P.pack "control.concurrent.qsem", base),
  (P.pack "control.concurrent.qsemn", base),
  (P.pack "control.concurrent.stm", stm),
  (P.pack "control.concurrent.stm.tchan", stm),
  (P.pack "control.concurrent.stm.tmvar", stm),
  (P.pack "control.concurrent.stm.tvar", stm),
  (P.pack "control.concurrent.samplevar", base),
  (P.pack "control.exception", base),
  (P.pack "control.monad", base),
  (P.pack "control.monad.cont", mtl),
  (P.pack "control.monad.error", mtl),
  (P.pack "control.monad.fix", base),
  (P.pack "control.monad.identity", mtl),
  (P.pack "control.monad.list", mtl),
  (P.pack "control.monad.rws", mtl),
  (P.pack "control.monad.reader", mtl),
  (P.pack "control.monad.st", base),
  (P.pack "control.monad.st.lazy", base),
  (P.pack "control.monad.st.strict", base),
  (P.pack "control.monad.state", mtl),
  (P.pack "control.monad.trans", mtl),
  (P.pack "control.monad.writer", mtl),
  (P.pack "control.parallel", base),
  (P.pack "control.parallel.strategies", base),
  (P.pack "data.array", base),
  (P.pack "data.array.diff", base),
  (P.pack "data.array.iarray", base),
  (P.pack "data.array.io", base),
  (P.pack "data.array.marray", base),
  (P.pack "data.array.st", base),
  (P.pack "data.array.storable", base),
  (P.pack "data.array.unboxed", base),
  (P.pack "data.bits", base),
  (P.pack "data.bool", base),
  (P.pack "data.char", base),
  (P.pack "data.complex", base),
  (P.pack "data.dynamic", base),
  (P.pack "data.either", base),
  (P.pack "data.finitemap", base),
  (P.pack "data.functorm", base),
  (P.pack "data.generics", base),
  (P.pack "data.generics.aliases", base),
  (P.pack "data.generics.basics", base),
  (P.pack "data.generics.instances", base),
  (P.pack "data.generics.schemes", base),
  (P.pack "data.generics.text", base),
  (P.pack "data.generics.twins", base),
  (P.pack "data.graph", containers),
  (P.pack "data.graph.inductive", fgl),
  (P.pack "data.graph.inductive.basic", fgl),
  (P.pack "data.graph.inductive.example", fgl),
  (P.pack "data.graph.inductive.graph", fgl),
  (P.pack "data.graph.inductive.graphviz", fgl),
  (P.pack "data.graph.inductive.internal.finitemap", fgl),
  (P.pack "data.graph.inductive.internal.heap", fgl),
  (P.pack "data.graph.inductive.internal.queue", fgl),
  (P.pack "data.graph.inductive.internal.rootpath", fgl),
  (P.pack "data.graph.inductive.internal.thread", fgl),
  (P.pack "data.graph.inductive.monad", fgl),
  (P.pack "data.graph.inductive.monad.ioarray", fgl),
  (P.pack "data.graph.inductive.nodemap", fgl),
  (P.pack "data.graph.inductive.query", fgl),
  (P.pack "data.graph.inductive.query.artpoint", fgl),
  (P.pack "data.graph.inductive.query.bcc", fgl),
  (P.pack "data.graph.inductive.query.bfs", fgl),
  (P.pack "data.graph.inductive.query.dfs", fgl),
  (P.pack "data.graph.inductive.query.dominators", fgl),
  (P.pack "data.graph.inductive.query.gvd", fgl),
  (P.pack "data.graph.inductive.query.indep", fgl),
  (P.pack "data.graph.inductive.query.mst", fgl),
  (P.pack "data.graph.inductive.query.maxflow", fgl),
  (P.pack "data.graph.inductive.query.maxflow2", fgl),
  (P.pack "data.graph.inductive.query.monad", fgl),
  (P.pack "data.graph.inductive.query.sp", fgl),
  (P.pack "data.graph.inductive.query.transclos", fgl),
  (P.pack "data.graph.inductive.tree", fgl),
  (P.pack "data.hashtable", base),
  (P.pack "data.ioref", base),
  (P.pack "data.int", base),
  (P.pack "data.intmap", containers),
  (P.pack "data.intset", containers),
  (P.pack "data.ix", base),
  (P.pack "data.list", base),
  (P.pack "data.map", containers),
  (P.pack "data.maybe", base),
  (P.pack "data.monoid", base),
  (P.pack "data.packedstring", base),
  (P.pack "data.queue", base),
  (P.pack "data.ratio", base),
  (P.pack "data.stref", base),
  (P.pack "data.stref.lazy", base),
  (P.pack "data.stref.strict", base),
  (P.pack "data.sequence", containers),
  (P.pack "data.set", containers),
  (P.pack "data.tree", containers),
  (P.pack "data.tuple", base),
  (P.pack "data.typeable", base),
  (P.pack "data.unique", base),
  (P.pack "data.version", base),
  (P.pack "data.word", base),
  (P.pack "debug.quickcheck", qc),
  (P.pack "debug.quickcheck.batch", qc),
  (P.pack "debug.quickcheck.poly", qc),
  (P.pack "debug.quickcheck.utils", qc),
  (P.pack "debug.trace", base),
  (P.pack "distribution.compat.directory", cabal),
  (P.pack "distribution.compat.exception", cabal),
  (P.pack "distribution.compat.filepath", cabal),
  (P.pack "distribution.compat.rawsystem", cabal),
  (P.pack "distribution.compat.readp", cabal),
  (P.pack "distribution.extension", cabal),
  (P.pack "distribution.getopt", cabal),
  (P.pack "distribution.installedpackageinfo", cabal),
  (P.pack "distribution.license", cabal),
  (P.pack "distribution.make", cabal),
  (P.pack "distribution.package", cabal),
  (P.pack "distribution.packagedescription", cabal),
  (P.pack "distribution.preprocess", cabal),
  (P.pack "distribution.preprocess.unlit", cabal),
  (P.pack "distribution.setup", cabal),
  (P.pack "distribution.simple", cabal),
  (P.pack "distribution.simple.build", cabal),
  (P.pack "distribution.simple.configure", cabal),
  (P.pack "distribution.simple.ghcpackageconfig", cabal),
  (P.pack "distribution.simple.install", cabal),
  (P.pack "distribution.simple.localbuildinfo", cabal),
  (P.pack "distribution.simple.register", cabal),
  (P.pack "distribution.simple.srcdist", cabal),
  (P.pack "distribution.simple.utils", cabal),
  (P.pack "distribution.version", cabal),
  (P.pack "foreign", base),
  (P.pack "foreign.c", base),
  (P.pack "foreign.c.error", base),
  (P.pack "foreign.c.string", base),
  (P.pack "foreign.c.types", base),
  (P.pack "foreign.concurrent", base),
  (P.pack "foreign.foreignptr", base),
  (P.pack "foreign.marshal", base),
  (P.pack "foreign.marshal.alloc", base),
  (P.pack "foreign.marshal.array", base),
  (P.pack "foreign.marshal.error", base),
  (P.pack "foreign.marshal.pool", base),
  (P.pack "foreign.marshal.utils", base),
  (P.pack "foreign.ptr", base),
  (P.pack "foreign.stableptr", base),
  (P.pack "foreign.storable", base),
  (P.pack "ghc.conc", base),
  (P.pack "ghc.consolehandler", base),
  (P.pack "ghc.dotnet", base),
  (P.pack "ghc.exts", base),
  (P.pack "graphics.hgl", hgl),
  (P.pack "graphics.hgl.core", hgl),
  (P.pack "graphics.hgl.draw", hgl),
  (P.pack "graphics.hgl.draw.brush", hgl),
  (P.pack "graphics.hgl.draw.font", hgl),
  (P.pack "graphics.hgl.draw.monad", hgl),
  (P.pack "graphics.hgl.draw.pen", hgl),
  (P.pack "graphics.hgl.draw.picture", hgl),
  (P.pack "graphics.hgl.draw.region", hgl),
  (P.pack "graphics.hgl.draw.text", hgl),
  (P.pack "graphics.hgl.key", hgl),
  (P.pack "graphics.hgl.run", hgl),
  (P.pack "graphics.hgl.units", hgl),
  (P.pack "graphics.hgl.utils", hgl),
  (P.pack "graphics.hgl.window", hgl),
  (P.pack "graphics.rendering.opengl", opengl),
  (P.pack "graphics.rendering.opengl.gl", opengl),
  (P.pack "graphics.rendering.opengl.gl.antialiasing", opengl),
  (P.pack "graphics.rendering.opengl.gl.basictypes", opengl),
  (P.pack "graphics.rendering.opengl.gl.beginend", opengl),
  (P.pack "graphics.rendering.opengl.gl.bitmaps", opengl),
  (P.pack "graphics.rendering.opengl.gl.bufferobjects", opengl),
  (P.pack "graphics.rendering.opengl.gl.clipping", opengl),
  (P.pack "graphics.rendering.opengl.gl.colorsum", opengl),
  (P.pack "graphics.rendering.opengl.gl.colors", opengl),
  (P.pack "graphics.rendering.opengl.gl.coordtrans", opengl),
  (P.pack "graphics.rendering.opengl.gl.displaylists", opengl),
  (P.pack "graphics.rendering.opengl.gl.evaluators", opengl),
  (P.pack "graphics.rendering.opengl.gl.feedback", opengl),
  (P.pack "graphics.rendering.opengl.gl.flushfinish", opengl),
  (P.pack "graphics.rendering.opengl.gl.fog", opengl),
  (P.pack "graphics.rendering.opengl.gl.framebuffer", opengl),
  (P.pack "graphics.rendering.opengl.gl.hints", opengl),
  (P.pack "graphics.rendering.opengl.gl.linesegments", opengl),
  (P.pack "graphics.rendering.opengl.gl.perfragment", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.colortable", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.convolution", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.histogram", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.minmax", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.pixelmap", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.pixelstorage", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.pixeltransfer", opengl),
  (P.pack "graphics.rendering.opengl.gl.pixelrectangles.rasterization", opengl),
  (P.pack "graphics.rendering.opengl.gl.points", opengl),
  (P.pack "graphics.rendering.opengl.gl.polygons", opengl),
  (P.pack "graphics.rendering.opengl.gl.rasterpos", opengl),
  (P.pack "graphics.rendering.opengl.gl.readcopypixels", opengl),
  (P.pack "graphics.rendering.opengl.gl.rectangles", opengl),
  (P.pack "graphics.rendering.opengl.gl.savingstate", opengl),
  (P.pack "graphics.rendering.opengl.gl.selection", opengl),
  (P.pack "graphics.rendering.opengl.gl.statevar", opengl),
  (P.pack "graphics.rendering.opengl.gl.stringqueries", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing.application", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing.environments", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing.objects", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing.parameters", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing.queries", opengl),
  (P.pack "graphics.rendering.opengl.gl.texturing.specification", opengl),
  (P.pack "graphics.rendering.opengl.gl.vertexarrays", opengl),
  (P.pack "graphics.rendering.opengl.gl.vertexspec", opengl),
  (P.pack "graphics.rendering.opengl.glu", opengl),
  (P.pack "graphics.rendering.opengl.glu.errors", opengl),
  (P.pack "graphics.rendering.opengl.glu.initialization", opengl),
  (P.pack "graphics.rendering.opengl.glu.matrix", opengl),
  (P.pack "graphics.rendering.opengl.glu.mipmapping", opengl),
  (P.pack "graphics.rendering.opengl.glu.nurbs", opengl),
  (P.pack "graphics.rendering.opengl.glu.quadrics", opengl),
  (P.pack "graphics.rendering.opengl.glu.tessellation", opengl),
  (P.pack "graphics.soe", hgl),
  (P.pack "graphics.ui.glut", glut),
  (P.pack "graphics.ui.glut.begin", glut),
  (P.pack "graphics.ui.glut.callbacks", glut),
  (P.pack "graphics.ui.glut.callbacks.global", glut),
  (P.pack "graphics.ui.glut.callbacks.window", glut),
  (P.pack "graphics.ui.glut.colormap", glut),
  (P.pack "graphics.ui.glut.debugging", glut),
  (P.pack "graphics.ui.glut.devicecontrol", glut),
  (P.pack "graphics.ui.glut.fonts", glut),
  (P.pack "graphics.ui.glut.gamemode", glut),
  (P.pack "graphics.ui.glut.initialization", glut),
  (P.pack "graphics.ui.glut.menu", glut),
  (P.pack "graphics.ui.glut.objects", glut),
  (P.pack "graphics.ui.glut.overlay", glut),
  (P.pack "graphics.ui.glut.state", glut),
  (P.pack "graphics.ui.glut.window", glut),
  (P.pack "graphics.x11.types", x11),
  (P.pack "graphics.x11.xlib", x11),
  (P.pack "graphics.x11.xlib.atom", x11),
  (P.pack "graphics.x11.xlib.color", x11),
  (P.pack "graphics.x11.xlib.context", x11),
  (P.pack "graphics.x11.xlib.display", x11),
  (P.pack "graphics.x11.xlib.event", x11),
  (P.pack "graphics.x11.xlib.font", x11),
  (P.pack "graphics.x11.xlib.misc", x11),
  (P.pack "graphics.x11.xlib.region", x11),
  (P.pack "graphics.x11.xlib.screen", x11),
  (P.pack "graphics.x11.xlib.types", x11),
  (P.pack "graphics.x11.xlib.window", x11),
  (P.pack "language.haskell.parser", hs),
  (P.pack "language.haskell.pretty", hs),
  (P.pack "language.haskell.syntax", hs),
  (P.pack "language.haskell.th", th),
  (P.pack "language.haskell.th.lib", th),
  (P.pack "language.haskell.th.ppr", th),
  (P.pack "language.haskell.th.pprlib", th),
  (P.pack "language.haskell.th.syntax", th),
  (P.pack "network", network),
  (P.pack "network.bsd", network),
  (P.pack "network.cgi", network),
  (P.pack "network.socket", network),
  (P.pack "network.uri", network),
  (P.pack "numeric", base),
  (P.pack "prelude", base),
  (P.pack "system.cputime", base),
  (P.pack "system.cmd", base),
  (P.pack "system.console.getopt", base),
  (P.pack "system.console.haskeline", haskeline),
  (P.pack "system.directory", base),
  (P.pack "system.environment", base),
  (P.pack "system.exit", base),
  (P.pack "system.io", base),
  (P.pack "system.io.error", base),
  (P.pack "system.io.unsafe", base),
  (P.pack "system.info", base),
  (P.pack "system.locale", base),
  (P.pack "system.mem", base),
  (P.pack "system.mem.stablename", base),
  (P.pack "system.mem.weak", base),
  (P.pack "system.posix", unix),
  (P.pack "system.posix.directory", unix),
  (P.pack "system.posix.dynamiclinker", unix),
  (P.pack "system.posix.dynamiclinker.module", unix),
  (P.pack "system.posix.dynamiclinker.prim", unix),
  (P.pack "system.posix.env", unix),
  (P.pack "system.posix.error", unix),
  (P.pack "system.posix.files", unix),
  (P.pack "system.posix.io", unix),
  (P.pack "system.posix.process", unix),
  (P.pack "system.posix.resource", unix),
  (P.pack "system.posix.signals", base),
  (P.pack "system.posix.signals.exts", unix),
  (P.pack "system.posix.temp", unix),
  (P.pack "system.posix.terminal", unix),
  (P.pack "system.posix.time", unix),
  (P.pack "system.posix.types", base),
  (P.pack "system.posix.unistd", unix),
  (P.pack "system.posix.user", unix),
  (P.pack "system.process", base),
  (P.pack "system.random", base),
  (P.pack "system.time", base),
  (P.pack "test.hunit", hunit),
  (P.pack "test.hunit.base", hunit),
  (P.pack "test.hunit.lang", hunit),
  (P.pack "test.hunit.terminal", hunit),
  (P.pack "test.hunit.text", hunit),
  (P.pack "test.quickcheck", qc),
  (P.pack "test.quickcheck.batch", qc),
  (P.pack "test.quickcheck.poly", qc),
  (P.pack "test.quickcheck.utils", qc),
  (P.pack "text.html", base),
  (P.pack "text.html.blocktable", base),
  (P.pack "text.parsercombinators.parsec", parsec),
  (P.pack "text.parsercombinators.parsec.char", parsec),
  (P.pack "text.parsercombinators.parsec.combinator", parsec),
  (P.pack "text.parsercombinators.parsec.error", parsec),
  (P.pack "text.parsercombinators.parsec.expr", parsec),
  (P.pack "text.parsercombinators.parsec.language", parsec),
  (P.pack "text.parsercombinators.parsec.perm", parsec),
  (P.pack "text.parsercombinators.parsec.pos", parsec),
  (P.pack "text.parsercombinators.parsec.prim", parsec),
  (P.pack "text.parsercombinators.parsec.token", parsec),
  (P.pack "text.parsercombinators.readp", base),
  (P.pack "text.parsercombinators.readprec", base),
  (P.pack "text.prettyprint", base),
  (P.pack "text.prettyprint.hughespj", base),
  (P.pack "text.printf", base),
  (P.pack "text.read", base),
  (P.pack "text.read.lex", base),
  (P.pack "text.regex", base),
  (P.pack "text.regex.posix", base),
  (P.pack "text.show", base),
  (P.pack "text.show.functions", base)]
