package latexDraw.generators.svg;

import latexDraw.figures.Figure;
import latexDraw.parsers.svg.CSSStyleList;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.elements.SVGDefsElement;

/**
 * Defines method to get/set CSS style from/to a LaTeXDraw shape.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/24/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public abstract class CSSStylesGenerator
{
	/**
	 * Sets the CSS styles of the given list to the given LaTeXDraw shape.
	 * @param f The shape to set.
	 * @param styles The styles to set to the shape.
	 * @param defs The definitions, may be null.
	 * @since 2.0.0
	 */
	public static void setCSSStyles(Figure f, CSSStyleList styles, SVGDefsElement defs)
	{
		if(f==null || styles==null)
			return ;
		
		LShapeSVGGenerator.setThickness(f, styles.getCSSValue(SVGAttributes.SVG_STROKE_WIDTH), styles.getCSSValue(SVGAttributes.SVG_STROKE));
		LShapeSVGGenerator.setLineColour(f, styles.getCSSValue(SVGAttributes.SVG_STROKE));
		LShapeSVGGenerator.setDashedDotted(f, styles.getCSSValue(SVGAttributes.SVG_STROKE_DASHARRAY), styles.getCSSValue(SVGAttributes.SVG_STROKE_LINECAP));
		LShapeSVGGenerator.setFill(f, styles.getCSSValue(SVGAttributes.SVG_FILL), defs);
	}
}
