/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcmaps_gsi_utils.h
    \brief  This file contains the headers for utility functions to retrieve
            info from gsi credentials/contexts (at the gssapi level)
    \author Martijn Steenbakkers for EGEE

    This file contains utility functions to retrieve info from gsi
    credentials/contexts (at the gssapi and gsi level)
    The following functions are defined:
    -# lcmaps_cred_to_x509()
    -# lcmaps_cred_to_x509_chain()
    -# lcmaps_ctx_to_cred()
*/

#ifndef _LCMAPS_GSI_UTILS_H
#define _LCMAPS_GSI_UTILS_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include <openssl/x509.h>
#include <gssapi.h>

/******************************************************************************
 *                 Module definition
 *****************************************************************************/

#ifndef LCMAPS_GSI_UTILS_C
#   define LCMAPS_GSI_UTILS_STORAGE_CLASS extern
#else
#   define LCMAPS_GSI_UTILS_STORAGE_CLASS
#endif

/******************************************************************************
Function:       lcmaps_cred_to_x509()
Description:    Return the pointer to X509 structure from gss credential
Parameters:
                cred: globus credential
Returns:        pointer to X509 struct or NULL
******************************************************************************/
LCMAPS_GSI_UTILS_STORAGE_CLASS X509 * lcmaps_cred_to_x509(
        gss_cred_id_t cred
);


/******************************************************************************
Function:       lcmaps_cred_to_x509_chain()
Description:    Return the pointer to X509 chain from gss credential
Parameters:
                cred: globus credential
Returns:        pointer to X509 chain or NULL
******************************************************************************/
LCMAPS_GSI_UTILS_STORAGE_CLASS STACK_OF(X509) * lcmaps_cred_to_x509_chain(
        gss_cred_id_t cred
);

/******************************************************************************
Function:       lcmaps_ctx_to_cred()
Description:    Return cred from a gss context
Parameters:
                cred: globus gss context
Returns:        pointer to globus credential or GSS_C_NO_CREDENTIAL
******************************************************************************/
LCMAPS_GSI_UTILS_STORAGE_CLASS gss_cred_id_t lcmaps_ctx_to_cred(gss_ctx_id_t);

#endif /* _LCMAPS_GSI_UTILS_H */
