/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett Sheffield <bacs@librecast.net> */

/* test for F = 0
 *
 * According to RFC 6330, F must be a non-negative integer up to 946270874880,
 * which means it can be zero. */

#include "test.h"
#include <lcrq.h>
#include <assert.h>

int main(void)
{
	char name[] = "F = 0";
	rq_t *rq;

	test_name(name);

	rq = rq_init(0, 1024);

	rq_free(rq);

	return test_status;
}
