/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.DHKeyExchange;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.PreMasterSecret;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

public final class ClientHandshaker
extends Handshaker {
    public PublicKey a;
    public byte[] b;
    public BigInteger c;
    public DHKeyExchange d;
    public HandshakeMessage.CertificateRequest e;

    public ClientHandshaker(SSLSocketImpl sSLSocketImpl) throws NoSuchAlgorithmException {
        this(sSLSocketImpl, null);
    }

    public ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, true);
    }

    public boolean canExchange(int n2, boolean bl2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean canUseCipherSuite(String string) {
        return this.isEnabled(string);
    }

    private int a(HandshakeMessage.ClientHello clientHello, int n2, int n3, int n4, String string) {
        if (this.isEnabled(string)) {
            clientHello.e[n4++] = (byte)n2;
            clientHello.e[n4++] = (byte)n3;
        }
        return n4;
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.d = new DHKeyExchange(bigInteger, bigInteger2);
        this.d.generateKeyPair(CipherSpec.s, 768);
    }

    public HandshakeMessage getKickstartMessage() throws SSLException {
        HandshakeMessage.ClientHello clientHello = new HandshakeMessage.ClientHello(CipherSpec.s);
        int n2 = 0;
        this.clnt_random = clientHello.c;
        this.session = this.sslContext.a().a(this.conn.e());
        if (Handshaker.debug != null && Debug.isOn("session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.e() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null) {
            if (!this.isEnabled(this.session.getCipherSuite())) {
                if (Handshaker.debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (Handshaker.debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.conn.getLocalPort());
                }
                clientHello.d = this.session.d();
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                clientHello.e = this.session.a().getCipherSuite();
                return clientHello;
            }
        }
        if (this.session == null) {
            if (this.enableNewSession) {
                clientHello.d = SSLSessionImpl.a.d();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        clientHello.e = new byte[2 * this.enabledCipherSuites.length];
        n2 = this.a(clientHello, 0, 5, n2, "SSL_RSA_WITH_RC4_128_SHA");
        n2 = this.a(clientHello, 0, 4, n2, "SSL_RSA_WITH_RC4_128_MD5");
        n2 = this.a(clientHello, 0, 9, n2, "SSL_RSA_WITH_DES_CBC_SHA");
        n2 = this.a(clientHello, 0, 10, n2, "SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        n2 = this.a(clientHello, 0, 18, n2, "SSL_DHE_DSS_WITH_DES_CBC_SHA");
        n2 = this.a(clientHello, 0, 19, n2, "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        n2 = this.a(clientHello, 0, 3, n2, "SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        n2 = this.a(clientHello, 0, 17, n2, "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        n2 = this.a(clientHello, 0, 2, n2, "SSL_RSA_WITH_NULL_SHA");
        n2 = this.a(clientHello, 0, 1, n2, "SSL_RSA_WITH_NULL_MD5");
        n2 = this.a(clientHello, 0, 24, n2, "SSL_DH_anon_WITH_RC4_128_MD5");
        n2 = this.a(clientHello, 0, 26, n2, "SSL_DH_anon_WITH_DES_CBC_SHA");
        n2 = this.a(clientHello, 0, 27, n2, "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        n2 = this.a(clientHello, 0, 23, n2, "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
        n2 = this.a(clientHello, 0, 25, n2, "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        return clientHello;
    }

    public void a(byte by2) throws SSLProtocolException {
        System.out.println("SSL -- handshake alert not dealt with, " + by2);
        throw new SSLProtocolException("handshake alert not dealt with:  " + by2);
    }

    public void processMessage(byte by2, int n2) throws IOException, NoSuchAlgorithmException {
        if (this.state > by2 && by2 != 0 && this.state != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by2);
        }
        block2 : switch (by2) {
            case 0: {
                this.a(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.a(new HandshakeMessage.ServerHello(this.input));
                break;
            }
            case 11: {
                if (this.key_exchange_algorithm == 7) {
                    this.conn.a((byte)10, "unexpected server cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(this.input));
                this.a = this.session.getPeerCertificateChain()[0].getPublicKey();
                break;
            }
            case 12: {
                switch (this.key_exchange_algorithm) {
                    case 1: 
                    case 2: {
                        try {
                            this.a(new HandshakeMessage.RSA_ServerKeyExchange(this.input, n2));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                    case 7: {
                        this.a(new HandshakeMessage.DH_ServerKeyExchange(this.input));
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        try {
                            this.a(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.a, this.clnt_random.a, this.svr_random.a, n2));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.key_exchange_algorithm);
            }
            case 13: {
                this.e = new HandshakeMessage.CertificateRequest(this.input);
                break;
            }
            case 14: {
                this.a(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(this.v_major, this.v_minor, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by2);
            }
        }
        if (this.state < by2) {
            this.state = by2;
        }
    }

    private void a() throws IOException {
        HandshakeMessage.Finished finished;
        try {
            if (this.md5[0] == null) {
                throw new CloneNotSupportedException("minor hack");
            }
            finished = this.v_minor == 0 ? new HandshakeMessage.Finished(this.v_major, this.v_minor, (MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), HandshakeMessage.Finished.c, this.session.c()) : new HandshakeMessage.Finished(this.v_major, this.v_minor, (MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), "client finished", this.session.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            finished = this.v_minor == 0 ? new HandshakeMessage.Finished(this.v_major, this.v_minor, this.md5[1], this.sha1[1], HandshakeMessage.Finished.c, this.session.c()) : new HandshakeMessage.Finished(this.v_major, this.v_minor, this.md5[1], this.sha1[1], "client finished", this.session.c());
            this.md5[1] = null;
            this.sha1[1] = null;
        }
        this.sendChangeCipherSpec(finished);
        this.state = 19;
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509TrustManager x509TrustManager;
        X509Certificate[] x509CertificateArray;
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            this.conn.a((byte)42, "null cert chain");
        }
        if ((x509TrustManager = this.sslContext.d()).isServerTrusted(x509CertificateArray)) {
            this.session.a(x509CertificateArray);
        } else {
            this.conn.a((byte)46, "untrusted server cert chain");
        }
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        boolean bl2 = false;
        try {
            bl2 = this.v_minor == 0 ? finished.verify((MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), HandshakeMessage.Finished.d, this.session.c()) : finished.verify((MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), "server finished", this.session.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl2 = this.v_minor == 0 ? finished.verify(this.md5[0], this.sha1[0], HandshakeMessage.Finished.d, this.session.c()) : finished.verify(this.md5[0], this.sha1[0], "server finished", this.session.c());
            this.md5[0] = null;
            this.sha1[0] = null;
        }
        if (!bl2) {
            this.conn.a((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.a();
        }
        if (this.conn.c() && this.session.e()) {
            this.sslContext.a().a(this.session);
            if (Handshaker.debug != null && Debug.isOn("session")) {
                System.out.println("%% Cached client session: " + this.session);
            }
        } else if (Handshaker.debug != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable client session: " + this.session);
        }
    }

    private void a(HandshakeMessage.ServerHello serverHello) throws IOException {
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            serverHello.a(System.out);
        }
        if (serverHello.a != 3 || serverHello.b > 1) {
            throw new SSLProtocolException("version mismatch, server is v" + serverHello.a + "." + serverHello.b);
        }
        this.v_major = serverHello.a;
        this.v_minor = serverHello.b;
        this.conn.a(this.v_major, this.v_minor);
        this.output.r.a(this.v_major, this.v_minor);
        this.svr_random = serverHello.c;
        if (this.session != null) {
            if (this.session.d().equals(serverHello.d)) {
                CipherSpec cipherSpec = this.session.a();
                byte[] byArray = cipherSpec.getCipherSuite();
                if (serverHello.e[0] != byArray[0] || serverHello.e[1] != byArray[1] || serverHello.a != cipherSpec.v_major || serverHello.b != cipherSpec.v_minor) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                this.resumingSession = true;
                this.state = 19;
                if (Handshaker.debug != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
            } else {
                this.session = null;
                if (!this.enableNewSession) {
                    throw new SSLException("New session creation was disabled");
                }
            }
        }
        if (!this.maybeSetCipherSuite(serverHello.e[0], serverHello.e[1])) {
            this.conn.a((byte)47, "Can't support cipher suite [" + serverHello.e[0] + ", " + serverHello.e[1] + "]");
        } else if (serverHello.f != 0) {
            this.conn.a((byte)47, "compression type not supported, " + serverHello.f);
        }
        if (this.session == null) {
            this.session = new SSLSessionImpl(this, serverHello.d, this.conn.e(), this.conn.getPort());
            if (Handshaker.debug != null && Debug.isOn("handshake")) {
                System.out.println("** " + this.session.a());
            }
        } else {
            try {
                this.calculateConnectionKeys(this.session.c());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
    }

    private void a(HandshakeMessage.ServerHelloDone serverHelloDone) throws IOException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            serverHelloDone.a(System.out);
        }
        this.input.digestNow();
        PrivateKey privateKey = null;
        if (this.e != null) {
            object3 = this.sslContext.c();
            object2 = null;
            HandshakeMessage.CertificateMsg certificateMsg = null;
            int n2 = 0;
            while (n2 < this.e.g.length) {
                object = null;
                if (this.e.g[n2] == 1) {
                    object = "RSA";
                } else if (this.e.g[n2] == 2) {
                    object = "DSA";
                }
                object2 = object3.chooseClientAlias((String)object, this.e.a());
                if (object2 != null) break;
                ++n2;
            }
            if (object2 != null) {
                certificateMsg = new HandshakeMessage.CertificateMsg(object3.getCertificateChain((String)object2));
                privateKey = object3.getPrivateKey((String)object2);
                this.session.a(true);
            } else if (this.v_minor > 0) {
                certificateMsg = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
            } else {
                this.conn.a((byte)41);
            }
            if (certificateMsg != null) {
                if (Handshaker.debug != null && Debug.isOn("handshake")) {
                    certificateMsg.a(System.out);
                }
                certificateMsg.write(this.output);
            }
        }
        switch (this.key_exchange_algorithm) {
            case 1: 
            case 2: {
                object2 = new PreMasterSecret(this.v_major, this.v_minor, CipherSpec.s, this.a);
                this.b = ((PreMasterSecret)object2).c;
                object3 = object2;
                break;
            }
            case 3: 
            case 4: {
                object3 = new ClientDiffieHellmanPublic();
                break;
            }
            case 6: 
            case 7: {
                object3 = new ClientDiffieHellmanPublic(this.d.getPublicKey());
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.key_exchange_algorithm);
            }
        }
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            ((HandshakeMessage)object3).a(System.out);
        }
        ((HandshakeMessage)object3).write(this.output);
        this.output.a();
        this.output.flush();
        switch (this.key_exchange_algorithm) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.b = this.d.getAgreedSecret(this.c);
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.key_exchange_algorithm);
            }
            case 1: 
            case 2: 
        }
        this.calculateKeys(this.b);
        int n3 = 0;
        while (n3 < this.b.length) {
            this.b[n3] = 0;
            ++n3;
        }
        if (privateKey != null) {
            MessageDigest messageDigest;
            HandshakeMessage handshakeMessage = null;
            try {
                object = (MessageDigest)this.md5[0].clone();
                messageDigest = (MessageDigest)this.sha1[0].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                object = this.md5[2];
                messageDigest = this.sha1[2];
                this.md5[2] = null;
                this.sha1[2] = null;
            }
            try {
                handshakeMessage = privateKey instanceof RSAPrivateKey ? new HandshakeMessage.CertificateVerify(this.v_minor, (RSAPrivateKey)privateKey, (MessageDigest)object, messageDigest, this.session.c()) : new HandshakeMessage.CertificateVerify(this.v_minor, privateKey, messageDigest, this.session.c());
            }
            catch (InvalidKeyException invalidKeyException) {
                this.conn.a((byte)40, "Invalid private key");
            }
            catch (SignatureException signatureException) {
                this.conn.a((byte)40, "DSS/DSA signature failure");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.conn.a((byte)40, "No DSS/DSA implementation");
            }
            if (Handshaker.debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateVerify)handshakeMessage).a(System.out);
            }
            handshakeMessage.write(this.output);
            this.output.a();
        }
        this.a();
    }

    private void a(HandshakeMessage.HelloRequest helloRequest) throws IOException {
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            helloRequest.a(System.out);
        }
        if (this.state < 1) {
            this.kickstart();
        }
    }

    private void a(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.a(System.out);
        }
        if (this.key_exchange_algorithm == 4 || this.key_exchange_algorithm == 3) {
            this.conn.a((byte)10, "not supporting DH certs for key exchange now");
        }
        this.a(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase());
        this.c = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void a(HandshakeMessage.RSA_ServerKeyExchange rSA_ServerKeyExchange) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (Handshaker.debug != null && Debug.isOn("handshake")) {
            rSA_ServerKeyExchange.a(System.out);
        }
        if (!(this.a instanceof RSAPublicKey)) {
            throw new InvalidKeyException("server key not an RSA key");
        }
        if (!rSA_ServerKeyExchange.a((RSAPublicKey)this.a, this.clnt_random, this.svr_random)) {
            this.conn.a((byte)40, "server key exchange invalid");
        }
        this.a = rSA_ServerKeyExchange.a();
    }
}

