#ifndef __ERLANG_H
#define __ERLANG_H

#include <arpa/inet.h>
#include "context.h"
#include "sequences.h"
#include "plugins.h"

/* erlang port plugin */
#define IN_FD      3
#define OUT_FD     4

/* commands */
#define CMD_CHAR             'C'
#define STOP_CHAR            'S'
#define UPDATE_CHAR          'U'
#define UPDATE_COLORMAP_CHAR 'C'
#define UPDATE_PICTURE_CHAR  'P'
#define UPDATE_SEQUENCE_CHAR 'S'
#define INFO_CHAR            'I'
#define WEBCAM_CHAR          'W'
#define BINIOU_CHAR          'B'

void info(const char *, ...);


static inline ssize_t
write_exact(const u_char *buf, const ssize_t len)
{
  ssize_t i, wrote = 0;

  do {
    if ((i = write(OUT_FD, buf+wrote, len-wrote)) <= 0)
      return i;
    wrote += i;
  } while (wrote < len);

  return len;
}


static inline void write_uint8(const uint8_t *val) {
  int ret = write_exact((const u_char *)val, sizeof(uint8_t));
#ifdef DEBUG
  assert(ret == 1);
#else
  if (ret != 1)
	fprintf(stderr, "[!] erlang: short write of 1 byte (ret= %d)\n", ret);
  if (-1 == ret) exit(1);
#endif
};


static inline void write_uint16(const uint16_t *val) {
  int ret = write_exact((const u_char *)val, sizeof(uint16_t));
#ifdef DEBUG
  assert(ret == 2);
#else
  if (ret != 2)
	fprintf(stderr, "[!] erlang: short write of 2 bytes (ret= %d)\n", ret);
  if (-1 == ret) exit(1);
#endif
};


static inline void write_uint32(const uint32_t *val) {
  int ret = write_exact((const u_char *)val, sizeof(uint32_t));
#ifdef DEBUG
  assert(ret == 4);
#else
  if (ret != 4)
    fprintf(stderr, "[!] erlang: short write of 4 bytes (ret= %d)\n", ret);
  if (-1 == ret) exit(1);
#endif
};


static inline void write_binary(const uint8_t *ptr, const ssize_t len) {
  int ret = write_exact((const u_char *)ptr, len*sizeof(uint8_t));
#ifdef DEBUG
  assert(ret == len);
#else
  if (ret != len)
	fprintf(stderr, "[!] erlang: short write of %d bytes (ret= %d)\n", (int)len, ret);
  if (-1 == ret) exit(1);
#endif
};

#endif /* __ERLANG_H */
