/* LekhoneeDialogs.vala
 *
 * Copyright (C) 2010  Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

using Xml;

public void xml_save_file(string filename, string title,string desc,string tags){
    Xml.Doc* doc;
    Xml.Node* root;
    //string xmlstr;
    
    doc = new Xml.Doc ("1.0");

    root = new Xml.Node(null,"post");
    doc->set_root_element(root);
    root->new_text_child (null, "title", title);
    root->new_text_child (null, "description", desc);
    root->new_text_child (null, "tags", tags);
    //root->new_text_child (null, "categories", categories);
    
    var stream = FileStream.open(filename, "w");
    doc->dump(stream);

}

public void xml_open_file(string path, out string title, out string desc, out string tags){
    Xml.Doc* doc = Parser.parse_file (path);
        if (doc == null) {
            stderr.printf ("File %s not found or permissions missing", path);
            return;
        }

        // Get the root node. notice the dereferencing operator -> instead of .
        Xml.Node* root = doc->get_root_element ();
        if (root == null) {
            // Free the document manually before returning
            delete doc;
            debug(@"The xml file '$path' is empty");
            return;
        }
        for (Xml.Node* iter = root->children; iter != null; iter = iter->next) {
            // Spaces between tags are also nodes, discard them
            if (iter->type != ElementType.ELEMENT_NODE) {
                continue;
            }

            // Get the node's name
            string node_name = iter->name;
            // Get the node's content with <tags> stripped
            string node_content = iter->get_content ();
            if(node_name == "title")
                title = node_content;
            if(node_name == "description")
                desc = node_content;
            if(node_name == "tags")
                tags = node_content;                



        }
        
        
        
    delete doc;
}
