package tests::ReportParserExcelWriterTest;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::ReportParser::ExcelWriter;
use Lire::Utils qw/tempfile/;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->init();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    unlink $self->{'unlink'}
      if $self->{'unlink'};

    return;
}

sub test_new {
    my $self = $_[0];

    my $parser = new Lire::ReportParser::ExcelWriter();
    $self->assert_isa( 'Lire::ReportParser::ExcelWriter', $parser );
    $self->assert_str_equals( '-', $parser->{'_output_file'} );

    $parser = new Lire::ReportParser::ExcelWriter( 'output_file' => 'report.xls' );
    $self->assert_str_equals( 'report.xls', $parser->{'_output_file'} );
}

sub test_parsefile {
    my $self = $_[0];

    my ( $fh, $file ) = tempfile( 'report_XXXXXX', 'SUFFIX' => '.xls' );
    close $fh;
    $self->{'unlink'} = $file;

    my $parser = new Lire::ReportParser::ExcelWriter( 'output_file' => $file );
    $parser->parsefile( "$self->{'testdir'}/data/test-sqlite.xml" );
    $self->assert( -s $file, "$file wasn't created" );

    return;
}

1;
