package tests::functional::LrLog2ReportTest;

use strict;

use base qw/Lire::Test::FunctionalTestCase tests::functional::TestSchemaFixture/;
use Lire::Config::Build qw/ac_info/;
use Lire::ReportParser::ReportBuilder;
use File::Basename qw/dirname/;
use Cwd 'realpath';
use Carp;

#our @TESTS = qw//;

sub new {
    my $self = shift->SUPER::new(@_);

    $self->tests::functional::TestSchemaFixture::init();

    $self->{'testsdir'} = realpath(dirname( __FILE__ ) . "/..");
    $self->{'report_cfg'} = "$self->{'testsdir'}/data/test.cfg";

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->set_up_test_schemas();
    $self->set_up_test_specs();
    $self->set_up_test2dlf();
    $self->set_up_TestDlfConverter();
    $self->set_up_test_analysers();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();
    $self->tests::functional::TestSchemaFixture::tear_down();
    return;
}

sub test_version {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_log2report -v" );
    $self->annotate( $result->stderr );
    $self->assert_equals( 0, $result->status );
    $self->assert( !$result->stdout, "stdout should be empty" );
    $self->assert_does_not_match( qr/(ERROR|WARNING)/, $result->stderr(),
                                  "There were warnings or error messages." );
    my $VERSION = ac_info( "VERSION" );
    $self->assert_matches( qr/shipped with Lire version $VERSION/,
                           $result->stderr() );
}

sub test_old_custom_converter_report {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_log2report -c $self->{'report_cfg'} -o xml test < /etc/passwd > report.xml" );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert( !$result->stdout, "stdout should be empty" );
    $self->assert_does_not_match( qr/(ERROR|WARNING)/, $result->stderr(),
                                  "There were warnings or error messages." );

    $self->assert( -f $self->rundir() . "/report.xml",
                   "XML report wasn't created" );
    $self->assert( -s $self->rundir() . "/report.xml",
                   "XML report is empty" );

    $self->check_xml_report( "$self->{'testsdir'}/data/test-sqlite.xml",
                             $self->rundir() . "/report.xml" );
}

sub test_custom_converter_report {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_log2report -c $self->{'report_cfg'} -o xml test_newapi < $self->{'testsdir'}/data/test.dlf > report.xml" );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert( !$result->stdout, "stdout should be empty" );
    $self->assert_does_not_match( qr/(ERROR|WARNING)/, $result->stderr(),
                                  "There were warnings or error messages." );

    $self->assert( -f $self->rundir() . "/report.xml",
                   "XML report wasn't created" );
    $self->assert( -s $self->rundir() . "/report.xml",
                   "XML report is empty" );

    $self->check_xml_report( "$self->{'testsdir'}/data/test-sqlite.xml",
                             $self->rundir() . "/report.xml" );
}

sub test_bad_service {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_log2report no_such_service" );
    $self->annotate( $result->stderr() );
    $self->assert_not_equals( 0, $result->status() );
    $self->assert( !$result->stdout, "stdout should be empty" );
    $self->assert_matches( qr/No such DLF converter/, $result->stderr() );
}

sub test_usage {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_log2report" );
    $self->annotate( $result->stderr() );
    $self->assert_not_equals( 0, $result->status() );
    $self->assert( !$result->stdout, "stdout should be empty" );
    $self->assert_matches( qr/Usage: lr_log2report/, $result->stderr() );
}

sub test_empty_log {
    my $self = $_[0];

    my $empty_file = $self->rundir() . "/empty.txt";
    $self->create_test_file( $empty_file );
    my $result = $self->lire_run( "lr_log2report -c $self->{'report_cfg'} -o xml test_newapi < $empty_file > report.xml" );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_does_not_match( qr/(ERROR|WARNING)/, $result->stderr(),
                                  "There were warnings or error messages." );

    $self->assert( -f $self->rundir() . "/report.xml",
                   "XML report wasn't created" );
    $self->assert( -s $self->rundir() . "/report.xml",
                   "XML report is empty" );

    $self->check_xml_report( "$self->{'testsdir'}/data/test-empty-sqlite.xml",
                             $self->rundir() . "/report.xml" );
}

sub test_bogus_log {
    my $self = $_[0];

    my $bogus_file = $self->rundir . "/bogus.txt";
    $self->create_test_file( $bogus_file, <<EOL );
Bogus log
Bogus log
Bogus log
EOL
    my $result = $self->lire_run( "lr_log2report -c $self->{'report_cfg'} -o xml test_newapi < $bogus_file > report.xml" );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert( !$result->stdout, "stdout should be empty" );
    $self->assert_does_not_match( qr/(ERROR|WARNING)/, $result->stderr(),
                                  "There were warnings or error messages." );

    $self->assert( -f $self->rundir . "/report.xml",
                   "XML report wasn't created" );
    $self->assert( -s $self->rundir . "/report.xml",
                   "XML report is empty" );

    $self->check_xml_report( "$self->{'testsdir'}/data/test-empty-sqlite.xml",
                             $self->rundir . "/report.xml" );
}

1;
