#ifndef _APPLET_H
#define _APPLET_H

#include "display.h"
#include "vibrator.h"

typedef std::string AppAction;

struct AppletWindowParams {
    AppletWindowParams(int width_p, int height_p, int width_l, int height_l, MyDisplay& d, std::string font, int size)
	:width_portrait(width_p), height_portrait(height_p), width_landscape(width_l), height_landscape(height_l), disp(d), font_path(font), font_size(size){}
    int width_landscape;
    int height_landscape;
    int width_portrait;
    int height_portrait;
    MyDisplay& disp;
    std::string font_path;
    int font_size;
};

class Applet {
  public:
    Applet(AppletWindowParams params);
    virtual ~Applet(){}
    enum Position { NORTH, SOUTH, SOUTH_EAST, SOUTH_WEST, NORTH_EAST, NORTH_WEST };
    void SetPosition(Position p);
    void SetBackground(XColor col);
    void SetForeground(XColor col);
    void Show();
    void Hide();
    bool Hidden();
    void Refresh();
    virtual AppAction OnMousePress(int x, int y){ return "";}
    virtual AppAction OnMouseMove(int x, int y){ return "";}
    virtual AppAction OnMouseRelease(int x, int y){ return "";}
    virtual void OnShow(){}
    virtual void OnHide(){}
    enum Rotation { LANDSCAPE, PORTRAIT };
    void WindowRotate(Rotation r);
    virtual void OnRotate(Rotation r) = 0;

    void SetTransparent(bool trans);
    void ToggleTransparent();
    bool IsTransparent();

    bool IsWindowOwner(Window xwin);
    void SetVibrator(Vibrator* vib);
    void Vibrate();


  protected:
    int GetCurrentWidth();
    int GetCurrentHeight();
    MyWindow win;
    Position pos;
    bool hidden;
    Rotation rot;
    AppletWindowParams params;
    Vibrator* vibrator;
};

#endif
