//===-- PPC64_DWARF_Registers.h ---------------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_SOURCE_UTILITY_PPC64_DWARF_REGISTERS_H
#define LLDB_SOURCE_UTILITY_PPC64_DWARF_REGISTERS_H

#include "lldb/lldb-private.h"

namespace ppc64_dwarf {

enum {
  dwarf_r0_ppc64 = 0,
  dwarf_r1_ppc64,
  dwarf_r2_ppc64,
  dwarf_r3_ppc64,
  dwarf_r4_ppc64,
  dwarf_r5_ppc64,
  dwarf_r6_ppc64,
  dwarf_r7_ppc64,
  dwarf_r8_ppc64,
  dwarf_r9_ppc64,
  dwarf_r10_ppc64,
  dwarf_r11_ppc64,
  dwarf_r12_ppc64,
  dwarf_r13_ppc64,
  dwarf_r14_ppc64,
  dwarf_r15_ppc64,
  dwarf_r16_ppc64,
  dwarf_r17_ppc64,
  dwarf_r18_ppc64,
  dwarf_r19_ppc64,
  dwarf_r20_ppc64,
  dwarf_r21_ppc64,
  dwarf_r22_ppc64,
  dwarf_r23_ppc64,
  dwarf_r24_ppc64,
  dwarf_r25_ppc64,
  dwarf_r26_ppc64,
  dwarf_r27_ppc64,
  dwarf_r28_ppc64,
  dwarf_r29_ppc64,
  dwarf_r30_ppc64,
  dwarf_r31_ppc64,
  dwarf_f0_ppc64,
  dwarf_f1_ppc64,
  dwarf_f2_ppc64,
  dwarf_f3_ppc64,
  dwarf_f4_ppc64,
  dwarf_f5_ppc64,
  dwarf_f6_ppc64,
  dwarf_f7_ppc64,
  dwarf_f8_ppc64,
  dwarf_f9_ppc64,
  dwarf_f10_ppc64,
  dwarf_f11_ppc64,
  dwarf_f12_ppc64,
  dwarf_f13_ppc64,
  dwarf_f14_ppc64,
  dwarf_f15_ppc64,
  dwarf_f16_ppc64,
  dwarf_f17_ppc64,
  dwarf_f18_ppc64,
  dwarf_f19_ppc64,
  dwarf_f20_ppc64,
  dwarf_f21_ppc64,
  dwarf_f22_ppc64,
  dwarf_f23_ppc64,
  dwarf_f24_ppc64,
  dwarf_f25_ppc64,
  dwarf_f26_ppc64,
  dwarf_f27_ppc64,
  dwarf_f28_ppc64,
  dwarf_f29_ppc64,
  dwarf_f30_ppc64,
  dwarf_f31_ppc64,
  dwarf_cr_ppc64 = 64,
  dwarf_fpscr_ppc64,
  dwarf_msr_ppc64,
  dwarf_xer_ppc64 = 100,
  dwarf_lr_ppc64 = 108,
  dwarf_ctr_ppc64,
  dwarf_vscr_ppc64,
  dwarf_vrsave_ppc64 = 356,
  dwarf_pc_ppc64,
  dwarf_vr0_ppc64 = 1124,
  dwarf_vr1_ppc64,
  dwarf_vr2_ppc64,
  dwarf_vr3_ppc64,
  dwarf_vr4_ppc64,
  dwarf_vr5_ppc64,
  dwarf_vr6_ppc64,
  dwarf_vr7_ppc64,
  dwarf_vr8_ppc64,
  dwarf_vr9_ppc64,
  dwarf_vr10_ppc64,
  dwarf_vr11_ppc64,
  dwarf_vr12_ppc64,
  dwarf_vr13_ppc64,
  dwarf_vr14_ppc64,
  dwarf_vr15_ppc64,
  dwarf_vr16_ppc64,
  dwarf_vr17_ppc64,
  dwarf_vr18_ppc64,
  dwarf_vr19_ppc64,
  dwarf_vr20_ppc64,
  dwarf_vr21_ppc64,
  dwarf_vr22_ppc64,
  dwarf_vr23_ppc64,
  dwarf_vr24_ppc64,
  dwarf_vr25_ppc64,
  dwarf_vr26_ppc64,
  dwarf_vr27_ppc64,
  dwarf_vr28_ppc64,
  dwarf_vr29_ppc64,
  dwarf_vr30_ppc64,
  dwarf_vr31_ppc64,
  dwarf_vs0_ppc64,
  dwarf_vs1_ppc64,
  dwarf_vs2_ppc64,
  dwarf_vs3_ppc64,
  dwarf_vs4_ppc64,
  dwarf_vs5_ppc64,
  dwarf_vs6_ppc64,
  dwarf_vs7_ppc64,
  dwarf_vs8_ppc64,
  dwarf_vs9_ppc64,
  dwarf_vs10_ppc64,
  dwarf_vs11_ppc64,
  dwarf_vs12_ppc64,
  dwarf_vs13_ppc64,
  dwarf_vs14_ppc64,
  dwarf_vs15_ppc64,
  dwarf_vs16_ppc64,
  dwarf_vs17_ppc64,
  dwarf_vs18_ppc64,
  dwarf_vs19_ppc64,
  dwarf_vs20_ppc64,
  dwarf_vs21_ppc64,
  dwarf_vs22_ppc64,
  dwarf_vs23_ppc64,
  dwarf_vs24_ppc64,
  dwarf_vs25_ppc64,
  dwarf_vs26_ppc64,
  dwarf_vs27_ppc64,
  dwarf_vs28_ppc64,
  dwarf_vs29_ppc64,
  dwarf_vs30_ppc64,
  dwarf_vs31_ppc64,
  dwarf_vs32_ppc64,
  dwarf_vs33_ppc64,
  dwarf_vs34_ppc64,
  dwarf_vs35_ppc64,
  dwarf_vs36_ppc64,
  dwarf_vs37_ppc64,
  dwarf_vs38_ppc64,
  dwarf_vs39_ppc64,
  dwarf_vs40_ppc64,
  dwarf_vs41_ppc64,
  dwarf_vs42_ppc64,
  dwarf_vs43_ppc64,
  dwarf_vs44_ppc64,
  dwarf_vs45_ppc64,
  dwarf_vs46_ppc64,
  dwarf_vs47_ppc64,
  dwarf_vs48_ppc64,
  dwarf_vs49_ppc64,
  dwarf_vs50_ppc64,
  dwarf_vs51_ppc64,
  dwarf_vs52_ppc64,
  dwarf_vs53_ppc64,
  dwarf_vs54_ppc64,
  dwarf_vs55_ppc64,
  dwarf_vs56_ppc64,
  dwarf_vs57_ppc64,
  dwarf_vs58_ppc64,
  dwarf_vs59_ppc64,
  dwarf_vs60_ppc64,
  dwarf_vs61_ppc64,
  dwarf_vs62_ppc64,
  dwarf_vs63_ppc64,
};

} // namespace ppc64_dwarf

#endif // LLDB_SOURCE_UTILITY_PPC64_DWARF_REGISTERS_H
