/*
 * SpectrumAnalyzerControls.cpp - controls for spectrum analyzer
 *
 * Copyright (c) 2008-2014 Tobias Doerffel <tobydox/at/users.sourceforge.net>
 * 
 * This file is part of LMMS - https://lmms.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */


#include "SpectrumAnalyzer.h"
#include "SpectrumAnalyzerControls.h"



SpectrumAnalyzerControls::SpectrumAnalyzerControls( SpectrumAnalyzer* effect ) :
	EffectControls( effect ),
	m_effect( effect ),
	m_linearSpec( false, this, tr( "Linear spectrum" ) ),
	m_linearYAxis( false, this, tr( "Linear Y axis" ) ),
	m_channelMode( SpectrumAnalyzer::MergeChannels,
					SpectrumAnalyzer::MergeChannels,
					SpectrumAnalyzer::RightChannel,
						this, tr( "Channel mode" ) )
{
}




void SpectrumAnalyzerControls::loadSettings( const QDomElement & _this )
{
}




void SpectrumAnalyzerControls::saveSettings( QDomDocument & _doc, 
							QDomElement & _this )
{
}





