/****************************************************************************/
/* Log forwarder implementation - Network configuration                     */
/*                                                                          */
/*  Author(s):                                                              */
/*    - Gael Le Mahec   (gael.le.mahec@ens-lyon.fr)                         */
/*                                                                          */
/*  This file is part of DIET .                                             */
/*                                                                          */
/*  Copyright (C) 2000-2003 ENS Lyon, LIFC, INSA, INRIA and SysFera (2000)  */
/*                                                                          */
/*  - Frederic.Desprez@ens-lyon.fr (Project Manager)                        */
/*  - Eddy.Caron@ens-lyon.fr (Technical Manager)                            */
/*  - Tech@sysfera.com (Maintainer and Technical Support)                   */
/*                                                                          */
/*  This software is a computer program whose purpose is to provide an      */
/*  distributed logging services.                                           */
/*                                                                          */
/*                                                                          */
/*  This software is governed by the CeCILL license under French law and    */
/*  abiding by the rules of distribution of free software.  You can  use,   */
/*  modify and/ or redistribute the software under the terms of the CeCILL  */
/*  license as circulated by CEA, CNRS and INRIA at the following URL       */
/*  "http://www.cecill.info".                                               */
/*                                                                          */
/*  As a counterpart to the access to the source code and  rights to copy,  */
/*  modify and redistribute granted by the license, users are provided      */
/*  only with a limited warranty  and the software's author,  the holder    */
/*  of the economic rights,  and the successive licensors  have only        */
/*  limited liability.                                                      */
/*                                                                          */
/*  In this respect, the user's attention is drawn to the risks             */
/*  associated with loading,  using,  modifying and/or developing or        */
/*  reproducing the software by the user in light of its specific status    */
/*  of free software, that may mean  that it is complicated to              */
/*  manipulate, and  that  also therefore means  that it is reserved for    */
/*  developers and experienced professionals having in-depth computer       */
/*  knowledge. Users are therefore encouraged to load and test the          */
/*  software's suitability as regards their requirements in conditions      */
/*  enabling the security of their systems and/or data to be ensured and,   */
/*  more generally, to use and operate it in the same conditions as         */
/*  regards security.                                                       */
/*                                                                          */
/*  The fact that you are presently reading this means that you have had    */
/*  knowledge of the CeCILL license and that you accept its terms.          */
/*                                                                          */
/****************************************************************************/
/* $Id$
 * $Log$
 * Revision 1.2  2011/02/04 15:35:22  bdepardo
 * Code indentation
 *
 * Revision 1.1  2010/11/10 02:27:43  kcoulomb
 * Update the log to use the forwarder.
 * Programm run without launching forwarders but fails with forwarder.
 *
 * Revision 1.3  2010/07/14 23:45:30  bdepardo
 * Header corrections
 *
 * Revision 1.2  2010/07/13 15:24:13  glemahec
 * Warnings corrections and some robustness improvements
 *
 * Revision 1.1  2010/07/12 16:11:03  glemahec
 * DIET 2.5 beta 1 - New ORB manager; LogForwarder application
 ****************************************************************************/

#ifndef NETCONFIG_HH
#define NETCONFIG_HH

#include <string>
#include <map>
#include <list>

class NetConfig {
public:
  NetConfig();
  NetConfig(const std::list<std::string>& accept,
            const std::list<std::string>& reject,
            const std::string& hostname);
  NetConfig(const std::string& path);
  NetConfig(const NetConfig& cfg);
	
  NetConfig& operator=(const NetConfig& cfg);
	
  void addAcceptNetwork(const std::string& pattern);
  void remAcceptNetwork(const std::string& pattern);
	
  void addRejectNetwork(const std::string& pattern);
  void remRejectNetwork(const std::string& pattern);
	
  bool manage(const std::string& hostname) const;
  void updateConfig();
	
  const std::list<std::string>& getAcceptList() const;
  const std::list<std::string>& getRejectList() const;

private:
  std::string filePath;
  std::list<std::string> accept;
  std::list<std::string> reject;
  void parseFile();
  void reset();
  std::string myHostname;
  void addLocalHost(std::list<std::string>& l) const;
};

#endif
