<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	/* This MILLE-XTERM Configurator setup.
	* Author: Nicolas Dufresne
	* Last Modification:
	* 		 29 jul 2004 Nicolas Dufresnes <nicolas@revolutionlinux.com>
	*		- Creation
	*/
	switch($module_action) {
		case 'build':
			break;
		default:
			require_once 'functions.php';
			require_once "LDAPAuth.php";
			require_once 'entityRole-config.php';
			require_once 'roles-config.php';
			require_once 'SessionData.php';
			global $GROUP_ROLE,$ROLE;

			#if (!use_https()) die(getMessage('need_https'));
			global $CONFIG;
			if($CONFIG['first_setup_lock'] == "TRUE"){
				$preserveLock=TRUE;
			}
			if($_POST['save']){
				require_once 'Node.php';
				$valide = true;
				unset($GLOBALS[CONFIG]);
				unset($CONFIG);
				global $CONFIG;
				foreach ($_POST as $name=>$value) {
					if ($value) {
						$CONFIG[$name] = $value;
					}
				}

				// Some message depend on config, refreshing
				include 'text-en.php';

				// Testing language file
				if (!$valide = is_readable("util/text-".$CONFIG['lang'].".php")) {
					$ERRORS[] = getMessage('no_language_file');
				}

				// Testing database config
				$root = new Node(0);
				if ($root->isError()) {
					$ERRORS[] = $root->lastError();
					$valide = false;
				}

				if ($valide) {
					$handle = fopen("util/config.php","w");
					if ($handle) {
						fwrite($handle,"<?php\n");
						fwrite($handle,"#This is a generated file, edit at your own risk !\n");
						unset($_POST['login']);
						unset($_POST['password']);
						//preserve setup is lock
						if($preserveLock == TRUE){
							fwrite($handle,"\t".'$CONFIG[\''."first_setup_lock".'\'] = "'."TRUE".'";'."\n");
							unset($_POST['first_setup_lock']);
						}
						foreach ($_POST as $name => $value) {
							//get Printer servers list
							if(substr($name,0,15) == "printer_servers" && $value){
								$printerServers[] = $value;
							}else if(substr($name,0,10) == "group_ldap" && strlen($value)>1){
								$ldapGroupRole[$value]=$_POST["role_".$name];
							}else if(substr($name,0,15) == "role_group_ldap" && $value){
								//this is a role, it is process with the group (previous if)
							}else if($value) fwrite($handle,"\t".'$CONFIG[\''.$name.'\'] = "'.$value.'";'."\n");
						}
						$hasPrinterServers = FALSE;
						$printerCount=0;
						if(is_array($printerServers)){
							foreach($printerServers as $printerServer){
								$printerCount++;
								if($printerCount == 1){
									$hasPrinterServers = TRUE;
									$printerServersStr = '$CONFIG[\'printer_servers\'] = array("'.$printerServer.'"';
								}else{
									$printerServersStr = $printerServersStr.',"'.$printerServer.'"';
								}
								$CONFIG['printer_servers'][] = $printerServer;
							}
						}
						if($printerCount > 0){
							$printerServersStr = $printerServersStr.');';
							fwrite($handle,"\t".$printerServersStr."\n");
						}
                        fwrite($handle,"\t".'$CONFIG[\'rootInstall\']="'.basePath()."\";\n");
                        fwrite($handle,"\n?>\n");
						fclose($handle);
						//if ($first_start) {
						if ($_POST['first_setup_lock']=="TRUE") {
							ltsp_goto();
							break;
						}
						else {
							$CONFIRMATIONS[] = getMessage('new_cfg_created');
						}
						//write the group->role in the entityRole-config.php file ifi ldap is use***************
						$roleHandle = fopen("util/entityRole-config.php","w");
						if ($roleHandle) {
							fwrite($roleHandle,"<?php\n");
							fwrite($roleHandle,"#This is a generated file, edit at your own risk !\n");
							$groupCount=0;
							unset($GROUP_ROLE);
							if(is_array($ldapGroupRole)){
								foreach ($ldapGroupRole as $groupToAdd => $roleToAdd) {
									$groupCount++;
									$hasGroups = TRUE;
									$groupRoleStr = '$GROUP_ROLE[\''.strtolower($groupToAdd).'\'] ="'.$roleToAdd."\";\n";
									fwrite($roleHandle,$groupRoleStr);
									$GROUP_ROLE[$groupToAdd] = $roleToAdd;
								}
							}
							fwrite($roleHandle,"\n?>\n");
							fclose($roleHandle);
						}
					}
					else {
						$ERRORS[] = getMessage('cannot_open_cfg_file');
					}
				}
				// Dropping to default
				//unset($GLOBALS[CONFIG]);
				//unset($CONFIG);
				global $CONFIG;
				if (is_readable("config.php")) {
					include "config.php";
				}
			//test ldap user
			}else if($_POST['test']){
			//testing authentification service
			// Testing ldap
			$auth = new Auth($_POST['login'],$_POST['password']);
			$error = $auth->authenticate();
			unset($CONFIG['login']);
			unset($CONFIG['password']);
				if(!empty($error)){
					$ERRORS[] = $error;
				}else{
					$CONFIRMATIONS[]=getMessage('group_role_msg');
					$user = $auth->userData;
					$gr = $user->getGroups();
					if(empty($gr)){
						$CONFIRMATIONS[]=getMessage('no_group_role_msg');
					}else{
						foreach($user->getGroups() as $group){
							if($GROUP_ROLE[strtolower($group)]){
								$CONFIRMATIONS[] = $group."--->".$GROUP_ROLE[strtolower($group)];
							}else{
								$CONFIRMATIONS[] = $group."--->".getMessage('no_role_msg');
							}
						}
					}

				}
			}else if($_POST['lock_setup']){
				//we only need to change first_setup_lock form false to true
				$CONFIG['first_setup_lock']="TRUE";
				$handle = fopen("util/config.php","w");
				if ($handle) {
					fwrite($handle,"<?php\n");
					fwrite($handle,"#This is a generated file, edit at your own risk !\n");
					foreach($CONFIG as $name => $value){
						//printers are in a array

						if(is_array($value)){
							$valueStr="array(";
							$count=0;
							foreach($value as $val){
								$count++;
								if($count == 1){
									$valueStr = $valueStr.'"'.$val.'"';
								}else{
									$valueStr = $valueStr.','.'"'.$val.'"';
								}
							}
							$valueStr = $valueStr.")";
							fwrite($handle,"\t".'$CONFIG[\''.$name.'\'] = '.$valueStr.';'."\n");
						}else if($value) fwrite($handle,"\t".'$CONFIG[\''.$name.'\'] = "'.$value.'";'."\n");
					}
                   fwrite($handle,"\n?>\n");
                   ltsp_goto();
					break;
				}

			}

			include "errorsView.php";
			include "setupView.php";
			break;
	}

?>
