<?php
/////////////////////////////////////////////////////////////////////////
// File Name : Node_Chooser.php
// Creation Date : July 2006
// Description : This file allows the user to choose the nodes he wants informations about
//
// Modifications : -
//
/////////////////////////////////////////////////////////////////////////

	include "header.php";
	include "functions/create_nodes.php";

	if( count( $_SESSION['tree'] ) == 0 ){
		$tree = create_nodes();
	} else {
		$tree = $_SESSION['tree'];
	}

	// Shows the childs of a node
	if( isset( $_GET['open'] ) ){
		$index = $_GET['open'];
		if( !$tree[ $index ]->is_opened ){
			$tree[ $index ]->open();
		}
	}

	// Hides the childs of a node
	if( isset( $_GET['close'] ) ){
		$index = $_GET['close'];
		if( $tree[ $index ]->is_opened ){
			$tree[ $index ]->close();
		}
	}

	// Checks a node and all it's childs + verifies the status of the parents
	if( isset( $_GET['check'] ) ){
		$index = $_GET['check'];
		if( !$tree[ $index ]->is_checked() ){
			checkChild($index);
			changeParentStatus($index);
		}
	}

	// Unchecks a node and all it's childs + verifies the status of the parents
	if( isset( $_GET['uncheck'] ) ){
		$index = $_GET['uncheck'];
		if( $tree[ $index ]->is_checked() ){
			uncheckChild($index);
			changeParentStatus($index);
		}
	}
	
	// Node_Kind is for the end of the Request, only this kind of node's information will be shown
	// 0 = Contexts, 1 = Terminals, 2 = All
	if( isset( $_GET['node_kind'] ) ){
		$_SESSION['node_kind'] = $_GET['node_kind'];
	}

	// Puts every child (and grand-childs) of an ID to checked
	function checkChild( $id ){
		global $tree;
		if( !$tree[ $id ]->is_checked() ){
			$tree[ $id ]->status = 2;
			$childs = $tree[ $id ]->returnChild( $tree );
			for( $i = 0; $i < count( $childs ); $i++){
				checkChild( $tree[ $childs[$i] ]->id );
			}
		}
	}

	// Puts every child (and grand-childs) of an ID to unchecked
	function uncheckChild( $id ){
		global $tree;
		if( $tree[ $id ]->is_checked() ){
			$tree[ $id ]->status = 0;
			$childs = $tree[ $id ]->returnChild( $tree );
			for( $i = 0; $i < count( $childs ); $i++){
				uncheckChild( $tree[ $childs[$i] ]->id );
			}
		}
	}

	// Verifies the childs of a node to change its status accordingly
	// Statuses : 0 unchecked or no sons checked / 1 checked or some sons checked / 2 checked and all sons checked
	function changeParentStatus( $id ){
		global $tree;
		$id_parent = $tree[ $id ]->id_parent;
		$childs = $tree[ $id_parent]->returnChild( $tree );
		$nb_checked = 0;
		for( $i = 0; $i < count( $childs ); $i++ ){
			$nb_checked += $tree[ $childs[$i] ]->status;
		}

		// Because this tests only parent-nodes, it is sure that it has childs
		if( $nb_checked == 0 ){
			// All childs Statuses are at 0
			$tree[ $id_parent ]->status = 0;
		} else if( $nb_checked == count( $childs ) * 2 ){
			// All childs Statuses are at 2
			$tree[ $id_parent ]->status = 2;
		} else {
			$tree[ $id_parent ]->status = 1;
		}

		// Don't roll around Root (who points itself)
		if( $id_parent <> $id ){
			changeParentStatus( $id_parent );
		}
	}

	// Prints the info of the ID, looks if it has childs, if it does, prints them recursively
	function printTree( $id ){
		global $tree;
		global $shown_page;
		$node = $tree[ $id ];
		$childs = $node->returnChild( $tree );
		$mode = $_SESSION['node_kind'];
		// Open is the ± sign, Check is the check box
		$showOpen = $showCheck = true;

		// Mode 1 : Terminals only
		if( $mode == 1 && $node->type == 0 && count( $childs ) == 0 ){
			$showCheck = false;
		// Mode 2 : Contexts only
		} else if( $mode == 0 && $node->type == 1 ) {
			$showCheck = false;
		}
		if( count( $childs ) == 0 ){
			$showOpen = false;
		}
		echo "<ul><li>";
		if( $showOpen ){
			echo "<a name='".$id."' href='".$shown_page."?step=1&";
			if( $node->is_opened ){
				echo "close=".$id."#".$node->id_parent."'";
			} else {
				echo "open=".$id."#".$id."'";
			}
			echo "><img src='images/";
			if( $node->is_opened ){
				echo "minus.gif' alt='-' title='-'";
			} else {
				echo "plus.gif' alt='+' title='+'";
			}
			echo " title=''></a>";
		}

		if( $node->type == 0 ){
			echo "<span>".$node->toString()."</span>";
		} else {
			echo $node->toString();
		}

		if( $showCheck ){
			echo "<a href='".$shown_page."?step=1&";
			if( $node->is_checked() ){
				echo "un";
			}
			echo "check=".$id."#".$id."'>";
				if( is_int( $node->status ) ){
					echo "<img src='images/check".$node->status.".gif";
				}
				echo "' title='' alt=''>";
			echo "</a>";
		}

		if( $node->is_opened ){
			for( $i = 0; $i < count( $childs ); $i++ ){
				printTree( $childs[ $i ] );
			}
		}
		echo "</li></ul>";
	}
	$_SESSION['tree'] = $tree;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<HTML>
	<HEAD>
		<TITLE>Step 1</TITLE>
		<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8">
		<link rel='stylesheet' type='text/css' href='style.css'>
	</HEAD>
	<BODY>
		<div>
			<?php
				echo getMessage('stats_node_selector_msg');
				// Print the tree from Root
				printTree( 0 );
			?>
		</div>
	</BODY>
</HTML>
