#!/usr/bin/env python

"""
Test file
"""

import traceback
from lbserverfactory import *
from lbserver import *

class TestLBServerFactory(LBServerFactory):
    def _createLBServer(self):
        return TestLBServer()
    def newLBServer(self):
        lbServer = self._loadLBServer(self.dom.childNodes[0])
        return lbServer

class TestLBServer(LBServer):
    def refreshNodesValues(self):
        for n in self.getNodes():
            if n.name == "server1":
                list = {}
                list["CPUVENDOR"] = LBNodeValue(n,{"name":"CPUVENDOR","value":"GenuineIntel"})
                list["CPUCOUNT"] = LBNodeValue(n,{"name":"CPUCOUNT","value":"1"})
                list["CPUFREQ"] = LBNodeValue(n,{"name":"CPUFREQ","value":"2000"})
                list["MEMTOTAL"] = LBNodeValue(n,{"name":"MEMTOTAL","value":"514212"})
                list["IP"] = LBNodeValue(n,{"name":"IP","value":"1.1.1.1"})
                list["NBX11SESS"] = LBNodeValue(n,{"name":"NBX11SESS","value":"0"})
                list["X11_INACTIVE"] = LBNodeValue(n,{"name":"X11_INACTIVE","value":"0"})
                list["MEMUSED"] = LBNodeValue(n,{"name":"MEMUSED","value":"0"})
                list["LOADAVG"] = LBNodeValue(n,{"name":"LOADAVG","value":"0"})
                n.updateValues(list)
            elif n.name == "server2":
                list = {}
                list["CPUFREQ"] = LBNodeValue(n,{"name":"CPUFREQ","value":"1000"})
                list["CPUVENDOR"] = LBNodeValue(n,{"name":"CPUVENDOR","value":"GenuineIntel"})
                list["CPUCOUNT"] = LBNodeValue(n,{"name":"CPUCOUNT","value":"1"})
                list["MEMTOTAL"] = LBNodeValue(n,{"name":"MEMTOTAL","value":"256212"})
                list["IP"] = LBNodeValue(n,{"name":"IP","value":"0.0.0.0"})
                list["NBX11SESS"] = LBNodeValue(n,{"name":"NBX11SESS","value":"5"})
                list["X11_INACTIVE"] = LBNodeValue(n,{"name":"X11_INACTIVE","value":"0"})
                list["MEMUSED"] = LBNodeValue(n,{"name":"MEMUSED","value":"112000"})
                list["LOADAVG"] = LBNodeValue(n,{"name":"LOADAVG","value":".6"})
                n.updateValues(list)
            elif n.name == "server3":
                list = {}
                list["1"] = LBNodeValue(n,{"name":"1","value":"2"})
                list["1"] = LBNodeValue(n,{"name":"1","value":"2"})
                n.updateValues(list)
            elif n.name == "server4":
                list = {}
                list["1"] = LBNodeValue(n,{"name":"1","value":"2"})
                list["1"] = LBNodeValue(n,{"name":"1","value":"2"})
                n.updateValues(list)

def test1():
    try:
        factory = TestLBServerFactory("lbsconfig.xml")
        lbServer = factory.newLBServer()
        lbServer.refreshNodesValues()
        #for x in range(70):
        print lbServer.getNextServerForGroup('SCHOOL_X')
        #   print lbServer.getStatusStruct()
    except Exception,e:
        traceback.print_exception(sys.exc_info()[0],sys.exc_info()[1],sys.exc_info()[2])
    print "END"

def main():
    test1()

if __name__ == "__main__":
    main()
