/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.Insn;
import jas.InsnOperand;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class LabelOperand
extends InsnOperand {
    Label target;
    Insn source;
    boolean wide;
    int ref;

    LabelOperand(Label l, Insn source, int line) {
        this.target = l;
        this.source = source;
        this.wide = false;
        this.ref = line;
    }

    LabelOperand(Label l, Insn source, boolean wide, int line) {
        this.target = l;
        this.source = source;
        this.wide = wide;
        this.ref = line;
    }

    int size(ClassEnv ce, CodeAttr code) {
        if (this.wide) {
            return 4;
        }
        return 2;
    }

    void resolve(ClassEnv e) {
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        if (this.wide) {
            this.target.writeWideOffset(ce, this.source, out);
        } else {
            int offset = ce.getPc(this.target);
            if (this.source != null) {
                offset -= ce.getPc(this.source);
            }
            if (offset > Short.MAX_VALUE || offset < Short.MIN_VALUE) {
                throw new jasError("reference from line " + this.ref + " exceed size for short");
            }
            this.target.writeOffset(ce, this.source, out);
        }
    }
}

