#if   !defined(__LISTER_HPP)
#define __LISTER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__VECTOR_HPP)
#include <corelinux/Vector.hpp>
#endif

#if   !defined(__SUBJECTOBSERVER_HPP)
#include <SubjectObserver.hpp>
#endif


DECLARE_CLASS( Lister );

/**
Does anybody read these things? Anyway, Lister is
the maintainer of the list, and is interested in changes
made to keep it current
*/

class Lister : public SubjectObserver
{
   CORELINUX_VECTOR(  string ,  ListEntries );

public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        Lister( void );   

                        /// Virtual destructor

   virtual              ~Lister( void );   

   //
   // Operator overloads
   //

            /// Equality test

            bool operator==( ListerCref ) const;

   //
   // Accessors
   //

   //
   // Mutators
   //

            /**
            Called once to get the list ready. I'm sure there are more
            imaginitive ways. This is actually a by product of hurried
            example writing, violating many of my own standards. Well,
            my son had a baseball game I had to go to so I cut it
            short!
            */
            
            void  initialize( void );

            /**
            Called by the subject when an event we are interested in
            gets generated.
            @param Event pointer to event
            */

   virtual  void  event( CORELINUX( Event<corelinux::Identifier> ) * ) throw ( CORELINUX(NullPointerException) );


protected:

                     /// Copy constructor
                  
                     Lister( ListerCref ) throw ( CORELINUX( Assertion ) );

            /// Assignment operator
         
            ListerRef  operator=( ListerCref ) throw ( CORELINUX( Assertion ) );

private:

         /// The infamous list

         ListEntries    theList;

};

#endif // if !defined(__LISTER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/


