//-------------------------------------------------------------------------
// Desc:	FLAIM text routines and conversion tables
// Tabs:	3
//
//		Copyright (c) 1991-2006 Novell, Inc. All Rights Reserved.
//
//		This program is free software; you can redistribute it and/or
//		modify it under the terms of version 2 of the GNU General Public
//		License as published by the Free Software Foundation.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, contact Novell, Inc.
//
//		To contact Novell about this file by physical or electronic mail,
//		you may find current contact information at www.novell.com
//
// $Id$
//-------------------------------------------------------------------------

#include "flaimsys.h"

#define WP60toUni_MAX					15
#define WPCH_HIMASK	   				0x00FF
#define WPCH_LOMASK	   				0xFF00
#define WPCH_MAX_COMPLEX				5

/****************************************************************************
Desc:	WP60 to Unicode - Multinational 1
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI1[ 256] = 
{
	0x0300, 0x00B7, 0x0303, 0x0302, 0x0335,
	0x0338, 0x0301, 0x0308, 0x0304, 0x0313,
	0x0315, 0x02BC, 0x0326, 0x0315, 0x030A,
	0x0307, 0x030B, 0x0327, 0x0328, 0x030C,
	0x0337, 0x0305, 0x0306, 0x00DF, 0x0138,
	0xF801, 0x00C1, 0x00E1, 0x00C2, 0x00E2,
	0x00C4, 0x00E4, 0x00C0, 0x00E0, 0x00C5,
	0x00E5, 0x00C6, 0x00E6, 0x00C7, 0x00E7,
	0x00C9, 0x00E9, 0x00CA, 0x00EA, 0x00CB,
	0x00EB, 0x00C8, 0x00E8, 0x00CD, 0x00ED,
	0x00CE, 0x00EE, 0x00CF, 0x00EF, 0x00CC,
	0x00EC, 0x00D1, 0x00F1, 0x00D3, 0x00F3,
	0x00D4, 0x00F4, 0x00D6, 0x00F6, 0x00D2,
	0x00F2, 0x00DA, 0x00FA, 0x00DB, 0x00FB,
	0x00DC, 0x00FC, 0x00D9, 0x00F9, 0x0178,
	0x00FF, 0x00C3, 0x00E3, 0x0110, 0x0111,
	0x00D8, 0x00F8, 0x00D5, 0x00F5, 0x00DD,
	0x00FD, 0x00D0, 0x00F0, 0x00DE, 0x00FE,
	0x0102, 0x0103, 0x0100, 0x0101, 0x0104,
	0x0105, 0x0106, 0x0107, 0x010C, 0x010D,
	0x0108, 0x0109, 0x010A, 0x010B, 0x010E,
	0x010F, 0x011A, 0x011B, 0x0116, 0x0117,
	0x0112, 0x0113, 0x0118, 0x0119, 0x0047,
	0x0067, 0x011E, 0x011F, 0x0047, 0x0067,
	0x0122, 0x0123, 0x011C, 0x011D, 0x0120,
	0x0121, 0x0124, 0x0125, 0x0126, 0x0127,
	0x0130, 0x0069, 0x012A, 0x012B, 0x012E,
	0x012F, 0x0128, 0x0129, 0x0132, 0x0133,
	0x0134, 0x0135, 0x0136, 0x0137, 0x0139,
	0x013A, 0x013D, 0x013E, 0x013B, 0x013C,
	0x013F, 0x0140, 0x0141, 0x0142, 0x0143,
	0x0144, 0xF802, 0x0149, 0x0147, 0x0148,
	0x0145, 0x0146, 0x0150, 0x0151, 0x014C,
	0x014D, 0x0152, 0x0153, 0x0154, 0x0155,
	0x0158, 0x0159, 0x0156, 0x0157, 0x015A,
	0x015B, 0x0160, 0x0161, 0x015E, 0x015F,
	0x015C, 0x015D, 0x0164, 0x0165, 0x0162,
	0x0163, 0x0166, 0x0167, 0x016C, 0x016D,
	0x0170, 0x0171, 0x016A, 0x016B, 0x0172,
	0x0173, 0x016E, 0x016F, 0x0168, 0x0169,
	0x0174, 0x0175, 0x0176, 0x0177, 0x0179,
	0x017A, 0x017D, 0x017E, 0x017B, 0x017C,
	0x014A, 0x014B, 0xF000, 0xF001, 0xF002,
	0xF003, 0xF004, 0xF005, 0xF006, 0xF007,
	0xF008, 0xF009, 0xF00A, 0xF00B, 0xF00C,
	0xF00D, 0xF00E, 0xF00F, 0x010E, 0x010F,
	0x01A0, 0x01A1, 0x01AF, 0x01B0, 0x0114,
	0x0115, 0x012C, 0x012D, 0x0049, 0x0131,
	0x014E, 0x014F, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Standard Phonetic
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI2[ 256] =
{
	0x02B9, 0x02BA, 0x02BB, 0xF813, 0x02BD,
	0x02BC, 0xF814, 0x02BE, 0x02BF, 0x0310,
	0x02D0, 0x02D1, 0x0306, 0x032E, 0x0329,
	0x02C8, 0x02CC, 0x02C9, 0x02CA, 0x02CB,
	0x02CD, 0x02CE, 0x02CF, 0x02C6, 0x02C7,
	0x02DC, 0x0325, 0x02DA, 0x032D, 0x032C,
	0x0323, 0x0308, 0x0324, 0x031C, 0x031D,
	0x031E, 0x031F, 0x0320, 0x0321, 0x0322,
	0x032A, 0x032B, 0x02D2, 0x02D3, 0xF815,
	0xF816, 0x005F, 0x2017, 0x033E, 0x02DB,
	0x0327, 0x02DE, 0x02C8, 0x02B0, 0x02B6,	
	0x0250, 0x0251, 0x0252, 0x0253, 0x0299, 
	0x0254, 0x0255, 0x0297,	0x0256, 0x0257,
	0x0258, 0x0259, 0x025A,	0x025B, 0x025C,
	0x025D, 0x029A, 0x025E, 0x025F, 0x0278,
	0x0261, 0x0260, 0x0262, 0x029B, 0x0263,
	0x0264, 0x0265, 0x0266, 0x0267, 0x029C,
	0x0268, 0x026A, 0x0269, 0x029D, 0x029E,
	0x026B, 0x026C, 0x026D, 0x029F, 0x026E,
	0x028E, 0x026F, 0x0270, 0x0271, 0x0272, 
	0x0273, 0x0274, 0x0276, 0x0277, 0x02A0, 
	0x0279, 0x027A, 0x027B, 0x027C, 0x027D, 
	0x027E, 0x027F, 0x0280, 0x0281, 0x0282,
	0x0283, 0x0284, 0x0285, 0x0286, 0x0287,
	0x0288, 0x0275, 0x0289, 0x028A, 0x028C,
	0x028B, 0x028D, 0x0058, 0x028F, 0x0290,
	0x0291, 0x0292, 0x0293, 0x0294, 0x0295,
	0x0296, 0x02A1, 0x02A2, 0x0298, 0x02A3,
	0x02A4, 0x02A5, 0x02A6, 0x02A7, 0x02A8,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP51/WP60 to Unicode - Box Drawing
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WPUNI3[ 256] = 
{
	0x2591, 0x2592, 0x2593, 0x2588, 0x258C,
	0x2580, 0x2590, 0x2584, 0x2500, 0x2502,
	0x250C, 0x2510, 0x2518, 0x2514, 0x251C,
	0x252C, 0x2524, 0x2534, 0x253C, 0x2550,
	0x2551, 0x2554, 0x2557, 0x255D, 0x255A,
	0x2560, 0x2566, 0x2563, 0x2569, 0x256C,
	0x2552, 0x2555, 0x255B, 0x2558, 0x2553,
	0x2556, 0x255C, 0x2559, 0x255E, 0x2565,
	0x2561, 0x2568, 0x255F, 0x2564, 0x2562,
	0x2567, 0x256B, 0x256A, 0x2574, 0x2575,
	0x2576, 0x2577, 0x2578, 0x2579, 0x257A,
	0x257B, 0x257C, 0x257E, 0x257D, 0x257F,
	0x251F, 0x2522, 0x251E, 0x2521, 0x252E,
	0x2532, 0x252D, 0x2531, 0x2527, 0x2526,
	0x252A, 0x2529, 0x2536, 0x253A, 0x2535,
	0x2539, 0x2541, 0x2546, 0x253E, 0x2540,
	0x2544, 0x254A, 0x253D, 0x2545, 0x2548,
	0x2543, 0x2549, 0x2547, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP51/WP60 to Unicode - Typographic Symbols
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WPUNI4[ 256] = 
{
	0x25CF, 0x25CB, 0x25A0, 0x2022, 0xF817,
	0x00B6, 0x00A7, 0x00A1, 0x00BF, 0x00AB,
	0x00BB, 0x00A3, 0x00A5, 0x20A7, 0x0192,
	0x00AA, 0x00BA, 0x00BD, 0x00BC, 0x00A2,
	0x00B2, 0x207F, 0x00AE, 0x00A9, 0x00A4,
	0x00BE, 0x00B3, 0x201B, 0x2019, 0x2018,
	0x201F, 0x201D, 0x201C, 0x2013, 0x2014,
	0x2039, 0x203A, 0x25CB, 0x25A1, 0x2020,
	0x2021, 0x2122, 0x2120, 0x211E, 0x25CF,
	0x25E6, 0x25A0, 0x25AA, 0x25A1, 0x25AB,
	0x2012, 0xFB00, 0xFB03, 0xFB04, 0xFB01,
	0xFB02, 0x2026, 0x0024, 0x20A3, 0x20A2,
	0x20A0, 0x20A4, 0x201A, 0x201E, 0x2153,
	0x2154, 0x215B, 0x215C, 0x215D, 0x215E,
	0x24C2, 0x24C5, 0x24CA, 0x2105, 0x2106,
	0x2030, 0x2116, 0xF818, 0x00B9, 0x2409,
	0x240C, 0x240D, 0x240A, 0x2424, 0x240B,
	0xF819, 0x20A9, 0x20A6, 0x20A8, 0xF81A,
	0xF81B, 0xF81C, 0xF81D, 0xF81E, 0xF81F,
	0xF820, 0xF821, 0xF822, 0xF823, 0xF824,
	0xF825, 0xF826, 0x20AC, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Iconic Symbols
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI5[ 256] = 
{
	0x2661, 0x2662, 0x2667, 0x2664, 0x2642,
	0x2640, 0x263C, 0x263A, 0x263B, 0x266A,
	0x266C, 0x25AC, 0x2302, 0x203C, 0x221A,
	0x21A8, 0x2310, 0x2319, 0x25D8, 0x25D9,
	0x21B5, 0x2104, 0x261C, 0x2007, 0x2610,
	0x2612, 0x2639, 0x266F, 0x266D, 0x266E,
	0x260E, 0x231A, 0x231B, 0x2701, 0x2702,
	0x2703, 0x2704, 0x260E, 0x2706, 0x2707,
	0x2708, 0x2709, 0x261B, 0x261E, 0x270C,
	0x270D, 0x270E, 0x270F, 0x2710, 0x2711,
	0x2712, 0x2713, 0x2714, 0x2715, 0x2716,
	0x2717, 0x2718, 0x2719, 0x271A, 0x271B,
	0x271C, 0x271D, 0x271E, 0x271F, 0x2720,
	0x2721, 0x2722, 0x2723, 0x2724, 0x2725,
	0x2726, 0x2727, 0x2605, 0x2729, 0x272A,
	0x272B, 0x272C, 0x272D, 0x272E, 0x272F,
	0x2730, 0x2731, 0x2732, 0x2733, 0x2734,
	0x2735, 0x2736, 0x2737, 0x2738, 0x2739,
	0x273A, 0x273B, 0x273C, 0x273D, 0x273E,
	0x273F, 0x2740, 0x2741, 0x2742, 0x2743,
	0x2744, 0x2745, 0x2746, 0x2747, 0x2748,
	0x2749, 0x274A, 0x274B, 0x25CF, 0x274D,
	0x25A0, 0x274F, 0x2750, 0x2751, 0x2752,
	0x25B2, 0x25BC, 0x25C6, 0x2756, 0x25D7,
	0x2758, 0x2759, 0x275A, 0x275B, 0x275C,
	0x275D, 0x275E, 0x2036, 0x2033, 0xF827,
	0xF828, 0xF829, 0xF82A, 0x2329, 0x232A,
	0x005B, 0x005D, 0xF82B, 0xF82C, 0xF82D,
	0xF82E, 0xF82F, 0xF830, 0xF831, 0x2190,
	0xF832, 0xF833, 0xF834, 0xF835, 0xF836,
	0x21E8, 0x21E6, 0x2794, 0xF838, 0xF839,
	0xF83A, 0xF83B, 0xF83C, 0x25D6, 0xF83D,
	0xF83E, 0x2761, 0x2762, 0x2763, 0x2764,
	0x2765, 0x2766, 0x2767, 0x2663, 0x2666,
	0x2665, 0x2660, 0x2780, 0x2781, 0x2782,
	0x2783, 0x2784, 0x2785, 0x2786, 0x2787,
	0x2788, 0x2789, 0x2776, 0x2777, 0x2778,
	0x2779, 0x277A, 0x277B, 0x277C, 0x277D,
	0x277E, 0x277F, 0x2780, 0x2781, 0x2782,
	0x2783, 0x2784, 0x2785, 0x2786, 0x2787,
	0x2788, 0x2789, 0x278A, 0x278B, 0x278C,
	0x278D, 0x278E, 0x278F, 0x2790, 0x2791,
	0x2792, 0x2793, 0x2794, 0x2192, 0x2194,
	0x2195, 0x2798, 0x2799, 0x279A, 0x279B,
	0x279C, 0x279D, 0x279E, 0x279F, 0x27A0,
	0x27A1, 0x27A2, 0x27A3, 0x27A4, 0x27A5,
	0x27A6, 0x27A7, 0x27A8, 0x27A9, 0x27AA,
	0x27AB, 0x27AC, 0x27AD, 0x27AE, 0x27AF,
	0xF83F, 0x27B1, 0x27B2, 0x27B3, 0x27B4,
	0x27B5, 0x27B6, 0x27B7, 0x27B8, 0x27B9,
	0x27BA, 0x27BB, 0x27BC, 0x27BD, 0x27BE,
	0x0000
};

/****************************************************************************
Desc:	WP51/WP60 to Unicode - Math/Scientific
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WPUNI6[ 256] = 
{
	0x2212, 0x00B1, 0x2264, 0x2265, 0x221D,
	0x01C0, 0x2215, 0x2216, 0x00F7, 0x2223,
	0x2329, 0x232A, 0x223C, 0x2248, 0x2261,
	0x2208, 0x2229, 0x2225, 0x2211, 0x221E,
	0x00AC, 0x2192, 0x2190, 0x2191, 0x2193,
	0x2194, 0x2195, 0x25B8, 0x25C2, 0x25B4,
	0x25BE, 0x22C5, 0xF850, 0x2218, 0x2219,
	0x212B, 0x00B0, 0x00B5, 0x203E, 0x00D7,
	0x222B, 0x220F, 0x2213, 0x2207, 0x2202,
	0x02B9, 0x02BA, 0x2192, 0x212F, 0x2113,
	0x210F, 0x2111, 0x211C, 0x2118, 0x21C4,
	0x21C6, 0x21D2, 0x21D0, 0x21D1, 0x21D3,
	0x21D4, 0x21D5, 0x2197, 0x2198, 0x2196,
	0x2199, 0x222A, 0x2282, 0x2283, 0x2286,
	0x2287, 0x220D, 0x2205, 0x2308, 0x2309,
	0x230A, 0x230B, 0x226A, 0x226B, 0x2220,
	0x2297, 0x2295, 0x2296, 0xF851, 0x2299,
	0x2227, 0x2228, 0x22BB, 0x22A4, 0x22A5,
	0x2312, 0x22A2, 0x22A3, 0x25A1, 0x25A0,
	0x25CA, 0xF852, 0xF853, 0xF854, 0x2260,
	0x2262, 0x2235, 0x2234, 0x2237, 0x222E,
	0x2112, 0x212D, 0x2128, 0x2118, 0x20DD,
	0xF855, 0x25C7, 0x22C6, 0x2034, 0x2210,
	0x2243, 0x2245, 0x227A, 0x227C, 0x227B,
	0x227D, 0x2203, 0x2200, 0x22D8, 0x22D9,
	0x228E, 0x228A, 0x228B, 0x2293, 0x2294,
	0x228F, 0x2291, 0x22E4, 0x2290, 0x2292,
	0x22E5, 0x25B3, 0x25BD, 0x25C3, 0x25B9,
	0x22C8, 0x2323, 0x2322, 0xF856, 0x219D,
	0x21A9, 0x21AA, 0x21A3, 0x21BC, 0x21BD,
	0x21C0, 0x21C1, 0x21CC, 0x21CB, 0x21BF,
	0x21BE, 0x21C3, 0x21C2, 0x21C9, 0x21C7,
	0x22D3, 0x22D2, 0x22D0, 0x22D1, 0x229A,
	0x229B, 0x229D, 0x2127, 0x2221, 0x2222,
	0x25C3, 0x25B9, 0x25B5, 0x25BF, 0x2214,
	0x2250, 0x2252, 0x2253, 0x224E, 0x224D,
	0x22A8, 0xF857, 0x226C, 0x0285, 0x2605,
	0x226E, 0x2270, 0x226F, 0x2271, 0x2241,
	0x2244, 0x2247, 0x2249, 0x2280, 0x22E0,
	0x2281, 0x22E1, 0x2284, 0x2285, 0x2288,
	0x2289, 0xF858, 0xF859, 0x22E2, 0x22E3,
	0x2226, 0x2224, 0x226D, 0x2204, 0x2209,
	0xF85A, 0x2130, 0x2131, 0x2102, 0xF85B, 
	0x2115, 0x211D, 0x225F, 0x221F, 0x220B,
	0x22EF, 0xF85C, 0x22EE, 0x22F1, 0xF85D,
	0x20E1, 0x002B, 0x002D, 0x003D, 0x002A,
	0xF85E, 0xF85F, 0xF860, 0x210C, 0x2118, 
	0x2272, 0x2273, 0xF861, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP51/WP60 to Unicode - Math/Science Extension
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WPUNI7[ 256] =
{
	0x2320, 0x2321, 0xF702, 0xF703, 0x221A,
	0xF705, 0xF706, 0xF707, 0xF708, 0xF709,
	0xF70A, 0xF70B, 0xF70C, 0xF70D, 0xF70E,
	0xF70F, 0xF710, 0xF711, 0xF712, 0xF713,
	0xF714, 0xF715, 0xF716, 0xF717, 0xF718,
	0xF719, 0xF71A, 0xF71B, 0xF71C, 0xF71D,
	0xF71E, 0xF71F, 0xF720, 0xF721, 0xF722,
	0xF723, 0xF724, 0xF725, 0xF726, 0xF727,
	0xF728, 0xF729, 0xF72A, 0xF72B, 0xF72C,
	0xF72D, 0xF72E, 0xF72F, 0xF730, 0xF731,
	0xF732, 0xF733, 0xF734, 0xF735, 0xF736,
	0xF737, 0xF738, 0xF739, 0xF73A, 0xF73B,
	0xF73C, 0xF73D, 0xF73E, 0xF73F, 0xF740,
	0xF741, 0xF742, 0xF743, 0xF744, 0xF745,
	0xF746, 0xF747, 0xF748, 0xF749, 0xF74A,
	0xF74B, 0xF74C, 0xF74D, 0xF74E, 0xF74F,
	0xF750, 0xF751, 0xF752, 0xF753, 0xF754,
	0xF755, 0xF756, 0xF757, 0xF758, 0xF759,
	0xF75A, 0xF75B, 0xF75C, 0xF75D, 0xF75E,
	0xF75F, 0xF760, 0xF761, 0xF762, 0xF763,
	0xF764, 0xF765, 0xF766, 0xF767, 0xF768,
	0xF769, 0xF76A, 0xF76B, 0xF76C, 0xF76D,
	0xF76E, 0xF76F, 0xF770, 0xF771, 0xF772,
	0xF773, 0xF774, 0xF775, 0xF776, 0xF777,
	0xF778, 0xF779, 0xF77A, 0xF77B, 0xF77C,
	0xF77D, 0xF77E, 0xF77F, 0xF780, 0xF781,
	0xF782, 0xF783, 0xF784, 0xF785, 0xF786,
	0xF787, 0xF788, 0xF789, 0xF78A, 0xF78B,
	0xF78C, 0xF78D, 0xF78E, 0xF78F, 0xF790,
	0xF791, 0xF792, 0xF793, 0xF794, 0xF795,
	0xF796, 0xF797, 0xF798, 0xF799, 0xF79A,
	0xF79B, 0xF79C, 0xF79D, 0xF79E, 0xF79F,
	0xF7A0, 0xF7A1, 0xF7A2, 0xF7A3, 0xF7A4,
	0xF7A5, 0xF7A6, 0xF7A7, 0xF7A8, 0xF7A9,
	0xF7AA, 0xF7AB, 0xF7AC, 0xF7AD, 0xF7AE,
	0xF7AF, 0xF7B0, 0xF7B1, 0xF7B2, 0xF7B3,
	0xF7B4, 0xF7B5, 0xF7B6, 0xF7B7, 0xF7B8,
	0xF7B9, 0xF7BA, 0xF7BB, 0xF7BC, 0xF7BD,
	0xF7BE, 0xF7BF, 0xF7C0, 0xF7C1, 0xF7C2,
	0xF7C3, 0xF7C4, 0xF7C5, 0xF7C6, 0xF7C7,
	0xF7C8, 0xF7C9, 0xF7CA, 0xF7CB, 0xF7CC,
	0xF7CD, 0xF7CE, 0xF7CF, 0xF7D0, 0xF7D1,
	0xF7D2, 0xF7D3, 0xF7D4, 0xF7D5, 0xF7D6,
	0xF7D7, 0xF7D8, 0xF7D9, 0xF7DA, 0xF7DB,
	0xF7DC, 0xF7DD, 0xF7DE, 0xF7DF, 0xF7E0,
	0xF7E1, 0xF7E2, 0xF7E3, 0xF7E4, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Greek
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI8[ 256] = 
{
	0x0391, 0x03B1, 0x0392, 0x03B2, 0x0392,
	0x03D0, 0x0393, 0x03B3, 0x0394, 0x03B4,
	0x0395, 0x03B5, 0x0396, 0x03B6, 0x0397,
	0x03B7, 0x0398, 0x03B8, 0x0399, 0x03B9,
	0x039A, 0x03BA, 0x039B, 0x03BB, 0x039C,
	0x03BC, 0x039D, 0x03BD, 0x039E, 0x03BE,
	0x039F, 0x03BF, 0x03A0, 0x03C0, 0x03A1,
	0x03C1, 0x03A3, 0x03C3, 0x03A3, 0x03C2,
	0x03A4, 0x03C4, 0x03A5, 0x03C5, 0x03A6,
	0x03C6, 0x03A7, 0x03C7, 0x03A8, 0x03C8,
	0x03A9, 0x03C9, 0xF106, 0x03AC, 0xF107,
	0x03AD, 0xF108, 0x03AE, 0xF109, 0x03AF,
	0x03AA, 0x03CA, 0xF10A, 0x03CC, 0xF10B,
	0x03CD, 0x03AB, 0x03CB, 0xF10C, 0x03CE, 
	0x03B5, 0x03D1, 0x03F0, 0x03D6, 0x03F1,
	0x03DB, 0x03D2, 0x03D5, 0x03D6, 0x03D7, 
	0x00B7, 0x0374, 0x0375, 0x0301, 0x0308,
	0xF216, 0xF217, 0x0300, 0x0311, 0x0313,
	0x0314, 0x0345, 0x1FCE, 0x1FDE, 0x1FCD,
	0x1FDD, 0xF200, 0xF201, 0xF022, 0xF021,
	0xF202, 0xF203, 0xF204, 0xF300, 0xF301,
	0xF302, 0xF303, 0xF304, 0xF305, 0x1F70,
	0xF100, 0x1FB3, 0x1FB4, 0x1FB2, 0xF205,
	0x1F00, 0x1F04, 0x1F02, 0xF206, 0x1F80, 
	0x1F84, 0x1F82, 0xF306, 0x1F01, 0x1F05,
	0x1F03, 0xF207, 0x1F81, 0x1F85, 0x1F83,
	0xF307, 0x1F72, 0x1F10, 0x1F14, 0x1F12,
	0x1F11, 0x1F15, 0x1F13, 0x1F74, 0xF101,
	0x1FC3, 0x1FC4, 0x1FC2, 0xF208, 0x1F20,
	0x1F24, 0x1F22, 0xF209, 0x1F90, 0x1F94,
	0x1F92, 0xF308, 0x1F21, 0x1F25, 0x1F23,
	0xF20A, 0x1F91, 0x1F95, 0x1F93, 0xF309,
	0x1F76, 0xF102, 0xF20B, 0xF20C, 0x1F30,
	0x1F34, 0x1F32, 0xF20D, 0x1F31, 0x1F35,	
	0x1F33, 0xF20E, 0x1F78, 0x1F40, 0x1F44,
	0x1F42, 0x1F41, 0x1F45, 0x1F43, 0x1FE5, 
	0x1FE4, 0x1F7A, 0xF103, 0xF20F, 0xF210,
	0x1F50, 0x1F54, 0x1F52, 0xF211, 0x1F51,
	0x1F55, 0x1F53, 0xF212, 0x1F7C, 0xF104,
	0x1FF3, 0x1FF4, 0x1FF2, 0xF213, 0x1F60,
	0x1F64, 0x1F62, 0xF214, 0x1FA0, 0x1FA4,
	0x1FA2, 0xF30A, 0x1F61, 0x1F65, 0x1F63, 
	0xF215, 0x1FA1, 0x1FA5, 0x1FA3, 0xF30B,
	0x03DA, 0x03DC, 0x03DE, 0x03E0, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Hebrew
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI9[ 256] = 
{
	0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4,
	0x05D5, 0x05D6, 0x05D7, 0x05D8, 0x05D9,
	0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE,
	0x05DF, 0x05E0, 0x05E1, 0x05E2, 0x05E3,
	0x05E4, 0x05E5, 0x05E6, 0x05E7, 0x05E8,
	0x05E9, 0x05EA, 0xF862, 0x05C0, 0x05C3,
	0x05F3, 0x05F4, 0x05B0, 0x05B1, 0x05B2,
	0x05B3, 0x05B4, 0x05B5, 0x05B6, 0x05B7,
	0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x05BC,
	0x05BD, 0x05BF, 0x05B7, 0xFB1E, 0x05F0,
	0x05F1, 0x05F2, 0xF114, 0xF8B0, 0xF863,
	0xF864, 0xF865, 0xF866, 0xF867, 0xF868,
	0xF869, 0xF86A, 0xF86B, 0xF86C, 0xF86D,
	0xF86E, 0xF86F, 0xF870, 0xF871, 0xF872,
	0xF873, 0xF874, 0x05F3, 0x05F3, 0x05F4,
	0xF876, 0xF877, 0xF878, 0xF879, 0xF87A,
	0xF87B, 0xF87C, 0xF87D, 0xF87E, 0xF115,
	0xF116, 0xF87F, 0xF117, 0xF118, 0xF119,
	0xF11A, 0xF11B, 0xF11C, 0xF11D, 0xF11E,
	0xF11F, 0xF120, 0xF121, 0xF122, 0xF123,
	0xF124, 0xF125, 0xF126, 0xF127, 0xF218,
	0xF128, 0xF129, 0xF12A, 0xF12B, 0xF12C,
	0xF12D, 0xF880, 0xF12E, 0xF12F, 0xF130,
	0xF219, 0x05E9, 0xF131, 0xF132, 0xF140,
	0xF141, 0xF142, 0x20AA, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Cyrillic/Georgian
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI10[ 256] = 
{
	0x0410, 0x0430, 0x0411, 0x0431, 0x0412,
	0x0432, 0x0413, 0x0433, 0x0414, 0x0434,
	0x0415, 0x0435, 0x0401, 0x0451, 0x0416,
	0x0436, 0x0417, 0x0437, 0x0418, 0x0438,
	0x0419, 0x0439, 0x041A, 0x043A, 0x041B,
	0x043B, 0x041C, 0x043C, 0x041D, 0x043D,
	0x041E, 0x043E, 0x041F, 0x043F, 0x0420,
	0x0440, 0x0421, 0x0441, 0x0422, 0x0442,
	0x0423, 0x0443, 0x0424, 0x0444, 0x0425,
	0x0445, 0x0426, 0x0446, 0x0427, 0x0447,
	0x0428, 0x0448, 0x0429, 0x0449, 0x042A,
	0x044A, 0x042B, 0x044B, 0x042C, 0x044C,
	0x042D, 0x044D, 0x042E, 0x044E, 0x042F,
	0x044F, 0x04D8, 0x04D9, 0x0403, 0x0453,
	0x0490, 0x0491, 0x0492, 0x0493, 0x0402,
	0x0452, 0x0404, 0x0454, 0x0404, 0x0454,
	0x0496, 0x0497, 0x0405, 0x0455, 0xF159,
	0xF889, 0xF15E, 0xF15F, 0x0406, 0x0456,
	0x0407, 0x0457, 0xF88C, 0xF88D, 0x0408,
	0x0458, 0x040C, 0x045C, 0x049A, 0x049B,
	0xF160, 0xF161, 0x049C, 0x049D, 0x0409,
	0x0459, 0x04A2, 0x04A3, 0x040A, 0x045A,
	0x047A, 0x047B, 0x0460, 0x0461, 0x040B,
	0x045B, 0x040E, 0x045E, 0x04EE, 0x04EF,
	0x04AE, 0x04AF, 0x04B0, 0x04B1, 0x0194,
	0x0263, 0x04B2, 0x04B3, 0xF162, 0xF163,
	0x04BA, 0x04BB, 0x047E, 0x047F, 0x040F,
	0x045F, 0x04B6, 0x04B7, 0x04B8, 0x04B9,
	0xF164, 0xF165, 0x0462, 0x0463, 0x0466,
	0x0467, 0x046A, 0x046B, 0x046E, 0x046F,
	0x0470, 0x0471, 0x0472, 0x0473, 0x0474,
	0x0475, 0xF400, 0xF401, 0xF402, 0xF403,
	0xF404, 0xF405, 0xF406, 0xF407, 0xF408,
	0xF409, 0xF40A, 0xF40B, 0xF40C, 0xF40D,
	0xF40E, 0xF40F, 0xF410, 0xF411, 0xF412,
	0xF413, 0xF414, 0xF415, 0xF416, 0xF417,
	0xF418, 0xF419, 0xF41A, 0xF41B, 0xF41C,
	0xF41D, 0xF41E, 0xF41F, 0xF420, 0xF421,
	0xF422, 0xF423, 0xF424, 0xF425, 0xF426,
	0xF427, 0xF428, 0xF429, 0xF42A, 0xF42B,
	0x0301, 0x0300, 0x0308, 0x0306, 0x0326,
	0x0328, 0x0304, 0xF893, 0x201E, 0x201F,
	0x10D0, 0x10D1, 0x10D2, 0x10D3, 0x10D4,
	0x10D5, 0x10D6, 0x10F1, 0x10D7, 0x10D8,
	0x10D9, 0x10DA, 0x10DB, 0x10DC, 0x10F2,
	0x10DD, 0x10DE, 0x10DF, 0x10E0, 0x10E1,
	0x10E2, 0x10E3, 0x10F3, 0x10E4, 0x10E5,
	0x10E6, 0x10E7, 0x10E8, 0x10E9, 0x10EA,
	0x10EB, 0x10EC, 0x10ED, 0x10EE, 0x10F4,
	0x10EF, 0x10F0, 0x10F5, 0x10F6, 0xF42C,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Japanese
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WP60UNI11[ 256] = 
{
	0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65,
	0xFF66, 0xFF67, 0xFF68, 0xFF69, 0xFF6A,
	0xFF6B, 0xFF6C, 0xFF6D, 0xFF6E, 0xFF6F,
	0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74,
	0xFF75, 0xFF76, 0xFF77, 0xFF78, 0xFF79,
	0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E,
	0xFF7F, 0xFF80, 0xFF81, 0xFF82, 0xFF83,
	0xFF84, 0xFF85, 0xFF86, 0xFF87, 0xFF88,
	0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D,
	0xFF8E, 0xFF8F, 0xFF90, 0xFF91, 0xFF92,
	0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF97,
	0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C,
	0xFF9D, 0xFF9E, 0xFF9F, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Arabic
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WPUNI13[ 256] = 
{
	0xF895, 0xF896, 0xF897, 0xF898, 0xF899,
	0xF89A, 0xF89B, 0xF89C, 0xF89D, 0xF89E,
	0x064E, 0x064E, 0x064F, 0x064F, 0x0650,
	0x0650, 0x064B, 0x064C, 0x064C, 0x0650,
	0x0652, 0x0652, 0x0651, 0xF503, 0xF502,
	0xF504, 0xF508, 0xF505, 0xF509, 0xF506,
	0xF50A, 0xF50B, 0xF507, 0xF50C, 0x06E4,
	0x06E4, 0x0674, 0x06D6, 0x060C, 0x061B,
	0x061F, 0x002A, 0x066A, 0x226B, 0x226A,
	0x0029, 0x0028, 0x0661, 0x0662, 0x0663,
	0x0664, 0x0665, 0x0666, 0x0667, 0x0668,
	0x0669, 0x0660, 0x0662, 0x0627, 0x0628,
	0x0628, 0x0628, 0x0628, 0x0628, 0x062A,
	0x062A, 0x062A, 0x062A, 0x062B, 0x062B,
	0x062B, 0x062B, 0x062C, 0x062C, 0x062C,
	0x062C, 0x062D, 0x062D, 0x062D, 0x062D,
	0x062E, 0x062E, 0x062E, 0x062E, 0x062F,
	0x062F, 0x0630, 0x0630, 0x0631, 0x0631,
	0x0632, 0x0632, 0x0633, 0x0633, 0x0633,
	0x0633, 0x0634, 0x0634, 0x0634, 0x0634,
	0x0635, 0x0635, 0x0635, 0x0635, 0x0636,
	0x0636, 0x0636, 0x0636, 0x0637, 0x0637,
	0x0637, 0x0637, 0x0638, 0x0638, 0x0638,
	0x0638, 0x0639, 0x0639, 0x0639, 0x0639,
	0x063A, 0x063A, 0x063A, 0x063A, 0x0641, 
	0x0641, 0x0641, 0x0641, 0x0642, 0x0642,
	0x0642, 0x0642, 0x0643, 0x0643, 0x0643,
	0x0643, 0x0644, 0x0644, 0x0644, 0x0644,
	0x0645, 0x0645, 0x0645, 0x0645, 0x0646,
	0x0646, 0x0646, 0x0646, 0x0647, 0x0647,
	0x0647, 0x0647, 0x0629, 0x0629, 0x0648,
	0x0648, 0x064A, 0x064A, 0x064A, 0x064A, 
	0x0649, 0x0649, 0x0649, 0x0649, 0x0621,
	0x0623, 0x0623, 0x0625, 0x0625, 0x0624,
	0x0624, 0x0626, 0x0626, 0x0626, 0x0626,
	0xF50D, 0xF50D, 0x0622, 0x0622, 0x0671,
	0x0671, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0640,
	0x0640, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:	WP60 to Unicode - Arabic Script
****************************************************************************/
FSTATIC FLMUINT16 WPCH_WPUNI14[ 256] = 
{
	0xF8B6, 0xF8B7, 0xF8B8, 0xF8B9, 0xF8BA,
	0xF8BB, 0xF8BC, 0xF8BD, 0xF8BE, 0xF8BF,			  
	0xF8C0, 0xF8C1, 0xF8C2, 0xF8C3, 0xF8C4,
	0xF8C5, 0xF8C6, 0xF8C7, 0xF8C8, 0xF8C9,
	0xF8CA, 0xF8CB, 0xF8CC, 0xF8CD, 0xF8CE,
	0xF8CF, 0xF8D0, 0x064E, 0x0652, 0xF8D3,
	0xF8D4, 0xF8D5, 0xF8D6, 0xF8D7, 0xF8D8,
	0xF8D9, 0x0674, 0x064C, 0xF8B2, 0xF8DB,
	0xF8DC, 0x06F4, 0x06F4, 0x06F5, 0x06F6,
	0x06F6, 0x06F7, 0x06F8, 0x067B, 0x067B,
	0x067B, 0x067B, 0x0680, 0x0680, 0x0680,
	0x0680, 0x067E, 0x067E, 0x067E, 0x067E,
	0x0679, 0x0679, 0x0679, 0x0679, 0x067C,
	0x067C, 0x067C, 0x067C, 0x067F, 0x067F,
	0x067F, 0x067F, 0x067D, 0x067D, 0x067D,
	0x067D, 0x067A, 0x067A, 0x067A, 0x067A,
	0x0684, 0x0684, 0x0684, 0x0684, 0x0683,
	0x0683, 0x0683, 0x0683, 0x0686, 0x0686, 
	0x0686, 0x0686, 0x0687, 0x0687, 0x0687,
	0x0687, 0x0685, 0x0685, 0x0685, 0x0685,
	0x0681, 0x0681, 0x0681, 0x0681, 0x0688,
	0x0688, 0x0689, 0x0689, 0x068C, 0x068C,
	0x068E, 0x068E, 0x068A, 0x068A, 0x068D,
	0x068D, 0x0693, 0x0693, 0x0691, 0x0691,
	0x0699, 0x0699, 0x0695, 0x0695, 0x0692,
	0x0692, 0x0698, 0x0698, 0x0696, 0x0696,
	0x0696, 0x0696, 0x069A, 0x069A, 0x069A,
	0x069A, 0x06A0, 0x06A0, 0x06A0, 0x06A0, 
	0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A6,
	0x06A6, 0x06A6, 0x06A6, 0x06A9, 0x06A9, 
	0x06A9, 0x06A9, 0x06A9, 0x06A9, 0x06A9,
	0x06A9, 0x06AA, 0x06AA, 0x06AA, 0x06AA, 
	0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF,
	0x06AF, 0x06AF, 0x06AF, 0x06AB, 0x06AB, 
	0x06AB, 0x06AB, 0x06B1, 0x06B1, 0x06B1,
	0x06B1, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 
	0x06B5, 0x06B5, 0x06B5, 0x06B5, 0x0000,
	0x0000, 0x06BA, 0x06BA, 0x06BA, 0x06BA, 
	0x06BC, 0x06BC, 0x06BC, 0x06BC, 0x06BB,
	0x06BB, 0x06BB, 0x06BB, 0x06C6, 0x06C6,
	0x06CA, 0x06CA, 0x06CA, 0x06CA, 0x0647,
	0x0647, 0x0647, 0x0647, 0x06CE, 0x06CE, 
	0x06CE, 0x06CE, 0x06D2, 0x06D2, 0x06D1,
	0x06D1, 0x06D1, 0x06D1, 0x06C0, 0x06C0,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000
};

/****************************************************************************
Desc:
****************************************************************************/
FSTATIC FLMUINT16 * WP60toUni[] = 
{
	0,
	WPCH_WP60UNI1,
	WPCH_WP60UNI2,
	WPCH_WPUNI3,
	WPCH_WPUNI4,
	WPCH_WP60UNI5,
	WPCH_WPUNI6,
	WPCH_WPUNI7,
	WPCH_WP60UNI8,
	WPCH_WP60UNI9,
	WPCH_WP60UNI10,
	WPCH_WP60UNI11,
	0,
	WPCH_WPUNI13,
	WPCH_WPUNI14
};

/****************************************************************************
Desc:	WP60 to Unicode - Complex Character Unit Table (Multinational 1)
****************************************************************************/
FLMUINT16 WPCH_CPXTAB1[][5] = 
{
	{ 0x0044, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0063, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x004C, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x006C, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x004E, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x006E, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0052, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0072, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0053, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0073, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0054, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0074, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0059, 0x0306, 0x0000, 0x0000, 0x0000 },
	{ 0x0079, 0x0306, 0x0000, 0x0000, 0x0000 },
	{ 0x0059, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0079, 0x0300, 0x0000, 0x0000, 0x0000 }
};

/****************************************************************************
Desc:	WP60 to Unicode - Complex Character Unit Table (Greek)
****************************************************************************/
FLMUINT16 WPCH_CPXGREEK[][5] = 
{
	{ 0x0020, 0x0313, 0x0301, 0x0000, 0x0000 },
	{ 0x0020, 0x0314, 0x0301, 0x0000, 0x0000 },
	{ 0x0020, 0x0313, 0x0300, 0x0000, 0x0000 },
	{ 0x0020, 0x0314, 0x0300, 0x0000, 0x0000 },
	{ 0x0020, 0x0313, 0x0302, 0x0000, 0x0000 },
	{ 0x0020, 0x0314, 0x0302, 0x0000, 0x0000 },
	{ 0x0020, 0x0345, 0x0301, 0x0000, 0x0000 },
	{ 0x0020, 0x0345, 0x0300, 0x0000, 0x0000 },
	{ 0x0020, 0x0345, 0x0302, 0x0000, 0x0000 },
	{ 0x0020, 0x0313, 0x0345, 0x0000, 0x0000 },
	{ 0x0020, 0x0314, 0x0345, 0x0000, 0x0000 },
	{ 0x0020, 0x0313, 0x0301, 0x0345, 0x0000 },
	{ 0x0020, 0x0314, 0x0301, 0x0345, 0x0000 },
	{ 0x0020, 0x0313, 0x0300, 0x0345, 0x0000 },
	{ 0x0020, 0x0314, 0x0300, 0x0345, 0x0000 },
	{ 0x0020, 0x0313, 0x0302, 0x0345, 0x0000 },
	{ 0x0020, 0x0302, 0x0345, 0x0314, 0x0000 },
	{ 0x03B1, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03B1, 0x0302, 0x0000, 0x0000, 0x0000 },
	{ 0x03B1, 0x0345, 0x0000, 0x0000, 0x0000 },
	{ 0x03B1, 0x0301, 0x0345, 0x0000, 0x0000 },
	{ 0x03B1, 0x0302, 0x0345, 0x0000, 0x0000 },
	{ 0x03B1, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03B1, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03B1, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03B1, 0x0302, 0x0313, 0x0000, 0x0000 },
	{ 0x03B1, 0x0345, 0x0313, 0x0000, 0x0000 },
	{ 0x03B1, 0x0301, 0x0345, 0x0313, 0x0000 },
	{ 0x03B1, 0x0302, 0x0345, 0x0313, 0x0000 },
	{ 0x03B1, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03B1, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03B1, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03B1, 0x0302, 0x0314, 0x0000, 0x0000 },
	{ 0x03B1, 0x0345, 0x0314, 0x0000, 0x0000 },
	{ 0x03B1, 0x0301, 0x0345, 0x0314, 0x0000 },
	{ 0x03B1, 0x0302, 0x0345, 0x0314, 0x0000 },
	{ 0x03B5, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03B5, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03B5, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03B5, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03B5, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03B5, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03B5, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03B7, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03B7, 0x0310, 0x0000, 0x0000, 0x0000 },
	{ 0x03B7, 0x0345, 0x0000, 0x0000, 0x0000 },
	{ 0x03B7, 0x0301, 0x0345, 0x0000, 0x0000 },
	{ 0x03B7, 0x0300, 0x0345, 0x0000, 0x0000 },
	{ 0x03B7, 0x0302, 0x0345, 0x0000, 0x0000 },
	{ 0x03B7, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03B7, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03B7, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03B7, 0x0302, 0x0313, 0x0000, 0x0000 },
	{ 0x03B7, 0x0345, 0x0313, 0x0000, 0x0000 },
	{ 0x03B7, 0x0301, 0x0345, 0x0313, 0x0000 },
	{ 0x03B7, 0x0302, 0x0345, 0x0313, 0x0000 },
	{ 0x03B7, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03B7, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03B7, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03B7, 0x0302, 0x0314, 0x0000, 0x0000 },
	{ 0x03B7, 0x0345, 0x0314, 0x0000, 0x0000 },
	{ 0x03B7, 0x0301, 0x0345, 0x0314, 0x0000 },
	{ 0x03B7, 0x0302, 0x0345, 0x0314, 0x0000 },
	{ 0x03B9, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03B9, 0x0302, 0x0000, 0x0000, 0x0000 },
	{ 0x03B9, 0x0308, 0x0301, 0x0000, 0x0000 },
	{ 0x03B9, 0x0308, 0x0300, 0x0000, 0x0000 },
	{ 0x03B9, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03B9, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03B9, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03B9, 0x0302, 0x0313, 0x0000, 0x0000 },
	{ 0x03B9, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03B9, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03B9, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03B9, 0x0302, 0x0314, 0x0000, 0x0000 },
	{ 0x03BF, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03BF, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03BF, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03BF, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03BF, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03BF, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03BF, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03C5, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03C5, 0x0302, 0x0000, 0x0000, 0x0000 },
	{ 0x03C5, 0x0308, 0x0301, 0x0000, 0x0000 },
	{ 0x03C5, 0x0308, 0x0300, 0x0000, 0x0000 },
	{ 0x03C5, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03C5, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03C5, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03C5, 0x0302, 0x0313, 0x0000, 0x0000 },
	{ 0x03C5, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03C5, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03C5, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03C5, 0x0302, 0x0314, 0x0000, 0x0000 },
	{ 0x03C9, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x03C9, 0x0302, 0x0000, 0x0000, 0x0000 },
	{ 0x03C9, 0x0345, 0x0000, 0x0000, 0x0000 },
	{ 0x03C9, 0x0301, 0x0345, 0x0000, 0x0000 },
	{ 0x03C9, 0x0300, 0x0345, 0x0000, 0x0000 },
	{ 0x03C9, 0x0302, 0x0345, 0x0000, 0x0000 },
	{ 0x03C9, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03C9, 0x0301, 0x0313, 0x0000, 0x0000 },
	{ 0x03C9, 0x0300, 0x0313, 0x0000, 0x0000 },
	{ 0x03C9, 0x0302, 0x0313, 0x0000, 0x0000 },
	{ 0x03C9, 0x0345, 0x0313, 0x0000, 0x0000 },
	{ 0x03C9, 0x0301, 0x0345, 0x0313, 0x0000 },
	{ 0x03C9, 0x0302, 0x0345, 0x0313, 0x0000 },
	{ 0x03C9, 0x0314, 0x0000, 0x0000, 0x0000 },
	{ 0x03C9, 0x0301, 0x0314, 0x0000, 0x0000 },
	{ 0x03C9, 0x0300, 0x0314, 0x0000, 0x0000 },
	{ 0x03C9, 0x0302, 0x0314, 0x0000, 0x0000 },
	{ 0x03C9, 0x0345, 0x0314, 0x0000, 0x0000 },
	{ 0x03C9, 0x0301, 0x0345, 0x0314, 0x0000 },
	{ 0x03C9, 0x0302, 0x0345, 0x0314, 0x0000 },
	{ 0x0391, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0395, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0397, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0399, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x039F, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x03A5, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x03A9, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x03C1, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03B1, 0x0300, 0x0345, 0x0000, 0x0000 },
	{ 0x03B1, 0x0300, 0x0313, 0x0345, 0x0000 },
	{ 0x03B1, 0x0300, 0x0314, 0x0345, 0x0000 },
	{ 0x03B7, 0x0300, 0x0313, 0x0345, 0x0000 },
	{ 0x03B7, 0x0300, 0x0314, 0x0345, 0x0000 },
	{ 0x03C1, 0x0313, 0x0000, 0x0000, 0x0000 },
	{ 0x03C9, 0x0300, 0x0313, 0x0345, 0x0000 },
	{ 0x03C9, 0x0300, 0x0314, 0x0345, 0x0000 },
	{ 0x0020, 0x0301, 0x0308, 0x0000, 0x0000 },
	{ 0x0020, 0x0300, 0x0308, 0x0000, 0x0000 }
};

/****************************************************************************
Desc:	WP60 to Unicode - Complex Character Unit Table (Hebrew)
****************************************************************************/
FLMUINT16 WPCH_CPXHEBREW[][5] = 
{
	{ 0x05F2, 0x05B7, 0x0000, 0x0000, 0x0000 },
	{ 0x05D0, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D1, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D2, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D3, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D4, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D5, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D5, 0x05B9, 0x0000, 0x0000, 0x0000 },
	{ 0x05D6, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D7, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D8, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D9, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05D9, 0x05B4, 0x0000, 0x0000, 0x0000 },
	{ 0x05DB, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05B0, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05B5, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05B1, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05B7, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05B8, 0x0000, 0x0000, 0x0000 },
	{ 0x05DA, 0x05BC, 0x05B8, 0x0000, 0x0000 },
	{ 0x05DC, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05DE, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05E0, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05DF, 0x05B8, 0x0000, 0x0000, 0x0000 },
	{ 0x05E1, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05E4, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05E6, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05E7, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05E9, 0x05B9, 0x0000, 0x0000, 0x0000 },
	{ 0x05E9, 0x05B9, 0x05BC, 0x0000, 0x0000 },
	{ 0x05E9, 0x05BC, 0x0000, 0x0000, 0x0000 },
	{ 0x05EA, 0x05BC, 0x0000, 0x0000, 0x0000 }
};

/****************************************************************************
Desc:	WP60 to Unicode - Complex Character Unit Table (Arabic)
****************************************************************************/
FLMUINT16 WPCH_CPXARABIC[][5] = 
{
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }
};

/****************************************************************************
Desc:	WP60 to Unicode - Complex Character Unit Table (Arabic Script)
****************************************************************************/
FLMUINT16  WPCH_CPXARABIC2[][5] = 
{
	{ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }
};	

/****************************************************************************
Desc:	WP60 to Unicode - Complex Character Unit Table (Cyrillic / Georgian)
****************************************************************************/
FLMUINT16 WPCH_CPXCYRILLIC[][5] = 
{
	{ 0x0410, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0430, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0415, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0435, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0404, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0454, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0418, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0438, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0406, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0456, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0407, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0457, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x041E, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x043E, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0423, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0443, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x042B, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x044B, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x042D, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x044D, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x042E, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x044E, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x042F, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x044F, 0x0301, 0x0000, 0x0000, 0x0000 },
	{ 0x0410, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0430, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0415, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0435, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0401, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0451, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0418, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0438, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x041E, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x043E, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0423, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x0443, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x042B, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x044B, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x042D, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x044D, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x042E, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x044E, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x042F, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x044F, 0x0300, 0x0000, 0x0000, 0x0000 },
	{ 0x10E3, 0x0302, 0x0000, 0x0000, 0x0000 },
	{ 0x0037, 0x0339, 0x0000, 0x0000, 0x0000 },
	{ 0x0428, 0x0329, 0x0000, 0x0000, 0x0000 },
	{ 0x0448, 0x0329, 0x0000, 0x0000, 0x0000 },
	{ 0x0406, 0x031C, 0x0000, 0x0000, 0x0000 },
	{ 0x0446, 0x031C, 0x0000, 0x0000, 0x0000 },
	{ 0x0418, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x0438, 0x0304, 0x0000, 0x0000, 0x0000 },
	{ 0x041A, 0x0328, 0x0000, 0x0000, 0x0000 },
	{ 0x043A, 0x0328, 0x0000, 0x0000, 0x0000 },
	{ 0x0425, 0x0328, 0x0000, 0x0000, 0x0000 },
	{ 0x0445, 0x0328, 0x0000, 0x0000, 0x0000 },
	{ 0x0428, 0x0329, 0x0000, 0x0000, 0x0000 },
	{ 0x0448, 0x0329, 0x0000, 0x0000, 0x0000 }
};

/****************************************************************************
Desc:
****************************************************************************/
FLMUINT16 * WP60toCpxUni[] = 
{
	0,
	(FLMUINT16 *)WPCH_CPXTAB1,
	0,
	0,
	0,
	0,
	0,
	0,
	(FLMUINT16 *)WPCH_CPXGREEK,
	(FLMUINT16 *)WPCH_CPXHEBREW,
	(FLMUINT16 *)WPCH_CPXCYRILLIC,
	(FLMUINT16 *)WPCH_CPXARABIC,
	(FLMUINT16 *)WPCH_CPXARABIC2
};

/****************************************************************************
Desc:
****************************************************************************/
FINLINE FLMUINT flmCharTypeAnsi7(
	FLMUINT16	ui16Char)
{
	if ((ui16Char >= ASCII_LOWER_A && ui16Char <= ASCII_LOWER_Z) ||
		 (ui16Char >= ASCII_UPPER_A && ui16Char <= ASCII_UPPER_Z) ||
		 (ui16Char >= ASCII_ZERO && ui16Char <= ASCII_NINE))
	{
		return (SDWD_CHR);
	}

	if (ui16Char == 0x27)
	{
		return (WDJN_CHR);
	}

	if (ui16Char <= 0x2B)
	{
		return (DELI_CHR);
	}

	if (ui16Char == ASCII_COMMA ||
		 ui16Char == ASCII_DASH ||
		 ui16Char == ASCII_DOT ||
		 ui16Char == ASCII_SLASH ||
		 ui16Char == ASCII_COLON ||
		 ui16Char == ASCII_AT ||
		 ui16Char == ASCII_BACKSLASH ||
		 ui16Char == ASCII_UNDERSCORE)
	{
		return (WDJN_CHR);
	}

	return (DELI_CHR);
}

/****************************************************************************
Desc: Return the next WP or unicode character value and parsing type.
****************************************************************************/
FLMUINT flmTextGetCharType(
	const FLMBYTE *		pText,
	FLMUINT					uiLen,
	FLMUINT16 *				pui16WPValue,
	FLMUNICODE *			puzUniValue,
	FLMUINT *				pType)
{
	FLMUINT			uiReturnLen;
	FLMUINT16		wpValue;
	FLMUNICODE		uniValue;
	FLMUINT			uiCharSet;

	uiReturnLen = flmTextGetValue( pText, uiLen, NULL, FLM_COMP_COMPRESS_WHITESPACE,
											pui16WPValue, puzUniValue);
	wpValue = *pui16WPValue;
	uniValue = *puzUniValue;

	if (wpValue)
	{
		if (wpValue < 0x080)
		{
			*pType = flmCharTypeAnsi7( wpValue);
			goto Exit;
		}

		uiCharSet = (FLMUINT) (wpValue >> 8);

		if (uiCharSet == 1 ||
			 uiCharSet == 2 ||
			 (uiCharSet >= 8 && uiCharSet <= 11))
		{
			*pType = SDWD_CHR;
			goto Exit;
		}

		*pType = DELI_CHR;
	}
	else
	{

		// For now all unicode is a delimeter

		*pType = DELI_CHR;
	}

Exit:

	return (uiReturnLen);
}

/****************************************************************************
Desc:		Return the next WP or unicode character value
Return: 	Number of bytes formatted to return the character value
****************************************************************************/
FLMUINT flmTextGetValue(
	const FLMBYTE *	pText,			// [in] Points to current value.
	FLMUINT				uiLen,			// [in] Bytes remaining in text.
	FLMUINT *			puiWpChar2,		// Was there a double character?
	FLMUINT				uiFlags,			// [in]
	FLMUINT16 *			pui16WPValue,	// [out] WP Character value or 0 if unicode.
	FLMUNICODE *		puzUniValue)	// [out] Unicode or OEM value if *pui16WPChar is zero.
{
	FLMUINT			uiReturnLength = 0;
	FLMUINT			uiObjectLength;
	FLMUINT16		ui16CurValue;
	FLMUNICODE		uzUniValue;

	uiReturnLength = 0;
	ui16CurValue = 0;
	uzUniValue = 0;

	if (puiWpChar2 && *puiWpChar2)
	{
		ui16CurValue = (FLMUINT16) (*puiWpChar2);
		*puiWpChar2 = 0;
		uiObjectLength = 0;
		goto Check_White_Space;
	}

	while (uiLen && !ui16CurValue && !uzUniValue)
	{
		ui16CurValue = (FLMUINT16) * pText;

		switch (flmTextObjType( ui16CurValue))
		{
			case ASCII_CHAR_CODE:				// 0nnnnnnn
			{
				uiObjectLength = 1;

Check_White_Space:

				// Do all of the bIgnore* stuff here. WHITE SPACE CODE doesn't
				// apply.

				if (ui16CurValue == (FLMUINT16) ASCII_UNDERSCORE &&
					 (uiFlags & FLM_COMP_NO_UNDERSCORES))
				{
					ui16CurValue = (FLMUINT16) ASCII_SPACE;
				}

				if (ui16CurValue == (FLMUINT16) ASCII_SPACE)
				{
					if (uiFlags & FLM_COMP_NO_WHITESPACE)
					{
						ui16CurValue = 0;
					}
					else if (uiFlags & FLM_COMP_COMPRESS_WHITESPACE)
					{

						// Eat up the remaining spaces and underscores (if
						// FLM_COMP_NO_UNDERSCORES).

						while ((pText[uiObjectLength] == ASCII_SPACE || 
								 (pText[uiObjectLength] == ASCII_UNDERSCORE && 
									(uiFlags & FLM_COMP_NO_UNDERSCORES))) && 
								uiObjectLength < uiLen)
						{
							uiObjectLength++;
						}
					}
				}
				else if (ui16CurValue == ASCII_DASH && (uiFlags & FLM_COMP_NO_DASHES))
				{
					ui16CurValue = 0;
				}
				
				break;
			}
			
			case CHAR_SET_CODE:					// 10nnnnnn - Character Set | Char
			{
				uiObjectLength = 2;
				ui16CurValue = (FLMUINT16) (((FLMUINT16) (ui16CurValue & 
										(~CHAR_SET_MASK)) << 8) + 
											(FLMUINT16) *(pText + 1));
					
				break;
			}
			
			case WHITE_SPACE_CODE:				// 110nnnnn
			{
				FLMBYTE	ucTmpByte;

				uiObjectLength = 1;
				ucTmpByte = *pText & (~WHITE_SPACE_MASK);

				ui16CurValue = ((ucTmpByte == HARD_HYPHEN) || 
									 (ucTmpByte == HARD_HYPHEN_EOL) ||
									 (ucTmpByte == HARD_HYPHEN_EOP)) 
									 	? (FLMUINT16) 0x2D 
										: (FLMUINT16) 0x20;
				break;
			}

			case EXT_CHAR_CODE:					// Full extended character
			{
				uiObjectLength = 3;
				ui16CurValue = (FLMUINT16) (((FLMUINT16) *(pText + 1) << 8) + 
													  (FLMUINT16) *(pText + 2));
				break;
			}
			
			case UNICODE_CODE:		// Unconvertable UNICODE code
			{
				uiObjectLength = 3;
				ui16CurValue = 0;
				uzUniValue = (FLMUINT16) (((FLMUINT16) *(pText + 1) << 8) + 
													(FLMUINT16) *(pText + 2));
				break;
			}
			
			case OEM_CODE:
			{
				uiObjectLength = 2;	// OEM characters are always >= 128

				// Make this a unicode character

				ui16CurValue = 0;
				uzUniValue = (FLMUINT16) * (pText + 1);
				break;
			}

			// Skip all of the unknown stuff

			case UNK_GT_255_CODE:
			{
				uiObjectLength = (FLMUINT16) (1 + sizeof(FLMUINT16) + 
															FB2UW( pText + 1));
				break;
			}
			
			case UNK_LE_255_CODE:
			{
				uiObjectLength = 2 + (FLMUINT16) * (pText + 1);
				break;
			}
			
			case UNK_EQ_1_CODE:
			{
				uiObjectLength = 2;
				break;
			}
			
			default:
			{
				// Coded to skip remaining data

				ui16CurValue = 0;
				uiObjectLength = uiLen;
				break;
			}
		}

		uiReturnLength += uiObjectLength;
		pText += uiObjectLength;
		uiLen -= uiObjectLength;
	}

	*pui16WPValue = ui16CurValue;
	*puzUniValue = uzUniValue;
	
	return (uiReturnLength);
}

/****************************************************************************
Desc:	Returns the size of buffer needed to hold the unicode string in
		FLAIM's storage format.
****************************************************************************/
FLMEXP FLMUINT FLMAPI FlmGetUnicodeStorageLength(
	const FLMUNICODE *		puzStr)
{
	FLMBYTE		chrSet;
	FLMUINT		uiStorageLength = 0;
	FLMUINT16	wp60Buf[12];

	flmAssert( puzStr != NULL);

	// Two passes are needed to store a UNICODE string: 1st pass
	// determines the storage length (via FlmGetUnicodeStorageLength) 2nd
	// pass stores the string into FLAIMs internal text format (via
	// FlmUnicode2Storage).

	do
	{
		if (*puzStr < 0x20)
		{
			uiStorageLength += 3;
		}
		else
		{
			if (*puzStr < 0x7F)
			{
				uiStorageLength++;
				puzStr++;
				continue;
			}

			if( !f_depricatedUnicodeToWP( *puzStr, wp60Buf))
			{
				uiStorageLength += 3;
			}
			else
			{
				if ((chrSet = (FLMBYTE) (wp60Buf[0] >> 8)) == 0)
				{
					uiStorageLength++;
				}
				else
				{
					uiStorageLength += (chrSet <= 63) ? 2 : 3;
				}
			}
		}

		puzStr++;
	} while (*puzStr != 0);

	return (uiStorageLength);
}

/****************************************************************************
Desc:	Copies and formats a Unicode string into FLAIM's storage format.
		The Unicode string must be in little endian format.
		Unicode values that are not represented as WordPerfect 6.x 
		characters are preserved as non-WP characters.
****************************************************************************/
FLMEXP RCODE FLMAPI FlmUnicode2Storage(
	const FLMUNICODE *		puzStr,
	FLMUINT *					puiBufLength,
	FLMBYTE *					pBuf)
{
	FLMBYTE		chrSet;
	FLMUINT16	wp60Buf[12];
	FLMUINT		uiStorageLength = 0;

	flmAssert( puzStr != NULL);
	flmAssert( pBuf != NULL);

	do
	{
		if (*puzStr < 0x20)
		{

			// Output the character as an unconvertable unicode character.

			*pBuf++ = UNICODE_CODE;
			*pBuf++ = *puzStr >> 8;
			*pBuf++ = (FLMBYTE) *puzStr;
			uiStorageLength += 3;
		}
		else
		{
			if (*puzStr < 0x7F)
			{
				uiStorageLength++;
				*pBuf++ = (FLMBYTE) *puzStr++;
				continue;
			}

			if( !f_depricatedUnicodeToWP( *puzStr, wp60Buf))
			{
				*pBuf++ = UNICODE_CODE;
				*pBuf++ = *puzStr >> 8;
				*pBuf++ = (FLMBYTE) *puzStr;
				uiStorageLength += 3;
			}
			else
			{
				chrSet = wp60Buf[0] >> 8;

				if (chrSet == 0)
				{
					*pBuf++ = (FLMBYTE) wp60Buf[0];
					uiStorageLength++;
				}
				else if (chrSet <= 63)
				{
					*pBuf++ = CHAR_SET_CODE | chrSet;
					*pBuf++ = (FLMBYTE) wp60Buf[0];
					uiStorageLength += 2;
				}
				else
				{
					*pBuf++ = EXT_CHAR_CODE;
					*pBuf++ = chrSet;
					*pBuf++ = (FLMBYTE) wp60Buf[0];
					uiStorageLength += 3;
				}
			}
		}

		puzStr++;

		// Make sure input buffer was large enough

		if (*puiBufLength < uiStorageLength)
		{
			return (RC_SET( FERR_CONV_DEST_OVERFLOW));
		}
	} while (*puzStr != 0);

	*puiBufLength = uiStorageLength;
	return (FERR_OK);
}

/****************************************************************************
Desc:	Converts storage formats to UNICODE.
****************************************************************************/
FLMEXP RCODE FLMAPI FlmStorage2Unicode(
	FLMUINT				uiValueType,
	FLMUINT				uiValueLength,
	const FLMBYTE *	pucValue,
	FLMUINT *			puiStrBufLen,
	FLMUNICODE *		puzStrBuf)
{
	RCODE				rc = FERR_OK;
	FLMUNICODE *	tablePtr;
	FLMBYTE			c;
	FLMUINT			bytesProcessed = 0;
	FLMUINT			bytesOutput = 0;
	FLMUINT			outputData;
	FLMUINT			maxOutLen;
	FLMBYTE			objType;
	FLMUINT			objLength = 0;
	FLMBYTE			tempBuf[80];
	FLMBYTE			chrSet;
	FLMBYTE			chrVal;
	FLMUNICODE		newChrVal;

	// If the value is a number, convert to text first

	if (uiValueType != FLM_TEXT_TYPE)
	{
		if (pucValue == NULL)
		{
			uiValueLength = 0;
		}
		else
		{
			if (uiValueType == FLM_NUMBER_TYPE)
			{
				uiValueLength = sizeof(tempBuf);
				rc = GedNumToText( pucValue, tempBuf, &uiValueLength);
			}
			else
			{
				rc = RC_SET( FERR_CONV_ILLEGAL);
				goto Exit;
			}

			if (RC_BAD( rc))
			{
				goto Exit;
			}

			pucValue = &tempBuf[0];
		}
	}

	maxOutLen = *puiStrBufLen;
	outputData = ((puzStrBuf != NULL) && (maxOutLen > 1));

	if (outputData)
	{
		maxOutLen -= 2;
	}

	// Parse through the string outputting data to the buffer as we go

	while (bytesProcessed < uiValueLength)
	{

		// Determine what we are pointing at

		c = *pucValue;
		objType = flmTextObjType( c);
		
		switch (objType)
		{
			case ASCII_CHAR_CODE:
			{
				objLength = 1;
				if (outputData)
				{
					if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto GedGetUNICODE_Output;
					}

					*puzStrBuf++ = c;
				}

				bytesOutput += 2;
				break;
			}
			
			case CHAR_SET_CODE:
			{
				objLength = 2;
				if (outputData)
				{
					if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto GedGetUNICODE_Output;
					}

					// Convert WP to UNICODE

					chrSet = c & 0x3F;
					chrVal = *(pucValue + 1);

					goto ConvertWPToUni;
				}

				bytesOutput += 2;
				break;
			}
			
			case WHITE_SPACE_CODE:
			{
				objLength = 1;

				if (outputData)
				{
					if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto GedGetUNICODE_Output;
					}

					if (c == (WHITE_SPACE_CODE | NATIVE_TAB))
					{
						*puzStrBuf = (FLMUNICODE) 9;
					}
					else if (c == (WHITE_SPACE_CODE | NATIVE_LINEFEED))
					{
						*puzStrBuf = (FLMUNICODE) 10;
					}
					else if (c == (WHITE_SPACE_CODE | HARD_RETURN))
					{
						*puzStrBuf = (FLMUNICODE) 13;
					}
					else
					{
						*puzStrBuf = (FLMUNICODE) 0x20;
					}

					puzStrBuf++;
				}

				bytesOutput += 2;
				break;
			}
			
			case EXT_CHAR_CODE:
			{
				objLength = 3;
				if (outputData)
				{
					if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto GedGetUNICODE_Output;
					}

					// Convert back from WP to UNICODE

					chrSet = *(pucValue + 1);
					chrVal = *(pucValue + 2);

ConvertWPToUni:

					if ((chrSet < WP60toUni_MAX) &&
						 ((tablePtr = WP60toUni[chrSet]) != 0))
					{
						FLMUNICODE *		pCpxUniStr;

						newChrVal = tablePtr[chrVal];

						if ((newChrVal & WPCH_LOMASK) == 0xF000)
						{

							// Does character convert to many Unicode chars?

							pCpxUniStr = WP60toCpxUni[chrSet];
							pCpxUniStr += (newChrVal & WPCH_HIMASK) * WPCH_MAX_COMPLEX;

							while (*pCpxUniStr)
							{
								if (outputData)
								{
									if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
									{
										rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
										goto GedGetUNICODE_Output;
									}

									*puzStrBuf++ = *pCpxUniStr++;
								}

								bytesOutput += 2;
							}
						}
						else
						{
							if (outputData)
							{
								if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
								{
									rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
									goto GedGetUNICODE_Output;
								}

								*puzStrBuf++ = newChrVal;
							}

							bytesOutput += 2;
						}
					}
					else
					{

						// Big extended WP char

						if (outputData)
						{
							if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
							{
								rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
								goto GedGetUNICODE_Output;
							}

							*puzStrBuf++ = 0x03;
						}

						bytesOutput += 2;
					}
				}
				break;
			}
			
			case OEM_CODE:
			{

				// We always just skip OEM codes

				objLength = 2;
				break;
			}
			
			case UNICODE_CODE:
			{
				objLength = 3;
				if (outputData)
				{
					if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto GedGetUNICODE_Output;
					}

					*puzStrBuf++ = (*(pucValue + 1) << 8) + *(pucValue + 2);
				}

				bytesOutput += 2;
				break;
			}
			
			case UNK_EQ_1_CODE:
			{
				objLength = 2;
				if (outputData)
				{
					if ((maxOutLen < 2) || (bytesOutput > maxOutLen - 2))
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto GedGetUNICODE_Output;
					}

					*puzStrBuf++ = *(pucValue + 1);
				}

				bytesOutput += 2;
				break;
			}
			
			default:
			{
				flmAssert( 0);
				bytesProcessed = uiValueLength;
				break;
			}
		}

		pucValue += objLength;
		bytesProcessed += objLength;
	}

	// Add TWO terminating NULL characters, but DO NOT increment the
	// bytesOutput counter.

GedGetUNICODE_Output:

	if (outputData)
	{
		*puzStrBuf = 0;
	}

	*puiStrBufLen = bytesOutput;

Exit:

	return (rc);
}

/****************************************************************************
Desc:	Returns the size of buffer needed to hold the native string in
		FLAIM's storage format.
****************************************************************************/
FLMEXP FLMUINT FLMAPI FlmGetNativeStorageLength(
	const char *		pszStr)
{
	RCODE			rc;
	FLMUINT		uiStorageLength;

	rc = FlmNative2Storage( pszStr, 0, &uiStorageLength, NULL);
	flmAssert( rc == FERR_OK);

	return (uiStorageLength);
}

/****************************************************************************
Desc:	Copies and formats a native 8-bit null terminated string into a
		caller supplied buffer, It converts the string into an internal FLAIM
		TEXT string.
****************************************************************************/
FLMEXP RCODE FLMAPI FlmNative2Storage(
	const char *	pszNativeString,
	FLMUINT			uiStringLength,
	FLMUINT *		puiStorageLen,
	FLMBYTE *		pStorageBuffer)
{
	FLMBOOL			bGetLengthPass;
	const char *	pCurChar;
	const char *	pEnd = NULL;
	FLMBYTE			ucAsciiChar;
	FLMUINT			uiStorageLen = 0;

	// Are we determining the needed length or converting the data

	bGetLengthPass = pStorageBuffer ? FALSE : TRUE;

	if (uiStringLength)
	{
		pEnd = &pszNativeString[uiStringLength];
	}

	// Parse through the string

	pCurChar = pszNativeString;

	for (;;)
	{
		if (*pCurChar == 0 || (pEnd && pCurChar >= pEnd))
		{

			// We have reached end of the string, return the storage length

			*puiStorageLen = uiStorageLen;
			return (FERR_OK);
		}

		// Put the character in a local variable for speed

		ucAsciiChar = f_toascii( *pCurChar);

		if (ucAsciiChar < ASCII_SPACE)
		{

			// If it is a tab, carriage return, or linefeed, output a
			// whitespace code for indexing and each word purposes

			if (ucAsciiChar == ASCII_TAB)
			{
				if (bGetLengthPass)
				{
					uiStorageLen++;
				}
				else
				{
					*pStorageBuffer++ = WHITE_SPACE_CODE | NATIVE_TAB;
				}
			}
			else if (ucAsciiChar == ASCII_NEWLINE)
			{
				if (bGetLengthPass)
				{
					uiStorageLen++;
				}
				else
				{
					*pStorageBuffer++ = WHITE_SPACE_CODE | NATIVE_LINEFEED;
				}
			}
			else if (ucAsciiChar == ASCII_CR)
			{
				if (bGetLengthPass)
				{
					uiStorageLen++;
				}
				else
				{
					*pStorageBuffer++ = WHITE_SPACE_CODE | HARD_RETURN;
				}
			}
			else
			{
				if (bGetLengthPass)
				{
					uiStorageLen += 2;
				}
				else
				{

					// Output the character as an unknown byte if no WP char
					// found

					*pStorageBuffer++ = UNK_EQ_1_CODE | NATIVE_TYPE;
					*pStorageBuffer++ = ucAsciiChar;
				}
			}
		}
		else if (ucAsciiChar < 127)
		{

			// For now assume < 127 means character set zero. Value 127 is
			// very sacred in WP land and is really an extended character

			if (bGetLengthPass)
			{
				uiStorageLen++;
			}
			else
			{
				*pStorageBuffer++ = ucAsciiChar;
			}
		}
		else
		{
			if (bGetLengthPass)
			{
				uiStorageLen += 2;
			}
			else
			{
				*pStorageBuffer++ = OEM_CODE;
				*pStorageBuffer++ = ucAsciiChar;
			}
		}

		pCurChar++;
	}
}

/****************************************************************************
Desc:	Convert a storage text string into a native string
****************************************************************************/
FLMEXP RCODE FLMAPI FlmStorage2Native(
	FLMUINT				uiValueType,
	FLMUINT				uiValueLength,
	const FLMBYTE *	pucValue,
	FLMUINT *			puiOutBufLenRV,
	char *				pOutBuffer)
{
	RCODE					rc = FERR_OK;
	const FLMBYTE *	ptr = pucValue;
	char *				outPtr;
	FLMBYTE				c;
	FLMUINT				bytesProcessed;
	FLMUINT				bytesOutput;
	FLMUINT				valLength = uiValueLength;
	FLMUINT				outputData;
	FLMUINT				maxOutLen = 0;
	FLMBYTE				objType;
	FLMUINT				objLength = 0;
	FLMBYTE				TempBuf[80];
	FLMUINT				length;

	// If the input is not a TEXT or a NUMBER node, return an error for now

	if ((uiValueType == FLM_BINARY_TYPE) || (uiValueType == FLM_CONTEXT_TYPE))
	{
		rc = RC_SET( FERR_CONV_ILLEGAL);
		goto Exit;
	}

	// If the node is a number, convert to text first

	if (uiValueType != FLM_TEXT_TYPE)
	{
		if (ptr == NULL)
		{
			valLength = 0;
		}
		else
		{
			valLength = sizeof(TempBuf);
			flmAssert( uiValueType == FLM_NUMBER_TYPE);
			if (RC_BAD( rc = GedNumToText( ptr, TempBuf, &valLength)))
			{
				goto Exit;
			}

			ptr = &TempBuf[0];
		}
	}

	outputData = ((pOutBuffer != NULL) && (*puiOutBufLenRV));
	if (outputData)
	{
		maxOutLen = *puiOutBufLenRV - 1;
	}

	bytesProcessed = 0;
	bytesOutput = 0;
	outPtr = pOutBuffer;

	while (bytesProcessed < valLength)
	{
		c = *ptr;
		objType = (FLMBYTE) flmTextObjType( c);

		switch (objType)
		{
			case ASCII_CHAR_CODE:
			{
				objLength = 1;
				if (outputData)
				{
					if (bytesOutput < maxOutLen)
					{
						*outPtr++ = f_tonative( c);
					}
					else
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto Native_Output;
					}
				}

				bytesOutput++;
				break;
			}
			
			case CHAR_SET_CODE:
			{
				objLength = 2;
				if (outputData)
				{
					if (bytesOutput < maxOutLen)
					{
						if ((c & (~objType)) == 0)
						{
							*outPtr++ = f_tonative( *(ptr + 1));
						}
						else
						{
							*outPtr++ = 0xFF;
						}
					}
					else
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto Native_Output;
					}
				}

				bytesOutput++;
				break;
			}
			
			case WHITE_SPACE_CODE:
			{
				objLength = 1;

				// ALWAYS OUTPUT A SPACE WHEN WE SEE A WHITE_SPACE_CODE ;
				// UNLESS IT IS A HYPHEN
				
				if (outputData)
				{
					if (bytesOutput < maxOutLen)
					{
						c &= (~WHITE_SPACE_MASK);
						if ((c == HARD_HYPHEN) ||
							 (c == HARD_HYPHEN_EOL) ||
							 (c == HARD_HYPHEN_EOP))
						{
							c = ASCII_DASH;
						}
						else if (c == NATIVE_TAB)
						{
							c = ASCII_TAB;
						}
						else if (c == NATIVE_LINEFEED)
						{
							c = ASCII_NEWLINE;
						}
						else if (c == HARD_RETURN)
						{
							c = ASCII_CR;
						}
						else
						{
							c = ASCII_SPACE;
						}

						*outPtr++ = f_tonative( c);
					}
					else
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto Native_Output;
					}
				}

				bytesOutput++;
				break;
			}
			
			case UNK_GT_255_CODE:
			case UNK_LE_255_CODE:
			{
				if (objType == UNK_GT_255_CODE)
				{
					length = FB2UW( ptr + 1);
					objLength = (FLMUINT16) (1 + sizeof(FLMUINT16) + length);
				}
				else
				{
					length = (FLMUINT16) * (ptr + 1);
					objLength = (FLMUINT16) (2 + length);
				}

				// Skip it if it is not a NATIVE code

				if ((c & (~objType)) == NATIVE_TYPE)
				{
					if (outputData)
					{
						if ((maxOutLen < length) || (bytesOutput > maxOutLen - length))
						{
							rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
							goto Native_Output;
						}

						if (objType == UNK_LE_255_CODE)
						{
							f_memcpy( outPtr, ptr + 2, length);
						}
						else
						{
							f_memcpy( outPtr, ptr + 1 + sizeof(FLMUINT16), length);
						}

						outPtr += length;
					}

					bytesOutput += length;
				}
				
				break;
			}
			
			case UNK_EQ_1_CODE:
			{
				objLength = 2;

				// Skip it if it is not a NATIVE code

				if ((c & (~objType)) == NATIVE_TYPE)
				{
					if (outputData)
					{
						if (bytesOutput < maxOutLen)
						{
							*outPtr++ = f_tonative( *(ptr + 1));
						}
						else
						{
							rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
							goto Native_Output;
						}
					}

					bytesOutput++;
				}
				break;
			}
			
			case EXT_CHAR_CODE:
			{
				objLength = 3;
				if (outputData)
				{
					if (bytesOutput < maxOutLen)
					{
						*outPtr += 0xFF;
					}
					else
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto Native_Output;
					}
				}

				bytesOutput++;
				break;
			}
			
			case OEM_CODE:
			{
				objLength = 2;
				if (outputData)
				{
					if (bytesOutput < maxOutLen)
					{
						*outPtr++ = f_tonative( *(ptr + 1));
					}
					else
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto Native_Output;
					}
				}

				bytesOutput++;
				break;
			}
			
			case UNICODE_CODE:
			{
				objLength = 3;
				if (outputData)
				{
					if (bytesOutput < maxOutLen)
					{
						*outPtr++ = UNICODE_UNCONVERTABLE_CHAR;
					}
					else
					{
						rc = RC_SET( FERR_CONV_DEST_OVERFLOW);
						goto Native_Output;
					}
				}

				bytesOutput++;
				break;
			}
			
			default:
			{
				break;
			}
		}

		ptr += objLength;
		bytesProcessed += objLength;
	}

	// Add a terminating NULL character, but DO NOT increment the
	// bytesOutput counter!
	
Native_Output:

	if (outputData)
	{
		*outPtr = 0;
	}

	*puiOutBufLenRV = bytesOutput;

Exit:

	return (rc);
}
