------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

pragma Ada_2012;

with GNAT.IO;                use GNAT.IO;
with GNATCOLL.GMP.Integers;  use GNATCOLL.GMP.Integers;

procedure Test_Image is

   N : Big_Integer;

   Input : constant String := "14000000000000000000000" &
                              "000000000000000000000001";

   Negated_Input : constant String := '-' & Input;

   Input_Base_2 : constant String :=
      "1001110011110010000001111001000111010111100010000101010100011010011" &
      "0000111101110001100000010011011111001001100000000000000000000000000" &
      "00000000000000000001";

   Input_Base_3 : constant String :=
      "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

begin
   Set (N, Input);
   if Image (N) /= Input then
      Put_Line ("test_image failed: basic Image call");
      return;
   end if;

   Negate (N);
   if Image (N) /= Negated_Input then
      Put_Line ("test_image failed: negated image is incorrect");
      return;
   end if;

   Set (N, Input);
   if Image (N, Base => 2) /= Input_Base_2 then
      Put_Line ("test_image failed: wrong image in base 2");
      return;
   end if;

   for J in Input_Base_3'Range loop
      declare
         Img  : constant String := Input_Base_3 (1 .. J);
         Img0 : constant String := Input_Base_3 (1 .. J) & '0';
         Base : constant Positive := Img0'Length;
      begin
         Set (N, Img, Base => GNATCOLL.GMP.Int (Base));

         if Img /= Image (N, (if J < 36 then -Base else Base)) then
            Put_Line ("test_image failed: wrong image in base" & Base'Img);
         end if;

         Set (N, Img0, Base => GNATCOLL.GMP.Int (Base));

         if Img0 /= Image (N, (if J < 36 then -Base else Base)) then
            Put_Line ("test_image failed: wrong img0 in base" & Base'Img);
         end if;
      end;
   end loop;

   Put_Line ("test_image passed");
end Test_Image;
