with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.VFS; use GNATCOLL.VFS;
with GNAT.Strings; use GNAT.Strings;

with GNAT.OS_Lib; use GNAT.OS_Lib;

with GNATCOLL.Traces; use GNATCOLL.Traces;

with Ada.Text_IO;

procedure Main is
   Self : Project_Environment_Access;
   Tree : Project_Tree;

   M, N : GNATCOLL.VFS.File_Array_Access;
   S : Status_Type;
   F : GNATCOLL.VFS.Virtual_File;
   OK : Boolean;
begin
   Parse_Config_File;
   Initialize (Self);
   Tree.Load
     (GNATCOLL.VFS.Create ("prj.gpr"),
      Self);

   --  Not a source case
   F := Create (+"not_a_main.adb");
   Append (M, F);
   Get_Closures
     (Tree.Root_Project,
      M,
      Status => S,
      Result => N);

   if N /= null then
      Ada.Text_IO.Put_Line ("non-null result for not a source");
   end if;
   if S /= Error then
      Ada.Text_IO.Put_Line ("status for not a source is "
                            & Status_Type'Image (S));
   end if;

   Unchecked_Free (M);
   Unchecked_Free (N);

   --  Normal case
   F := Create (+"main.adb");
   Append (M, F);
   F := Create (+"main2.adb");
   Append (M, F);

   Get_Closures
     (Tree.Root_Project,
      M,
      Status => S,
      Result => N);

   if N = null then
      Ada.Text_IO.Put_Line ("null result for real mains");
   elsif S /= Success then
      Ada.Text_IO.Put_Line ("status for real mains is "
                            & Status_Type'Image (S));
   else
      for I in N'Range loop
         Ada.Text_IO.Put_Line (N (I).Display_Base_Name);
      end loop;
   end if;

   Unchecked_Free (N);

   --  Invalid project case
   Get_Closures
     (No_Project,
      M,
      Status => S,
      Result => N);

   if N /= null then
      Ada.Text_IO.Put_Line ("non-null result for not a project");
   end if;
   if S /= Error then
      Ada.Text_IO.Put_Line ("status for not a project is "
                            & Status_Type'Image (S));
   end if;

   Unchecked_Free (N);

   --  Incomplete closure case
   Ada.Text_IO.New_Line;
   Delete_File ("obj_prj/pkg2.ali", OK);

   Get_Closures
     (Tree.Root_Project,
      M,
      Status => S,
      Result => N);

   if N = null then
      Ada.Text_IO.Put_Line ("null result for incomplete closure");
   elsif S /= Incomplete_Closure then
      Ada.Text_IO.Put_Line ("status for incomplete closure is "
                            & Status_Type'Image (S));
   else
      for I in N'Range loop
         Ada.Text_IO.Put_Line (N (I).Display_Base_Name);
      end loop;
   end if;

   Tree.Unload;
end Main;
