/*
 *  @(#)ValidateTaskType.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.ant;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Definer;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.Task;

import java.lang.reflect.Method;

import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.IErrors;
import net.sourceforge.groboutils.mbtf.v1.ISystem;
import net.sourceforge.groboutils.mbtf.v1.IAction;
import net.sourceforge.groboutils.mbtf.v1.TestHaltRuntimeException;


/**
 * A specific IValidate instance, which is Ant compatible, that executes an
 * ant Task/Target (via Reference), and registers an error if the "build"
 * fails.  Use the "refid" attribute to set the reference task/target.
 * Set the "sysid" to set the ID to register the "system" variable in the
 * project.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 13, 2002
 */
public class ValidateTaskType extends ReferenceType
        implements IValidate, IAction
{
    // intended to be an imbedded task, but can be defined outside
    // the state iterator.
    public static final String DEFAULT_ANT_NAME = "mbtf.validateant";
    
    
    public void validate( ISystem system, IErrors errors )
    {
        execute( system, errors );
    }
    
    
    public void performAction( ISystem system, IErrors errors )
    {
        execute( system, errors );
    }
}

