/* gsd-utils.c generated by valac 0.20.1, the Vala compiler
 * generated from gsd-utils.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <sys/select.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
   * Error domain for the FD namespace functions. It is mainly a wrapper around
   * some errnos to have exceptions for them.
   */
typedef enum  {
	GSD_FD_ERROR_KILL_ERROR,
	GSD_FD_ERROR_READ_ERROR,
	GSD_FD_ERROR_SELECT_ERROR,
	GSD_FD_ERROR_WAITPID_ERROR
} GsdFDError;
#define GSD_FD_ERROR gsd_fd_error_quark ()


GQuark gsd_fd_error_quark (void);
gboolean gsd_fd_read_ready (gint fd, GError** error);
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error);
guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error);


GQuark gsd_fd_error_quark (void) {
	return g_quark_from_static_string ("gsd_fd_error-quark");
}


/**
     * Gets whether a file descriptor is ready to be read or not.
     * 
     * Being ready means that reading data from it would not be blocking, as
     * there is data to be read.
     * 
     * @param fd a file descriptor
     * 
     * @return %TRUE if the file is read, %FALSE otherwise.
     */
gboolean gsd_fd_read_ready (gint fd, GError** error) {
	gboolean result = FALSE;
	gboolean ready;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	ready = FALSE;
	_tmp0_ = fd;
	if (_tmp0_ > 0) {
		fd_set _tmp1_ = {0};
		fd_set rfds;
		struct timeval _tmp2_ = {0};
		struct timeval tv;
		fd_set _tmp3_ = {0};
		gint _tmp4_;
		gint _tmp5_;
		struct timeval _tmp6_;
		gint _tmp7_ = 0;
		gint rv;
		gint _tmp8_;
		rfds = _tmp1_;
		_tmp2_.tv_sec = (time_t) 0;
		_tmp2_.tv_usec = (glong) 0;
		tv = _tmp2_;
		FD_ZERO (&_tmp3_);
		rfds = _tmp3_;
		_tmp4_ = fd;
		FD_SET (_tmp4_, &rfds);
		_tmp5_ = fd;
		_tmp6_ = tv;
		_tmp7_ = select (_tmp5_ + 1, &rfds, NULL, NULL, &_tmp6_);
		rv = _tmp7_;
		_tmp8_ = rv;
		if (_tmp8_ == (-1)) {
			gint _tmp9_;
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_;
			_tmp9_ = errno;
			_tmp10_ = g_strerror (_tmp9_);
			_tmp11_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_SELECT_ERROR, "select(): %s", _tmp10_);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		} else {
			gint _tmp12_;
			_tmp12_ = rv;
			if (_tmp12_ > 0) {
				ready = TRUE;
			}
		}
	}
	result = ready;
	return result;
}


/**
     * Reads content of a file as a string.
     * 
     * This function may only work with text data.
     * 
     * @param fd a file descriptor
     * @param n_bytes number of bytes to read from @fd, or -1 to read all @fd
     * 
     * @return a newly allocated string containing data in @fd.
     */
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error) {
	gchar* result = NULL;
	gchar* buf;
	gssize _tmp0_;
	gchar* _tmp49_;
	GError * _inner_error_ = NULL;
	buf = NULL;
	_tmp0_ = n_bytes;
	if (_tmp0_ > ((gssize) 0)) {
		gssize n_read = 0L;
		gssize _tmp1_;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		gchar* _tmp4_;
		gssize _tmp5_;
		gssize _tmp6_ = 0L;
		gssize _tmp7_;
		_tmp1_ = n_bytes;
		_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
		buf = _tmp2_;
		_tmp3_ = fd;
		_tmp4_ = buf;
		_tmp5_ = n_bytes;
		_tmp6_ = read (_tmp3_, _tmp4_, (gsize) _tmp5_);
		n_read = _tmp6_;
		_tmp7_ = n_read;
		if (_tmp7_ < ((gssize) 0)) {
			gint _tmp8_;
			gint errn;
			gchar* _tmp9_;
			gint _tmp10_;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_;
			_tmp8_ = errno;
			errn = _tmp8_;
			_tmp9_ = buf;
			g_free (_tmp9_);
			buf = NULL;
			_tmp10_ = errn;
			_tmp11_ = g_strerror (_tmp10_);
			_tmp12_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp11_);
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			gchar* _tmp13_;
			gssize _tmp14_;
			gchar _tmp15_;
			_tmp13_ = buf;
			_tmp14_ = n_read;
			_tmp13_[_tmp14_] = (gchar) 0;
			_tmp15_ = _tmp13_[_tmp14_];
		}
	} else {
		gsize packet_size;
		gsize n_read;
		gssize read_rv;
		gssize _tmp40_;
		packet_size = (gsize) 64;
		n_read = (gsize) 0;
		read_rv = (gssize) 0;
		n_bytes = (gssize) 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gchar* _tmp26_;
				gssize _tmp27_;
				gsize _tmp28_;
				void* _tmp29_ = NULL;
				gint _tmp30_;
				gchar* _tmp31_;
				gssize _tmp32_;
				gsize _tmp33_;
				gssize _tmp34_ = 0L;
				gssize _tmp35_;
				gssize _tmp38_;
				gsize _tmp39_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					gssize _tmp20_;
					gboolean _tmp22_;
					gboolean _tmp25_;
					_tmp20_ = n_bytes;
					if (_tmp20_ > ((gssize) 0)) {
						gssize _tmp21_;
						_tmp21_ = read_rv;
						_tmp19_ = _tmp21_ >= ((gssize) 0);
					} else {
						_tmp19_ = FALSE;
					}
					_tmp22_ = _tmp19_;
					if (_tmp22_) {
						gssize _tmp23_;
						gsize _tmp24_;
						_tmp23_ = read_rv;
						_tmp24_ = packet_size;
						_tmp18_ = ((gsize) _tmp23_) == _tmp24_;
					} else {
						_tmp18_ = FALSE;
					}
					_tmp25_ = _tmp18_;
					if (!_tmp25_) {
						break;
					}
				}
				_tmp16_ = FALSE;
				_tmp26_ = buf;
				_tmp27_ = n_bytes;
				_tmp28_ = packet_size;
				_tmp29_ = g_realloc (_tmp26_, (_tmp27_ + _tmp28_) + 1);
				buf = _tmp29_;
				_tmp30_ = fd;
				_tmp31_ = buf;
				_tmp32_ = n_bytes;
				_tmp33_ = packet_size;
				_tmp34_ = read (_tmp30_, &_tmp31_[_tmp32_], _tmp33_);
				read_rv = _tmp34_;
				_tmp35_ = read_rv;
				if (_tmp35_ >= ((gssize) 0)) {
					gsize _tmp36_;
					gssize _tmp37_;
					_tmp36_ = n_read;
					_tmp37_ = read_rv;
					n_read = _tmp36_ + _tmp37_;
				}
				_tmp38_ = n_bytes;
				_tmp39_ = packet_size;
				n_bytes = _tmp38_ + ((gssize) _tmp39_);
			}
		}
		_tmp40_ = read_rv;
		if (_tmp40_ < ((gssize) 0)) {
			gint _tmp41_;
			gint errn;
			gchar* _tmp42_;
			gint _tmp43_;
			const gchar* _tmp44_ = NULL;
			GError* _tmp45_;
			_tmp41_ = errno;
			errn = _tmp41_;
			_tmp42_ = buf;
			g_free (_tmp42_);
			buf = NULL;
			_tmp43_ = errn;
			_tmp44_ = g_strerror (_tmp43_);
			_tmp45_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp44_);
			_inner_error_ = _tmp45_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			gchar* _tmp46_;
			gsize _tmp47_;
			gchar _tmp48_;
			_tmp46_ = buf;
			_tmp47_ = n_read;
			_tmp46_[_tmp47_] = (gchar) 0;
			_tmp48_ = _tmp46_[_tmp47_];
		}
	}
	_tmp49_ = buf;
	buf = NULL;
	result = (gchar*) _tmp49_;
	return result;
}


/**
     * Counts the number of occurrence of a given byte in a file descriptor.
     * 
     * This function is non-blocking and returns 0 if there is no data in the
     * buffer rather than blocking waiting for data.
     * 
     * @param fd a valid file descriptor
     * @param byte the byte to cont in @fd
     * @param bufsize the size of the buffer used to cache the file's content.
     *    Tweaking it may improve the performances with different amount of data
     *    in @fd: the better value is the closer to the total number of bytes
     *    that will be read (the size of the file's content) or a multiple of it
     *    if it is a too big value to be reasonably allocated at once.
     * 
     * @return the number of occurrences of @byte in @fd.
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error) {
	guint result = 0U;
	guint n_occur;
	GError * _inner_error_ = NULL;
	n_occur = (guint) 0;
	{
		gint _tmp0_;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		_tmp0_ = fd;
		_tmp1_ = gsd_fd_read_ready (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GSD_FD_ERROR) {
				goto __catch11_gsd_fd_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
		if (_tmp2_) {
			gsize _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* buf;
			gint buf_length1;
			gint _buf_size_;
			gssize read_rv;
			_tmp3_ = bufsize;
			_tmp4_ = g_new0 (gchar, _tmp3_);
			buf = _tmp4_;
			buf_length1 = _tmp3_;
			_buf_size_ = buf_length1;
			read_rv = (gssize) 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_;
					gint _tmp9_;
					gchar* _tmp10_;
					gint _tmp10__length1;
					gsize _tmp11_;
					gssize _tmp12_ = 0L;
					gssize _tmp13_;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gssize _tmp7_;
						gsize _tmp8_;
						_tmp7_ = read_rv;
						_tmp8_ = bufsize;
						if (!(((gsize) _tmp7_) == _tmp8_)) {
							break;
						}
					}
					_tmp5_ = FALSE;
					_tmp9_ = fd;
					_tmp10_ = buf;
					_tmp10__length1 = buf_length1;
					_tmp11_ = bufsize;
					_tmp12_ = read (_tmp9_, _tmp10_, _tmp11_);
					read_rv = _tmp12_;
					_tmp13_ = read_rv;
					if (_tmp13_ < ((gssize) 0)) {
						gint _tmp14_;
						const gchar* _tmp15_ = NULL;
						GError* _tmp16_;
						_tmp14_ = errno;
						_tmp15_ = g_strerror (_tmp14_);
						_tmp16_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp15_);
						_inner_error_ = _tmp16_;
						buf = (g_free (buf), NULL);
						if (_inner_error_->domain == GSD_FD_ERROR) {
							goto __catch11_gsd_fd_error;
						}
						buf = (g_free (buf), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					} else {
						{
							guint i;
							i = (guint) 0;
							{
								gboolean _tmp17_;
								_tmp17_ = TRUE;
								while (TRUE) {
									gboolean _tmp18_;
									guint _tmp20_;
									gssize _tmp21_;
									gchar* _tmp22_;
									gint _tmp22__length1;
									guint _tmp23_;
									gchar _tmp24_;
									gint _tmp25_;
									_tmp18_ = _tmp17_;
									if (!_tmp18_) {
										guint _tmp19_;
										_tmp19_ = i;
										i = _tmp19_ + 1;
									}
									_tmp17_ = FALSE;
									_tmp20_ = i;
									_tmp21_ = read_rv;
									if (!(((gssize) _tmp20_) < _tmp21_)) {
										break;
									}
									_tmp22_ = buf;
									_tmp22__length1 = buf_length1;
									_tmp23_ = i;
									_tmp24_ = _tmp22_[_tmp23_];
									_tmp25_ = byte;
									if (((gint) _tmp24_) == _tmp25_) {
										guint _tmp26_;
										_tmp26_ = n_occur;
										n_occur = _tmp26_ + 1;
									}
								}
							}
						}
					}
				}
			}
			buf = (g_free (buf), NULL);
		}
	}
	goto __finally11;
	__catch11_gsd_fd_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		GError* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _g_error_copy0 (_tmp27_);
		_inner_error_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally11;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_FD_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	result = n_occur;
	return result;
}



