/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_QML_ACTION
#define UBUNTU_HUD_QML_ACTION

#include "../src/action.h"
#include "../src/parameter.h"

#include <QQmlListProperty>

namespace Ubuntu {
namespace HUD {
namespace QML {
    class Action;
}
}
}

class Ubuntu::HUD::QML::Action : public Ubuntu::HUD::Action
{
    Q_OBJECT

    Q_PROPERTY(QQmlListProperty<Ubuntu::HUD::Parameter> parameters
               READ parameters_list)

    Q_CLASSINFO("DefaultProperty", "parameters");

public:

    Action(QObject *parent = 0);
    ~Action();

    QQmlListProperty<Ubuntu::HUD::Parameter> parameters_list();

private:

    static void append(QQmlListProperty<Ubuntu::HUD::Parameter> *list, Ubuntu::HUD::Parameter *parameter);
    static Ubuntu::HUD::Parameter *at(QQmlListProperty<Ubuntu::HUD::Parameter> *list, int index);
    static void clear(QQmlListProperty<Ubuntu::HUD::Parameter> *list);
    static int count(QQmlListProperty<Ubuntu::HUD::Parameter> *list);
};

#endif
