package org.jboss.cache.loader;

import static org.testng.AssertJUnit.assertNotNull;

import java.io.IOException;
import java.util.Properties;

import net.noderunner.amazon.s3.emulator.Server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.testng.annotations.Test;


/**
 * Tests {@link org.jboss.cache.loader.s3.S3CacheLoader}.
 * 
 * This requires a S3 account to truly test; uses an emulator otherwise.
 *
 * @author Elias Ross
 * @version $Id: JdbmCacheLoaderTest.java 4561 2007-10-08 14:02:02Z manik.surtani@jboss.com $
 */
@Test(groups =
{"functional"}, enabled = true)
public class S3CacheLoaderTest extends CacheLoaderTestsBase
{

   private static final Log log = LogFactory.getLog(S3CacheLoaderTest.class);

   private Server server;

   @Override
   protected void configureCache() throws Exception
   {      
      String accessKey = System.getProperty("accessKey");
      String properties;
      if (accessKey == null)
      {
         log.info("Testing using S3CacheLoader using emulator");
         server = new Server();
         server.start();
         properties = 
               "cache.s3.accessKeyId=dummy\n"  +
               "cache.s3.secretAccessKey=dummy\n"  +
               "cache.s3.server=localhost\n"  +
               "cache.s3.port=" + server.getPort() + "\n"  +
               "cache.s3.callingFormat=VANITY" + "\n"  +
               "cache.s3.bucket=localhost" + "\n";
      }
      else
      {
          properties = 
             "cache.s3.accessKeyId=" + accessKey + "\n" +
             "cache.s3.secretAccessKey=" + System.getProperty("secretKey") + "\n" ;
      }
      CacheLoaderConfig config = getSingleCacheLoaderConfig("", "org.jboss.cache.loader.s3.S3CacheLoader", properties, false, true, false);
      // System.out.println(config);
      Properties p = config.getFirstCacheLoaderConfig().getProperties();
      // System.out.println(p);
      assertNotNull(p.get("cache.s3.accessKeyId"));
      assertNotNull(p.get("cache.s3.secretAccessKey"));
      cache.getConfiguration().setCacheLoaderConfig(config);
   }
   
   @Override
   public void cleanup() {
      if (server != null)
      {
         try
         {
             server.close();
         }
         catch (IOException e) {
         }
      }
   }

   protected void postConfigure()
   {
      cache.removeNode(Fqn.root());
   }

   //@Override
   public void testCacheLoaderThreadSafety()
   {

   }

   //@Override
   public void testPartialLoadAndStore()
   {
      // do nothing
   }

   //@Override
   public void testBuddyBackupStore()
   {
      // do nothing
   }

   //@Override
   protected void threadSafetyTest(final boolean singleFqn) throws Exception
   {
   }
   
}
