/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.test.microcontainer.support.deployers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.w3c.dom.Document;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class AspectManagerBean
{
   AspectMan delegate = new AspectMan();
   MBeanServer server;
   String bootstrapXml;
   
   public AspectManagerBean(String bootstrapXml)
   {
      this.bootstrapXml = bootstrapXml;
      try
      {
         if (bootstrapXml != null)
         {
            InputStream in = new BufferedInputStream(new ByteArrayInputStream(bootstrapXml.getBytes()));
            try
            {
               Document doc = AspectXmlLoader.loadDocument(new BufferedInputStream(in));
               AspectXmlLoader loader = new AspectXmlLoader();
               loader.setManager(getAspectManager());
               loader.deployXML(doc, null);
            }
            finally
            {
               if (in != null)
               {
                  in.close();
               }
            }
         }
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException("Problem starting AspectManager", e);
      }
   }
   
   public void setMbeanServer(MBeanServer server)
   {
      this.server = server;
   }

   public MBeanServer getMbeanServer()
   {
      return server;
   }
   
   public AspectManager getAspectManager()
   {
      return AspectManager.getTopLevelAspectManager();
   }

   public void start() throws Exception
   {
      try
      {
         server.registerMBean(delegate, new ObjectName("jboss.aop:service=AspectManager"));
      }
      catch (Exception e)
      {
         throw new RuntimeException("Problem registering jboss.aop:service=AspectManager with JMXServer", e);
      }
   }

   public void destroy()
   {
      if (this.server == null)
      {
         try
         {
            if (bootstrapXml != null)
            {
               InputStream in = new BufferedInputStream(new ByteArrayInputStream(bootstrapXml.getBytes()));
               try
               {
                  Document doc = AspectXmlLoader.loadDocument(new BufferedInputStream(in));
                  AspectXmlLoader loader = new AspectXmlLoader();
                  loader.setManager(getAspectManager());
                  loader.deployXML(doc, null);
               }
               finally
               {
                  if (in != null)
                  {
                     in.close();
                  }
               }
            }
            server.unregisterMBean(new ObjectName("jboss.aop:service=AspectManager"));
         }
         catch (Exception e)
         {
            throw new RuntimeException("Problem unregistering jboss.aop:service=AspectManager with JMXServer", e);
         }
      }
   }
   
   public interface AspectManMBean
   {
      
   }

   public static class AspectMan implements AspectManMBean
   {
      
   }
   
}
