//start of LimitedInputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF


/**
 * LimitedInputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.InputStream;
import java.lang.Math;

//import exceptions
import java.io.IOException;
import java.lang.IllegalArgumentException;

/**
 * ǂݍ݉\ȃf[^ʂꂽ̓Xg[B<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LimitedInputStream.java,v $
 * Revision 1.1.2.1  2003/07/20 17:03:37  dangan
 * [maintenance]
 *     ŐV LimitedInputStream \[X荞ށB
 *
 * Revision 1.1  2002/12/05 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [change]
 *     EndOfStream ɒB read( new byte[0] )  
 *     read( byte[] buf, int off, 0 ) ̖߂l
 *     InputStream Ɠ 0 ɂȂ悤ɂ
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1.2.1 $
 */
public class LimitedInputStream extends InputStream{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream in
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[
     */
    private InputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private long position
    //  private final long limit
    //  private long markPosition
    //------------------------------------------------------------------
    /**
     * ݓǂݍ݈ʒu
     */
    private long position;

    /**
     * ǂݍ݌E
     */
    private final long limit;

    /**
     * }[Nʒu
     */
    private long markPosition;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  public LimitedInputStream( InputStream in, long limit )
    //------------------------------------------------------------------
    /**
     * in ̓ǂݍ݉\ȃf[^ʂ𐧌
     * ̓Xg[\zB<br>
     * 
     * @param in    ̓Xg[
     * @param limit ǂݍ݉\oCg
     *
     * @exception IllegalArgumentException
     *              limit łꍇ
     */
    public LimitedInputStream( InputStream in, long limit ){
        if( in != null && 0 <= limit ){
            this.in           = in;
            this.position     = 0;
            this.limit        = limit;
            this.markPosition = -1;
        }else if( in == null ){
            throw new NullPointerException( "in" );
        }else{
            throw new IllegalArgumentException( "limit must be 0 or more." );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //  public long skip( long length )
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ 1oCg̃f[^ǂݍށB
     * 
     * @return ǂݍ܂ꂽ 1oCg̃f[^<br>
     *         EndOfStream ɒBĂA
     *         ɒBꍇ -1 ԂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read() throws IOException {
        if( this.position < this.limit ){
            int ret = this.in.read();                                           //throws IOException
            if( 0 <= ret ){
                this.position++;
            }
            return ret;
        }else{
            return -1;
        }
    }

    /**
     * ڑꂽ̓Xg[ buffer 𖞂悤
     * f[^ǂݍށB<br>
     * f[^͕K buffer 𖞂Ƃ͌ȂƂɒӁB<br>
     * 
     * @param buffer ǂݍ񂾃f[^i[邽߂̃oCgz<br>
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *         EndOfStream ɒBĂA
     *         ɒBꍇ -1 ԂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read( byte[] buffer ) throws IOException {
        if( 0 < buffer.length ){
            int ret;
            if( buffer.length < this.limit - this.position ){
                ret = this.in.read( buffer );                                   //throws IOException
            }else if( this.position < this.limit ){
                ret = this.in.read( buffer, 0, (int)( this.limit - this.position ) );//throws IOException
            }else{
                return -1;
            }
            if( 0 < ret ){
                this.position += ret;
            }
            return ret;
        }else{
            return 0;
        }
    }

    /**
     * ڑꂽ̓Xg[ oCgz buffer 
     * index Ŏw肳ꂽʒu length oCg̃f[^
     * ǂݍށB<br>
     * f[^͕K length oCgǂݍ܂Ƃ͌
     * ȂƂɒӁB<br>
     * 
     * @param buffer ǂݍ܂ꂽf[^i[邽߂̃oCgz
     * @param index  buffer̃f[^ǂݍ݊Jnʒu
     * @param length bufferɓǂݍރf[^
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *         EndOfStream ɒBĂA
     *         ɒBꍇ -1 ԂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read( byte[] buffer, int index, int length )
                                                           throws IOException {

        if( 0 < length ){
            if( this.limit <= this.position ){
                return -1;
            }else if( this.limit - this.position < length ){
                length = (int)( this.limit - this.position );
            }
            int ret = this.in.read( buffer, index, length );                    //throws IOException
            if( 0 < ret ){
                this.position += ret;
            }
            return ret;
        }else{
            return 0;
        }
    }

    /**
     * ڑꂽ̓Xg[̃f[^ length oCgǂݔ΂B<br>
     * 
     * @param length ǂݔ΂oCgB<br>
     * 
     * @return ۂɓǂݔ΂ꂽoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public long skip( long length ) throws IOException {

        if( 0 < length ){
            if( this.limit <= this.position ){
                return 0;
            }else if( this.limit - this.position < length ){
                length = this.limit - this.position;
            } 
            length = this.in.skip( length );                                    //throws IOException
            if( 0 < length ){
                this.position += length;
            }
            return length;
        }else{
            return 0;
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupprted()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     */
    public void mark( int readLimit ){
        this.in.mark( readLimit );
        this.markPosition = this.position;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException <br>
     *              <ol>
     *                <li> LimitedInputStream  mark ȂĂȂꍇB<br>
     *                <li> ڑꂽ̓Xg[ markSupported()
     *                     false ԂꍇB<br>
     *                <li> ڑꂽ̓Xg[
     *                     o̓G[ꍇB<br>
     *              </ol>
     *              ̉ꂩB
     */
    public void reset() throws IOException {
        if( !this.in.markSupported() ){
            throw new IOException( "not support mark()/reset()." );
        }else if( this.markPosition < 0 ){ //RXgN^ MarkPosition  -1 ɐݒ肳̂𗘗pB
            throw new IOException( "not marked." );
        }else{
            this.in.reset();                                                    //throws IOException
            this.position = this.markPosition;
        }
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ubNȂ
     * ǂݍނƂ̂łoCg𓾂B<br>
     * 
     * @return ubNȂœǂݏooCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int available() throws IOException {
        return (int)Math.min( (long)this.in.available(),                        //throws IOException
                               this.limit - this.position );
    }

    /**
     * ̓̓Xg[AgpĂ
     * SẴ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException
        this.in = null;
    }

}
//end of LimitedInputStream.java
