using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Abstract Syntax Trees for mathematical expressions.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * <a target='_blank'
 * href='http://en.wikipedia.org/wiki/Abstract_syntax_tree'>Abstract Syntax
 * Trees</a> (ASTs) are a simple kind of data structure used in libSBML for
 * storing mathematical expressions.  LibSBML ASTs provide a canonical,
 * in-memory representation for all mathematical formulas regardless of their
 * original format (which might be MathML or might be text strings).
 *
 *
 * 
 * An AST @em node in libSBML is a recursive tree structure; each node has a
 * type, a pointer to a value, and a list of children nodes.  Each ASTNode
 * node may have none, one, two, or more children depending on its type.
 * There are node types to represent numbers (with subtypes to distinguish
 * integer, real, and rational numbers), names (e.g., constants or
 * variables), simple mathematical operators, logical or relational operators
 * and functions.  The following diagram illustrates an example of how the
 * mathematical expression <code>'1 + 2'</code> is represented as an AST with
 * one @em plus node having two @em integer children nodes for the numbers
 * <code>1</code> and <code>2</code>.  The figure also shows the
 * corresponding MathML representation:
 *
 * @htmlinclude astnode-illustration.html
 *
 * The following are other noteworthy points about the AST representation
 * in libSBML:

 * @li A numerical value represented in MathML as a real number with an
 * exponent is preserved as such in the AST node representation, even if the
 * number could be stored in a @c double data type.  This is done so that
 * when an SBML model is read in and then written out again, the amount of
 * change introduced by libSBML to the SBML during the round-trip activity is
 * minimized.
 *
 * @li Rational numbers are represented in an AST node using separate
 * numerator and denominator values.  These can be retrieved using the
 * methods ASTNode::getNumerator() and ASTNode::getDenominator().
 *
 * @li The children of an ASTNode are other ASTNode objects.  The list of
 * children is empty for nodes that are leaf elements, such as numbers.
 * For nodes that are actually roots of expression subtrees, the list of
 * children points to the parsed objects that make up the rest of the
 * expression.
 *
 * For many applications, the details of ASTs are irrelevant because libSBML
 * provides text-string based translation functions such as
 * @sbmlfunction{formulaToL3String, ASTNode} and
 * @sbmlfunction{parseL3Formula, String}.  If you find the complexity
 * of using the AST representation of expressions too high for your purposes,
 * perhaps the string-based functions will be more suitable.
 *
 *
 *
 * @if clike <h3><a class='anchor' name='ASTNodeType_t'>
 * ASTNodeType_t</a></h3> @else <h3><a class='anchor'
 * name='ASTNodeType_t'>The set of possible %ASTNode types</a></h3> @endif
 *
 *
 * 
 * Every ASTNode has an associated type code to indicate whether, for
 * example, it holds a number or stands for an arithmetic operator.
 * @if clike The type is recorded as a value drawn from the enumeration
 * #ASTNodeType_t.@endif
 * @if java The type is recorded as a value drawn from a
 * set of static integer constants defined in the class @link
 * libsbml.libsbml@endlink. Their names begin with the characters @c AST_.@endif
 * @if python The type is recorded as a value drawn from a
 * set of static integer constants defined in the class @link
 * libsbml@endlink. Their names begin with the characters @c AST_.@endif
 * @if csharp The type is recorded as a value drawn from a
 * set of static integer constants defined in the class @link
 * libsbml@endlink. Their names begin with the characters @c AST_.@endif
 * The list of possible types is quite long, because it covers all the
 * mathematical functions that are permitted in SBML. The values are shown
 * in the following table:
 *
 * @htmlinclude astnode-types.html
 *
 * The types have the following meanings:
 *
 * @li If the node is basic mathematical operator (e.g., @c '+'), then the
 * node's type will be @link libsbml#AST_PLUS AST_PLUS@endlink,
 * @link libsbml#AST_MINUS AST_MINUS@endlink,
 * @link libsbml#AST_TIMES AST_TIMES@endlink,
 * @link libsbml#AST_DIVIDE AST_DIVIDE@endlink, or
 * @link libsbml#AST_POWER AST_POWER@endlink, as appropriate.
 *
 * @li If the node is a predefined function or operator from %SBML
 * Level&nbsp;1 (in the string-based formula syntax used in Level&nbsp;1) or
 * %SBML Level&nbsp;2 and&nbsp;3 (in the subset of MathML used in SBML
 * Levels&nbsp;2 and&nbsp;3), then the node's type
 * will be either <code style='margin-right: 0'>AST_FUNCTION_</code><span
 * class='placeholder-nospace'>X</span>, <code style='margin-right: 0'>AST_LOGICAL_</code><span
 * class='placeholder-nospace'>X</span>, or <code style='margin-right: 0'>AST_RELATIONAL_</code><span
 * class='placeholder-nospace'>X</span>, as appropriate.  (Examples:
 * @link libsbml#AST_FUNCTION_LOG AST_FUNCTION_LOG@endlink,
 * @link libsbml#AST_RELATIONAL_LEQ AST_RELATIONAL_LEQ@endlink.)
 *
 * @li If the node refers to a user-defined function, the node's type will
 * be @link libsbml#AST_FUNCTION AST_FUNCTION@endlink (because it holds the
 * name of the function).
 *
 * @li If the node is a lambda expression, its type will be
 * @link libsbml#AST_LAMBDA AST_LAMBDA@endlink.
 *
 * @li If the node is a predefined constant (@c 'ExponentialE', @c 'Pi', @c
 * 'True' or @c 'False'), then the node's type will be
 * @link libsbml#AST_CONSTANT_E AST_CONSTANT_E@endlink,
 * @link libsbml#AST_CONSTANT_PI AST_CONSTANT_PI@endlink,
 * @link libsbml#AST_CONSTANT_TRUE AST_CONSTANT_TRUE@endlink, or
 * @link libsbml#AST_CONSTANT_FALSE AST_CONSTANT_FALSE@endlink.
 *
 * @li (Levels&nbsp;2 and&nbsp;3 only) If the node is the special MathML
 * csymbol @c time, the value of the node will be
 * @link libsbml#AST_NAME_TIME AST_NAME_TIME@endlink.  (Note, however, that the
 * MathML csymbol @c delay is translated into a node of type
 * @link libsbml#AST_FUNCTION_DELAY AST_FUNCTION_DELAY@endlink.  The difference is due to
 * the fact that @c time is a single variable, whereas @c delay is actually a
 * function taking arguments.)
 *
 * @li (Level&nbsp;3 only) If the node is the special MathML csymbol @c
 * avogadro, the value of the node will be
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink.
 *
 * @li If the node contains a numerical value, its type will be
 * @link libsbml#AST_INTEGER AST_INTEGER@endlink,
 * @link libsbml#AST_REAL AST_REAL@endlink,
 * @link libsbml#AST_REAL_E AST_REAL_E@endlink, or
 * @link libsbml#AST_RATIONAL AST_RATIONAL@endlink, as appropriate.
 *
 *
 *
 * <h3><a class='anchor' name='math-convert'>Converting between ASTs and text
 * strings</a></h3>
 *
 * The text-string form of mathematical formulas produced by
 * @sbmlfunction{formulaToString, String} and
 * @sbmlfunction{formulaToL3String, String}, and read by
 * @sbmlfunction{parseFormula, ASTNode} and
 * @sbmlfunction{parseL3Formula, ASTNode}, are in a simple C-inspired
 * infix notation.  A formula in one of these two text-string formats can be
 * handed to a program that understands SBML mathematical expressions, or
 * used as part of a translation system.  The libSBML distribution comes with
 * example programs in the @c 'examples' subdirectory that demonstrate such
 * things as translating infix formulas into MathML and vice-versa.
 *
 * Please see the documentation for the functions @sbmlfunction{parseFormula,
 * ASTNode} and @sbmlfunction{parseL3Formula, ASTNode} for detailed
 * explanations of the infix syntax they accept.
 *
 * <h3><a class='anchor' name='math-history'>Historical notes</a></h3>
 *
 * Readers may wonder why this part of libSBML uses a seemingly less
 * object-oriented design than other parts.  Originally, much of libSBML was
 * written in&nbsp;C.  All subsequent development was done in C++, but the
 * complexity of some of the functionality for converting between infix, AST
 * and MathML, coupled with the desire to maintain stability and backward
 * compatibility, means that some of the underlying code is still written
 * in&nbsp;C.  This has lead to the exposed API being more C-like.

 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see @sbmlfunction{formulaToL3String, ASTNode}
 * @see @sbmlfunction{formulaToString, ASTNode}
 * @see @sbmlfunction{getDefaultL3ParserSettings,}
 */

public class ASTNode : ASTBase {
	private HandleRef swigCPtr;
	
	internal ASTNode(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.ASTNode_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.ASTNodeUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(ASTNode obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (ASTNode obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~ASTNode() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_ASTNode(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  public static bool operator==(ASTNode lhs, ASTNode rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(ASTNode lhs, ASTNode rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is ASTNode) )
    {
      return false;
    }

    return this == (ASTNode)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/** */ /* libsbml-internal */ public
 ASTNode(int type) : this(libsbmlPINVOKE.new_ASTNode__SWIG_0(type), true) {
  }

  
/** */ /* libsbml-internal */ public
 ASTNode() : this(libsbmlPINVOKE.new_ASTNode__SWIG_1(), true) {
  }

  
/** */ /* libsbml-internal */ public
 ASTNode(SBMLNamespaces sbmlns, int type) : this(libsbmlPINVOKE.new_ASTNode__SWIG_2(SBMLNamespaces.getCPtr(sbmlns), type), true) {
  }

  
/** */ /* libsbml-internal */ public
 ASTNode(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_ASTNode__SWIG_3(SBMLNamespaces.getCPtr(sbmlns)), true) {
  }

  
/**
   * Copy constructor; creates a deep copy of the given ASTNode.
   *
   * @param orig the ASTNode to be copied.
   */ public
 ASTNode(ASTNode orig) : this(libsbmlPINVOKE.new_ASTNode__SWIG_4(ASTNode.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Frees the name of this ASTNode and sets it to @c null.
   *
   * This operation is only applicable to ASTNode objects corresponding to
   * operators, numbers, or @link libsbml#AST_UNKNOWN AST_UNKNOWN@endlink.  This
   * method has no effect on other types of nodes.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   */ public
 int freeName() {
    int ret = libsbmlPINVOKE.ASTNode_freeName(swigCPtr);
    return ret;
  }

  
/**
   * Converts this ASTNode to a canonical form.
   *
   * The rules determining the canonical form conversion are as follows:
   *
   * @li If the node type is @link libsbml#AST_NAME AST_NAME@endlink
   * and the node name matches @c 'ExponentialE', @c 'Pi', @c 'True' or @c
   * 'False' the node type is converted to the corresponding
   * <code>AST_CONSTANT_</code><em><span class='placeholder'>X</span></em> type.
   * @li If the node type is an @link libsbml#AST_FUNCTION AST_FUNCTION@endlink and
   * the node name matches an SBML (MathML) function name, logical operator name,
   * or relational operator name, the node is converted to the corresponding
   * <code>AST_FUNCTION_</code><em><span class='placeholder'>X</span></em> or
   * <code>AST_LOGICAL_</code><em><span class='placeholder'>X</span></em> type.
   *
   * SBML Level&nbsp;1 function names are searched first; thus, for example,
   * canonicalizing @c log will result in a node type of
   * @link libsbml#AST_FUNCTION_LN AST_FUNCTION_LN@endlink.  (See the SBML
   * Level&nbsp;1 Version&nbsp;2 Specification, Appendix C.)
   *
   * Sometimes, canonicalization of a node results in a structural conversion
   * of the node as a result of adding a child.  For example, a node with the
   * SBML Level&nbsp;1 function name @c sqr and a single child node (the
   * argument) will be transformed to a node of type
   * @link libsbml#AST_FUNCTION_POWER AST_FUNCTION_POWER@endlink with two children.  The
   * first child will remain unchanged, but the second child will be an
   * ASTNode of type @link libsbml#AST_INTEGER AST_INTEGER@endlink and a value of
   * 2.  The function names that result in structural changes are: @c log10,
   * @c sqr, and @c sqrt.
   *
   * @return @c true if this node was successfully converted to
   * canonical form, @c false otherwise.
   */ public
 bool canonicalize() {
    bool ret = libsbmlPINVOKE.ASTNode_canonicalize(swigCPtr);
    return ret;
  }

  
/**
   * Adds the given node as a child of this ASTNode.
   *
   * Child nodes are added in-order, from left to right.
   *
   * @param disownedChild the ASTNode instance to add
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @warning Explicitly adding, removing or replacing children of an
 * @if conly ASTNode_t structure@else ASTNode object@endif may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * @if conly ASTNode_isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
 * may also be useful for checking the results of node modifications.
 *
 *
   *
   * @see prependChild(ASTNode disownedChild)
   * @see replaceChild(unsigned int n, ASTNode disownedChild, bool delreplaced)
   * @see insertChild(unsigned int n, ASTNode disownedChild)
   * @see removeChild(unsigned int n)
   * @see isWellFormedASTNode()
   */ public
 int addChild(ASTNode disownedChild) {
    int ret = libsbmlPINVOKE.ASTNode_addChild(swigCPtr, ASTNode.getCPtrAndDisown(disownedChild));
    return ret;
  }

  
/**
   * Adds the given node as a child of this ASTNode.
   *
   * This method adds child nodes from right to left.
   *
   * @param disownedChild the ASTNode instance to add
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @warning Explicitly adding, removing or replacing children of an
 * @if conly ASTNode_t structure@else ASTNode object@endif may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * @if conly ASTNode_isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
 * may also be useful for checking the results of node modifications.
 *
 *
   *
   * @see addChild(ASTNode disownedChild)
   * @see replaceChild(unsigned int n, ASTNode disownedChild, bool delreplaced)
   * @see insertChild(unsigned int n, ASTNode disownedChild)
   * @see removeChild(unsigned int n)
   */ public
 int prependChild(ASTNode disownedChild) {
    int ret = libsbmlPINVOKE.ASTNode_prependChild(swigCPtr, ASTNode.getCPtrAndDisown(disownedChild));
    return ret;
  }

  
/**
   * Removes the nth child of this ASTNode object.
   *
   * @param n unsigned int the index of the child to remove
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   *
 * @warning Explicitly adding, removing or replacing children of an
 * @if conly ASTNode_t structure@else ASTNode object@endif may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * @if conly ASTNode_isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
 * may also be useful for checking the results of node modifications.
 *
 *
   *
   * @see addChild(ASTNode disownedChild)
   * @see prependChild(ASTNode disownedChild)
   * @see replaceChild(unsigned int n, ASTNode disownedChild, bool delreplaced)
   * @see insertChild(unsigned int n, ASTNode disownedChild)
   */ public
 int removeChild(long n) {
    int ret = libsbmlPINVOKE.ASTNode_removeChild(swigCPtr, n);
    return ret;
  }

  
/**
   * Replaces the nth child of this ASTNode with the given ASTNode.
   *
   * @param n unsigned int the index of the child to replace
   * @param disownedChild ASTNode to replace the nth child
   * @param delreplaced boolean indicating whether to delete the replaced child.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   *
 * @warning Explicitly adding, removing or replacing children of an
 * @if conly ASTNode_t structure@else ASTNode object@endif may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * @if conly ASTNode_isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
 * may also be useful for checking the results of node modifications.
 *
 *
   *
   * @see addChild(ASTNode disownedChild)
   * @see prependChild(ASTNode disownedChild)
   * @see insertChild(unsigned int n, ASTNode disownedChild)
   * @see removeChild(unsigned int n)
   */ public
 int replaceChild(long n, ASTNode disownedChild, bool delreplaced) {
    int ret = libsbmlPINVOKE.ASTNode_replaceChild__SWIG_0(swigCPtr, n, ASTNode.getCPtrAndDisown(disownedChild), delreplaced);
    return ret;
  }

  
/**
   * Replaces the nth child of this ASTNode with the given ASTNode.
   *
   * @param n unsigned int the index of the child to replace
   * @param disownedChild ASTNode to replace the nth child
   * @param delreplaced boolean indicating whether to delete the replaced child.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   *
 * @warning Explicitly adding, removing or replacing children of an
 * @if conly ASTNode_t structure@else ASTNode object@endif may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * @if conly ASTNode_isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
 * may also be useful for checking the results of node modifications.
 *
 *
   *
   * @see addChild(ASTNode disownedChild)
   * @see prependChild(ASTNode disownedChild)
   * @see insertChild(unsigned int n, ASTNode disownedChild)
   * @see removeChild(unsigned int n)
   */ public
 int replaceChild(long n, ASTNode disownedChild) {
    int ret = libsbmlPINVOKE.ASTNode_replaceChild__SWIG_1(swigCPtr, n, ASTNode.getCPtrAndDisown(disownedChild));
    return ret;
  }

  
/**
   * Inserts the given ASTNode node at a given point in the current ASTNode's
   * list of children.
   *
   * @param n unsigned int the index of the ASTNode being added
   * @param disownedChild ASTNode to insert as the nth child
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   *
 * @warning Explicitly adding, removing or replacing children of an
 * @if conly ASTNode_t structure@else ASTNode object@endif may change the
 * structure of the mathematical formula it represents, and may even render
 * the representation invalid.  Callers need to be careful to use this method
 * in the context of other operations to create complete and correct
 * formulas.  The method
 * @if conly ASTNode_isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
 * may also be useful for checking the results of node modifications.
 *
 *
   *
   * @see addChild(ASTNode disownedChild)
   * @see prependChild(ASTNode disownedChild)
   * @see replaceChild(unsigned int n, ASTNode disownedChild, bool delreplaced)
   * @see removeChild(unsigned int n)
   */ public
 int insertChild(long n, ASTNode disownedChild) {
    int ret = libsbmlPINVOKE.ASTNode_insertChild(swigCPtr, n, ASTNode.getCPtrAndDisown(disownedChild));
    return ret;
  }

  
/**
   * Creates a recursive copy of this node and all its children.
   *
   * @return a copy of this ASTNode and all its children.  The caller owns
   * the returned ASTNode and is responsible for deleting it.
   */ public
 ASTBase deepCopy() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_deepCopy(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
   * Returns the child at index n of this node.
   *
   * @param n the index of the child to get
   *
   * @return the nth child of this ASTNode or @c null if this node has no nth
   * child (<code>n &gt; </code>
   * @if clike getNumChildren()@else ASTNode::getNumChildren()@endif
   * <code>- 1</code>).
   *
   * @see getNumChildren()
   * @see getLeftChild()
   * @see getRightChild()
   */ public new
 ASTNode getChild(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getChild(swigCPtr, n);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns the left child of this node.
   *
   * @return the left child of this ASTNode.  This is equivalent to calling
   * @if clike getChild()@else ASTNode::getChild(unsigned int)@endif
   * with an argument of @c 0.
   *
   * @see getNumChildren()
   * @see getChild(@if java unsigned int@endif)
   * @see getRightChild()
   */ public
 ASTNode getLeftChild() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getLeftChild(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns the right child of this node.
   *
   * @return the right child of this ASTNode, or @c null if this node has no
   * right child.  If
   * @if clike getNumChildren()@else ASTNode::getNumChildren()@endif
   * <code>&gt; 1</code>, then this is equivalent to:
   * @verbatim
getChild( getNumChildren() - 1 );
@endverbatim
   *
   * @see getNumChildren()
   * @see getLeftChild()
   * @see getChild(@if java unsigned int@endif)
   */ public
 ASTNode getRightChild() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getRightChild(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns the number of children of this node.
   *
   * @return the number of children of this ASTNode, or 0 is this node has
   * no children.
   */ public
 long getNumChildren() { return (long)libsbmlPINVOKE.ASTNode_getNumChildren(swigCPtr); }

  
/**
   * Adds the given XMLNode as a MathML <code>&lt;semantics&gt;</code>
   * element to this ASTNode.
   *
   *
 * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
 * that can be used to associate additional information with a MathML
 * construct.  The construct can be used to decorate a MathML expressions with
 * a sequence of one or more <code>&lt;annotation&gt;</code> or
 * <code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
 * pair of items; the first is a symbol that acts as an attribute or key, and
 * the second is the value associated with the attribute or key.  Please refer
 * to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
 * href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
 * 5.2, Semantic Annotations</a> for more information about these constructs.
 *
 *
   *
   * @param disownedAnnotation the annotation to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note Although SBML permits the use of the MathML
 * <code>&lt;semantics&gt;</code> annotation construct, the truth is that
 * this construct has so far (at this time of this writing, which is early
 * 2014) seen very little use in SBML software.  The full implications of
 * using these annotations are still poorly understood.  If you wish to
 * use this construct, we urge you to discuss possible uses and applications
 * on the SBML discussion lists, particularly <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-discuss</a> and/or <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-interoperability</a>.
   *
   * @see ASTNode::getNumSemanticsAnnotations()
   * @see ASTNode::getSemanticsAnnotation(@if java unsigned int@endif)
   */ public
 int addSemanticsAnnotation(XMLNode disownedAnnotation) {
    int ret = libsbmlPINVOKE.ASTNode_addSemanticsAnnotation(swigCPtr, XMLNode.getCPtrAndDisown(disownedAnnotation));
    return ret;
  }

  
/**
   * Returns the number of MathML <code>&lt;semantics&gt;</code> element
   * elements on this node.
   *
   *
 * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
 * that can be used to associate additional information with a MathML
 * construct.  The construct can be used to decorate a MathML expressions with
 * a sequence of one or more <code>&lt;annotation&gt;</code> or
 * <code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
 * pair of items; the first is a symbol that acts as an attribute or key, and
 * the second is the value associated with the attribute or key.  Please refer
 * to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
 * href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
 * 5.2, Semantic Annotations</a> for more information about these constructs.
 *
 *
   *
   * @return the number of annotations of this ASTNode.
   *
   *
 * @note Although SBML permits the use of the MathML
 * <code>&lt;semantics&gt;</code> annotation construct, the truth is that
 * this construct has so far (at this time of this writing, which is early
 * 2014) seen very little use in SBML software.  The full implications of
 * using these annotations are still poorly understood.  If you wish to
 * use this construct, we urge you to discuss possible uses and applications
 * on the SBML discussion lists, particularly <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-discuss</a> and/or <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-interoperability</a>.
   *
   * @see ASTNode::addSemanticsAnnotation(@if java XMLNode@endif)
   * @see ASTNode::getSemanticsAnnotation(@if java unsigned int@endif)
   */ public
 long getNumSemanticsAnnotations() { return (long)libsbmlPINVOKE.ASTNode_getNumSemanticsAnnotations(swigCPtr); }

  
/**
   * Returns the nth MathML <code>&lt;semantics&gt;</code> element on this
   * ASTNode.
   *
   *
 * The <code>&lt;semantics&gt;</code> element is a MathML&nbsp;2.0 construct
 * that can be used to associate additional information with a MathML
 * construct.  The construct can be used to decorate a MathML expressions with
 * a sequence of one or more <code>&lt;annotation&gt;</code> or
 * <code>&lt;annotation-xml&gt;</code> elements.  Each such element contains a
 * pair of items; the first is a symbol that acts as an attribute or key, and
 * the second is the value associated with the attribute or key.  Please refer
 * to the MathML&nbsp;2.0 documentation, particularly the <a target='_blank'
 * href='http://www.w3.org/TR/2007/WD-MathML3-20071005/chapter5.html#mixing.semantic.annotations'>Section
 * 5.2, Semantic Annotations</a> for more information about these constructs.
 *
 *
   *
   * @param n the index of the annotation to return.  Callers should
   * use ASTNode::getNumSemanticsAnnotations() to first find out how
   * many annotations there are.
   *
   * @return the nth annotation inside this ASTNode, or @c null if this node has
   * no nth annotation (<code>n &gt;</code>
   * @if clike getNumSemanticsAnnotations()@else ASTNode::getNumSemanticsAnnotations()@endif
   * <code>- 1</code>).
   *
   *
 * @note Although SBML permits the use of the MathML
 * <code>&lt;semantics&gt;</code> annotation construct, the truth is that
 * this construct has so far (at this time of this writing, which is early
 * 2014) seen very little use in SBML software.  The full implications of
 * using these annotations are still poorly understood.  If you wish to
 * use this construct, we urge you to discuss possible uses and applications
 * on the SBML discussion lists, particularly <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-discuss</a> and/or <a target='_blank'
 * href='http://sbml.org/Forums'>sbml-interoperability</a>.
   *
   * @see ASTNode::addSemanticsAnnotation(@if java XMLNode@endif)
   * @see ASTNode::getNumSemanticsAnnotations()
   */ public
 XMLNode getSemanticsAnnotation(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getSemanticsAnnotation(swigCPtr, n);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, false);
    return ret;
  }

  
/**
   * Returns the value of this node as a single character.
   *
   * This function should be called only when ASTNode::getType() returns
   * @link libsbml#AST_MINUS AST_MINUS@endlink, @link libsbml#AST_TIMES AST_TIMES@endlink, @link libsbml#AST_DIVIDE AST_DIVIDE@endlink or
   * @link libsbml#AST_POWER AST_POWER@endlink.
   *
   * @return the value of this ASTNode as a single character
   */ public
 char getCharacter() {
    char ret = libsbmlPINVOKE.ASTNode_getCharacter(swigCPtr);
    return ret;
  }

  
/**
   * Returns the MathML @c id attribute value of this ASTNode.
   *
   * @return the MathML id of this ASTNode.
   *
   * @see isSetId()
   * @see setId(@if java string id@endif)
   * @see unsetId()
   */ public
 string getId() {
    string ret = libsbmlPINVOKE.ASTNode_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the MathML @c class attribute value of this ASTNode.
   *
   * @return the MathML class of this ASTNode, if any exists.
   *
   * @see isSetClass()
   * @see @if java setClassName(string id)@else setClass()@endif
   * @see unsetClass()
   */ public
 string getClass() {
    string ret = libsbmlPINVOKE.ASTNode_getClass(swigCPtr);
    return ret;
  }

  
/**
   * Returns the MathML @c style attribute value of this ASTNode.
   *
   * @return the MathML style of this ASTNode, if any exists.
   *
   * @see isSetStyle()
   * @see setStyle(@if java string id@endif)
   * @see unsetStyle()
   */ public
 string getStyle() {
    string ret = libsbmlPINVOKE.ASTNode_getStyle(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of this node as an integer.
   *
   * If this node type is @link libsbml#AST_RATIONAL AST_RATIONAL@endlink, this
   * method returns the value of the numerator.
   *
   * @return the value of this ASTNode as a (<code>long</code>) integer.
   *
   * @note This function should be called only when
   * @if clike getType()@else ASTNode::getType()@endif returns
   * @link libsbml#AST_INTEGER AST_INTEGER@endlink or
   * @link libsbml#AST_RATIONAL AST_RATIONAL@endlink.
   * It will return @c 0 if the node type is @em not one of these, but since
   * @c 0 may be a valid value for integer, it is important to be sure that
   * the node type is one of the expected types in order to understand if @c
   * 0 is the actual value.
   */ public
 int getInteger() {
    int ret = libsbmlPINVOKE.ASTNode_getInteger(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of this node as a string.
   *
   * This function may be called on nodes that (1) are not operators, i.e.,
   * nodes for which @if clike isOperator()@else ASTNode::isOperator()@endif
   * returns @c false, and (2) are not numbers, i.e.,
   * @if clike isNumber()@else ASTNode::isNumber()@endif returns @c false.
   *
   * @return the value of this ASTNode as a string, or @c null if it is
   * a node that does not have a name equivalent (e.g., if it is a number).
   */ public
 string getName() {
    string ret = libsbmlPINVOKE.ASTNode_getName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of this operator node as a string.
   *
   * This function may be called on nodes that are operators, i.e., nodes for
   * which @if clike isOperator()@else ASTNode::isOperator()@endif returns
   * @c true.
   *
   * @return the name of this operator ASTNode as a string (or @c null if not
   * an operator).
   */ public
 string getOperatorName() {
    string ret = libsbmlPINVOKE.ASTNode_getOperatorName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the numerator of this node.
   *
   * This function should be called only when
   * @if clike getType()@else ASTNode::getType()@endif returns
   * @link libsbml#AST_RATIONAL AST_RATIONAL@endlink or
   * @link libsbml#AST_INTEGER AST_INTEGER@endlink.
   *
   * @return the value of the numerator of this ASTNode.
   */ public
 int getNumerator() {
    int ret = libsbmlPINVOKE.ASTNode_getNumerator(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the denominator of this node.
   *
   * @return the value of the denominator of this ASTNode, or @c 1 if
   * this node has no numerical value.
   *
   * @note This function should be called only when
   * @if clike getType()@else ASTNode::getType()@endif returns
   * @link libsbml#AST_RATIONAL AST_RATIONAL@endlink.
   * It will return @c 1 if the node type is another type, but since @c 1 may
   * be a valid value for the denominator of a rational number, it is
   * important to be sure that the node type is the correct type in order to
   * correctly interpret the returned value.
   */ public
 int getDenominator() {
    int ret = libsbmlPINVOKE.ASTNode_getDenominator(swigCPtr);
    return ret;
  }

  
/**
   * Returns the real-numbered value of this node.
   *
   * This function performs the necessary arithmetic if the node type is
   * @link libsbml#AST_REAL_E AST_REAL_E@endlink (<em>mantissa *
   * 10<sup> exponent</sup></em>) or
   * @link libsbml#AST_RATIONAL AST_RATIONAL@endlink
   * (<em>numerator / denominator</em>).
   *
   * @return the value of this ASTNode as a real (double), or @c 0
   * if this is not a node that holds a number.
   *
   * @note This function should be called only when this ASTNode has a
   * numerical value type.  It will return @c 0 if the node type is another
   * type, but since @c 0 may be a valid value, it is important to be sure
   * that the node type is the correct type in order to correctly interpret
   * the returned value.
   */ public
 double getReal() {
    double ret = libsbmlPINVOKE.ASTNode_getReal(swigCPtr);
    return ret;
  }

  
/**
   * Returns the mantissa value of this node.
   *
   * If @if clike getType()@else ASTNode::getType()@endif returns
   * @link libsbml#AST_REAL AST_REAL@endlink, this method is
   * identical to ASTNode::getReal().
   *
   * @return the value of the mantissa of this ASTNode, or @c 0 if this
   * node is not a type that has a real-numbered value.
   *
   * @note This function should be called only when
   * @if clike getType()@else ASTNode::getType()@endif returns
   * @link libsbml#AST_REAL_E AST_REAL_E@endlink,
   * @link libsbml#AST_REAL AST_REAL@endlink or
   * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink.  It
   * will return @c 0 if the node type is another type, but since @c 0 may be
   * a valid value, it is important to be sure that the node type is the
   * correct type in order to correctly interpret the returned value.
   */ public
 double getMantissa() {
    double ret = libsbmlPINVOKE.ASTNode_getMantissa(swigCPtr);
    return ret;
  }

  
/**
   * Returns the exponent value of this ASTNode.
   *
   * @return the value of the exponent of this ASTNode, or @c 0 if this
   * is not a type of node that has an exponent.
   *
   * @note This function should be called only when
   * @if clike getType()@else ASTNode::getType()@endif
   * returns @link libsbml#AST_REAL_E AST_REAL_E@endlink.
   * It will return @c 0 if the node type is another type, but since @c 0 may
   * be a valid value, it is important to be sure that the node type is the
   * correct type in order to correctly interpret the returned value.
   */ public
 int getExponent() {
    int ret = libsbmlPINVOKE.ASTNode_getExponent(swigCPtr);
    return ret;
  }

  
/**
   * Returns the numerical value of this ASTNode.
   *
   * @return the numerical value of this ASTNode, or @c NaN if this
   * is not a type of node that has a numerical value.
   *
   * @note This function will return a numerical value (as a double) for 
   * any ASTNode_t that represents a number, a constant such as 
   * @link libsbml#AST_CONSTANT_PI AST_CONSTANT_PI@endlink, 
   * @link libsbml#AST_CONSTANT_E AST_CONSTANT_E@endlink, or 
   * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink, or 
   * @c 1 for nodes of type 
   * @link libsbml#AST_CONSTANT_TRUE AST_CONSTANT_TRUE@endlink and @c 0 for nodes of type
   * @link libsbml#AST_CONSTANT_FALSE AST_CONSTANT_FALSE@endlink. It does not evaluate
   * the node in any way so, for example, it will not return the value of 
   * a named ASTNode_t or attempt to evaluate a function. 
   * This includes a node representing @c time i.e. nodes
   * of type @link libsbml#AST_NAME_TIME AST_NAME_TIME@endlink.
   */ public
 double getValue() {
    double ret = libsbmlPINVOKE.ASTNode_getValue(swigCPtr);
    return ret;
  }

  
/**
   * Returns the precedence of this node in the infix math syntax of SBML
   * Level&nbsp;1.
   *
   * For more information about the infix syntax, see the discussion about <a
   * href='#math-convert'>text string formulas</a> at the top of the
   * documentation for ASTNode.
   *
   * @return an integer indicating the precedence of this ASTNode
   */ public
 int getPrecedence() {
    int ret = libsbmlPINVOKE.ASTNode_getPrecedence(swigCPtr);
    return ret;
  }

  
/**
   * Returns the type of this ASTNode.
   *
   * The value returned is one of the Core AST type codes such as
   * @link libsbml#AST_LAMBDA AST_LAMBDA@endlink,
   * @link libsbml#AST_PLUS AST_PLUS@endlink, etc.
   *
   * @return the type of this ASTNode.
   *
   * @note The introduction of extensibility in SBML Level&nbsp;3 brings with
   * it a need to allow for the possibility of node types that are defined by
   * plug-ins implementing SBML Level&nbsp;3 packages.  If a given ASTNode is
   * a construct created by a package rather than libSBML Core, then
   * getType() will return
   * @link libsbml#AST_ORIGINATES_IN_PACKAGE AST_ORIGINATES_IN_PACKAGE@endlink.
   * Callers can then obtain the package-specific type by
   * calling getExtendedType().
   *
   * @see getExtendedType()
   */ public
 int getType() {
    int ret = libsbmlPINVOKE.ASTNode_getType(swigCPtr);
    return ret;
  }

  
/**
   * Returns the extended type of this ASTNode.
   *
   * The type may be either a core
   * @ifnot clike integer type code@else #ASTNodeType_t value@endif
   * or a value of a type code defined by an SBML Level&nbsp;3 package.
   *
   * @return the type of this ASTNode.
   *
   * @note When the ASTNode is of a type from a package, the value returned
   * by ASTNode::getType() will be
   * @link libsbml#AST_ORIGINATES_IN_PACKAGE AST_ORIGINATES_IN_PACKAGE@endlink
   * and getExtendedType() will return a package-specific type
   * code.  To find out the possible package-specific types (if any), please
   * consult the documentation for the particular package.
   *
   * @see getType()
   */ public new
 int getExtendedType() {
    int ret = libsbmlPINVOKE.ASTNode_getExtendedType(swigCPtr);
    return ret;
  }

  
/**
   * Returns the units of this ASTNode.
   *
   * @htmlinclude about-sbml-units-attrib.html
   *
   * @return the units of this ASTNode.
   *
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   *
   * @see @sbmlfunction{parseL3Formula, String}
   */ public
 string getUnits() {
    string ret = libsbmlPINVOKE.ASTNode_getUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents the predefined
   * value for Avogadro's constant.
   *
   * SBML Level&nbsp;3 introduced a predefined MathML <code>&lt;csymbol&gt;</code>
   * for the value of Avogadro's constant.  LibSBML stores this internally as
   * a node of type @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink.
   * This method returns @c true if this node has that type.
   *
   * @return @c true if this ASTNode is the special symbol avogadro,
   * @c false otherwise.
   *
   * @see @sbmlfunction{parseL3Formula, String}
   */ public new
 bool isAvogadro() {
    bool ret = libsbmlPINVOKE.ASTNode_isAvogadro(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node has a Boolean type.
   *
   * The ASTNode objects that have Boolean types are the logical operators,
   * relational operators, and the constants @c true or @c false.
   *
   * @return @c true if this ASTNode has a Boolean type, @c false otherwise.
   */ public new
 bool isBoolean() {
    bool ret = libsbmlPINVOKE.ASTNode_isBoolean(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node returns a Boolean value.
   *
   * This function looks at the whole ASTNode rather than just the top level
   * of the ASTNode. Thus, it will consider return values from piecewise
   * statements.  In addition, if this ASTNode uses a function call to a
   * user-defined function, the return value of the corresponding
   * FunctionDefinition object will be determined.  Note that this is only
   * possible where the ASTNode can trace its parent Model; that is, the
   * ASTNode must represent the <code>&lt;math&gt;</code> element of some
   * SBML object that has already been added to an instance of an
   * SBMLDocument.
   *
   * @param model the Model to use as context
   *
   * @see isBoolean()
   *
   * @return true if this ASTNode returns a boolean, @c false otherwise.
   */ public
 bool returnsBoolean(Model model) {
    bool ret = libsbmlPINVOKE.ASTNode_returnsBoolean__SWIG_0(swigCPtr, Model.getCPtr(model));
    return ret;
  }

  
/**
   * Returns @c true if this node returns a Boolean value.
   *
   * This function looks at the whole ASTNode rather than just the top level
   * of the ASTNode. Thus, it will consider return values from piecewise
   * statements.  In addition, if this ASTNode uses a function call to a
   * user-defined function, the return value of the corresponding
   * FunctionDefinition object will be determined.  Note that this is only
   * possible where the ASTNode can trace its parent Model; that is, the
   * ASTNode must represent the <code>&lt;math&gt;</code> element of some
   * SBML object that has already been added to an instance of an
   * SBMLDocument.
   *
   * @param model the Model to use as context
   *
   * @see isBoolean()
   *
   * @return true if this ASTNode returns a boolean, @c false otherwise.
   */ public
 bool returnsBoolean() {
    bool ret = libsbmlPINVOKE.ASTNode_returnsBoolean__SWIG_1(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents a MathML
   * constant.
   *
   * Examples of MathML constants include such things as pi.
   *
   * @return @c true if this ASTNode is a MathML constant, @c false
   * otherwise.
   *
   * @note This function will also return @c true for nodes of type
   * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink in SBML Level&nbsp;3.
   */ public new
 bool isConstant() {
    bool ret = libsbmlPINVOKE.ASTNode_isConstant(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents a function.
   *
   * The three types of functions in SBML are MathML functions (e.g.,
   * <code>abs()</code>), SBML Level&nbsp;1 functions (in the SBML
   * Level&nbsp;1 math syntax), and user-defined functions (using
   * FunctionDefinition in SBML Level&nbsp;2 and&nbsp;3).
   *
   * @return @c true if this ASTNode is a function, @c false otherwise.
   */ public new
 bool isFunction() {
    bool ret = libsbmlPINVOKE.ASTNode_isFunction(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents the special IEEE 754
   * value for infinity.
   *
   * @return @c true if this ASTNode is the special IEEE 754 value infinity,
   * @c false otherwise.
   */ public
 bool isInfinity() {
    bool ret = libsbmlPINVOKE.ASTNode_isInfinity(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node contains an integer value.
   *
   * @return @c true if this ASTNode is of type @link libsbml#AST_INTEGER AST_INTEGER@endlink, @c false otherwise.
   */ public new
 bool isInteger() {
    bool ret = libsbmlPINVOKE.ASTNode_isInteger(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a MathML
   * <code>&lt;lambda&gt;</code>.
   *
   * @return @c true if this ASTNode is of type @link libsbml#AST_LAMBDA AST_LAMBDA@endlink, @c false otherwise.
   */ public new
 bool isLambda() {
    bool ret = libsbmlPINVOKE.ASTNode_isLambda(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents a @c log10 function.
   *
   * More precisely, this predicate returns @c true if the node type is
   * @link libsbml#AST_FUNCTION_LOG AST_FUNCTION_LOG@endlink with two children, the
   * first of which is an @link libsbml#AST_INTEGER AST_INTEGER@endlink equal to
   * 10.
   *
   * @return @c true if the given ASTNode represents a @c log10() function, @c
   * false otherwise.
   *
   * @see @sbmlfunction{parseL3Formula, String}
   */ public new
 bool isLog10() {
    bool ret = libsbmlPINVOKE.ASTNode_isLog10(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a MathML logical operator.
   *
   * The possible MathML logical operators are @c and, @c or, @c not, and @c
   * xor.
   *
   * @return @c true if this ASTNode is a MathML logical operator, @c false
   * otherwise.
   */ public new
 bool isLogical() {
    bool ret = libsbmlPINVOKE.ASTNode_isLogical(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a user-defined variable name
   * or the symbols for time or Avogadro's constant.
   *
   * SBML Levels&nbsp;2 and&nbsp;3 provides <code>&lt;csymbol&gt;</code>
   * definitions for 'time' and 'avogadro', which can be used to represent
   * simulation time and Avogadro's constant in MathML.  Note that this
   * method does @em not return @c true for the other <code>csymbol</code>
   * values defined by SBML, 'delay', because the 'delay' is a function
   * and not a constant or variable.
   *
   * @return @c true if this ASTNode is a user-defined variable name in SBML
   * or the special symbols for time or Avogadro's constant. It returns @c
   * false otherwise.
   */ public new
 bool isName() {
    bool ret = libsbmlPINVOKE.ASTNode_isName(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents the special IEEE 754
   * value 'not a number' (NaN).
   *
   * @return @c true if this ASTNode is the special IEEE 754 NaN, @c false
   * otherwise.
   */ public
 bool isNaN() {
    bool ret = libsbmlPINVOKE.ASTNode_isNaN(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents the special IEEE 754
   * value 'negative infinity'.
   *
   * @return @c true if this ASTNode is the special IEEE 754 value negative
   * infinity, @c false otherwise.
   */ public
 bool isNegInfinity() {
    bool ret = libsbmlPINVOKE.ASTNode_isNegInfinity(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node contains a number.
   *
   * @return @c true if this ASTNode is a number, @c false otherwise.
   */ public new
 bool isNumber() {
    bool ret = libsbmlPINVOKE.ASTNode_isNumber(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a mathematical
   * operator.
   *
   * The possible mathematical operators in the MathML syntax supported by
   * SBML are <code>+</code>, <code>-</code>, <code>*</code>, <code>/</code>
   * and <code>^</code> (power).
   *
   * @return @c true if this ASTNode is an operator, @c false otherwise.
   */ public new
 bool isOperator() {
    bool ret = libsbmlPINVOKE.ASTNode_isOperator(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is the MathML
   * <code>&lt;piecewise&gt;</code> construct.
   *
   * @return @c true if this ASTNode is a MathML @c piecewise function,
   * @c false otherwise.
   */ public new
 bool isPiecewise() {
    bool ret = libsbmlPINVOKE.ASTNode_isPiecewise(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this node is a MathML
   * qualifier.
   *
   * The MathML qualifier node types are @c bvar, @c degree, @c base, @c
   * piece, and @c otherwise.
   *
   * @return @c true if this ASTNode is a MathML qualifier, @c false
   * otherwise.
   */ public new
 bool isQualifier() {
    bool ret = libsbmlPINVOKE.ASTNode_isQualifier(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents a rational number.
   *
   * @return @c true if this ASTNode is of type @link libsbml#AST_RATIONAL AST_RATIONAL@endlink, @c false otherwise.
   */ public new
 bool isRational() {
    bool ret = libsbmlPINVOKE.ASTNode_isRational(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node can represent a real number.
   *
   * More precisely, this node must be of one of the following types:
   * @link libsbml#AST_REAL AST_REAL@endlink, @link libsbml#AST_REAL_E AST_REAL_E@endlink or @link libsbml#AST_RATIONAL AST_RATIONAL@endlink.
   *
   * @return @c true if the value of this ASTNode can represented as a real
   * number, @c false otherwise.
   */ public new
 bool isReal() {
    bool ret = libsbmlPINVOKE.ASTNode_isReal(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a MathML
   * relational operator.
   *
   * The MathML relational operators are <code>==</code>, <code>&gt;=</code>,
   * <code>&gt;</code>, <code>&lt;</code>, and <code>!=</code>.
   *
   * @return @c true if this ASTNode is a MathML relational operator, @c
   * false otherwise.
   */ public new
 bool isRelational() {
    bool ret = libsbmlPINVOKE.ASTNode_isRelational(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this node is a MathML
   * semantics node.
   *
   * @return @c true if this ASTNode is a MathML semantics node, @c false
   * otherwise.
   */ public new
 bool isSemantics() {
    bool ret = libsbmlPINVOKE.ASTNode_isSemantics(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node represents a square root
   * function.
   *
   * More precisely, the node type must be @link libsbml#AST_FUNCTION_ROOT AST_FUNCTION_ROOT@endlink with two children, the first of which is an
   * @link libsbml#AST_INTEGER AST_INTEGER@endlink node having value equal to 2.
   *
   * @return @c true if the given ASTNode represents a <code>sqrt()</code>
   * function, @c false otherwise.
   */ public
 bool isSqrt() {
    bool ret = libsbmlPINVOKE.ASTNode_isSqrt(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a unary minus operator.
   *
   * A node is defined as a unary minus node if it is of type
   * @link libsbml#AST_MINUS AST_MINUS@endlink and has exactly one child.
   *
   * For numbers, unary minus nodes can be 'collapsed' by negating the
   * number.  In fact, @sbmlfunction{parseFormula, String} does this during
   * its parsing process, and @sbmlfunction{parseL3Formula, String} has a
   * configuration option that allows this behavior to be turned on or off.
   * However, unary minus nodes for symbols (@link libsbml#AST_NAME AST_NAME@endlink) cannot be 'collapsed', so this predicate function is
   * necessary.
   *
   * @return @c true if this ASTNode is a unary minus, @c false
   * otherwise.
   *
   * @see @sbmlfunction{parseL3Formula, String}
   */ public
 bool isUMinus() {
    bool ret = libsbmlPINVOKE.ASTNode_isUMinus(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node is a unary plus operator.
   *
   * A node is defined as a unary plus node if it is of type
   * @link libsbml#AST_PLUS AST_PLUS@endlink and has exactly one child.
   *
   * @return @c true if this ASTNode is a unary plus, @c false otherwise.
   */ public
 bool isUPlus() {
    bool ret = libsbmlPINVOKE.ASTNode_isUPlus(swigCPtr);
    return ret;
  }

  
/**
  * Returns @c true if this node is of a certain type with a specific number
  * of children.
  *
  * Designed for use in cases where it is useful to discover if the node is a
  * unary not or unary minus, or a times node with no children, etc.
  *
  * @param type the type of ASTNode sought.
  * @param numchildren the number of child nodes sought.
  *
  * @return @c true if this ASTNode is has the specified type and number of
  * children, @c false otherwise.
  */ public
 int hasTypeAndNumChildren(int type, long numchildren) {
    int ret = libsbmlPINVOKE.ASTNode_hasTypeAndNumChildren(swigCPtr, type, numchildren);
    return ret;
  }

  
/**
   * Returns @c true if this node has an unknown type.
   *
   * 'Unknown' nodes have the type @link libsbml#AST_UNKNOWN AST_UNKNOWN@endlink.
   * Nodes with unknown types will not appear in an ASTNode tree returned by
   * libSBML based upon valid SBML input; the only situation in which a node
   * with type @link libsbml#AST_UNKNOWN AST_UNKNOWN@endlink may appear is
   * immediately after having create a new, untyped node using the ASTNode
   * constructor.  Callers creating nodes should endeavor to set the type to
   * a valid node type as soon as possible after creating new nodes.
   *
   * @return @c true if this ASTNode is of type @link libsbml#AST_UNKNOWN AST_UNKNOWN@endlink, @c false otherwise.
   */ public new
 bool isUnknown() {
    bool ret = libsbmlPINVOKE.ASTNode_isUnknown(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node has a value for the MathML
   * attribute @c id.
   *
   * @return true if this ASTNode has an attribute id, @c false
   * otherwise.
   *
   * @see isSetClass()
   * @see isSetStyle()
   * @see setId(@if java string id@endif)
   * @see unsetId()
   */ public
 bool isSetId() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node has a value for the MathML
   * attribute @c class.
   *
   * @return true if this ASTNode has an attribute class, @c false
   * otherwise.
   *
   * @see isSetId()
   * @see isSetStyle()
   * @see @if java setClassName(string id)@else setClass()@endif
   * @see unsetClass()
   */ public
 bool isSetClass() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetClass(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node has a value for the MathML
   * attribute @c style.
   *
   * @return true if this ASTNode has an attribute style, @c false
   * otherwise.
   *
   * @see isSetClass()
   * @see isSetId()
   * @see setStyle(@if java string id@endif)
   * @see unsetStyle()
   */ public
 bool isSetStyle() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetStyle(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node has the attribute
   * <code>sbml:units</code>.
   *
   * @htmlinclude about-sbml-units-attrib.html
   *
   * @return @c true if this ASTNode has units associated with it, @c false
   * otherwise.
   *
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   *
   * @see hasUnits()
   * @see setUnits(@if java string units@endif)
   */ public
 bool isSetUnits() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node or any of its
   * children nodes have the attribute <code>sbml:units</code>.
   *
   * @htmlinclude about-sbml-units-attrib.html
   *
   * @return @c true if this ASTNode or its children has units associated
   * with it, @c false otherwise.
   *
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   *
   * @see isSetUnits()
   * @see setUnits(@if java string units@endif)
   */ public
 bool hasUnits() {
    bool ret = libsbmlPINVOKE.ASTNode_hasUnits(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given character.  If character
   * is one of @c +, @c -, <code>*</code>, <code>/</code> or @c ^, the node
   * type will be set accordingly.  For all other characters, the node type
   * will be set to @link libsbml#AST_UNKNOWN AST_UNKNOWN@endlink.
   *
   * @param value the character value to which the node's value should be
   * set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setCharacter(char value) {
    int ret = libsbmlPINVOKE.ASTNode_setCharacter(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the MathML attribute @c id of this ASTNode.
   *
   * @param id @c string representing the identifier.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see isSetId()
   * @see getId()
   * @see unsetId()
   */ public
 int setId(string id) {
    int ret = libsbmlPINVOKE.ASTNode_setId(swigCPtr, id);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the MathML attribute @c class of this ASTNode.
   *
   * @param className @c string representing the MathML class for this node.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @if java
   * @note In the API interfaces for languages other than Java, this method
   * is named <code>setClass()</code>, but in Java it is renamed
   * <code>setClassName()</code> to avoid a name collision with Java's
   * standard object method of the same name.
   * @endif
   *
   * @see isSetClass()
   * @see getClass()
   * @see unsetClass()
   */ public
 int setClass(string className) {
    int ret = libsbmlPINVOKE.ASTNode_setClass(swigCPtr, className);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the MathML attribute @c style of this ASTNode.
   *
   * @param style @c string representing the identifier.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see isSetStyle()
   * @see getStyle()
   * @see unsetStyle()
   */ public
 int setStyle(string style) {
    int ret = libsbmlPINVOKE.ASTNode_setStyle(swigCPtr, style);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given name.
   *
   * As a side effect, this ASTNode object's type will be reset to
   * @link libsbml#AST_NAME AST_NAME@endlink if (and <em>only if</em>) the
   * ASTNode was previously an operator (i.e., @if clike isOperator()@else
   * ASTNode::isOperator()@endif returns @c true), number (i.e., @if clike
   * isNumber()@else ASTNode::isNumber()@endif returns @c true), or
   * unknown.  This allows names to be set for @link libsbml#AST_FUNCTION AST_FUNCTION@endlink nodes and the like.
   *
   * @param name the string containing the name to which this node's value
   * should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setName(string name) {
    int ret = libsbmlPINVOKE.ASTNode_setName(swigCPtr, name);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given (@c long) integer
   *
   * As a side effect, this operation sets the node type to
   * @link libsbml#AST_INTEGER AST_INTEGER@endlink.
   *
   * @param value the integer to which this node's value should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setValue(int value) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_0(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given rational.
   *
   * As a side effect, this operation sets the node type to
   * @link libsbml#AST_RATIONAL AST_RATIONAL@endlink.
   *
   * @param numerator the numerator value of the rational.
   * @param denominator the denominator value of the rational.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setValue(int numerator, int denominator) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_1(swigCPtr, numerator, denominator);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given real (@c double).
   *
   * As a side effect, this operation sets the node type to
   * @link libsbml#AST_REAL AST_REAL@endlink.
   *
   * This is functionally equivalent to:
   * @verbatim
setValue(value, 0);
@endverbatim
   *
   * @param value the @c double format number to which this node's value
   * should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setValue(double value) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_2(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given real (@c double)
   *
   * As a side effet, this operation sets the node type to
   * @link libsbml#AST_REAL_E AST_REAL_E@endlink.
   *
   * @param mantissa the mantissa of this node's real-numbered value.
   * @param exponent the exponent of this node's real-numbered value.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setValue(double mantissa, int exponent) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_3(swigCPtr, mantissa, exponent);
    return ret;
  }

  
/**
   * Sets the type of this ASTNode.
   *
   * This uses integer type codes, which may come from @if clike the
   * enumeration #ASTNodeType_t@else the set
   * of static integer constants whose names begin with the prefix
   * <code>AST_</code> @endif @if java defined in the interface class
   * <code><a href='libsbml.libsbml.html'>libsbmlConstants</a></code>
   * @endif@if python defined in the interface class @link libsbml
   * libsbml@endlink@endif or an enumeration of AST types in an SBML
   * Level&nbsp;3 package.
   *
   * @param type the integer representing the type to which this node should
   * be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note A side-effect of doing this is that any numerical values
   * previously stored in this node are reset to zero.
   *
   * @see getType()
   * @see setType(@if java int@else ASTNodeType_t type@endif)
   */ public
 int setType(int type) {
    int ret = libsbmlPINVOKE.ASTNode_setType(swigCPtr, type);
    return ret;
  }

  
/**
   * Sets the units of this ASTNode to units.
   *
   * The units will be set @em only if this ASTNode object represents a
   * MathML <code>&lt;cn&gt;</code> element, i.e., represents a number.
   * Callers may use
   * @if clike isNumber()@else ASTNode::isNumber()@endif
   * to inquire whether the node is of that type.
   *
   * @htmlinclude about-sbml-units-attrib.html
   *
   * @param units @c string representing the unit identifier.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The <code>sbml:units</code> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   *
   * @see isSetUnits()
   * @see hasUnits()
   */ public
 int setUnits(string units) {
    int ret = libsbmlPINVOKE.ASTNode_setUnits(swigCPtr, units);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Swaps the children of this node with the children of another node.
   *
   * @param that the other node whose children should be used to replace
   * <em>this</em> node's children.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int swapChildren(ASTNode that) {
    int ret = libsbmlPINVOKE.ASTNode_swapChildren(swigCPtr, ASTNode.getCPtr(that));
    return ret;
  }

  
/**
   * Renames all the SIdRef attributes on this node and its child nodes.
   *
   * @param oldid the old identifier.
   * @param newid the new identifier.
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.ASTNode_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Renames all the UnitSIdRef attributes on this node and its child nodes.
   *
   * The only place UnitSIDRefs appear in MathML <code>&lt;cn&gt;</code>
   * elements, so the effects of this method are limited to that.
   *
   * @param oldid the old identifier.
   * @param newid the new identifier.
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.ASTNode_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void replaceIDWithFunction(string id, ASTNode function) {
    libsbmlPINVOKE.ASTNode_replaceIDWithFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void setIsChildFlag(bool flag) {
    libsbmlPINVOKE.ASTNode_setIsChildFlag(swigCPtr, flag);
  }

  
/**
   * Unsets the units of this ASTNode.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetUnits() {
    int ret = libsbmlPINVOKE.ASTNode_unsetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the MathML @c id attribute of this ASTNode.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetId() {
    int ret = libsbmlPINVOKE.ASTNode_unsetId(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the MathML @c class attribute of this ASTNode.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetClass() {
    int ret = libsbmlPINVOKE.ASTNode_unsetClass(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the MathML @c style attribute of this ASTNode.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetStyle() {
    int ret = libsbmlPINVOKE.ASTNode_unsetStyle(swigCPtr);
    return ret;
  }

  
/**
   * Sets the MathML attribute @c definitionURL.
   *
   * @param url the URL value for the @c definitionURL attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @see setDefinitionURL(string url)
   * @see getDefinitionURL()
   * @see getDefinitionURLString()
   */ public
 int setDefinitionURL(XMLAttributes url) {
    int ret = libsbmlPINVOKE.ASTNode_setDefinitionURL__SWIG_0(swigCPtr, XMLAttributes.getCPtr(url));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the MathML attribute @c definitionURL.
   *
   * @param url the URL value for the @c definitionURL attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   * @see setDefinitionURL(XMLAttributes url)
   * @see getDefinitionURL()
   * @see getDefinitionURLString()
   */ public
 int setDefinitionURL(string url) {
    int ret = libsbmlPINVOKE.ASTNode_setDefinitionURL__SWIG_1(swigCPtr, url);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the MathML @c definitionURL attribute value.
   *
   * @return the value of the @c definitionURL attribute, in the form of
   * a libSBML XMLAttributes object.
   *
   * @see setDefinitionURL(XMLAttributes url)
   * @see setDefinitionURL(string url)
   * @see getDefinitionURLString()
   */ public
 XMLAttributes getDefinitionURL() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getDefinitionURL(swigCPtr);
    XMLAttributes ret = (cPtr == IntPtr.Zero) ? null : new XMLAttributes(cPtr, false);
    return ret;
  }

  
/**
   * Replaces occurrences of a given name with a given ASTNode.
   *
   * For example, if the formula in this ASTNode is <code>x + y</code>,
   * then the <code>&lt;bvar&gt;</code> is @c x and @c arg is an ASTNode
   * representing the real value @c 3.  This method substitutes @c 3 for @c
   * x within this ASTNode object.
   *
   * @param bvar a string representing the variable name to be substituted.
   *
   * @param arg an ASTNode representing the name/value/formula to use as
   * a replacement.
   */ public
 void replaceArgument(string bvar, ASTNode arg) {
    libsbmlPINVOKE.ASTNode_replaceArgument(swigCPtr, bvar, ASTNode.getCPtr(arg));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Returns the parent SBML object.
   *
   * @return the parent SBML object of this ASTNode.
   *
   * @see isSetParentSBMLObject()
   * @if clike @see setParentSBMLObject()@endif
   */ public
 SBase getParentSBMLObject() {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ASTNode_getParentSBMLObject(swigCPtr), false);
	return ret;
}

  
/**
   * Unsets the parent SBML object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isSetParentSBMLObject()
   * @see getParentSBMLObject()
   */ public
 int unsetParentSBMLObject() {
    int ret = libsbmlPINVOKE.ASTNode_unsetParentSBMLObject(swigCPtr);
    return ret;
  }

  
/**
   * Returns @c true if this node has a value for the parent SBML
   * object.
   *
   * @return true if this ASTNode has an parent SBML object set, @c false otherwise.
   *
   * @see getParentSBMLObject()
   * @if clike @see setParentSBMLObject()@endif
   */ public
 bool isSetParentSBMLObject() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetParentSBMLObject(swigCPtr);
    return ret;
  }

  
/**
   * Reduces this ASTNode to a binary tree.
   *
   * Example: if this ASTNode is <code>and(x, y, z)</code>, then the
   * formula of the reduced node is <code>and(and(x, y), z)</code>.  The
   * operation replaces the formula stored in the current ASTNode object.
   */ public
 void reduceToBinary() {
    libsbmlPINVOKE.ASTNode_reduceToBinary(swigCPtr);
  }

  
/**
  * Unsets the user data of this node.
  *
  * The user data can be used by the application developer to attach custom
  * information to the node.  In case of a deep copy, this attribute will
  * passed as it is. The attribute will be never interpreted by this class.
  *
  *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
  * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
  *
  * @if clike
  * @see ASTNode::setUserData()
  * @see ASTNode::getUserData()
  * @see ASTNode::isSetUserData()
  * @endif
  */ public
 int unsetUserData() {
    int ret = libsbmlPINVOKE.ASTNode_unsetUserData(swigCPtr);
    return ret;
  }

  
/**
  * Returns @c true if this node has a user data object.
  *
  * @return true if this ASTNode has a user data object set, @c false
  * otherwise.
  *
  * @if clike
  * @see ASTNode::setUserData()
  * @see ASTNode::getUserData()
  * @see ASTNode::unsetUserData()
  * @endif
  */ public
 bool isSetUserData() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetUserData(swigCPtr);
    return ret;
  }

  
/**
  * Returns @c true or @c false depending on whether this
  * ASTNode is well-formed.
  *
  * @note An ASTNode may be well-formed, with each node and its children
  * having the appropriate number of children for the given type, but may
  * still be invalid in the context of its use within an SBML model.
  *
  * @return @c true if this ASTNode is well-formed, @c false otherwise.
  *
  * @see hasCorrectNumberArguments()
  */ public
 bool isWellFormedASTNode() {
    bool ret = libsbmlPINVOKE.ASTNode_isWellFormedASTNode(swigCPtr);
    return ret;
  }

  
/**
  * Returns @c true if this ASTNode has the correct number of children for
  * its type.
  *
  * For example, an ASTNode with type @link libsbml#AST_PLUS AST_PLUS@endlink
  * expects 2 child nodes.
  *
  * @return @c true if this ASTNode has the appropriate number of children
  * for its type, @c false otherwise.
  *
  * @note This function performs a check on the top-level node only.  Child
  * nodes are not checked.
  *
  * @see isWellFormedASTNode()
  */ public
 bool hasCorrectNumberArguments() {
    bool ret = libsbmlPINVOKE.ASTNode_hasCorrectNumberArguments(swigCPtr);
    return ret;
  }

  
/**
   * Returns the MathML @c definitionURL attribute value as a string.
   *
   * @return the value of the @c definitionURL attribute, as a string.
   *
   * @see getDefinitionURL()
   * @see setDefinitionURL(string url)
   * @see setDefinitionURL(XMLAttributes url)
   */ public
 string getDefinitionURLString() {
    string ret = libsbmlPINVOKE.ASTNode_getDefinitionURLString(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool representsBvar() {
    bool ret = libsbmlPINVOKE.ASTNode_representsBvar(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void write(XMLOutputStream stream) {
    libsbmlPINVOKE.ASTNode_write(swigCPtr, XMLOutputStream.getCPtr(stream));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 bool read(XMLInputStream stream, string reqd_prefix) {
    bool ret = libsbmlPINVOKE.ASTNode_read__SWIG_0(swigCPtr, XMLInputStream.getCPtr(stream), reqd_prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 bool read(XMLInputStream stream) {
    bool ret = libsbmlPINVOKE.ASTNode_read__SWIG_1(swigCPtr, XMLInputStream.getCPtr(stream));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void writeNodeOfType(XMLOutputStream stream, int type, bool inChildNode) {
    libsbmlPINVOKE.ASTNode_writeNodeOfType__SWIG_0(swigCPtr, XMLOutputStream.getCPtr(stream), type, inChildNode);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void writeNodeOfType(XMLOutputStream stream, int type) {
    libsbmlPINVOKE.ASTNode_writeNodeOfType__SWIG_1(swigCPtr, XMLOutputStream.getCPtr(stream), type);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 long getNumBvars() { return (long)libsbmlPINVOKE.ASTNode_getNumBvars(swigCPtr); }

  
/** */ /* libsbml-internal */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.ASTNode_getTypeCode(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 string getPackageName() {
    string ret = libsbmlPINVOKE.ASTNode_getPackageName(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 ASTBasePlugin getPlugin(string package) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getPlugin__SWIG_0(swigCPtr, package);
    ASTBasePlugin ret = (cPtr == IntPtr.Zero) ? null : new ASTBasePlugin(cPtr, false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 ASTBasePlugin getPlugin(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getPlugin__SWIG_2(swigCPtr, n);
    ASTBasePlugin ret = (cPtr == IntPtr.Zero) ? null : new ASTBasePlugin(cPtr, false);
    return ret;
  }

  public ASTNodeList getListOfNodes() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getListOfNodes(swigCPtr);
    ASTNodeList ret = (cPtr == IntPtr.Zero) ? null : new ASTNodeList(cPtr, true);
    return ret;
  }

}

}
