//------------------------------------------------------------------------------
//$Author: saulius $
//$Date: 2015-06-12 06:06:39 -0400 (Fri, 12 Jun 2015) $
//$Revision: 63 $
//$URL: svn://saulius-grazulis.lt/libraries/trunk/java/SOptions/SOptions.java $
//------------------------------------------------------------------------------

import java.io.*;

class SOptions {
    public static String[] get_options( String argv[], Option[] options )
        throws SOptionsException
    {
        String files[] = new String[argv.length];
        int f = 0;

        for( int i = 0; i < argv.length; i++ ) {
            if( argv[i].equals("-") ) {
                files[f++] = argv[i];
                continue;
            }
            if( argv[i].equals("--") ) {
                i++; 
                while( i < argv.length ) {
                    files[f++] = argv[i++];
                }
                break;
            }

            Option option = find_option( options, argv[i] );

            if( option != null ) {
                if( option.value == null ) {
                    option.value = new OptionValue();
                }
                option.value.present = true;
                option.value.count++;
                switch( option.option_type ) {
                case OT_BOOLEAN_FALSE:
                    option.value.bool = false;
                    break;
                case OT_BOOLEAN_TRUE:
                    option.value.bool = true;
                    break;
                case OT_STRING:
                    option.value.s = argv[++i];
                    break;
                case OT_INT:
                    option.value.i = Integer.parseInt( argv[++i] );
                    break;
                case OT_LONG:
                    option.value.i = Long.parseLong( argv[++i] );
                    break;
                case OT_FLOAT:
                    option.value.f = Float.parseFloat( argv[++i] );
                    break;
                case OT_DOUBLE:
                    option.value.f = Double.parseDouble( argv[++i] );
                    break;
                case OT_FUNCTION:
                    i = option.proc( argv, i );
                    break;
                default:
                    break;
                }
            } else {
                files[f++] = argv[i];
            }
        }

        if( f > 0 ) {
            String[] return_files = new String[f];
            for( int i = 0; i < f; i++ ) {
                return_files[i] = files[i];
            }
            return return_files;
        } else {
            return null;
        }
    }

    static Option find_option( Option[] options, String arg )
        throws SOptionsException
    {
        int hit_count = 0, found = -1;

        if( !arg.startsWith( "-" ) ) {
            return null;
        }

        for( int i = 0; i < options.length; i++ ) {
            // System.out.println( ">>> '" + options[i].long_name + "', '" + arg + "'" );
            if( options[i] != null &&
                ( arg.equals(options[i].short_name) ||
                  arg.equals(options[i].long_name) )) {
                return options[i];
            }
            if( options[i].long_name != null && 
                options[i].long_name.indexOf( arg ) == 0 ) {
	        hit_count++;
	        found = i;
            }
        }

        if( hit_count == 1 && found >= 0 )
            return options[found];

        throw new SOptionsException( "unknown option '" + arg + "'" );
    }
}
