
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsBufrAttributes.h
    \\brief Definition of EpsBufr Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "EpsBufrAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

EpsBufrAttributes::EpsBufrAttributes():
	path_(ParameterManager::getString("epsbufr_input_filename")),
	title_(ParameterManager::getString("epsbufr_title")),
	param_title_(ParameterManager::getString("epsbufr_parameter_title")),
	information_(ParameterManager::getBool("epsbufr_information")),
	short_title_(ParameterManager::getBool("epsbufr_short_title")),
	param_descriptor_(ParameterManager::getInt("epsbufr_parameter_descriptor")),
	param_descriptor_2_(ParameterManager::getInt("epsbufr_parameter_2_descriptor")),
	accumulated_(ParameterManager::getBool("epsbufr_accumulated_parameter")),
	station_name_(ParameterManager::getString("epsbufr_station_name")),
	latitude_(ParameterManager::getDouble("epsbufr_station_latitude")),
	longitude_(ParameterManager::getDouble("epsbufr_station_longitude")),
	param_scaling_factor_(ParameterManager::getDouble("epsbufr_parameter_scaling_factor")),
	param_offset_factor_(ParameterManager::getDouble("epsbufr_parameter_offset_factor")),
	percentile_(ParameterManager::getDouble("epsbufr_y_axis_percentile")),
	threshold_(ParameterManager::getDouble("epsbufr_y_axis_threshold"))
	
	
{
}


EpsBufrAttributes::~EpsBufrAttributes()
{

}


void EpsBufrAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "epsbufr";
	
	setAttribute(prefix, "epsbufr_input_filename", path_, params);
	setAttribute(prefix, "epsbufr_title", title_, params);
	setAttribute(prefix, "epsbufr_parameter_title", param_title_, params);
	setAttribute(prefix, "epsbufr_information", information_, params);
	setAttribute(prefix, "epsbufr_short_title", short_title_, params);
	setAttribute(prefix, "epsbufr_parameter_descriptor", param_descriptor_, params);
	setAttribute(prefix, "epsbufr_parameter_2_descriptor", param_descriptor_2_, params);
	setAttribute(prefix, "epsbufr_accumulated_parameter", accumulated_, params);
	setAttribute(prefix, "epsbufr_station_name", station_name_, params);
	setAttribute(prefix, "epsbufr_station_latitude", latitude_, params);
	setAttribute(prefix, "epsbufr_station_longitude", longitude_, params);
	setAttribute(prefix, "epsbufr_parameter_scaling_factor", param_scaling_factor_, params);
	setAttribute(prefix, "epsbufr_parameter_offset_factor", param_offset_factor_, params);
	setAttribute(prefix, "epsbufr_y_axis_percentile", percentile_, params);
	setAttribute(prefix, "epsbufr_y_axis_threshold", threshold_, params);
	
	
}

void EpsBufrAttributes::copy(const EpsBufrAttributes& other)
{
	path_ = other.path_;
	title_ = other.title_;
	param_title_ = other.param_title_;
	information_ = other.information_;
	short_title_ = other.short_title_;
	param_descriptor_ = other.param_descriptor_;
	param_descriptor_2_ = other.param_descriptor_2_;
	accumulated_ = other.accumulated_;
	station_name_ = other.station_name_;
	latitude_ = other.latitude_;
	longitude_ = other.longitude_;
	param_scaling_factor_ = other.param_scaling_factor_;
	param_offset_factor_ = other.param_offset_factor_;
	percentile_ = other.percentile_;
	threshold_ = other.threshold_;
	
}


bool EpsBufrAttributes::accept(const string& node)
{

	if ( magCompare(node, "epsbufr")  )
		return true;
	
	return false;
}

void EpsBufrAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "epsbufr")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void EpsBufrAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " path = " <<  path_;
	out << " title = " <<  title_;
	out << " param_title = " <<  param_title_;
	out << " information = " <<  information_;
	out << " short_title = " <<  short_title_;
	out << " param_descriptor = " <<  param_descriptor_;
	out << " param_descriptor_2 = " <<  param_descriptor_2_;
	out << " accumulated = " <<  accumulated_;
	out << " station_name = " <<  station_name_;
	out << " latitude = " <<  latitude_;
	out << " longitude = " <<  longitude_;
	out << " param_scaling_factor = " <<  param_scaling_factor_;
	out << " param_offset_factor = " <<  param_offset_factor_;
	out << " percentile = " <<  percentile_;
	out << " threshold = " <<  threshold_;
	
	out << "]" << "\n";
}

void EpsBufrAttributes::toxml(ostream& out)  const
{
	out <<  "\"epsbufr\"";
	out << ", \"epsbufr_input_filename\":";
	niceprint(out,path_);
	out << ", \"epsbufr_title\":";
	niceprint(out,title_);
	out << ", \"epsbufr_parameter_title\":";
	niceprint(out,param_title_);
	out << ", \"epsbufr_information\":";
	niceprint(out,information_);
	out << ", \"epsbufr_short_title\":";
	niceprint(out,short_title_);
	out << ", \"epsbufr_parameter_descriptor\":";
	niceprint(out,param_descriptor_);
	out << ", \"epsbufr_parameter_2_descriptor\":";
	niceprint(out,param_descriptor_2_);
	out << ", \"epsbufr_accumulated_parameter\":";
	niceprint(out,accumulated_);
	out << ", \"epsbufr_station_name\":";
	niceprint(out,station_name_);
	out << ", \"epsbufr_station_latitude\":";
	niceprint(out,latitude_);
	out << ", \"epsbufr_station_longitude\":";
	niceprint(out,longitude_);
	out << ", \"epsbufr_parameter_scaling_factor\":";
	niceprint(out,param_scaling_factor_);
	out << ", \"epsbufr_parameter_offset_factor\":";
	niceprint(out,param_offset_factor_);
	out << ", \"epsbufr_y_axis_percentile\":";
	niceprint(out,percentile_);
	out << ", \"epsbufr_y_axis_threshold\":";
	niceprint(out,threshold_);
	
}

static MagicsParameter<string> epsbufr_input_filename("epsbufr_input_filename", "");
static MagicsParameter<string> epsbufr_title("epsbufr_title", "");
static MagicsParameter<string> epsbufr_parameter_title("epsbufr_parameter_title", "");
static MagicsParameter<string> epsbufr_information("epsbufr_information", "on");
static MagicsParameter<string> epsbufr_short_title("epsbufr_short_title", "on");
static MagicsParameter<int> epsbufr_parameter_descriptor("epsbufr_parameter_descriptor", 0);
static MagicsParameter<int> epsbufr_parameter_2_descriptor("epsbufr_parameter_2_descriptor", 0);
static MagicsParameter<string> epsbufr_accumulated_parameter("epsbufr_accumulated_parameter", "off");
static MagicsParameter<string> epsbufr_station_name("epsbufr_station_name", "");
static MagicsParameter<double> epsbufr_station_latitude("epsbufr_station_latitude", 0);
static MagicsParameter<double> epsbufr_station_longitude("epsbufr_station_longitude", 0);
static MagicsParameter<double> epsbufr_parameter_scaling_factor("epsbufr_parameter_scaling_factor", 1);
static MagicsParameter<double> epsbufr_parameter_offset_factor("epsbufr_parameter_offset_factor", 0);
static MagicsParameter<double> epsbufr_y_axis_percentile("epsbufr_y_axis_percentile", 1);
static MagicsParameter<double> epsbufr_y_axis_threshold("epsbufr_y_axis_threshold", 50);
