# Copyright (C) 2010-2011 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Import pywo library and define additional extensions"""

from xlib import *
from time import sleep

def window_from_pid(pid, command = None):
    """ Return the first XID matching a PID

    :param pid: Process ID
    :param command: Command used to launch the application. Used as fallback 
                    to find the window using WM_COMMAND
    """
    WM.flush()

    # Lets try 5 secs before aborting
    for i in range(0,10):
        for w in WM.windows():
            try:
                wm_pid = w.get_property('_NET_WM_PID')
                if wm_pid and wm_pid.value[0] == pid:
                    return w
            # Workaround
            # BadWindow: <class 'Xlib.error.BadWindow'>: code = 3
            except xlib.error.BadWindow:
                pass

	# Failed with PID try with command
        if command:
            for w in WM.windows():
                try:
                    wm_cmd = w.get_property('WM_COMMAND')
                    if wm_cmd and command in wm_cmd.value:
                        return w
                # Workaround
                # BadWindow: <class 'Xlib.error.BadWindow'>: code = 3
                except xlib.error.BadWindow:
                    pass

        sleep(.5)
    return None
