# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class PixelBufferObject(Object):
    r"""
    PixelBufferObject - abstracts an open_gl pixel buffer object.
    
    Superclass: Object
    
    Provides low-level access to PBO mapped memory. Used to transfer raw
    data to/from PBO mapped memory and the application. Once data is
    transferred to the PBO it can then be transferred to the GPU (eg
    texture memory). Data may be uploaded from the application into a
    pixel buffer or downloaded from the pixel buffer to the application.
    The TextureObject is used to transfer data from/to the PBO to/from
    texture memory on the GPU.
    @sa
    open_gl Pixel Buffer Object Extension Spec (ARB_pixel_buffer_object):
    http://www.opengl.org/registry/specs/ARB/pixel_buffer_object.txt
    @warning
    Since most PBO mapped don't support double format all double data is
    converted to float and then uploaded.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPixelBufferObject, obj, update, **traits)
    
    components = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComponents,
                        self.components)

    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        r"""
        
        """
    )

    size = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    type = traits.Int(3, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetType,
                        self.type)

    usage = traits.Int(3, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _usage_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUsage,
                        self.usage)

    def _get_handle(self):
        return self._vtk_obj.GetHandle()
    handle = traits.Property(_get_handle, desc=\
        r"""
        Get the openGL buffer handle.
        """
    )

    def allocate(self, *args):
        """
        allocate(self, Type:int, numtuples:int, comps:int,
            mode:BufferType) -> None
        C++: void allocate(int Type, unsigned int numtuples, int comps,
             BufferType mode)
        allocate(self, nbytes:int, mode:BufferType) -> None
        C++: void allocate(unsigned int nbytes, BufferType mode)
        Allocate PACKED/UNPACKED memory to hold numTuples*numComponents
        of Type.
        """
        ret = self._wrap_call(self._vtk_obj.Allocate, *args)
        return ret

    def bind(self, *args):
        """
        bind(self, buffer:BufferType) -> None
        C++: void bind(BufferType buffer)
        Make the buffer active.
        """
        ret = self._wrap_call(self._vtk_obj.Bind, *args)
        return ret

    def bind_to_packed_buffer(self):
        """
        bind_to_packed_buffer(self) -> None
        C++: void bind_to_packed_buffer()
        Convenience methods for binding.
        """
        ret = self._vtk_obj.BindToPackedBuffer()
        return ret
        

    def bind_to_un_packed_buffer(self):
        """
        bind_to_un_packed_buffer(self) -> None
        C++: void bind_to_un_packed_buffer()"""
        ret = self._vtk_obj.BindToUnPackedBuffer()
        return ret
        

    def download1d(self, *args):
        """
        download1d(self, type:int, data:Pointer, dim:int, numcomps:int,
            increment:int) -> bool
        C++: bool download1d(int type, void *data, unsigned int dim,
            int numcomps, IdType increment)
        Download data from pixel buffer to the 1D array. The length of
        the array must be equal to the size of the data in the memory.
        """
        ret = self._wrap_call(self._vtk_obj.Download1D, *args)
        return ret

    def download2d(self, *args):
        """
        download2d(self, type:int, data:Pointer, dims:[int, int],
            numcomps:int, increments:[int, int]) -> bool
        C++: bool download2d(int type, void *data, unsigned int dims[2],
            int numcomps, IdType increments[2])
        Download data from pixel buffer to the 2D array. (lengthx *
        lengthy) must be equal to the size of the data in the memory.
        """
        ret = self._wrap_call(self._vtk_obj.Download2D, *args)
        return ret

    def download3d(self, *args):
        """
        download3d(self, type:int, data:Pointer, dims:[int, int, int],
            numcomps:int, increments:[int, int, int]) -> bool
        C++: bool download3d(int type, void *data, unsigned int dims[3],
            int numcomps, IdType increments[3])
        Download data from pixel buffer to the 3D array. (lengthx *
        lengthy * lengthz) must be equal to the size of the data in the
        memory.
        """
        ret = self._wrap_call(self._vtk_obj.Download3D, *args)
        return ret

    def is_supported(self, *args):
        """
        is_supported(renWin:RenderWindow) -> bool
        C++: static bool is_supported(RenderWindow *renWin)
        Returns if the context supports the required extensions.
        Extension will be loaded when the context is set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def map_buffer(self, *args):
        """
        map_buffer(self, type:int, numtuples:int, comps:int,
            mode:BufferType) -> Pointer
        C++: void *map_buffer(int type, unsigned int numtuples, int comps,
            BufferType mode)
        map_buffer(self, numbytes:int, mode:BufferType) -> Pointer
        C++: void *map_buffer(unsigned int numbytes, BufferType mode)
        map_buffer(self, mode:BufferType) -> Pointer
        C++: void *map_buffer(BufferType mode)
        Map the buffer to our addresspace. Returns a pointer to the
        mapped memory for read/write access. If type, tuples and
        components are specified new buffer data will be allocated, else
        the current allocation is mapped. When finished call unmap_buffer.
        """
        ret = self._wrap_call(self._vtk_obj.MapBuffer, *args)
        return ret

    def map_packed_buffer(self, *args):
        """
        map_packed_buffer(self) -> Pointer
        C++: void *map_packed_buffer()
        map_packed_buffer(self, type:int, numtuples:int, comps:int)
            -> Pointer
        C++: void *map_packed_buffer(int type, unsigned int numtuples,
            int comps)
        map_packed_buffer(self, numbytes:int) -> Pointer
        C++: void *map_packed_buffer(unsigned int numbytes)
        Convenience api for mapping buffers to app address space. See
        also map_buffer.
        """
        ret = self._wrap_call(self._vtk_obj.MapPackedBuffer, *args)
        return ret

    def map_unpacked_buffer(self, *args):
        """
        map_unpacked_buffer(self) -> Pointer
        C++: void *map_unpacked_buffer()
        map_unpacked_buffer(self, type:int, numtuples:int, comps:int)
            -> Pointer
        C++: void *map_unpacked_buffer(int type, unsigned int numtuples,
            int comps)
        map_unpacked_buffer(self, numbytes:int) -> Pointer
        C++: void *map_unpacked_buffer(unsigned int numbytes)"""
        ret = self._wrap_call(self._vtk_obj.MapUnpackedBuffer, *args)
        return ret

    def release_memory(self):
        """
        release_memory(self) -> None
        C++: void release_memory()
        Release the memory allocated without destroying the PBO handle.
        """
        ret = self._vtk_obj.ReleaseMemory()
        return ret
        

    def un_bind(self):
        """
        un_bind(self) -> None
        C++: void un_bind()
        Deactivate the buffer.
        """
        ret = self._vtk_obj.UnBind()
        return ret
        

    def unmap_buffer(self, *args):
        """
        unmap_buffer(self, mode:BufferType) -> None
        C++: void unmap_buffer(BufferType mode)
        Un-map the buffer from our address space, open_gl can then
        use/reclaim the buffer contents.
        """
        ret = self._wrap_call(self._vtk_obj.UnmapBuffer, *args)
        return ret

    def unmap_packed_buffer(self):
        """
        unmap_packed_buffer(self) -> None
        C++: void unmap_packed_buffer()"""
        ret = self._vtk_obj.UnmapPackedBuffer()
        return ret
        

    def unmap_unpacked_buffer(self):
        """
        unmap_unpacked_buffer(self) -> None
        C++: void unmap_unpacked_buffer()
        Convenience api for unmapping buffers from app address space. See
        also unmap_buffer.
        """
        ret = self._vtk_obj.UnmapUnpackedBuffer()
        return ret
        

    def upload1d(self, *args):
        """
        upload1d(self, type:int, data:Pointer, numtuples:int, comps:int,
            increment:int) -> bool
        C++: bool upload1d(int type, void *data, unsigned int numtuples,
            int comps, IdType increment)
        Upload data to PBO mapped. The input data can be freed after this
        call. The data ptr is treated as an 1D array with the given
        number of tuples and given number of components in each tuple to
        be copied to the PBO mapped. increment is the offset added after
        the last component in each tuple is transferred. Look at the
        documentation for continuous_increments in ImageData for
        details about how increments are specified.
        """
        ret = self._wrap_call(self._vtk_obj.Upload1D, *args)
        return ret

    def upload2d(self, *args):
        """
        upload2d(self, type:int, data:Pointer, dims:[int, int], comps:int,
             increments:[int, int]) -> bool
        C++: bool upload2d(int type, void *data, unsigned int dims[2],
            int comps, IdType increments[2])
        Update data to PBO mapped sourcing it from a 2D array. The input
        data can be freed after this call. The data ptr is treated as a
        2D array with increments indicating how to iterate over the data.
        Look at the documentation for continuous_increments in
        ImageData for details about how increments are specified.
        """
        ret = self._wrap_call(self._vtk_obj.Upload2D, *args)
        return ret

    def upload3d(self, *args):
        """
        upload3d(self, type:int, data:Pointer, dims:[int, int, int],
            comps:int, increments:[int, int, int], components:int,
            componentList:[int, ...]) -> bool
        C++: bool upload3d(int type, void *data, unsigned int dims[3],
            int comps, IdType increments[3], int components,
            int *componentList)
        Update data to PBO mapped sourcing it from a 3D array. The input
        data can be freed after this call. The data ptr is treated as a
        3D array with increments indicating how to iterate over the data.
        Look at the documentation for continuous_increments in
        ImageData for details about how increments are specified.
        """
        ret = self._wrap_call(self._vtk_obj.Upload3D, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('components', 'GetComponents'), ('size',
    'GetSize'), ('type', 'GetType'), ('usage', 'GetUsage'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'components', 'object_name',
    'size', 'type', 'usage'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PixelBufferObject, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PixelBufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['components', 'object_name', 'size', 'type', 'usage']),
            title='Edit PixelBufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PixelBufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

