*
* $Id: fxg260.F,v 1.1.1.3 1996/11/15 17:32:42 cernlib Exp $
*
* $Log: fxg260.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:42  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:07:02  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:18  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXG260(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.1154E-01,0.1220E-01,0.1290E-01,0.1363E-01,0.1441E-01,0.1523E-01,
     +0.1610E-01,0.1702E-01,0.1799E-01,0.1901E-01,0.2010E-01,0.2124E-01,
     +0.2245E-01,0.2373E-01,0.2509E-01,0.2652E-01,0.2803E-01,0.2962E-01,
     +0.3131E-01,0.3309E-01,0.3498E-01,0.3697E-01,0.3908E-01,0.4130E-01,
     +0.4365E-01,0.4613E-01,0.4876E-01,0.5153E-01,0.5445E-01,0.5755E-01,
     +0.6082E-01,0.6427E-01,0.6791E-01,0.7176E-01,0.7583E-01,0.8012E-01,
     +0.8465E-01,0.8943E-01,0.9448E-01,0.9981E-01,0.1054E+00,0.1114E+00,
     +0.1176E+00,0.1242E+00,0.1311E+00,0.1385E+00,0.1462E+00,0.1543E+00,
     +0.1628E+00,0.1718E+00,0.1812E+00,0.1912E+00,0.2016E+00,0.2125E+00,
     +0.2239E+00,0.2359E+00,0.2484E+00,0.2615E+00,0.2751E+00,0.2893E+00,
     +0.3040E+00,0.3193E+00,0.3350E+00,0.3513E+00,0.3679E+00,0.3850E+00,
     +0.4023E+00,0.4198E+00,0.4373E+00,0.4548E+00,0.4719E+00,0.4886E+00,
     +0.5045E+00,0.5193E+00,0.5326E+00,0.5440E+00,0.5530E+00,0.5591E+00,
     +0.5617E+00,0.5601E+00,0.5538E+00,0.5421E+00,0.5243E+00,0.5002E+00,
     +0.4693E+00,0.4318E+00,0.3881E+00,0.3390E+00,0.2860E+00,0.2312E+00,
     +0.1982E+00,0.1679E+00,0.1404E+00,0.1157E+00,0.9371E-01,0.7442E-01,
     +0.5769E-01,0.4337E-01,0.3133E-01,0.2144E-01,0.1357E-01,0.7621E-02,
     +0.3496E-02,0.1057E-02/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.6591E-02,0.6967E-02,0.7364E-02,0.7784E-02,0.8228E-02,0.8697E-02,
     +0.9193E-02,0.9717E-02,0.1027E-01,0.1086E-01,0.1147E-01,0.1213E-01,
     +0.1282E-01,0.1355E-01,0.1432E-01,0.1514E-01,0.1600E-01,0.1691E-01,
     +0.1787E-01,0.1889E-01,0.1997E-01,0.2110E-01,0.2230E-01,0.2357E-01,
     +0.2491E-01,0.2632E-01,0.2782E-01,0.2940E-01,0.3107E-01,0.3283E-01,
     +0.3469E-01,0.3665E-01,0.3872E-01,0.4091E-01,0.4322E-01,0.4566E-01,
     +0.4823E-01,0.5095E-01,0.5381E-01,0.5683E-01,0.6001E-01,0.6336E-01,
     +0.6689E-01,0.7061E-01,0.7453E-01,0.7864E-01,0.8297E-01,0.8752E-01,
     +0.9230E-01,0.9732E-01,0.1026E+00,0.1081E+00,0.1138E+00,0.1199E+00,
     +0.1262E+00,0.1327E+00,0.1395E+00,0.1466E+00,0.1539E+00,0.1615E+00,
     +0.1693E+00,0.1773E+00,0.1854E+00,0.1938E+00,0.2022E+00,0.2106E+00,
     +0.2191E+00,0.2274E+00,0.2355E+00,0.2433E+00,0.2506E+00,0.2573E+00,
     +0.2633E+00,0.2682E+00,0.2719E+00,0.2741E+00,0.2746E+00,0.2731E+00,
     +0.2694E+00,0.2630E+00,0.2539E+00,0.2419E+00,0.2269E+00,0.2088E+00,
     +0.1881E+00,0.1651E+00,0.1404E+00,0.1149E+00,0.8969E-01,0.6600E-01,
     +0.5296E-01,0.4178E-01,0.3235E-01,0.2453E-01,0.1816E-01,0.1305E-01,
     +0.9059E-02,0.6015E-02,0.3770E-02,0.2186E-02,0.1134E-02,0.4973E-03,
     +0.1640E-03,0.3020E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.1725E+02,0.1679E+02,0.1634E+02,0.1590E+02,0.1547E+02,0.1506E+02,
     +0.1466E+02,0.1427E+02,0.1389E+02,0.1352E+02,0.1316E+02,0.1281E+02,
     +0.1247E+02,0.1214E+02,0.1181E+02,0.1150E+02,0.1120E+02,0.1090E+02,
     +0.1061E+02,0.1034E+02,0.1006E+02,0.9801E+01,0.9545E+01,0.9296E+01,
     +0.9054E+01,0.8819E+01,0.8591E+01,0.8369E+01,0.8154E+01,0.7945E+01,
     +0.7743E+01,0.7546E+01,0.7355E+01,0.7169E+01,0.6989E+01,0.6814E+01,
     +0.6645E+01,0.6480E+01,0.6320E+01,0.6165E+01,0.6014E+01,0.5867E+01,
     +0.5725E+01,0.5586E+01,0.5451E+01,0.5320E+01,0.5192E+01,0.5066E+01,
     +0.4944E+01,0.4824E+01,0.4706E+01,0.4590E+01,0.4476E+01,0.4363E+01,
     +0.4251E+01,0.4139E+01,0.4028E+01,0.3917E+01,0.3805E+01,0.3693E+01,
     +0.3579E+01,0.3464E+01,0.3346E+01,0.3226E+01,0.3104E+01,0.2979E+01,
     +0.2850E+01,0.2718E+01,0.2583E+01,0.2444E+01,0.2302E+01,0.2157E+01,
     +0.2009E+01,0.1859E+01,0.1707E+01,0.1555E+01,0.1402E+01,0.1251E+01,
     +0.1103E+01,0.9586E+00,0.8199E+00,0.6883E+00,0.5656E+00,0.4533E+00,
     +0.3526E+00,0.2647E+00,0.1904E+00,0.1299E+00,0.8285E-01,0.4849E-01,
     +0.3294E-01,0.2209E-01,0.1440E-01,0.9088E-02,0.5512E-02,0.3188E-02,
     +0.1739E-02,0.8814E-03,0.4061E-03,0.1646E-03,0.5573E-04,0.1437E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6996E+00,0.6996E+00,0.6994E+00,0.6994E+00,0.6994E+00,0.6992E+00,
     +0.6993E+00,0.6992E+00,0.6990E+00,0.6989E+00,0.6988E+00,0.6987E+00,
     +0.6985E+00,0.6983E+00,0.6981E+00,0.6980E+00,0.6977E+00,0.6974E+00,
     +0.6972E+00,0.6968E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6911E+00,
     +0.6902E+00,0.6891E+00,0.6879E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6818E+00,0.6799E+00,0.6777E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5134E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3374E-04,0.1182E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2913E+00,
     +0.2914E+00,0.2913E+00,0.2913E+00,0.2912E+00,0.2912E+00,0.2911E+00,
     +0.2910E+00,0.2910E+00,0.2909E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2904E+00,0.2902E+00,0.2901E+00,0.2899E+00,0.2897E+00,
     +0.2895E+00,0.2892E+00,0.2890E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1669E-02,
     +0.1016E-02,0.5892E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1406E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1165E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1294E-03,0.6680E-04,0.3207E-04,0.1413E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.1265E-01,0.1337E-01,0.1413E-01,0.1493E-01,0.1578E-01,0.1668E-01,
     +0.1762E-01,0.1862E-01,0.1968E-01,0.2080E-01,0.2198E-01,0.2322E-01,
     +0.2454E-01,0.2593E-01,0.2740E-01,0.2895E-01,0.3059E-01,0.3232E-01,
     +0.3415E-01,0.3608E-01,0.3812E-01,0.4027E-01,0.4254E-01,0.4495E-01,
     +0.4748E-01,0.5016E-01,0.5299E-01,0.5597E-01,0.5912E-01,0.6245E-01,
     +0.6596E-01,0.6966E-01,0.7357E-01,0.7769E-01,0.8204E-01,0.8663E-01,
     +0.9146E-01,0.9656E-01,0.1019E+00,0.1076E+00,0.1136E+00,0.1198E+00,
     +0.1265E+00,0.1334E+00,0.1408E+00,0.1485E+00,0.1566E+00,0.1651E+00,
     +0.1740E+00,0.1834E+00,0.1932E+00,0.2035E+00,0.2142E+00,0.2255E+00,
     +0.2373E+00,0.2495E+00,0.2623E+00,0.2756E+00,0.2894E+00,0.3037E+00,
     +0.3184E+00,0.3336E+00,0.3492E+00,0.3651E+00,0.3814E+00,0.3978E+00,
     +0.4144E+00,0.4309E+00,0.4473E+00,0.4634E+00,0.4789E+00,0.4936E+00,
     +0.5072E+00,0.5194E+00,0.5298E+00,0.5379E+00,0.5434E+00,0.5457E+00,
     +0.5442E+00,0.5384E+00,0.5278E+00,0.5118E+00,0.4902E+00,0.4625E+00,
     +0.4289E+00,0.3896E+00,0.3452E+00,0.2969E+00,0.2462E+00,0.1951E+00,
     +0.1651E+00,0.1379E+00,0.1137E+00,0.9220E-01,0.7345E-01,0.5726E-01,
     +0.4348E-01,0.3193E-01,0.2245E-01,0.1487E-01,0.9045E-02,0.4830E-02,
     +0.2068E-02,0.5603E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.7221E-02,0.7630E-02,0.8063E-02,0.8521E-02,0.9004E-02,0.9515E-02,
     +0.1005E-01,0.1062E-01,0.1123E-01,0.1186E-01,0.1254E-01,0.1325E-01,
     +0.1400E-01,0.1479E-01,0.1562E-01,0.1651E-01,0.1744E-01,0.1843E-01,
     +0.1947E-01,0.2057E-01,0.2173E-01,0.2296E-01,0.2425E-01,0.2562E-01,
     +0.2706E-01,0.2858E-01,0.3019E-01,0.3189E-01,0.3368E-01,0.3556E-01,
     +0.3756E-01,0.3966E-01,0.4187E-01,0.4421E-01,0.4667E-01,0.4927E-01,
     +0.5201E-01,0.5489E-01,0.5792E-01,0.6112E-01,0.6448E-01,0.6801E-01,
     +0.7173E-01,0.7564E-01,0.7974E-01,0.8405E-01,0.8857E-01,0.9331E-01,
     +0.9827E-01,0.1035E+00,0.1089E+00,0.1146E+00,0.1205E+00,0.1266E+00,
     +0.1330E+00,0.1396E+00,0.1465E+00,0.1536E+00,0.1609E+00,0.1684E+00,
     +0.1761E+00,0.1839E+00,0.1918E+00,0.1998E+00,0.2078E+00,0.2158E+00,
     +0.2236E+00,0.2312E+00,0.2384E+00,0.2452E+00,0.2514E+00,0.2569E+00,
     +0.2614E+00,0.2647E+00,0.2667E+00,0.2672E+00,0.2658E+00,0.2623E+00,
     +0.2565E+00,0.2483E+00,0.2375E+00,0.2239E+00,0.2076E+00,0.1889E+00,
     +0.1679E+00,0.1452E+00,0.1216E+00,0.9779E-01,0.7489E-01,0.5391E-01,
     +0.4263E-01,0.3312E-01,0.2524E-01,0.1881E-01,0.1367E-01,0.9629E-02,
     +0.6535E-02,0.4231E-02,0.2576E-02,0.1443E-02,0.7184E-03,0.2987E-03,
     +0.9162E-04,0.1508E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.2805E+02,0.2725E+02,0.2647E+02,0.2571E+02,0.2497E+02,0.2425E+02,
     +0.2355E+02,0.2287E+02,0.2221E+02,0.2157E+02,0.2094E+02,0.2033E+02,
     +0.1974E+02,0.1917E+02,0.1861E+02,0.1806E+02,0.1753E+02,0.1702E+02,
     +0.1651E+02,0.1603E+02,0.1555E+02,0.1509E+02,0.1464E+02,0.1420E+02,
     +0.1378E+02,0.1337E+02,0.1296E+02,0.1257E+02,0.1219E+02,0.1182E+02,
     +0.1146E+02,0.1111E+02,0.1077E+02,0.1044E+02,0.1012E+02,0.9807E+01,
     +0.9502E+01,0.9206E+01,0.8917E+01,0.8636E+01,0.8363E+01,0.8096E+01,
     +0.7837E+01,0.7584E+01,0.7337E+01,0.7097E+01,0.6862E+01,0.6633E+01,
     +0.6409E+01,0.6190E+01,0.5976E+01,0.5766E+01,0.5560E+01,0.5358E+01,
     +0.5159E+01,0.4963E+01,0.4770E+01,0.4580E+01,0.4392E+01,0.4206E+01,
     +0.4021E+01,0.3838E+01,0.3656E+01,0.3476E+01,0.3296E+01,0.3117E+01,
     +0.2938E+01,0.2760E+01,0.2583E+01,0.2407E+01,0.2232E+01,0.2059E+01,
     +0.1888E+01,0.1719E+01,0.1554E+01,0.1393E+01,0.1236E+01,0.1085E+01,
     +0.9410E+00,0.8047E+00,0.6771E+00,0.5593E+00,0.4521E+00,0.3564E+00,
     +0.2727E+00,0.2013E+00,0.1422E+00,0.9519E-01,0.5944E-01,0.3381E-01,
     +0.2243E-01,0.1450E-01,0.8924E-02,0.5081E-02,0.2504E-02,0.8373E-03,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.2534E+01,0.2476E+01,0.2419E+01,0.2363E+01,0.2309E+01,0.2257E+01,
     +0.2206E+01,0.2156E+01,0.2108E+01,0.2061E+01,0.2015E+01,0.1971E+01,
     +0.1927E+01,0.1885E+01,0.1844E+01,0.1804E+01,0.1765E+01,0.1728E+01,
     +0.1691E+01,0.1655E+01,0.1620E+01,0.1586E+01,0.1553E+01,0.1521E+01,
     +0.1490E+01,0.1459E+01,0.1430E+01,0.1401E+01,0.1372E+01,0.1345E+01,
     +0.1318E+01,0.1292E+01,0.1266E+01,0.1241E+01,0.1216E+01,0.1192E+01,
     +0.1169E+01,0.1146E+01,0.1123E+01,0.1101E+01,0.1079E+01,0.1057E+01,
     +0.1035E+01,0.1014E+01,0.9930E+00,0.9720E+00,0.9511E+00,0.9302E+00,
     +0.9092E+00,0.8882E+00,0.8670E+00,0.8455E+00,0.8239E+00,0.8018E+00,
     +0.7794E+00,0.7565E+00,0.7332E+00,0.7092E+00,0.6847E+00,0.6595E+00,
     +0.6337E+00,0.6072E+00,0.5800E+00,0.5521E+00,0.5236E+00,0.4945E+00,
     +0.4649E+00,0.4350E+00,0.4049E+00,0.3747E+00,0.3446E+00,0.3149E+00,
     +0.2858E+00,0.2575E+00,0.2303E+00,0.2043E+00,0.1797E+00,0.1568E+00,
     +0.1354E+00,0.1157E+00,0.9755E-01,0.8100E-01,0.6593E-01,0.5231E-01,
     +0.4013E-01,0.2948E-01,0.2046E-01,0.1322E-01,0.7793E-02,0.4107E-02,
     +0.2622E-02,0.1646E-02,0.1022E-02,0.6339E-03,0.3968E-03,0.2526E-03,
     +0.1634E-03,0.1063E-03,0.6790E-04,0.4132E-04,0.2297E-04,0.1095E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.7109E+00,0.6976E+00,0.6845E+00,0.6719E+00,0.6596E+00,0.6475E+00,
     +0.6359E+00,0.6246E+00,0.6135E+00,0.6027E+00,0.5923E+00,0.5821E+00,
     +0.5722E+00,0.5625E+00,0.5531E+00,0.5439E+00,0.5350E+00,0.5263E+00,
     +0.5178E+00,0.5096E+00,0.5016E+00,0.4937E+00,0.4861E+00,0.4786E+00,
     +0.4713E+00,0.4642E+00,0.4573E+00,0.4505E+00,0.4438E+00,0.4373E+00,
     +0.4310E+00,0.4247E+00,0.4186E+00,0.4125E+00,0.4066E+00,0.4007E+00,
     +0.3950E+00,0.3892E+00,0.3836E+00,0.3779E+00,0.3723E+00,0.3667E+00,
     +0.3611E+00,0.3555E+00,0.3498E+00,0.3441E+00,0.3383E+00,0.3324E+00,
     +0.3264E+00,0.3203E+00,0.3140E+00,0.3075E+00,0.3008E+00,0.2940E+00,
     +0.2868E+00,0.2794E+00,0.2717E+00,0.2637E+00,0.2554E+00,0.2468E+00,
     +0.2378E+00,0.2284E+00,0.2187E+00,0.2087E+00,0.1983E+00,0.1877E+00,
     +0.1768E+00,0.1656E+00,0.1544E+00,0.1430E+00,0.1317E+00,0.1204E+00,
     +0.1094E+00,0.9863E-01,0.8825E-01,0.7834E-01,0.6897E-01,0.6019E-01,
     +0.5203E-01,0.4449E-01,0.3756E-01,0.3122E-01,0.2544E-01,0.2019E-01,
     +0.1549E-01,0.1136E-01,0.7854E-02,0.5034E-02,0.2927E-02,0.1504E-02,
     +0.9364E-03,0.5682E-03,0.3372E-03,0.1976E-03,0.1157E-03,0.6882E-04,
     +0.4192E-04,0.2606E-04,0.1620E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.5362E+00,0.5228E+00,0.5098E+00,0.4972E+00,0.4849E+00,0.4728E+00,
     +0.4612E+00,0.4499E+00,0.4389E+00,0.4282E+00,0.4177E+00,0.4076E+00,
     +0.3977E+00,0.3881E+00,0.3788E+00,0.3697E+00,0.3608E+00,0.3522E+00,
     +0.3439E+00,0.3357E+00,0.3278E+00,0.3201E+00,0.3126E+00,0.3052E+00,
     +0.2981E+00,0.2912E+00,0.2844E+00,0.2779E+00,0.2715E+00,0.2652E+00,
     +0.2591E+00,0.2532E+00,0.2474E+00,0.2418E+00,0.2363E+00,0.2309E+00,
     +0.2256E+00,0.2205E+00,0.2154E+00,0.2105E+00,0.2056E+00,0.2009E+00,
     +0.1962E+00,0.1916E+00,0.1870E+00,0.1825E+00,0.1781E+00,0.1736E+00,
     +0.1692E+00,0.1648E+00,0.1605E+00,0.1561E+00,0.1517E+00,0.1472E+00,
     +0.1428E+00,0.1382E+00,0.1336E+00,0.1290E+00,0.1243E+00,0.1195E+00,
     +0.1146E+00,0.1096E+00,0.1045E+00,0.9930E-01,0.9404E-01,0.8870E-01,
     +0.8330E-01,0.7786E-01,0.7240E-01,0.6695E-01,0.6154E-01,0.5620E-01,
     +0.5098E-01,0.4592E-01,0.4105E-01,0.3640E-01,0.3202E-01,0.2791E-01,
     +0.2409E-01,0.2057E-01,0.1734E-01,0.1438E-01,0.1170E-01,0.9281E-02,
     +0.7123E-02,0.5239E-02,0.3649E-02,0.2370E-02,0.1412E-02,0.7582E-03,
     +0.4923E-03,0.3161E-03,0.2019E-03,0.1294E-03,0.8383E-04,0.5512E-04,
     +0.3662E-04,0.2426E-04,0.1568E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.4197E+00,0.4063E+00,0.3933E+00,0.3807E+00,0.3684E+00,0.3564E+00,
     +0.3448E+00,0.3335E+00,0.3225E+00,0.3118E+00,0.3014E+00,0.2913E+00,
     +0.2814E+00,0.2719E+00,0.2626E+00,0.2535E+00,0.2447E+00,0.2362E+00,
     +0.2279E+00,0.2198E+00,0.2119E+00,0.2043E+00,0.1969E+00,0.1896E+00,
     +0.1826E+00,0.1758E+00,0.1692E+00,0.1628E+00,0.1565E+00,0.1505E+00,
     +0.1446E+00,0.1389E+00,0.1333E+00,0.1279E+00,0.1227E+00,0.1176E+00,
     +0.1127E+00,0.1079E+00,0.1033E+00,0.9884E-01,0.9451E-01,0.9030E-01,
     +0.8623E-01,0.8229E-01,0.7848E-01,0.7479E-01,0.7122E-01,0.6777E-01,
     +0.6444E-01,0.6122E-01,0.5810E-01,0.5510E-01,0.5220E-01,0.4940E-01,
     +0.4670E-01,0.4410E-01,0.4158E-01,0.3916E-01,0.3683E-01,0.3458E-01,
     +0.3241E-01,0.3033E-01,0.2832E-01,0.2639E-01,0.2452E-01,0.2273E-01,
     +0.2101E-01,0.1936E-01,0.1777E-01,0.1624E-01,0.1478E-01,0.1339E-01,
     +0.1205E-01,0.1079E-01,0.9583E-02,0.8449E-02,0.7384E-02,0.6390E-02,
     +0.5469E-02,0.4622E-02,0.3853E-02,0.3160E-02,0.2546E-02,0.2009E-02,
     +0.1548E-02,0.1162E-02,0.8453E-03,0.5944E-03,0.4024E-03,0.2613E-03,
     +0.1962E-03,0.1481E-03,0.1117E-03,0.8392E-04,0.6255E-04,0.4599E-04,
     +0.3309E-04,0.2306E-04,0.1533E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.1567E+00,0.1516E+00,0.1466E+00,0.1417E+00,0.1370E+00,0.1324E+00,
     +0.1279E+00,0.1236E+00,0.1194E+00,0.1153E+00,0.1114E+00,0.1075E+00,
     +0.1038E+00,0.1001E+00,0.9660E-01,0.9317E-01,0.8984E-01,0.8660E-01,
     +0.8346E-01,0.8041E-01,0.7745E-01,0.7458E-01,0.7179E-01,0.6908E-01,
     +0.6645E-01,0.6390E-01,0.6142E-01,0.5902E-01,0.5669E-01,0.5443E-01,
     +0.5224E-01,0.5012E-01,0.4806E-01,0.4606E-01,0.4413E-01,0.4226E-01,
     +0.4044E-01,0.3868E-01,0.3698E-01,0.3534E-01,0.3374E-01,0.3220E-01,
     +0.3071E-01,0.2926E-01,0.2787E-01,0.2652E-01,0.2522E-01,0.2396E-01,
     +0.2275E-01,0.2158E-01,0.2044E-01,0.1935E-01,0.1830E-01,0.1729E-01,
     +0.1631E-01,0.1537E-01,0.1446E-01,0.1359E-01,0.1275E-01,0.1194E-01,
     +0.1117E-01,0.1042E-01,0.9703E-02,0.9014E-02,0.8353E-02,0.7719E-02,
     +0.7111E-02,0.6528E-02,0.5971E-02,0.5439E-02,0.4932E-02,0.4449E-02,
     +0.3990E-02,0.3556E-02,0.3147E-02,0.2763E-02,0.2404E-02,0.2072E-02,
     +0.1765E-02,0.1486E-02,0.1233E-02,0.1007E-02,0.8073E-03,0.6342E-03,
     +0.4866E-03,0.3635E-03,0.2635E-03,0.1845E-03,0.1244E-03,0.8048E-04,
     +0.6027E-04,0.4538E-04,0.3411E-04,0.2551E-04,0.1893E-04,0.1384E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.1377E-01,0.1455E-01,0.1537E-01,0.1624E-01,0.1716E-01,0.1813E-01,
     +0.1915E-01,0.2024E-01,0.2138E-01,0.2258E-01,0.2386E-01,0.2520E-01,
     +0.2662E-01,0.2812E-01,0.2970E-01,0.3137E-01,0.3314E-01,0.3500E-01,
     +0.3696E-01,0.3904E-01,0.4123E-01,0.4354E-01,0.4598E-01,0.4855E-01,
     +0.5127E-01,0.5413E-01,0.5716E-01,0.6035E-01,0.6371E-01,0.6725E-01,
     +0.7099E-01,0.7493E-01,0.7909E-01,0.8347E-01,0.8808E-01,0.9294E-01,
     +0.9805E-01,0.1034E+00,0.1091E+00,0.1151E+00,0.1214E+00,0.1280E+00,
     +0.1349E+00,0.1422E+00,0.1498E+00,0.1579E+00,0.1663E+00,0.1751E+00,
     +0.1844E+00,0.1941E+00,0.2042E+00,0.2148E+00,0.2258E+00,0.2373E+00,
     +0.2493E+00,0.2617E+00,0.2746E+00,0.2880E+00,0.3018E+00,0.3160E+00,
     +0.3307E+00,0.3456E+00,0.3609E+00,0.3764E+00,0.3921E+00,0.4078E+00,
     +0.4235E+00,0.4390E+00,0.4541E+00,0.4687E+00,0.4824E+00,0.4952E+00,
     +0.5066E+00,0.5163E+00,0.5240E+00,0.5293E+00,0.5316E+00,0.5305E+00,
     +0.5256E+00,0.5163E+00,0.5023E+00,0.4831E+00,0.4585E+00,0.4285E+00,
     +0.3933E+00,0.3532E+00,0.3091E+00,0.2622E+00,0.2142E+00,0.1668E+00,
     +0.1395E+00,0.1152E+00,0.9368E-01,0.7495E-01,0.5883E-01,0.4512E-01,
     +0.3364E-01,0.2419E-01,0.1660E-01,0.1068E-01,0.6269E-02,0.3196E-02,
     +0.1283E-02,0.3127E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.7854E-02,0.8298E-02,0.8766E-02,0.9261E-02,0.9784E-02,0.1034E-01,
     +0.1092E-01,0.1153E-01,0.1218E-01,0.1287E-01,0.1360E-01,0.1436E-01,
     +0.1517E-01,0.1602E-01,0.1692E-01,0.1787E-01,0.1888E-01,0.1993E-01,
     +0.2105E-01,0.2223E-01,0.2348E-01,0.2479E-01,0.2617E-01,0.2764E-01,
     +0.2918E-01,0.3080E-01,0.3252E-01,0.3432E-01,0.3623E-01,0.3824E-01,
     +0.4035E-01,0.4258E-01,0.4493E-01,0.4740E-01,0.5001E-01,0.5275E-01,
     +0.5563E-01,0.5866E-01,0.6185E-01,0.6520E-01,0.6872E-01,0.7242E-01,
     +0.7629E-01,0.8036E-01,0.8463E-01,0.8909E-01,0.9376E-01,0.9865E-01,
     +0.1038E+00,0.1091E+00,0.1146E+00,0.1204E+00,0.1264E+00,0.1326E+00,
     +0.1391E+00,0.1457E+00,0.1526E+00,0.1596E+00,0.1669E+00,0.1742E+00,
     +0.1817E+00,0.1893E+00,0.1969E+00,0.2045E+00,0.2120E+00,0.2194E+00,
     +0.2266E+00,0.2334E+00,0.2398E+00,0.2456E+00,0.2507E+00,0.2550E+00,
     +0.2582E+00,0.2601E+00,0.2606E+00,0.2595E+00,0.2565E+00,0.2514E+00,
     +0.2441E+00,0.2344E+00,0.2223E+00,0.2077E+00,0.1907E+00,0.1717E+00,
     +0.1509E+00,0.1289E+00,0.1064E+00,0.8431E-01,0.6348E-01,0.4484E-01,
     +0.3499E-01,0.2682E-01,0.2015E-01,0.1480E-01,0.1058E-01,0.7320E-02,
     +0.4870E-02,0.3083E-02,0.1829E-02,0.9933E-03,0.4760E-03,0.1884E-03,
     +0.5394E-04,0.0000E+00/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.4122E+02,0.3994E+02,0.3869E+02,0.3748E+02,0.3631E+02,0.3517E+02,
     +0.3406E+02,0.3298E+02,0.3193E+02,0.3091E+02,0.2992E+02,0.2896E+02,
     +0.2803E+02,0.2712E+02,0.2624E+02,0.2539E+02,0.2456E+02,0.2375E+02,
     +0.2297E+02,0.2221E+02,0.2147E+02,0.2075E+02,0.2005E+02,0.1938E+02,
     +0.1872E+02,0.1808E+02,0.1746E+02,0.1686E+02,0.1627E+02,0.1571E+02,
     +0.1516E+02,0.1462E+02,0.1410E+02,0.1360E+02,0.1311E+02,0.1263E+02,
     +0.1217E+02,0.1173E+02,0.1129E+02,0.1087E+02,0.1046E+02,0.1006E+02,
     +0.9676E+01,0.9301E+01,0.8936E+01,0.8582E+01,0.8238E+01,0.7903E+01,
     +0.7577E+01,0.7260E+01,0.6952E+01,0.6652E+01,0.6359E+01,0.6074E+01,
     +0.5796E+01,0.5525E+01,0.5260E+01,0.5002E+01,0.4749E+01,0.4502E+01,
     +0.4260E+01,0.4024E+01,0.3792E+01,0.3565E+01,0.3343E+01,0.3126E+01,
     +0.2913E+01,0.2705E+01,0.2501E+01,0.2303E+01,0.2110E+01,0.1922E+01,
     +0.1740E+01,0.1565E+01,0.1396E+01,0.1235E+01,0.1082E+01,0.9373E+00,
     +0.8021E+00,0.6768E+00,0.5619E+00,0.4578E+00,0.3650E+00,0.2837E+00,
     +0.2139E+00,0.1554E+00,0.1080E+00,0.7088E-01,0.4317E-01,0.2364E-01,
     +0.1513E-01,0.9236E-02,0.5133E-02,0.2348E-02,0.5209E-03,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.5016E+01,0.4871E+01,0.4729E+01,0.4592E+01,0.4459E+01,0.4329E+01,
     +0.4204E+01,0.4082E+01,0.3963E+01,0.3848E+01,0.3736E+01,0.3628E+01,
     +0.3523E+01,0.3421E+01,0.3322E+01,0.3225E+01,0.3132E+01,0.3041E+01,
     +0.2953E+01,0.2868E+01,0.2785E+01,0.2705E+01,0.2627E+01,0.2551E+01,
     +0.2477E+01,0.2406E+01,0.2337E+01,0.2269E+01,0.2204E+01,0.2141E+01,
     +0.2079E+01,0.2019E+01,0.1961E+01,0.1905E+01,0.1850E+01,0.1797E+01,
     +0.1745E+01,0.1694E+01,0.1645E+01,0.1597E+01,0.1550E+01,0.1505E+01,
     +0.1460E+01,0.1416E+01,0.1374E+01,0.1332E+01,0.1291E+01,0.1251E+01,
     +0.1211E+01,0.1172E+01,0.1133E+01,0.1095E+01,0.1057E+01,0.1020E+01,
     +0.9821E+00,0.9448E+00,0.9076E+00,0.8703E+00,0.8330E+00,0.7956E+00,
     +0.7581E+00,0.7204E+00,0.6827E+00,0.6447E+00,0.6068E+00,0.5688E+00,
     +0.5309E+00,0.4931E+00,0.4558E+00,0.4189E+00,0.3827E+00,0.3475E+00,
     +0.3133E+00,0.2805E+00,0.2492E+00,0.2196E+00,0.1919E+00,0.1661E+00,
     +0.1423E+00,0.1205E+00,0.1006E+00,0.8266E-01,0.6650E-01,0.5210E-01,
     +0.3948E-01,0.2865E-01,0.1970E-01,0.1265E-01,0.7486E-02,0.4025E-02,
     +0.2633E-02,0.1714E-02,0.1116E-02,0.7309E-03,0.4836E-03,0.3228E-03,
     +0.2156E-03,0.1420E-03,0.9019E-04,0.5378E-04,0.2896E-04,0.1323E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.1206E+01,0.1175E+01,0.1145E+01,0.1116E+01,0.1088E+01,0.1061E+01,
     +0.1034E+01,0.1008E+01,0.9832E+00,0.9589E+00,0.9353E+00,0.9123E+00,
     +0.8900E+00,0.8684E+00,0.8474E+00,0.8270E+00,0.8071E+00,0.7879E+00,
     +0.7692E+00,0.7510E+00,0.7334E+00,0.7162E+00,0.6996E+00,0.6834E+00,
     +0.6677E+00,0.6524E+00,0.6375E+00,0.6230E+00,0.6090E+00,0.5953E+00,
     +0.5820E+00,0.5690E+00,0.5563E+00,0.5440E+00,0.5319E+00,0.5201E+00,
     +0.5086E+00,0.4974E+00,0.4863E+00,0.4755E+00,0.4649E+00,0.4544E+00,
     +0.4441E+00,0.4339E+00,0.4238E+00,0.4138E+00,0.4039E+00,0.3940E+00,
     +0.3841E+00,0.3743E+00,0.3643E+00,0.3544E+00,0.3443E+00,0.3342E+00,
     +0.3239E+00,0.3134E+00,0.3028E+00,0.2920E+00,0.2810E+00,0.2698E+00,
     +0.2583E+00,0.2466E+00,0.2347E+00,0.2226E+00,0.2103E+00,0.1979E+00,
     +0.1853E+00,0.1726E+00,0.1600E+00,0.1474E+00,0.1350E+00,0.1228E+00,
     +0.1109E+00,0.9949E-01,0.8854E-01,0.7816E-01,0.6841E-01,0.5933E-01,
     +0.5094E-01,0.4323E-01,0.3619E-01,0.2979E-01,0.2401E-01,0.1883E-01,
     +0.1426E-01,0.1032E-01,0.7042E-02,0.4464E-02,0.2579E-02,0.1331E-02,
     +0.8392E-03,0.5213E-03,0.3209E-03,0.1977E-03,0.1230E-03,0.7779E-04,
     +0.4985E-04,0.3194E-04,0.2000E-04,0.1185E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.1031E+01,0.1000E+01,0.9706E+00,0.9416E+00,0.9134E+00,0.8861E+00,
     +0.8596E+00,0.8338E+00,0.8088E+00,0.7845E+00,0.7609E+00,0.7381E+00,
     +0.7158E+00,0.6943E+00,0.6733E+00,0.6530E+00,0.6333E+00,0.6141E+00,
     +0.5955E+00,0.5775E+00,0.5600E+00,0.5430E+00,0.5265E+00,0.5105E+00,
     +0.4950E+00,0.4799E+00,0.4653E+00,0.4511E+00,0.4373E+00,0.4239E+00,
     +0.4109E+00,0.3983E+00,0.3860E+00,0.3742E+00,0.3626E+00,0.3514E+00,
     +0.3405E+00,0.3299E+00,0.3195E+00,0.3095E+00,0.2997E+00,0.2902E+00,
     +0.2810E+00,0.2719E+00,0.2631E+00,0.2544E+00,0.2460E+00,0.2377E+00,
     +0.2296E+00,0.2216E+00,0.2138E+00,0.2061E+00,0.1985E+00,0.1910E+00,
     +0.1835E+00,0.1761E+00,0.1688E+00,0.1615E+00,0.1543E+00,0.1471E+00,
     +0.1398E+00,0.1327E+00,0.1255E+00,0.1183E+00,0.1112E+00,0.1041E+00,
     +0.9700E-01,0.9000E-01,0.8309E-01,0.7630E-01,0.6966E-01,0.6319E-01,
     +0.5694E-01,0.5095E-01,0.4524E-01,0.3985E-01,0.3479E-01,0.3010E-01,
     +0.2577E-01,0.2180E-01,0.1819E-01,0.1493E-01,0.1200E-01,0.9403E-02,
     +0.7128E-02,0.5183E-02,0.3576E-02,0.2313E-02,0.1385E-02,0.7591E-03,
     +0.5046E-03,0.3351E-03,0.2229E-03,0.1493E-03,0.1009E-03,0.6852E-04,
     +0.4636E-04,0.3079E-04,0.1967E-04,0.1177E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.9147E+00,0.8840E+00,0.8541E+00,0.8252E+00,0.7971E+00,0.7697E+00,
     +0.7432E+00,0.7175E+00,0.6925E+00,0.6683E+00,0.6447E+00,0.6219E+00,
     +0.5997E+00,0.5782E+00,0.5573E+00,0.5370E+00,0.5173E+00,0.4982E+00,
     +0.4797E+00,0.4618E+00,0.4443E+00,0.4275E+00,0.4111E+00,0.3952E+00,
     +0.3798E+00,0.3648E+00,0.3504E+00,0.3363E+00,0.3227E+00,0.3096E+00,
     +0.2968E+00,0.2845E+00,0.2725E+00,0.2609E+00,0.2497E+00,0.2388E+00,
     +0.2283E+00,0.2181E+00,0.2083E+00,0.1988E+00,0.1896E+00,0.1807E+00,
     +0.1722E+00,0.1639E+00,0.1559E+00,0.1481E+00,0.1407E+00,0.1335E+00,
     +0.1266E+00,0.1199E+00,0.1134E+00,0.1072E+00,0.1012E+00,0.9547E-01,
     +0.8992E-01,0.8459E-01,0.7946E-01,0.7453E-01,0.6979E-01,0.6524E-01,
     +0.6087E-01,0.5667E-01,0.5265E-01,0.4879E-01,0.4509E-01,0.4155E-01,
     +0.3817E-01,0.3493E-01,0.3185E-01,0.2891E-01,0.2611E-01,0.2346E-01,
     +0.2096E-01,0.1859E-01,0.1638E-01,0.1431E-01,0.1239E-01,0.1061E-01,
     +0.8990E-02,0.7519E-02,0.6198E-02,0.5027E-02,0.4002E-02,0.3121E-02,
     +0.2376E-02,0.1761E-02,0.1266E-02,0.8798E-03,0.5887E-03,0.3779E-03,
     +0.2816E-03,0.2109E-03,0.1576E-03,0.1171E-03,0.8612E-04,0.6233E-04,
     +0.4403E-04,0.3003E-04,0.1946E-04,0.1172E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.6590E+00,0.6363E+00,0.6142E+00,0.5929E+00,0.5721E+00,0.5520E+00,
     +0.5325E+00,0.5136E+00,0.4952E+00,0.4774E+00,0.4602E+00,0.4434E+00,
     +0.4272E+00,0.4115E+00,0.3962E+00,0.3814E+00,0.3671E+00,0.3532E+00,
     +0.3397E+00,0.3267E+00,0.3140E+00,0.3018E+00,0.2899E+00,0.2784E+00,
     +0.2673E+00,0.2565E+00,0.2461E+00,0.2360E+00,0.2262E+00,0.2167E+00,
     +0.2076E+00,0.1987E+00,0.1902E+00,0.1819E+00,0.1739E+00,0.1661E+00,
     +0.1586E+00,0.1514E+00,0.1444E+00,0.1376E+00,0.1311E+00,0.1248E+00,
     +0.1188E+00,0.1129E+00,0.1072E+00,0.1018E+00,0.9653E-01,0.9147E-01,
     +0.8659E-01,0.8189E-01,0.7737E-01,0.7301E-01,0.6883E-01,0.6480E-01,
     +0.6093E-01,0.5721E-01,0.5364E-01,0.5021E-01,0.4691E-01,0.4376E-01,
     +0.4073E-01,0.3783E-01,0.3506E-01,0.3241E-01,0.2987E-01,0.2745E-01,
     +0.2514E-01,0.2294E-01,0.2085E-01,0.1886E-01,0.1698E-01,0.1520E-01,
     +0.1353E-01,0.1196E-01,0.1050E-01,0.9133E-02,0.7874E-02,0.6719E-02,
     +0.5668E-02,0.4720E-02,0.3873E-02,0.3127E-02,0.2479E-02,0.1924E-02,
     +0.1458E-02,0.1076E-02,0.7701E-03,0.5328E-03,0.3549E-03,0.2267E-03,
     +0.1685E-03,0.1257E-03,0.9355E-04,0.6917E-04,0.5060E-04,0.3639E-04,
     +0.2551E-04,0.1725E-04,0.1107E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1568E-01,0.1656E-01,0.1749E-01,0.1848E-01,0.1951E-01,0.2060E-01,
     +0.2176E-01,0.2297E-01,0.2426E-01,0.2561E-01,0.2704E-01,0.2855E-01,
     +0.3015E-01,0.3183E-01,0.3360E-01,0.3547E-01,0.3744E-01,0.3952E-01,
     +0.4171E-01,0.4402E-01,0.4646E-01,0.4903E-01,0.5173E-01,0.5459E-01,
     +0.5759E-01,0.6076E-01,0.6410E-01,0.6761E-01,0.7132E-01,0.7521E-01,
     +0.7932E-01,0.8363E-01,0.8817E-01,0.9295E-01,0.9798E-01,0.1033E+00,
     +0.1088E+00,0.1146E+00,0.1208E+00,0.1272E+00,0.1339E+00,0.1410E+00,
     +0.1484E+00,0.1562E+00,0.1643E+00,0.1728E+00,0.1817E+00,0.1909E+00,
     +0.2006E+00,0.2107E+00,0.2212E+00,0.2321E+00,0.2435E+00,0.2552E+00,
     +0.2674E+00,0.2799E+00,0.2929E+00,0.3062E+00,0.3198E+00,0.3338E+00,
     +0.3480E+00,0.3623E+00,0.3769E+00,0.3914E+00,0.4059E+00,0.4202E+00,
     +0.4342E+00,0.4478E+00,0.4607E+00,0.4727E+00,0.4836E+00,0.4932E+00,
     +0.5010E+00,0.5069E+00,0.5104E+00,0.5112E+00,0.5089E+00,0.5030E+00,
     +0.4933E+00,0.4793E+00,0.4609E+00,0.4378E+00,0.4099E+00,0.3776E+00,
     +0.3411E+00,0.3011E+00,0.2586E+00,0.2149E+00,0.1715E+00,0.1301E+00,
     +0.1069E+00,0.8662E-01,0.6909E-01,0.5413E-01,0.4152E-01,0.3105E-01,
     +0.2250E-01,0.1567E-01,0.1035E-01,0.6364E-02,0.3530E-02,0.1670E-02,
     +0.6020E-03,0.1216E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.8934E-02,0.9435E-02,0.9963E-02,0.1052E-01,0.1111E-01,0.1173E-01,
     +0.1239E-01,0.1308E-01,0.1381E-01,0.1458E-01,0.1539E-01,0.1625E-01,
     +0.1715E-01,0.1810E-01,0.1911E-01,0.2017E-01,0.2129E-01,0.2247E-01,
     +0.2371E-01,0.2502E-01,0.2640E-01,0.2785E-01,0.2938E-01,0.3100E-01,
     +0.3270E-01,0.3449E-01,0.3637E-01,0.3835E-01,0.4044E-01,0.4264E-01,
     +0.4495E-01,0.4738E-01,0.4993E-01,0.5261E-01,0.5543E-01,0.5839E-01,
     +0.6150E-01,0.6476E-01,0.6817E-01,0.7175E-01,0.7550E-01,0.7943E-01,
     +0.8354E-01,0.8783E-01,0.9231E-01,0.9698E-01,0.1019E+00,0.1069E+00,
     +0.1122E+00,0.1177E+00,0.1234E+00,0.1292E+00,0.1353E+00,0.1416E+00,
     +0.1480E+00,0.1546E+00,0.1613E+00,0.1682E+00,0.1752E+00,0.1822E+00,
     +0.1893E+00,0.1963E+00,0.2033E+00,0.2102E+00,0.2169E+00,0.2233E+00,
     +0.2293E+00,0.2348E+00,0.2398E+00,0.2440E+00,0.2474E+00,0.2498E+00,
     +0.2510E+00,0.2508E+00,0.2491E+00,0.2457E+00,0.2405E+00,0.2333E+00,
     +0.2240E+00,0.2125E+00,0.1990E+00,0.1834E+00,0.1659E+00,0.1470E+00,
     +0.1269E+00,0.1064E+00,0.8608E-01,0.6666E-01,0.4894E-01,0.3358E-01,
     +0.2569E-01,0.1930E-01,0.1419E-01,0.1018E-01,0.7096E-02,0.4778E-02,
     +0.3083E-02,0.1884E-02,0.1073E-02,0.5550E-03,0.2502E-03,0.9134E-04,
     +0.2322E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.6954E+02,0.6706E+02,0.6467E+02,0.6234E+02,0.6010E+02,0.5792E+02,
     +0.5581E+02,0.5377E+02,0.5180E+02,0.4989E+02,0.4803E+02,0.4624E+02,
     +0.4451E+02,0.4283E+02,0.4121E+02,0.3964E+02,0.3812E+02,0.3665E+02,
     +0.3523E+02,0.3386E+02,0.3253E+02,0.3124E+02,0.3000E+02,0.2880E+02,
     +0.2764E+02,0.2652E+02,0.2543E+02,0.2439E+02,0.2338E+02,0.2240E+02,
     +0.2146E+02,0.2054E+02,0.1966E+02,0.1882E+02,0.1800E+02,0.1720E+02,
     +0.1644E+02,0.1570E+02,0.1499E+02,0.1431E+02,0.1365E+02,0.1301E+02,
     +0.1239E+02,0.1180E+02,0.1123E+02,0.1067E+02,0.1014E+02,0.9629E+01,
     +0.9134E+01,0.8658E+01,0.8198E+01,0.7755E+01,0.7329E+01,0.6918E+01,
     +0.6521E+01,0.6140E+01,0.5772E+01,0.5417E+01,0.5076E+01,0.4747E+01,
     +0.4430E+01,0.4126E+01,0.3833E+01,0.3551E+01,0.3280E+01,0.3020E+01,
     +0.2771E+01,0.2533E+01,0.2305E+01,0.2088E+01,0.1881E+01,0.1685E+01,
     +0.1499E+01,0.1325E+01,0.1162E+01,0.1009E+01,0.8685E+00,0.7389E+00,
     +0.6207E+00,0.5140E+00,0.4187E+00,0.3346E+00,0.2615E+00,0.1991E+00,
     +0.1468E+00,0.1042E+00,0.7048E-01,0.4477E-01,0.2607E-01,0.1325E-01,
     +0.7832E-02,0.4139E-02,0.1642E-02,0.1420E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.1013E+02,0.9787E+01,0.9453E+01,0.9130E+01,0.8817E+01,0.8514E+01,
     +0.8221E+01,0.7937E+01,0.7662E+01,0.7397E+01,0.7139E+01,0.6890E+01,
     +0.6649E+01,0.6416E+01,0.6191E+01,0.5973E+01,0.5762E+01,0.5558E+01,
     +0.5360E+01,0.5169E+01,0.4985E+01,0.4806E+01,0.4634E+01,0.4467E+01,
     +0.4306E+01,0.4150E+01,0.3999E+01,0.3854E+01,0.3713E+01,0.3577E+01,
     +0.3445E+01,0.3318E+01,0.3195E+01,0.3077E+01,0.2962E+01,0.2851E+01,
     +0.2743E+01,0.2640E+01,0.2539E+01,0.2442E+01,0.2348E+01,0.2257E+01,
     +0.2169E+01,0.2083E+01,0.2000E+01,0.1920E+01,0.1842E+01,0.1766E+01,
     +0.1693E+01,0.1621E+01,0.1551E+01,0.1483E+01,0.1417E+01,0.1352E+01,
     +0.1288E+01,0.1226E+01,0.1165E+01,0.1105E+01,0.1047E+01,0.9888E+00,
     +0.9321E+00,0.8764E+00,0.8216E+00,0.7678E+00,0.7150E+00,0.6632E+00,
     +0.6126E+00,0.5632E+00,0.5152E+00,0.4687E+00,0.4239E+00,0.3809E+00,
     +0.3400E+00,0.3013E+00,0.2649E+00,0.2309E+00,0.1995E+00,0.1706E+00,
     +0.1443E+00,0.1205E+00,0.9916E-01,0.8014E-01,0.6336E-01,0.4874E-01,
     +0.3624E-01,0.2583E-01,0.1747E-01,0.1109E-01,0.6539E-02,0.3554E-02,
     +0.2361E-02,0.1572E-02,0.1050E-02,0.7057E-03,0.4762E-03,0.3207E-03,
     +0.2134E-03,0.1381E-03,0.8522E-04,0.4885E-04,0.2502E-04,0.1075E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.2227E+01,0.2156E+01,0.2088E+01,0.2022E+01,0.1958E+01,0.1896E+01,
     +0.1836E+01,0.1777E+01,0.1721E+01,0.1667E+01,0.1614E+01,0.1563E+01,
     +0.1513E+01,0.1466E+01,0.1419E+01,0.1375E+01,0.1331E+01,0.1289E+01,
     +0.1249E+01,0.1209E+01,0.1171E+01,0.1135E+01,0.1099E+01,0.1065E+01,
     +0.1031E+01,0.9993E+00,0.9681E+00,0.9379E+00,0.9087E+00,0.8805E+00,
     +0.8531E+00,0.8266E+00,0.8009E+00,0.7760E+00,0.7519E+00,0.7285E+00,
     +0.7059E+00,0.6838E+00,0.6625E+00,0.6417E+00,0.6214E+00,0.6018E+00,
     +0.5826E+00,0.5639E+00,0.5456E+00,0.5277E+00,0.5102E+00,0.4930E+00,
     +0.4761E+00,0.4595E+00,0.4432E+00,0.4270E+00,0.4110E+00,0.3952E+00,
     +0.3795E+00,0.3639E+00,0.3483E+00,0.3328E+00,0.3173E+00,0.3019E+00,
     +0.2864E+00,0.2710E+00,0.2556E+00,0.2402E+00,0.2249E+00,0.2097E+00,
     +0.1947E+00,0.1798E+00,0.1652E+00,0.1509E+00,0.1370E+00,0.1235E+00,
     +0.1106E+00,0.9834E-01,0.8674E-01,0.7587E-01,0.6576E-01,0.5645E-01,
     +0.4792E-01,0.4018E-01,0.3318E-01,0.2691E-01,0.2133E-01,0.1643E-01,
     +0.1220E-01,0.8654E-02,0.5792E-02,0.3608E-02,0.2059E-02,0.1063E-02,
     +0.6765E-03,0.4283E-03,0.2712E-03,0.1728E-03,0.1113E-03,0.7225E-04,
     +0.4686E-04,0.2987E-04,0.1830E-04,0.1047E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.2052E+01,0.1982E+01,0.1913E+01,0.1847E+01,0.1783E+01,0.1721E+01,
     +0.1661E+01,0.1603E+01,0.1547E+01,0.1493E+01,0.1440E+01,0.1389E+01,
     +0.1340E+01,0.1292E+01,0.1246E+01,0.1201E+01,0.1158E+01,0.1116E+01,
     +0.1076E+01,0.1037E+01,0.9988E+00,0.9622E+00,0.9269E+00,0.8927E+00,
     +0.8597E+00,0.8277E+00,0.7968E+00,0.7670E+00,0.7382E+00,0.7103E+00,
     +0.6834E+00,0.6573E+00,0.6322E+00,0.6079E+00,0.5844E+00,0.5617E+00,
     +0.5397E+00,0.5185E+00,0.4980E+00,0.4782E+00,0.4590E+00,0.4404E+00,
     +0.4225E+00,0.4051E+00,0.3883E+00,0.3720E+00,0.3562E+00,0.3409E+00,
     +0.3260E+00,0.3116E+00,0.2975E+00,0.2839E+00,0.2706E+00,0.2577E+00,
     +0.2451E+00,0.2328E+00,0.2208E+00,0.2090E+00,0.1976E+00,0.1863E+00,
     +0.1753E+00,0.1645E+00,0.1540E+00,0.1437E+00,0.1336E+00,0.1237E+00,
     +0.1141E+00,0.1048E+00,0.9574E-01,0.8701E-01,0.7861E-01,0.7058E-01,
     +0.6294E-01,0.5572E-01,0.4895E-01,0.4264E-01,0.3680E-01,0.3145E-01,
     +0.2657E-01,0.2217E-01,0.1822E-01,0.1471E-01,0.1163E-01,0.8943E-02,
     +0.6655E-02,0.4754E-02,0.3230E-02,0.2066E-02,0.1233E-02,0.6830E-03,
     +0.4605E-03,0.3116E-03,0.2116E-03,0.1444E-03,0.9870E-04,0.6717E-04,
     +0.4503E-04,0.2929E-04,0.1815E-04,0.1043E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1936E+01,0.1865E+01,0.1797E+01,0.1731E+01,0.1667E+01,0.1605E+01,
     +0.1545E+01,0.1487E+01,0.1431E+01,0.1377E+01,0.1324E+01,0.1273E+01,
     +0.1224E+01,0.1176E+01,0.1130E+01,0.1085E+01,0.1042E+01,0.1001E+01,
     +0.9602E+00,0.9212E+00,0.8835E+00,0.8471E+00,0.8119E+00,0.7779E+00,
     +0.7450E+00,0.7133E+00,0.6826E+00,0.6530E+00,0.6244E+00,0.5968E+00,
     +0.5701E+00,0.5444E+00,0.5196E+00,0.4957E+00,0.4726E+00,0.4503E+00,
     +0.4289E+00,0.4082E+00,0.3883E+00,0.3691E+00,0.3506E+00,0.3328E+00,
     +0.3157E+00,0.2992E+00,0.2834E+00,0.2681E+00,0.2535E+00,0.2394E+00,
     +0.2259E+00,0.2129E+00,0.2004E+00,0.1885E+00,0.1770E+00,0.1660E+00,
     +0.1555E+00,0.1454E+00,0.1358E+00,0.1265E+00,0.1177E+00,0.1093E+00,
     +0.1012E+00,0.9358E-01,0.8627E-01,0.7931E-01,0.7269E-01,0.6641E-01,
     +0.6045E-01,0.5480E-01,0.4947E-01,0.4445E-01,0.3973E-01,0.3530E-01,
     +0.3117E-01,0.2732E-01,0.2377E-01,0.2049E-01,0.1750E-01,0.1479E-01,
     +0.1235E-01,0.1017E-01,0.8253E-02,0.6586E-02,0.5157E-02,0.3953E-02,
     +0.2958E-02,0.2154E-02,0.1522E-02,0.1039E-02,0.6828E-03,0.4300E-03,
     +0.3166E-03,0.2338E-03,0.1719E-03,0.1254E-03,0.9032E-04,0.6379E-04,
     +0.4381E-04,0.2891E-04,0.1805E-04,0.1041E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1691E+01,0.1628E+01,0.1567E+01,0.1509E+01,0.1452E+01,0.1397E+01,
     +0.1344E+01,0.1292E+01,0.1242E+01,0.1194E+01,0.1148E+01,0.1103E+01,
     +0.1059E+01,0.1017E+01,0.9763E+00,0.9370E+00,0.8990E+00,0.8623E+00,
     +0.8268E+00,0.7925E+00,0.7595E+00,0.7275E+00,0.6966E+00,0.6669E+00,
     +0.6381E+00,0.6103E+00,0.5836E+00,0.5577E+00,0.5328E+00,0.5087E+00,
     +0.4856E+00,0.4632E+00,0.4417E+00,0.4209E+00,0.4009E+00,0.3816E+00,
     +0.3630E+00,0.3452E+00,0.3280E+00,0.3114E+00,0.2955E+00,0.2802E+00,
     +0.2654E+00,0.2513E+00,0.2377E+00,0.2246E+00,0.2121E+00,0.2000E+00,
     +0.1885E+00,0.1774E+00,0.1668E+00,0.1566E+00,0.1468E+00,0.1375E+00,
     +0.1286E+00,0.1200E+00,0.1119E+00,0.1041E+00,0.9662E-01,0.8952E-01,
     +0.8276E-01,0.7632E-01,0.7020E-01,0.6438E-01,0.5886E-01,0.5364E-01,
     +0.4869E-01,0.4402E-01,0.3963E-01,0.3550E-01,0.3162E-01,0.2801E-01,
     +0.2465E-01,0.2153E-01,0.1866E-01,0.1603E-01,0.1364E-01,0.1148E-01,
     +0.9542E-02,0.7827E-02,0.6324E-02,0.5025E-02,0.3917E-02,0.2988E-02,
     +0.2226E-02,0.1613E-02,0.1134E-02,0.7704E-03,0.5038E-03,0.3155E-03,
     +0.2314E-03,0.1701E-03,0.1245E-03,0.9027E-04,0.6458E-04,0.4527E-04,
     +0.3081E-04,0.2013E-04,0.1242E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1739E-01,0.1836E-01,0.1939E-01,0.2046E-01,0.2160E-01,0.2280E-01,
     +0.2407E-01,0.2541E-01,0.2682E-01,0.2830E-01,0.2987E-01,0.3152E-01,
     +0.3326E-01,0.3510E-01,0.3703E-01,0.3907E-01,0.4122E-01,0.4348E-01,
     +0.4587E-01,0.4838E-01,0.5103E-01,0.5381E-01,0.5675E-01,0.5983E-01,
     +0.6308E-01,0.6650E-01,0.7010E-01,0.7389E-01,0.7787E-01,0.8205E-01,
     +0.8645E-01,0.9107E-01,0.9592E-01,0.1010E+00,0.1064E+00,0.1120E+00,
     +0.1179E+00,0.1240E+00,0.1305E+00,0.1373E+00,0.1444E+00,0.1518E+00,
     +0.1595E+00,0.1676E+00,0.1761E+00,0.1849E+00,0.1941E+00,0.2037E+00,
     +0.2136E+00,0.2239E+00,0.2346E+00,0.2457E+00,0.2572E+00,0.2690E+00,
     +0.2812E+00,0.2937E+00,0.3065E+00,0.3196E+00,0.3329E+00,0.3464E+00,
     +0.3601E+00,0.3738E+00,0.3875E+00,0.4010E+00,0.4144E+00,0.4274E+00,
     +0.4398E+00,0.4516E+00,0.4625E+00,0.4723E+00,0.4808E+00,0.4877E+00,
     +0.4927E+00,0.4956E+00,0.4959E+00,0.4933E+00,0.4876E+00,0.4783E+00,
     +0.4653E+00,0.4483E+00,0.4271E+00,0.4017E+00,0.3722E+00,0.3389E+00,
     +0.3024E+00,0.2634E+00,0.2230E+00,0.1823E+00,0.1429E+00,0.1062E+00,
     +0.8606E-01,0.6871E-01,0.5397E-01,0.4158E-01,0.3133E-01,0.2296E-01,
     +0.1627E-01,0.1104E-01,0.7079E-02,0.4197E-02,0.2224E-02,0.9895E-03,
     +0.3251E-03,0.5480E-04/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.9897E-02,0.1045E-01,0.1103E-01,0.1164E-01,0.1229E-01,0.1297E-01,
     +0.1369E-01,0.1444E-01,0.1524E-01,0.1609E-01,0.1697E-01,0.1791E-01,
     +0.1890E-01,0.1993E-01,0.2103E-01,0.2218E-01,0.2340E-01,0.2468E-01,
     +0.2603E-01,0.2744E-01,0.2894E-01,0.3051E-01,0.3216E-01,0.3391E-01,
     +0.3574E-01,0.3766E-01,0.3968E-01,0.4181E-01,0.4405E-01,0.4639E-01,
     +0.4886E-01,0.5145E-01,0.5416E-01,0.5701E-01,0.6000E-01,0.6312E-01,
     +0.6640E-01,0.6983E-01,0.7342E-01,0.7717E-01,0.8108E-01,0.8517E-01,
     +0.8944E-01,0.9388E-01,0.9851E-01,0.1033E+00,0.1083E+00,0.1135E+00,
     +0.1189E+00,0.1244E+00,0.1301E+00,0.1360E+00,0.1421E+00,0.1483E+00,
     +0.1546E+00,0.1611E+00,0.1676E+00,0.1743E+00,0.1810E+00,0.1876E+00,
     +0.1943E+00,0.2008E+00,0.2072E+00,0.2134E+00,0.2193E+00,0.2248E+00,
     +0.2298E+00,0.2343E+00,0.2380E+00,0.2410E+00,0.2430E+00,0.2439E+00,
     +0.2435E+00,0.2418E+00,0.2385E+00,0.2335E+00,0.2268E+00,0.2182E+00,
     +0.2076E+00,0.1952E+00,0.1809E+00,0.1649E+00,0.1475E+00,0.1290E+00,
     +0.1100E+00,0.9086E-01,0.7233E-01,0.5504E-01,0.3961E-01,0.2657E-01,
     +0.2003E-01,0.1480E-01,0.1070E-01,0.7540E-02,0.5154E-02,0.3397E-02,
     +0.2139E-02,0.1272E-02,0.7009E-03,0.3485E-03,0.1494E-03,0.5092E-04,
     +0.1164E-04,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.9877E+02,0.9489E+02,0.9114E+02,0.8753E+02,0.8404E+02,0.8067E+02,
     +0.7742E+02,0.7428E+02,0.7125E+02,0.6833E+02,0.6552E+02,0.6280E+02,
     +0.6018E+02,0.5766E+02,0.5523E+02,0.5288E+02,0.5062E+02,0.4845E+02,
     +0.4635E+02,0.4433E+02,0.4238E+02,0.4051E+02,0.3871E+02,0.3697E+02,
     +0.3530E+02,0.3370E+02,0.3215E+02,0.3066E+02,0.2923E+02,0.2786E+02,
     +0.2654E+02,0.2527E+02,0.2405E+02,0.2288E+02,0.2175E+02,0.2067E+02,
     +0.1963E+02,0.1864E+02,0.1768E+02,0.1676E+02,0.1588E+02,0.1504E+02,
     +0.1423E+02,0.1346E+02,0.1271E+02,0.1200E+02,0.1132E+02,0.1067E+02,
     +0.1005E+02,0.9448E+01,0.8876E+01,0.8329E+01,0.7807E+01,0.7307E+01,
     +0.6830E+01,0.6374E+01,0.5939E+01,0.5524E+01,0.5128E+01,0.4751E+01,
     +0.4391E+01,0.4049E+01,0.3724E+01,0.3415E+01,0.3122E+01,0.2844E+01,
     +0.2581E+01,0.2333E+01,0.2099E+01,0.1880E+01,0.1674E+01,0.1482E+01,
     +0.1303E+01,0.1137E+01,0.9848E+00,0.8450E+00,0.7177E+00,0.6027E+00,
     +0.4997E+00,0.4082E+00,0.3279E+00,0.2583E+00,0.1988E+00,0.1490E+00,
     +0.1080E+00,0.7517E-01,0.4968E-01,0.3062E-01,0.1704E-01,0.7971E-02,
     +0.4243E-02,0.1759E-02,0.1388E-03,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1609E+02,0.1549E+02,0.1491E+02,0.1435E+02,0.1381E+02,0.1329E+02,
     +0.1278E+02,0.1230E+02,0.1183E+02,0.1137E+02,0.1093E+02,0.1051E+02,
     +0.1010E+02,0.9710E+01,0.9330E+01,0.8964E+01,0.8611E+01,0.8270E+01,
     +0.7942E+01,0.7625E+01,0.7320E+01,0.7026E+01,0.6742E+01,0.6469E+01,
     +0.6206E+01,0.5952E+01,0.5707E+01,0.5472E+01,0.5245E+01,0.5027E+01,
     +0.4816E+01,0.4614E+01,0.4419E+01,0.4231E+01,0.4050E+01,0.3876E+01,
     +0.3708E+01,0.3547E+01,0.3391E+01,0.3241E+01,0.3097E+01,0.2958E+01,
     +0.2825E+01,0.2696E+01,0.2571E+01,0.2451E+01,0.2336E+01,0.2224E+01,
     +0.2116E+01,0.2012E+01,0.1912E+01,0.1815E+01,0.1721E+01,0.1630E+01,
     +0.1541E+01,0.1456E+01,0.1373E+01,0.1292E+01,0.1214E+01,0.1138E+01,
     +0.1065E+01,0.9932E+00,0.9237E+00,0.8564E+00,0.7911E+00,0.7280E+00,
     +0.6670E+00,0.6084E+00,0.5520E+00,0.4982E+00,0.4469E+00,0.3983E+00,
     +0.3526E+00,0.3098E+00,0.2700E+00,0.2333E+00,0.1997E+00,0.1692E+00,
     +0.1416E+00,0.1170E+00,0.9514E-01,0.7593E-01,0.5924E-01,0.4494E-01,
     +0.3295E-01,0.2315E-01,0.1546E-01,0.9711E-02,0.5690E-02,0.3094E-02,
     +0.2064E-02,0.1382E-02,0.9284E-03,0.6257E-03,0.4215E-03,0.2818E-03,
     +0.1848E-03,0.1172E-03,0.7048E-04,0.3913E-04,0.1929E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.3311E+01,0.3194E+01,0.3081E+01,0.2972E+01,0.2866E+01,0.2764E+01,
     +0.2665E+01,0.2570E+01,0.2478E+01,0.2390E+01,0.2304E+01,0.2221E+01,
     +0.2141E+01,0.2064E+01,0.1990E+01,0.1918E+01,0.1849E+01,0.1782E+01,
     +0.1718E+01,0.1656E+01,0.1596E+01,0.1538E+01,0.1482E+01,0.1428E+01,
     +0.1376E+01,0.1326E+01,0.1278E+01,0.1231E+01,0.1186E+01,0.1143E+01,
     +0.1101E+01,0.1061E+01,0.1022E+01,0.9842E+00,0.9480E+00,0.9130E+00,
     +0.8792E+00,0.8466E+00,0.8151E+00,0.7846E+00,0.7551E+00,0.7265E+00,
     +0.6989E+00,0.6721E+00,0.6461E+00,0.6209E+00,0.5964E+00,0.5725E+00,
     +0.5492E+00,0.5266E+00,0.5044E+00,0.4828E+00,0.4616E+00,0.4408E+00,
     +0.4204E+00,0.4004E+00,0.3807E+00,0.3612E+00,0.3421E+00,0.3232E+00,
     +0.3046E+00,0.2862E+00,0.2681E+00,0.2502E+00,0.2327E+00,0.2155E+00,
     +0.1986E+00,0.1822E+00,0.1663E+00,0.1508E+00,0.1360E+00,0.1218E+00,
     +0.1083E+00,0.9559E-01,0.8370E-01,0.7265E-01,0.6248E-01,0.5318E-01,
     +0.4475E-01,0.3715E-01,0.3036E-01,0.2433E-01,0.1904E-01,0.1447E-01,
     +0.1059E-01,0.7396E-02,0.4875E-02,0.2994E-02,0.1691E-02,0.8691E-03,
     +0.5548E-03,0.3536E-03,0.2261E-03,0.1455E-03,0.9435E-04,0.6131E-04,
     +0.3949E-04,0.2480E-04,0.1485E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.3137E+01,0.3020E+01,0.2907E+01,0.2797E+01,0.2692E+01,0.2590E+01,
     +0.2491E+01,0.2396E+01,0.2304E+01,0.2216E+01,0.2130E+01,0.2048E+01,
     +0.1968E+01,0.1891E+01,0.1817E+01,0.1745E+01,0.1676E+01,0.1609E+01,
     +0.1545E+01,0.1483E+01,0.1423E+01,0.1366E+01,0.1310E+01,0.1257E+01,
     +0.1205E+01,0.1155E+01,0.1107E+01,0.1061E+01,0.1017E+01,0.9738E+00,
     +0.9325E+00,0.8927E+00,0.8544E+00,0.8176E+00,0.7820E+00,0.7478E+00,
     +0.7149E+00,0.6832E+00,0.6527E+00,0.6233E+00,0.5950E+00,0.5677E+00,
     +0.5415E+00,0.5162E+00,0.4918E+00,0.4684E+00,0.4457E+00,0.4239E+00,
     +0.4029E+00,0.3826E+00,0.3630E+00,0.3440E+00,0.3258E+00,0.3081E+00,
     +0.2910E+00,0.2745E+00,0.2585E+00,0.2430E+00,0.2280E+00,0.2134E+00,
     +0.1994E+00,0.1857E+00,0.1725E+00,0.1597E+00,0.1474E+00,0.1355E+00,
     +0.1240E+00,0.1130E+00,0.1024E+00,0.9237E-01,0.8280E-01,0.7374E-01,
     +0.6523E-01,0.5727E-01,0.4989E-01,0.4308E-01,0.3684E-01,0.3118E-01,
     +0.2608E-01,0.2153E-01,0.1749E-01,0.1395E-01,0.1088E-01,0.8258E-02,
     +0.6061E-02,0.4271E-02,0.2865E-02,0.1814E-02,0.1076E-02,0.5952E-03,
     +0.4022E-03,0.2730E-03,0.1859E-03,0.1268E-03,0.8630E-04,0.5817E-04,
     +0.3840E-04,0.2447E-04,0.1477E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.3021E+01,0.2904E+01,0.2790E+01,0.2681E+01,0.2576E+01,0.2474E+01,
     +0.2375E+01,0.2280E+01,0.2189E+01,0.2100E+01,0.2014E+01,0.1932E+01,
     +0.1852E+01,0.1775E+01,0.1701E+01,0.1630E+01,0.1561E+01,0.1494E+01,
     +0.1430E+01,0.1368E+01,0.1309E+01,0.1251E+01,0.1196E+01,0.1142E+01,
     +0.1091E+01,0.1041E+01,0.9937E+00,0.9478E+00,0.9036E+00,0.8610E+00,
     +0.8201E+00,0.7807E+00,0.7428E+00,0.7064E+00,0.6713E+00,0.6377E+00,
     +0.6053E+00,0.5742E+00,0.5444E+00,0.5157E+00,0.4882E+00,0.4618E+00,
     +0.4365E+00,0.4122E+00,0.3889E+00,0.3666E+00,0.3453E+00,0.3248E+00,
     +0.3053E+00,0.2865E+00,0.2686E+00,0.2515E+00,0.2352E+00,0.2196E+00,
     +0.2047E+00,0.1905E+00,0.1770E+00,0.1642E+00,0.1519E+00,0.1403E+00,
     +0.1292E+00,0.1188E+00,0.1088E+00,0.9943E-01,0.9055E-01,0.8217E-01,
     +0.7428E-01,0.6687E-01,0.5992E-01,0.5342E-01,0.4737E-01,0.4174E-01,
     +0.3654E-01,0.3175E-01,0.2736E-01,0.2337E-01,0.1976E-01,0.1652E-01,
     +0.1365E-01,0.1112E-01,0.8921E-02,0.7036E-02,0.5443E-02,0.4120E-02,
     +0.3044E-02,0.2188E-02,0.1525E-02,0.1027E-02,0.6655E-03,0.4125E-03,
     +0.3005E-03,0.2193E-03,0.1591E-03,0.1143E-03,0.8094E-04,0.5607E-04,
     +0.3766E-04,0.2424E-04,0.1471E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.2784E+01,0.2675E+01,0.2569E+01,0.2467E+01,0.2368E+01,0.2273E+01,
     +0.2181E+01,0.2092E+01,0.2007E+01,0.1924E+01,0.1845E+01,0.1768E+01,
     +0.1694E+01,0.1622E+01,0.1553E+01,0.1487E+01,0.1423E+01,0.1361E+01,
     +0.1302E+01,0.1244E+01,0.1189E+01,0.1136E+01,0.1085E+01,0.1036E+01,
     +0.9883E+00,0.9426E+00,0.8987E+00,0.8564E+00,0.8158E+00,0.7767E+00,
     +0.7391E+00,0.7029E+00,0.6682E+00,0.6348E+00,0.6028E+00,0.5720E+00,
     +0.5424E+00,0.5141E+00,0.4868E+00,0.4607E+00,0.4357E+00,0.4117E+00,
     +0.3887E+00,0.3666E+00,0.3455E+00,0.3253E+00,0.3060E+00,0.2875E+00,
     +0.2698E+00,0.2529E+00,0.2368E+00,0.2214E+00,0.2067E+00,0.1927E+00,
     +0.1794E+00,0.1667E+00,0.1546E+00,0.1431E+00,0.1322E+00,0.1218E+00,
     +0.1120E+00,0.1027E+00,0.9390E-01,0.8560E-01,0.7777E-01,0.7040E-01,
     +0.6348E-01,0.5699E-01,0.5092E-01,0.4527E-01,0.4002E-01,0.3515E-01,
     +0.3067E-01,0.2656E-01,0.2281E-01,0.1941E-01,0.1635E-01,0.1362E-01,
     +0.1120E-01,0.9090E-02,0.7262E-02,0.5701E-02,0.4390E-02,0.3308E-02,
     +0.2432E-02,0.1740E-02,0.1207E-02,0.8084E-03,0.5209E-03,0.3208E-03,
     +0.2327E-03,0.1689E-03,0.1218E-03,0.8698E-04,0.6112E-04,0.4198E-04,
     +0.2792E-04,0.1778E-04,0.1065E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.5303E+00,0.5075E+00,0.4855E+00,0.4643E+00,0.4440E+00,0.4244E+00,
     +0.4056E+00,0.3875E+00,0.3701E+00,0.3533E+00,0.3373E+00,0.3218E+00,
     +0.3070E+00,0.2927E+00,0.2791E+00,0.2659E+00,0.2533E+00,0.2412E+00,
     +0.2296E+00,0.2185E+00,0.2078E+00,0.1975E+00,0.1877E+00,0.1783E+00,
     +0.1693E+00,0.1607E+00,0.1524E+00,0.1445E+00,0.1369E+00,0.1296E+00,
     +0.1227E+00,0.1161E+00,0.1097E+00,0.1036E+00,0.9785E-01,0.9232E-01,
     +0.8704E-01,0.8200E-01,0.7719E-01,0.7260E-01,0.6822E-01,0.6406E-01,
     +0.6009E-01,0.5631E-01,0.5271E-01,0.4929E-01,0.4604E-01,0.4296E-01,
     +0.4002E-01,0.3724E-01,0.3461E-01,0.3211E-01,0.2974E-01,0.2750E-01,
     +0.2539E-01,0.2339E-01,0.2150E-01,0.1973E-01,0.1806E-01,0.1649E-01,
     +0.1501E-01,0.1363E-01,0.1233E-01,0.1113E-01,0.1000E-01,0.8952E-02,
     +0.7980E-02,0.7081E-02,0.6251E-02,0.5488E-02,0.4790E-02,0.4153E-02,
     +0.3575E-02,0.3053E-02,0.2585E-02,0.2167E-02,0.1798E-02,0.1475E-02,
     +0.1194E-02,0.9530E-03,0.7484E-03,0.5774E-03,0.4366E-03,0.3229E-03,
     +0.2328E-03,0.1631E-03,0.1107E-03,0.7243E-04,0.4542E-04,0.2708E-04,
     +0.1920E-04,0.1357E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1897E-01,0.2002E-01,0.2113E-01,0.2230E-01,0.2353E-01,0.2483E-01,
     +0.2620E-01,0.2764E-01,0.2916E-01,0.3077E-01,0.3246E-01,0.3424E-01,
     +0.3611E-01,0.3808E-01,0.4016E-01,0.4235E-01,0.4466E-01,0.4709E-01,
     +0.4964E-01,0.5233E-01,0.5516E-01,0.5814E-01,0.6127E-01,0.6456E-01,
     +0.6802E-01,0.7166E-01,0.7548E-01,0.7950E-01,0.8371E-01,0.8814E-01,
     +0.9279E-01,0.9766E-01,0.1028E+00,0.1081E+00,0.1138E+00,0.1196E+00,
     +0.1258E+00,0.1323E+00,0.1390E+00,0.1461E+00,0.1534E+00,0.1611E+00,
     +0.1691E+00,0.1775E+00,0.1862E+00,0.1952E+00,0.2046E+00,0.2144E+00,
     +0.2245E+00,0.2349E+00,0.2458E+00,0.2569E+00,0.2684E+00,0.2802E+00,
     +0.2923E+00,0.3046E+00,0.3172E+00,0.3300E+00,0.3429E+00,0.3560E+00,
     +0.3690E+00,0.3820E+00,0.3949E+00,0.4075E+00,0.4197E+00,0.4314E+00,
     +0.4424E+00,0.4526E+00,0.4618E+00,0.4697E+00,0.4761E+00,0.4808E+00,
     +0.4834E+00,0.4837E+00,0.4814E+00,0.4763E+00,0.4679E+00,0.4561E+00,
     +0.4407E+00,0.4215E+00,0.3985E+00,0.3718E+00,0.3414E+00,0.3080E+00,
     +0.2720E+00,0.2343E+00,0.1960E+00,0.1581E+00,0.1221E+00,0.8924E-01,
     +0.7147E-01,0.5637E-01,0.4371E-01,0.3322E-01,0.2465E-01,0.1777E-01,
     +0.1236E-01,0.8211E-02,0.5132E-02,0.2951E-02,0.1504E-02,0.6348E-03,
     +0.1919E-03,0.2691E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1078E-01,0.1138E-01,0.1201E-01,0.1267E-01,0.1337E-01,0.1411E-01,
     +0.1488E-01,0.1570E-01,0.1656E-01,0.1747E-01,0.1842E-01,0.1943E-01,
     +0.2049E-01,0.2160E-01,0.2278E-01,0.2401E-01,0.2531E-01,0.2668E-01,
     +0.2812E-01,0.2964E-01,0.3123E-01,0.3290E-01,0.3466E-01,0.3651E-01,
     +0.3846E-01,0.4050E-01,0.4264E-01,0.4489E-01,0.4725E-01,0.4972E-01,
     +0.5232E-01,0.5504E-01,0.5788E-01,0.6087E-01,0.6399E-01,0.6725E-01,
     +0.7066E-01,0.7423E-01,0.7795E-01,0.8183E-01,0.8587E-01,0.9008E-01,
     +0.9446E-01,0.9901E-01,0.1037E+00,0.1086E+00,0.1137E+00,0.1189E+00,
     +0.1243E+00,0.1299E+00,0.1356E+00,0.1415E+00,0.1475E+00,0.1536E+00,
     +0.1598E+00,0.1661E+00,0.1725E+00,0.1788E+00,0.1852E+00,0.1915E+00,
     +0.1977E+00,0.2037E+00,0.2095E+00,0.2151E+00,0.2202E+00,0.2250E+00,
     +0.2291E+00,0.2326E+00,0.2354E+00,0.2372E+00,0.2381E+00,0.2378E+00,
     +0.2362E+00,0.2332E+00,0.2287E+00,0.2226E+00,0.2148E+00,0.2052E+00,
     +0.1939E+00,0.1808E+00,0.1662E+00,0.1502E+00,0.1330E+00,0.1152E+00,
     +0.9709E-01,0.7925E-01,0.6226E-01,0.4670E-01,0.3307E-01,0.2178E-01,
     +0.1621E-01,0.1182E-01,0.8428E-02,0.5850E-02,0.3935E-02,0.2547E-02,
     +0.1572E-02,0.9131E-03,0.4897E-03,0.2355E-03,0.9669E-04,0.3103E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1274E+03,0.1220E+03,0.1168E+03,0.1118E+03,0.1070E+03,0.1023E+03,
     +0.9788E+02,0.9360E+02,0.8947E+02,0.8551E+02,0.8170E+02,0.7803E+02,
     +0.7451E+02,0.7113E+02,0.6788E+02,0.6475E+02,0.6176E+02,0.5888E+02,
     +0.5611E+02,0.5346E+02,0.5091E+02,0.4847E+02,0.4612E+02,0.4388E+02,
     +0.4172E+02,0.3966E+02,0.3768E+02,0.3578E+02,0.3397E+02,0.3223E+02,
     +0.3056E+02,0.2897E+02,0.2744E+02,0.2598E+02,0.2459E+02,0.2326E+02,
     +0.2198E+02,0.2076E+02,0.1960E+02,0.1849E+02,0.1743E+02,0.1642E+02,
     +0.1545E+02,0.1453E+02,0.1365E+02,0.1282E+02,0.1202E+02,0.1126E+02,
     +0.1054E+02,0.9856E+01,0.9203E+01,0.8582E+01,0.7993E+01,0.7433E+01,
     +0.6902E+01,0.6398E+01,0.5920E+01,0.5468E+01,0.5040E+01,0.4635E+01,
     +0.4253E+01,0.3892E+01,0.3551E+01,0.3231E+01,0.2930E+01,0.2648E+01,
     +0.2383E+01,0.2136E+01,0.1905E+01,0.1691E+01,0.1492E+01,0.1309E+01,
     +0.1141E+01,0.9863E+00,0.8459E+00,0.7188E+00,0.6045E+00,0.5026E+00,
     +0.4123E+00,0.3333E+00,0.2648E+00,0.2062E+00,0.1568E+00,0.1160E+00,
     +0.8282E-01,0.5666E-01,0.3665E-01,0.2193E-01,0.1165E-01,0.4937E-02,
     +0.2258E-02,0.5210E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.2291E+02,0.2199E+02,0.2111E+02,0.2026E+02,0.1944E+02,0.1865E+02,
     +0.1789E+02,0.1716E+02,0.1646E+02,0.1578E+02,0.1512E+02,0.1449E+02,
     +0.1389E+02,0.1331E+02,0.1274E+02,0.1220E+02,0.1169E+02,0.1119E+02,
     +0.1071E+02,0.1024E+02,0.9799E+01,0.9372E+01,0.8962E+01,0.8567E+01,
     +0.8188E+01,0.7824E+01,0.7474E+01,0.7138E+01,0.6816E+01,0.6506E+01,
     +0.6208E+01,0.5923E+01,0.5649E+01,0.5385E+01,0.5133E+01,0.4891E+01,
     +0.4658E+01,0.4435E+01,0.4221E+01,0.4016E+01,0.3819E+01,0.3630E+01,
     +0.3448E+01,0.3274E+01,0.3107E+01,0.2947E+01,0.2793E+01,0.2646E+01,
     +0.2504E+01,0.2368E+01,0.2237E+01,0.2111E+01,0.1990E+01,0.1874E+01,
     +0.1762E+01,0.1654E+01,0.1550E+01,0.1451E+01,0.1354E+01,0.1262E+01,
     +0.1173E+01,0.1087E+01,0.1005E+01,0.9253E+00,0.8492E+00,0.7764E+00,
     +0.7067E+00,0.6403E+00,0.5771E+00,0.5173E+00,0.4610E+00,0.4081E+00,
     +0.3587E+00,0.3130E+00,0.2708E+00,0.2323E+00,0.1973E+00,0.1657E+00,
     +0.1376E+00,0.1126E+00,0.9069E-01,0.7165E-01,0.5529E-01,0.4148E-01,
     +0.3006E-01,0.2088E-01,0.1379E-01,0.8587E-02,0.4999E-02,0.2710E-02,
     +0.1808E-02,0.1211E-02,0.8132E-03,0.5464E-03,0.3658E-03,0.2420E-03,
     +0.1565E-03,0.9744E-04,0.5730E-04,0.3098E-04,0.1481E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.4431E+01,0.4262E+01,0.4099E+01,0.3942E+01,0.3791E+01,0.3645E+01,
     +0.3504E+01,0.3369E+01,0.3238E+01,0.3112E+01,0.2991E+01,0.2874E+01,
     +0.2762E+01,0.2653E+01,0.2549E+01,0.2449E+01,0.2352E+01,0.2259E+01,
     +0.2170E+01,0.2083E+01,0.2000E+01,0.1921E+01,0.1844E+01,0.1770E+01,
     +0.1699E+01,0.1631E+01,0.1565E+01,0.1502E+01,0.1441E+01,0.1383E+01,
     +0.1327E+01,0.1273E+01,0.1221E+01,0.1171E+01,0.1122E+01,0.1076E+01,
     +0.1032E+01,0.9888E+00,0.9476E+00,0.9078E+00,0.8696E+00,0.8327E+00,
     +0.7971E+00,0.7628E+00,0.7297E+00,0.6977E+00,0.6668E+00,0.6369E+00,
     +0.6079E+00,0.5798E+00,0.5526E+00,0.5261E+00,0.5004E+00,0.4753E+00,
     +0.4509E+00,0.4271E+00,0.4039E+00,0.3812E+00,0.3591E+00,0.3374E+00,
     +0.3162E+00,0.2955E+00,0.2753E+00,0.2556E+00,0.2363E+00,0.2176E+00,
     +0.1995E+00,0.1820E+00,0.1651E+00,0.1489E+00,0.1335E+00,0.1189E+00,
     +0.1051E+00,0.9223E-01,0.8026E-01,0.6923E-01,0.5915E-01,0.5000E-01,
     +0.4175E-01,0.3439E-01,0.2785E-01,0.2211E-01,0.1713E-01,0.1287E-01,
     +0.9304E-02,0.6419E-02,0.4179E-02,0.2537E-02,0.1420E-02,0.7258E-03,
     +0.4632E-03,0.2958E-03,0.1897E-03,0.1223E-03,0.7929E-04,0.5128E-04,
     +0.3271E-04,0.2023E-04,0.1188E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.4257E+01,0.4088E+01,0.3925E+01,0.3768E+01,0.3617E+01,0.3471E+01,
     +0.3330E+01,0.3195E+01,0.3064E+01,0.2939E+01,0.2818E+01,0.2701E+01,
     +0.2589E+01,0.2480E+01,0.2376E+01,0.2276E+01,0.2180E+01,0.2087E+01,
     +0.1998E+01,0.1912E+01,0.1829E+01,0.1749E+01,0.1673E+01,0.1600E+01,
     +0.1529E+01,0.1461E+01,0.1396E+01,0.1333E+01,0.1273E+01,0.1215E+01,
     +0.1159E+01,0.1106E+01,0.1055E+01,0.1005E+01,0.9580E+00,0.9126E+00,
     +0.8691E+00,0.8272E+00,0.7871E+00,0.7486E+00,0.7117E+00,0.6762E+00,
     +0.6422E+00,0.6095E+00,0.5782E+00,0.5481E+00,0.5192E+00,0.4915E+00,
     +0.4649E+00,0.4393E+00,0.4148E+00,0.3912E+00,0.3685E+00,0.3468E+00,
     +0.3258E+00,0.3057E+00,0.2863E+00,0.2677E+00,0.2498E+00,0.2325E+00,
     +0.2160E+00,0.2000E+00,0.1847E+00,0.1700E+00,0.1560E+00,0.1425E+00,
     +0.1297E+00,0.1174E+00,0.1058E+00,0.9479E-01,0.8443E-01,0.7471E-01,
     +0.6566E-01,0.5726E-01,0.4954E-01,0.4247E-01,0.3606E-01,0.3028E-01,
     +0.2512E-01,0.2056E-01,0.1655E-01,0.1307E-01,0.1009E-01,0.7574E-02,
     +0.5497E-02,0.3830E-02,0.2543E-02,0.1595E-02,0.9393E-03,0.5174E-03,
     +0.3492E-03,0.2367E-03,0.1608E-03,0.1092E-03,0.7376E-04,0.4917E-04,
     +0.3199E-04,0.2002E-04,0.1183E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.4141E+01,0.3972E+01,0.3809E+01,0.3652E+01,0.3501E+01,0.3355E+01,
     +0.3214E+01,0.3079E+01,0.2949E+01,0.2823E+01,0.2702E+01,0.2585E+01,
     +0.2473E+01,0.2365E+01,0.2261E+01,0.2161E+01,0.2065E+01,0.1972E+01,
     +0.1883E+01,0.1797E+01,0.1714E+01,0.1635E+01,0.1559E+01,0.1486E+01,
     +0.1415E+01,0.1348E+01,0.1283E+01,0.1220E+01,0.1160E+01,0.1103E+01,
     +0.1048E+01,0.9946E+00,0.9437E+00,0.8950E+00,0.8483E+00,0.8035E+00,
     +0.7606E+00,0.7194E+00,0.6801E+00,0.6424E+00,0.6063E+00,0.5718E+00,
     +0.5388E+00,0.5072E+00,0.4771E+00,0.4483E+00,0.4208E+00,0.3945E+00,
     +0.3695E+00,0.3456E+00,0.3229E+00,0.3012E+00,0.2806E+00,0.2610E+00,
     +0.2424E+00,0.2247E+00,0.2079E+00,0.1920E+00,0.1769E+00,0.1626E+00,
     +0.1491E+00,0.1364E+00,0.1244E+00,0.1131E+00,0.1024E+00,0.9246E-01,
     +0.8312E-01,0.7439E-01,0.6627E-01,0.5872E-01,0.5173E-01,0.4529E-01,
     +0.3938E-01,0.3397E-01,0.2907E-01,0.2464E-01,0.2067E-01,0.1715E-01,
     +0.1404E-01,0.1134E-01,0.9020E-02,0.7048E-02,0.5400E-02,0.4048E-02,
     +0.2960E-02,0.2105E-02,0.1452E-02,0.9669E-03,0.6190E-03,0.3785E-03,
     +0.2732E-03,0.1973E-03,0.1415E-03,0.1004E-03,0.7007E-04,0.4776E-04,
     +0.3151E-04,0.1988E-04,0.1179E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.3911E+01,0.3750E+01,0.3594E+01,0.3444E+01,0.3299E+01,0.3160E+01,
     +0.3026E+01,0.2897E+01,0.2772E+01,0.2653E+01,0.2537E+01,0.2426E+01,
     +0.2319E+01,0.2217E+01,0.2118E+01,0.2023E+01,0.1931E+01,0.1843E+01,
     +0.1759E+01,0.1677E+01,0.1599E+01,0.1524E+01,0.1452E+01,0.1383E+01,
     +0.1316E+01,0.1252E+01,0.1191E+01,0.1132E+01,0.1076E+01,0.1021E+01,
     +0.9695E+00,0.9196E+00,0.8719E+00,0.8261E+00,0.7823E+00,0.7403E+00,
     +0.7001E+00,0.6616E+00,0.6248E+00,0.5896E+00,0.5559E+00,0.5237E+00,
     +0.4930E+00,0.4636E+00,0.4355E+00,0.4088E+00,0.3832E+00,0.3589E+00,
     +0.3357E+00,0.3136E+00,0.2926E+00,0.2726E+00,0.2536E+00,0.2355E+00,
     +0.2183E+00,0.2021E+00,0.1867E+00,0.1721E+00,0.1583E+00,0.1452E+00,
     +0.1329E+00,0.1213E+00,0.1104E+00,0.1001E+00,0.9049E-01,0.8148E-01,
     +0.7307E-01,0.6523E-01,0.5794E-01,0.5120E-01,0.4497E-01,0.3925E-01,
     +0.3402E-01,0.2925E-01,0.2494E-01,0.2107E-01,0.1761E-01,0.1455E-01,
     +0.1187E-01,0.9548E-02,0.7559E-02,0.5880E-02,0.4485E-02,0.3346E-02,
     +0.2435E-02,0.1723E-02,0.1182E-02,0.7830E-03,0.4982E-03,0.3025E-03,
     +0.2173E-03,0.1560E-03,0.1112E-03,0.7830E-04,0.5420E-04,0.3661E-04,
     +0.2390E-04,0.1490E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.1735E+01,0.1658E+01,0.1583E+01,0.1512E+01,0.1443E+01,0.1377E+01,
     +0.1314E+01,0.1253E+01,0.1194E+01,0.1138E+01,0.1085E+01,0.1033E+01,
     +0.9837E+00,0.9363E+00,0.8909E+00,0.8474E+00,0.8056E+00,0.7657E+00,
     +0.7274E+00,0.6907E+00,0.6557E+00,0.6221E+00,0.5899E+00,0.5592E+00,
     +0.5298E+00,0.5017E+00,0.4749E+00,0.4492E+00,0.4247E+00,0.4013E+00,
     +0.3790E+00,0.3577E+00,0.3373E+00,0.3179E+00,0.2994E+00,0.2818E+00,
     +0.2650E+00,0.2491E+00,0.2339E+00,0.2194E+00,0.2056E+00,0.1925E+00,
     +0.1801E+00,0.1683E+00,0.1571E+00,0.1465E+00,0.1364E+00,0.1269E+00,
     +0.1179E+00,0.1093E+00,0.1013E+00,0.9365E-01,0.8646E-01,0.7967E-01,
     +0.7328E-01,0.6727E-01,0.6162E-01,0.5631E-01,0.5133E-01,0.4668E-01,
     +0.4232E-01,0.3826E-01,0.3447E-01,0.3095E-01,0.2768E-01,0.2466E-01,
     +0.2187E-01,0.1930E-01,0.1695E-01,0.1479E-01,0.1283E-01,0.1106E-01,
     +0.9459E-02,0.8025E-02,0.6747E-02,0.5618E-02,0.4626E-02,0.3765E-02,
     +0.3023E-02,0.2393E-02,0.1862E-02,0.1424E-02,0.1066E-02,0.7804E-03,
     +0.5567E-03,0.3858E-03,0.2586E-03,0.1670E-03,0.1032E-03,0.6040E-04,
     +0.4230E-04,0.2949E-04,0.2035E-04,0.1382E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.2044E-01,0.2157E-01,0.2275E-01,0.2400E-01,0.2532E-01,0.2671E-01,
     +0.2817E-01,0.2971E-01,0.3134E-01,0.3305E-01,0.3485E-01,0.3674E-01,
     +0.3874E-01,0.4084E-01,0.4305E-01,0.4537E-01,0.4782E-01,0.5039E-01,
     +0.5310E-01,0.5595E-01,0.5894E-01,0.6208E-01,0.6539E-01,0.6886E-01,
     +0.7251E-01,0.7634E-01,0.8036E-01,0.8457E-01,0.8900E-01,0.9364E-01,
     +0.9850E-01,0.1036E+00,0.1089E+00,0.1145E+00,0.1204E+00,0.1265E+00,
     +0.1329E+00,0.1396E+00,0.1465E+00,0.1538E+00,0.1614E+00,0.1693E+00,
     +0.1775E+00,0.1860E+00,0.1949E+00,0.2041E+00,0.2137E+00,0.2236E+00,
     +0.2338E+00,0.2443E+00,0.2552E+00,0.2663E+00,0.2778E+00,0.2895E+00,
     +0.3014E+00,0.3136E+00,0.3259E+00,0.3383E+00,0.3509E+00,0.3634E+00,
     +0.3758E+00,0.3881E+00,0.4002E+00,0.4118E+00,0.4230E+00,0.4335E+00,
     +0.4433E+00,0.4520E+00,0.4596E+00,0.4658E+00,0.4704E+00,0.4732E+00,
     +0.4738E+00,0.4720E+00,0.4676E+00,0.4603E+00,0.4499E+00,0.4362E+00,
     +0.4190E+00,0.3983E+00,0.3740E+00,0.3464E+00,0.3158E+00,0.2825E+00,
     +0.2474E+00,0.2111E+00,0.1747E+00,0.1393E+00,0.1062E+00,0.7649E-01,
     +0.6065E-01,0.4734E-01,0.3630E-01,0.2726E-01,0.1997E-01,0.1419E-01,
     +0.9709E-02,0.6330E-02,0.3870E-02,0.2167E-02,0.1067E-02,0.4292E-03,
     +0.1199E-03,0.1371E-04/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1161E-01,0.1225E-01,0.1292E-01,0.1363E-01,0.1437E-01,0.1516E-01,
     +0.1598E-01,0.1686E-01,0.1777E-01,0.1874E-01,0.1975E-01,0.2082E-01,
     +0.2195E-01,0.2313E-01,0.2438E-01,0.2569E-01,0.2707E-01,0.2851E-01,
     +0.3004E-01,0.3163E-01,0.3332E-01,0.3508E-01,0.3693E-01,0.3888E-01,
     +0.4092E-01,0.4306E-01,0.4531E-01,0.4766E-01,0.5013E-01,0.5271E-01,
     +0.5542E-01,0.5825E-01,0.6121E-01,0.6430E-01,0.6753E-01,0.7091E-01,
     +0.7443E-01,0.7810E-01,0.8193E-01,0.8591E-01,0.9005E-01,0.9435E-01,
     +0.9882E-01,0.1034E+00,0.1082E+00,0.1132E+00,0.1183E+00,0.1236E+00,
     +0.1290E+00,0.1345E+00,0.1402E+00,0.1460E+00,0.1519E+00,0.1579E+00,
     +0.1640E+00,0.1701E+00,0.1762E+00,0.1823E+00,0.1884E+00,0.1943E+00,
     +0.2001E+00,0.2056E+00,0.2109E+00,0.2159E+00,0.2204E+00,0.2244E+00,
     +0.2278E+00,0.2305E+00,0.2323E+00,0.2333E+00,0.2331E+00,0.2319E+00,
     +0.2293E+00,0.2253E+00,0.2199E+00,0.2128E+00,0.2042E+00,0.1939E+00,
     +0.1821E+00,0.1687E+00,0.1539E+00,0.1380E+00,0.1213E+00,0.1041E+00,
     +0.8689E-01,0.7020E-01,0.5453E-01,0.4039E-01,0.2820E-01,0.1828E-01,
     +0.1346E-01,0.9705E-02,0.6836E-02,0.4684E-02,0.3107E-02,0.1980E-02,
     +0.1201E-02,0.6835E-03,0.3579E-03,0.1671E-03,0.6600E-04,0.2002E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1557E+03,0.1487E+03,0.1420E+03,0.1355E+03,0.1293E+03,0.1234E+03,
     +0.1177E+03,0.1122E+03,0.1069E+03,0.1019E+03,0.9705E+02,0.9241E+02,
     +0.8797E+02,0.8372E+02,0.7965E+02,0.7574E+02,0.7200E+02,0.6843E+02,
     +0.6500E+02,0.6172E+02,0.5859E+02,0.5559E+02,0.5272E+02,0.4998E+02,
     +0.4736E+02,0.4486E+02,0.4247E+02,0.4019E+02,0.3801E+02,0.3593E+02,
     +0.3395E+02,0.3206E+02,0.3025E+02,0.2853E+02,0.2689E+02,0.2533E+02,
     +0.2385E+02,0.2244E+02,0.2109E+02,0.1981E+02,0.1860E+02,0.1744E+02,
     +0.1634E+02,0.1530E+02,0.1431E+02,0.1337E+02,0.1248E+02,0.1164E+02,
     +0.1084E+02,0.1009E+02,0.9370E+01,0.8694E+01,0.8055E+01,0.7451E+01,
     +0.6881E+01,0.6344E+01,0.5837E+01,0.5361E+01,0.4912E+01,0.4491E+01,
     +0.4095E+01,0.3725E+01,0.3378E+01,0.3054E+01,0.2751E+01,0.2470E+01,
     +0.2208E+01,0.1965E+01,0.1741E+01,0.1534E+01,0.1344E+01,0.1171E+01,
     +0.1012E+01,0.8688E+00,0.7394E+00,0.6234E+00,0.5201E+00,0.4288E+00,
     +0.3489E+00,0.2796E+00,0.2201E+00,0.1698E+00,0.1278E+00,0.9343E-01,
     +0.6590E-01,0.4441E-01,0.2818E-01,0.1642E-01,0.8334E-02,0.3177E-02,
     +0.1177E-02,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.2980E+02,0.2855E+02,0.2735E+02,0.2619E+02,0.2507E+02,0.2400E+02,
     +0.2297E+02,0.2198E+02,0.2103E+02,0.2011E+02,0.1923E+02,0.1839E+02,
     +0.1758E+02,0.1680E+02,0.1605E+02,0.1533E+02,0.1464E+02,0.1398E+02,
     +0.1334E+02,0.1273E+02,0.1215E+02,0.1159E+02,0.1105E+02,0.1053E+02,
     +0.1004E+02,0.9562E+01,0.9108E+01,0.8672E+01,0.8255E+01,0.7856E+01,
     +0.7473E+01,0.7106E+01,0.6756E+01,0.6420E+01,0.6098E+01,0.5791E+01,
     +0.5497E+01,0.5215E+01,0.4946E+01,0.4688E+01,0.4442E+01,0.4206E+01,
     +0.3981E+01,0.3765E+01,0.3559E+01,0.3362E+01,0.3174E+01,0.2993E+01,
     +0.2821E+01,0.2656E+01,0.2498E+01,0.2347E+01,0.2203E+01,0.2065E+01,
     +0.1933E+01,0.1806E+01,0.1685E+01,0.1569E+01,0.1458E+01,0.1351E+01,
     +0.1250E+01,0.1152E+01,0.1059E+01,0.9709E+00,0.8864E+00,0.8061E+00,
     +0.7299E+00,0.6577E+00,0.5896E+00,0.5257E+00,0.4658E+00,0.4100E+00,
     +0.3584E+00,0.3108E+00,0.2673E+00,0.2279E+00,0.1923E+00,0.1605E+00,
     +0.1322E+00,0.1074E+00,0.8583E-01,0.6722E-01,0.5142E-01,0.3821E-01,
     +0.2742E-01,0.1887E-01,0.1235E-01,0.7622E-02,0.4407E-02,0.2379E-02,
     +0.1584E-02,0.1059E-02,0.7085E-03,0.4737E-03,0.3148E-03,0.2062E-03,
     +0.1316E-03,0.8064E-04,0.4654E-04,0.2462E-04,0.1147E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.5567E+01,0.5343E+01,0.5126E+01,0.4918E+01,0.4718E+01,0.4525E+01,
     +0.4340E+01,0.4161E+01,0.3990E+01,0.3825E+01,0.3666E+01,0.3514E+01,
     +0.3367E+01,0.3227E+01,0.3091E+01,0.2961E+01,0.2837E+01,0.2717E+01,
     +0.2602E+01,0.2491E+01,0.2385E+01,0.2283E+01,0.2185E+01,0.2091E+01,
     +0.2001E+01,0.1914E+01,0.1831E+01,0.1752E+01,0.1675E+01,0.1602E+01,
     +0.1532E+01,0.1464E+01,0.1400E+01,0.1338E+01,0.1278E+01,0.1221E+01,
     +0.1166E+01,0.1114E+01,0.1063E+01,0.1015E+01,0.9684E+00,0.9238E+00,
     +0.8809E+00,0.8396E+00,0.8000E+00,0.7618E+00,0.7251E+00,0.6897E+00,
     +0.6556E+00,0.6227E+00,0.5910E+00,0.5603E+00,0.5306E+00,0.5018E+00,
     +0.4740E+00,0.4470E+00,0.4209E+00,0.3955E+00,0.3708E+00,0.3469E+00,
     +0.3236E+00,0.3010E+00,0.2791E+00,0.2579E+00,0.2374E+00,0.2176E+00,
     +0.1986E+00,0.1803E+00,0.1628E+00,0.1461E+00,0.1304E+00,0.1155E+00,
     +0.1016E+00,0.8872E-01,0.7681E-01,0.6590E-01,0.5598E-01,0.4704E-01,
     +0.3903E-01,0.3192E-01,0.2566E-01,0.2021E-01,0.1551E-01,0.1154E-01,
     +0.8264E-02,0.5641E-02,0.3634E-02,0.2185E-02,0.1212E-02,0.6161E-03,
     +0.3927E-03,0.2508E-03,0.1608E-03,0.1036E-03,0.6694E-04,0.4302E-04,
     +0.2716E-04,0.1657E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.5393E+01,0.5169E+01,0.4952E+01,0.4744E+01,0.4544E+01,0.4351E+01,
     +0.4166E+01,0.3988E+01,0.3816E+01,0.3652E+01,0.3493E+01,0.3341E+01,
     +0.3195E+01,0.3054E+01,0.2919E+01,0.2789E+01,0.2665E+01,0.2545E+01,
     +0.2430E+01,0.2320E+01,0.2214E+01,0.2112E+01,0.2015E+01,0.1921E+01,
     +0.1831E+01,0.1745E+01,0.1663E+01,0.1584E+01,0.1508E+01,0.1435E+01,
     +0.1366E+01,0.1299E+01,0.1235E+01,0.1174E+01,0.1115E+01,0.1059E+01,
     +0.1005E+01,0.9538E+00,0.9046E+00,0.8575E+00,0.8125E+00,0.7694E+00,
     +0.7281E+00,0.6887E+00,0.6509E+00,0.6148E+00,0.5803E+00,0.5472E+00,
     +0.5156E+00,0.4854E+00,0.4565E+00,0.4288E+00,0.4023E+00,0.3769E+00,
     +0.3527E+00,0.3295E+00,0.3073E+00,0.2860E+00,0.2657E+00,0.2462E+00,
     +0.2276E+00,0.2098E+00,0.1928E+00,0.1767E+00,0.1613E+00,0.1466E+00,
     +0.1327E+00,0.1196E+00,0.1072E+00,0.9554E-01,0.8465E-01,0.7451E-01,
     +0.6512E-01,0.5648E-01,0.4857E-01,0.4140E-01,0.3493E-01,0.2914E-01,
     +0.2401E-01,0.1951E-01,0.1558E-01,0.1221E-01,0.9340E-02,0.6948E-02,
     +0.4995E-02,0.3448E-02,0.2268E-02,0.1411E-02,0.8250E-03,0.4520E-03,
     +0.3042E-03,0.2056E-03,0.1391E-03,0.9391E-04,0.6295E-04,0.4153E-04,
     +0.2667E-04,0.1643E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.5277E+01,0.5053E+01,0.4836E+01,0.4628E+01,0.4428E+01,0.4236E+01,
     +0.4050E+01,0.3872E+01,0.3701E+01,0.3536E+01,0.3378E+01,0.3226E+01,
     +0.3079E+01,0.2939E+01,0.2804E+01,0.2674E+01,0.2550E+01,0.2430E+01,
     +0.2316E+01,0.2205E+01,0.2100E+01,0.1998E+01,0.1901E+01,0.1808E+01,
     +0.1718E+01,0.1632E+01,0.1550E+01,0.1471E+01,0.1396E+01,0.1324E+01,
     +0.1255E+01,0.1188E+01,0.1125E+01,0.1064E+01,0.1006E+01,0.9508E+00,
     +0.8978E+00,0.8472E+00,0.7988E+00,0.7526E+00,0.7085E+00,0.6664E+00,
     +0.6262E+00,0.5880E+00,0.5515E+00,0.5168E+00,0.4837E+00,0.4522E+00,
     +0.4223E+00,0.3938E+00,0.3668E+00,0.3411E+00,0.3168E+00,0.2937E+00,
     +0.2718E+00,0.2511E+00,0.2315E+00,0.2130E+00,0.1956E+00,0.1791E+00,
     +0.1636E+00,0.1490E+00,0.1353E+00,0.1225E+00,0.1105E+00,0.9930E-01,
     +0.8886E-01,0.7915E-01,0.7016E-01,0.6185E-01,0.5421E-01,0.4720E-01,
     +0.4080E-01,0.3500E-01,0.2976E-01,0.2507E-01,0.2090E-01,0.1722E-01,
     +0.1401E-01,0.1123E-01,0.8867E-02,0.6875E-02,0.5226E-02,0.3885E-02,
     +0.2817E-02,0.1986E-02,0.1357E-02,0.8951E-03,0.5671E-03,0.3426E-03,
     +0.2453E-03,0.1755E-03,0.1246E-03,0.8745E-04,0.6028E-04,0.4054E-04,
     +0.2634E-04,0.1634E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.5054E+01,0.4836E+01,0.4627E+01,0.4425E+01,0.4232E+01,0.4046E+01,
     +0.3867E+01,0.3695E+01,0.3529E+01,0.3370E+01,0.3218E+01,0.3071E+01,
     +0.2930E+01,0.2795E+01,0.2665E+01,0.2540E+01,0.2420E+01,0.2305E+01,
     +0.2195E+01,0.2089E+01,0.1988E+01,0.1890E+01,0.1797E+01,0.1708E+01,
     +0.1622E+01,0.1540E+01,0.1461E+01,0.1386E+01,0.1314E+01,0.1245E+01,
     +0.1179E+01,0.1116E+01,0.1055E+01,0.9977E+00,0.9425E+00,0.8898E+00,
     +0.8394E+00,0.7914E+00,0.7455E+00,0.7017E+00,0.6599E+00,0.6201E+00,
     +0.5821E+00,0.5459E+00,0.5115E+00,0.4788E+00,0.4476E+00,0.4180E+00,
     +0.3898E+00,0.3631E+00,0.3377E+00,0.3137E+00,0.2909E+00,0.2693E+00,
     +0.2488E+00,0.2295E+00,0.2113E+00,0.1941E+00,0.1778E+00,0.1626E+00,
     +0.1482E+00,0.1347E+00,0.1221E+00,0.1103E+00,0.9927E-01,0.8899E-01,
     +0.7943E-01,0.7058E-01,0.6239E-01,0.5485E-01,0.4793E-01,0.4161E-01,
     +0.3586E-01,0.3066E-01,0.2598E-01,0.2181E-01,0.1811E-01,0.1487E-01,
     +0.1205E-01,0.9621E-02,0.7561E-02,0.5837E-02,0.4416E-02,0.3268E-02,
     +0.2358E-02,0.1654E-02,0.1124E-02,0.7370E-03,0.4639E-03,0.2781E-03,
     +0.1980E-03,0.1408E-03,0.9930E-04,0.6913E-04,0.4724E-04,0.3145E-04,
     +0.2021E-04,0.1238E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.2943E+01,0.2808E+01,0.2677E+01,0.2552E+01,0.2433E+01,0.2318E+01,
     +0.2208E+01,0.2102E+01,0.2001E+01,0.1904E+01,0.1811E+01,0.1722E+01,
     +0.1637E+01,0.1556E+01,0.1478E+01,0.1403E+01,0.1332E+01,0.1264E+01,
     +0.1198E+01,0.1136E+01,0.1076E+01,0.1019E+01,0.9648E+00,0.9129E+00,
     +0.8633E+00,0.8160E+00,0.7708E+00,0.7277E+00,0.6867E+00,0.6476E+00,
     +0.6103E+00,0.5748E+00,0.5410E+00,0.5088E+00,0.4782E+00,0.4491E+00,
     +0.4214E+00,0.3951E+00,0.3702E+00,0.3465E+00,0.3240E+00,0.3027E+00,
     +0.2825E+00,0.2633E+00,0.2452E+00,0.2280E+00,0.2118E+00,0.1965E+00,
     +0.1820E+00,0.1684E+00,0.1555E+00,0.1434E+00,0.1320E+00,0.1213E+00,
     +0.1112E+00,0.1018E+00,0.9290E-01,0.8462E-01,0.7688E-01,0.6966E-01,
     +0.6293E-01,0.5667E-01,0.5087E-01,0.4549E-01,0.4053E-01,0.3595E-01,
     +0.3174E-01,0.2789E-01,0.2437E-01,0.2118E-01,0.1828E-01,0.1567E-01,
     +0.1333E-01,0.1125E-01,0.9404E-02,0.7783E-02,0.6370E-02,0.5151E-02,
     +0.4108E-02,0.3228E-02,0.2495E-02,0.1892E-02,0.1406E-02,0.1020E-02,
     +0.7213E-03,0.4951E-03,0.3285E-03,0.2096E-03,0.1278E-03,0.7367E-04,
     +0.5102E-04,0.3514E-04,0.2392E-04,0.1601E-04,0.1048E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.2182E-01,0.2301E-01,0.2427E-01,0.2560E-01,0.2700E-01,0.2847E-01,
     +0.3002E-01,0.3165E-01,0.3336E-01,0.3517E-01,0.3707E-01,0.3907E-01,
     +0.4118E-01,0.4339E-01,0.4572E-01,0.4817E-01,0.5075E-01,0.5345E-01,
     +0.5630E-01,0.5929E-01,0.6243E-01,0.6572E-01,0.6919E-01,0.7282E-01,
     +0.7663E-01,0.8063E-01,0.8482E-01,0.8922E-01,0.9382E-01,0.9865E-01,
     +0.1037E+00,0.1090E+00,0.1145E+00,0.1203E+00,0.1263E+00,0.1327E+00,
     +0.1392E+00,0.1461E+00,0.1533E+00,0.1607E+00,0.1685E+00,0.1766E+00,
     +0.1849E+00,0.1936E+00,0.2026E+00,0.2120E+00,0.2216E+00,0.2316E+00,
     +0.2419E+00,0.2524E+00,0.2633E+00,0.2744E+00,0.2857E+00,0.2973E+00,
     +0.3091E+00,0.3210E+00,0.3330E+00,0.3451E+00,0.3572E+00,0.3692E+00,
     +0.3811E+00,0.3927E+00,0.4039E+00,0.4147E+00,0.4249E+00,0.4344E+00,
     +0.4429E+00,0.4504E+00,0.4566E+00,0.4613E+00,0.4643E+00,0.4653E+00,
     +0.4642E+00,0.4607E+00,0.4546E+00,0.4455E+00,0.4335E+00,0.4182E+00,
     +0.3996E+00,0.3778E+00,0.3527E+00,0.3247E+00,0.2940E+00,0.2612E+00,
     +0.2269E+00,0.1920E+00,0.1574E+00,0.1243E+00,0.9371E-01,0.6661E-01,
     +0.5235E-01,0.4048E-01,0.3074E-01,0.2284E-01,0.1654E-01,0.1160E-01,
     +0.7826E-02,0.5018E-02,0.3009E-02,0.1645E-02,0.7853E-03,0.3023E-03,
     +0.7822E-04,0.0000E+00/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.1238E-01,0.1306E-01,0.1377E-01,0.1452E-01,0.1531E-01,0.1614E-01,
     +0.1701E-01,0.1793E-01,0.1890E-01,0.1992E-01,0.2099E-01,0.2212E-01,
     +0.2331E-01,0.2455E-01,0.2586E-01,0.2724E-01,0.2869E-01,0.3020E-01,
     +0.3180E-01,0.3348E-01,0.3523E-01,0.3708E-01,0.3902E-01,0.4105E-01,
     +0.4317E-01,0.4540E-01,0.4774E-01,0.5019E-01,0.5275E-01,0.5542E-01,
     +0.5822E-01,0.6115E-01,0.6421E-01,0.6740E-01,0.7072E-01,0.7419E-01,
     +0.7781E-01,0.8157E-01,0.8548E-01,0.8954E-01,0.9376E-01,0.9813E-01,
     +0.1027E+00,0.1073E+00,0.1122E+00,0.1171E+00,0.1223E+00,0.1275E+00,
     +0.1329E+00,0.1385E+00,0.1441E+00,0.1498E+00,0.1556E+00,0.1615E+00,
     +0.1674E+00,0.1733E+00,0.1792E+00,0.1851E+00,0.1908E+00,0.1964E+00,
     +0.2018E+00,0.2069E+00,0.2117E+00,0.2161E+00,0.2200E+00,0.2234E+00,
     +0.2261E+00,0.2280E+00,0.2291E+00,0.2292E+00,0.2283E+00,0.2262E+00,
     +0.2228E+00,0.2180E+00,0.2118E+00,0.2041E+00,0.1948E+00,0.1840E+00,
     +0.1718E+00,0.1582E+00,0.1435E+00,0.1278E+00,0.1115E+00,0.9494E-01,
     +0.7860E-01,0.6293E-01,0.4840E-01,0.3546E-01,0.2446E-01,0.1563E-01,
     +0.1140E-01,0.8139E-02,0.5672E-02,0.3843E-02,0.2517E-02,0.1582E-02,
     +0.9448E-03,0.5282E-03,0.2708E-03,0.1231E-03,0.4694E-04,0.1351E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.1833E+03,0.1746E+03,0.1663E+03,0.1584E+03,0.1508E+03,0.1435E+03,
     +0.1365E+03,0.1298E+03,0.1234E+03,0.1173E+03,0.1114E+03,0.1059E+03,
     +0.1005E+03,0.9539E+02,0.9050E+02,0.8584E+02,0.8138E+02,0.7712E+02,
     +0.7305E+02,0.6918E+02,0.6548E+02,0.6195E+02,0.5858E+02,0.5537E+02,
     +0.5231E+02,0.4940E+02,0.4663E+02,0.4398E+02,0.4147E+02,0.3908E+02,
     +0.3680E+02,0.3464E+02,0.3259E+02,0.3063E+02,0.2878E+02,0.2702E+02,
     +0.2534E+02,0.2376E+02,0.2226E+02,0.2083E+02,0.1948E+02,0.1820E+02,
     +0.1699E+02,0.1585E+02,0.1477E+02,0.1375E+02,0.1278E+02,0.1187E+02,
     +0.1101E+02,0.1020E+02,0.9436E+01,0.8717E+01,0.8041E+01,0.7405E+01,
     +0.6807E+01,0.6247E+01,0.5721E+01,0.5229E+01,0.4768E+01,0.4338E+01,
     +0.3936E+01,0.3561E+01,0.3213E+01,0.2889E+01,0.2589E+01,0.2311E+01,
     +0.2054E+01,0.1818E+01,0.1601E+01,0.1403E+01,0.1222E+01,0.1058E+01,
     +0.9090E+00,0.7752E+00,0.6555E+00,0.5491E+00,0.4550E+00,0.3726E+00,
     +0.3010E+00,0.2395E+00,0.1871E+00,0.1431E+00,0.1068E+00,0.7733E-01,
     +0.5394E-01,0.3588E-01,0.2238E-01,0.1272E-01,0.6188E-02,0.2107E-02,
     +0.5656E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.3671E+02,0.3510E+02,0.3356E+02,0.3207E+02,0.3065E+02,0.2928E+02,
     +0.2797E+02,0.2671E+02,0.2551E+02,0.2435E+02,0.2324E+02,0.2217E+02,
     +0.2115E+02,0.2017E+02,0.1923E+02,0.1833E+02,0.1747E+02,0.1664E+02,
     +0.1585E+02,0.1509E+02,0.1436E+02,0.1367E+02,0.1300E+02,0.1237E+02,
     +0.1176E+02,0.1117E+02,0.1062E+02,0.1009E+02,0.9576E+01,0.9089E+01,
     +0.8624E+01,0.8179E+01,0.7755E+01,0.7350E+01,0.6962E+01,0.6593E+01,
     +0.6240E+01,0.5903E+01,0.5582E+01,0.5276E+01,0.4983E+01,0.4704E+01,
     +0.4439E+01,0.4185E+01,0.3943E+01,0.3713E+01,0.3493E+01,0.3283E+01,
     +0.3084E+01,0.2893E+01,0.2712E+01,0.2539E+01,0.2374E+01,0.2217E+01,
     +0.2067E+01,0.1924E+01,0.1788E+01,0.1658E+01,0.1534E+01,0.1417E+01,
     +0.1305E+01,0.1198E+01,0.1097E+01,0.1001E+01,0.9097E+00,0.8237E+00,
     +0.7425E+00,0.6660E+00,0.5944E+00,0.5274E+00,0.4652E+00,0.4075E+00,
     +0.3544E+00,0.3059E+00,0.2617E+00,0.2219E+00,0.1862E+00,0.1545E+00,
     +0.1266E+00,0.1022E+00,0.8105E-01,0.6302E-01,0.4783E-01,0.3526E-01,
     +0.2509E-01,0.1712E-01,0.1111E-01,0.6807E-02,0.3911E-02,0.2100E-02,
     +0.1394E-02,0.9288E-03,0.6191E-03,0.4117E-03,0.2716E-03,0.1762E-03,
     +0.1112E-03,0.6717E-04,0.3814E-04,0.1981E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.6707E+01,0.6423E+01,0.6151E+01,0.5889E+01,0.5638E+01,0.5396E+01,
     +0.5164E+01,0.4941E+01,0.4728E+01,0.4522E+01,0.4325E+01,0.4136E+01,
     +0.3955E+01,0.3781E+01,0.3614E+01,0.3454E+01,0.3301E+01,0.3154E+01,
     +0.3013E+01,0.2878E+01,0.2748E+01,0.2624E+01,0.2505E+01,0.2391E+01,
     +0.2282E+01,0.2178E+01,0.2078E+01,0.1982E+01,0.1890E+01,0.1803E+01,
     +0.1719E+01,0.1638E+01,0.1562E+01,0.1488E+01,0.1418E+01,0.1350E+01,
     +0.1286E+01,0.1224E+01,0.1165E+01,0.1108E+01,0.1054E+01,0.1002E+01,
     +0.9527E+00,0.9052E+00,0.8595E+00,0.8158E+00,0.7738E+00,0.7335E+00,
     +0.6948E+00,0.6576E+00,0.6219E+00,0.5875E+00,0.5543E+00,0.5224E+00,
     +0.4916E+00,0.4619E+00,0.4332E+00,0.4056E+00,0.3788E+00,0.3530E+00,
     +0.3281E+00,0.3040E+00,0.2808E+00,0.2584E+00,0.2369E+00,0.2163E+00,
     +0.1966E+00,0.1777E+00,0.1598E+00,0.1429E+00,0.1269E+00,0.1120E+00,
     +0.9812E-01,0.8528E-01,0.7350E-01,0.6276E-01,0.5305E-01,0.4434E-01,
     +0.3659E-01,0.2974E-01,0.2376E-01,0.1857E-01,0.1415E-01,0.1044E-01,
     +0.7411E-02,0.5013E-02,0.3200E-02,0.1906E-02,0.1049E-02,0.5306E-03,
     +0.3375E-03,0.2152E-03,0.1378E-03,0.8864E-04,0.5703E-04,0.3640E-04,
     +0.2277E-04,0.1372E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.6533E+01,0.6250E+01,0.5977E+01,0.5715E+01,0.5464E+01,0.5223E+01,
     +0.4991E+01,0.4768E+01,0.4555E+01,0.4349E+01,0.4153E+01,0.3964E+01,
     +0.3783E+01,0.3609E+01,0.3442E+01,0.3282E+01,0.3129E+01,0.2982E+01,
     +0.2842E+01,0.2707E+01,0.2578E+01,0.2454E+01,0.2335E+01,0.2222E+01,
     +0.2113E+01,0.2009E+01,0.1910E+01,0.1815E+01,0.1724E+01,0.1637E+01,
     +0.1554E+01,0.1474E+01,0.1398E+01,0.1325E+01,0.1256E+01,0.1189E+01,
     +0.1126E+01,0.1066E+01,0.1008E+01,0.9528E+00,0.9002E+00,0.8500E+00,
     +0.8021E+00,0.7564E+00,0.7128E+00,0.6712E+00,0.6315E+00,0.5937E+00,
     +0.5576E+00,0.5232E+00,0.4904E+00,0.4591E+00,0.4292E+00,0.4008E+00,
     +0.3737E+00,0.3478E+00,0.3232E+00,0.2997E+00,0.2773E+00,0.2560E+00,
     +0.2358E+00,0.2165E+00,0.1982E+00,0.1808E+00,0.1644E+00,0.1488E+00,
     +0.1342E+00,0.1204E+00,0.1074E+00,0.9532E-01,0.8407E-01,0.7366E-01,
     +0.6407E-01,0.5530E-01,0.4733E-01,0.4013E-01,0.3367E-01,0.2794E-01,
     +0.2289E-01,0.1847E-01,0.1466E-01,0.1140E-01,0.8661E-02,0.6392E-02,
     +0.4559E-02,0.3121E-02,0.2036E-02,0.1257E-02,0.7303E-03,0.3978E-03,
     +0.2669E-03,0.1797E-03,0.1210E-03,0.8123E-04,0.5403E-04,0.3531E-04,
     +0.2241E-04,0.1362E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.6417E+01,0.6134E+01,0.5861E+01,0.5600E+01,0.5348E+01,0.5107E+01,
     +0.4875E+01,0.4653E+01,0.4439E+01,0.4234E+01,0.4037E+01,0.3849E+01,
     +0.3668E+01,0.3494E+01,0.3327E+01,0.3168E+01,0.3015E+01,0.2868E+01,
     +0.2727E+01,0.2593E+01,0.2464E+01,0.2340E+01,0.2222E+01,0.2109E+01,
     +0.2001E+01,0.1897E+01,0.1798E+01,0.1703E+01,0.1613E+01,0.1526E+01,
     +0.1443E+01,0.1364E+01,0.1289E+01,0.1217E+01,0.1148E+01,0.1082E+01,
     +0.1020E+01,0.9600E+00,0.9032E+00,0.8490E+00,0.7974E+00,0.7483E+00,
     +0.7016E+00,0.6571E+00,0.6149E+00,0.5747E+00,0.5366E+00,0.5004E+00,
     +0.4660E+00,0.4335E+00,0.4027E+00,0.3735E+00,0.3458E+00,0.3197E+00,
     +0.2950E+00,0.2718E+00,0.2498E+00,0.2291E+00,0.2097E+00,0.1914E+00,
     +0.1743E+00,0.1582E+00,0.1432E+00,0.1291E+00,0.1160E+00,0.1039E+00,
     +0.9258E-01,0.8213E-01,0.7249E-01,0.6363E-01,0.5551E-01,0.4811E-01,
     +0.4139E-01,0.3533E-01,0.2989E-01,0.2505E-01,0.2077E-01,0.1701E-01,
     +0.1376E-01,0.1097E-01,0.8601E-02,0.6625E-02,0.5002E-02,0.3693E-02,
     +0.2658E-02,0.1860E-02,0.1261E-02,0.8245E-03,0.5174E-03,0.3093E-03,
     +0.2198E-03,0.1560E-03,0.1098E-03,0.7629E-04,0.5203E-04,0.3458E-04,
     +0.2218E-04,0.1356E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.6199E+01,0.5922E+01,0.5657E+01,0.5402E+01,0.5157E+01,0.4922E+01,
     +0.4696E+01,0.4479E+01,0.4272E+01,0.4072E+01,0.3881E+01,0.3698E+01,
     +0.3522E+01,0.3353E+01,0.3192E+01,0.3037E+01,0.2888E+01,0.2746E+01,
     +0.2610E+01,0.2480E+01,0.2355E+01,0.2235E+01,0.2121E+01,0.2012E+01,
     +0.1907E+01,0.1807E+01,0.1711E+01,0.1620E+01,0.1533E+01,0.1449E+01,
     +0.1370E+01,0.1294E+01,0.1221E+01,0.1152E+01,0.1086E+01,0.1023E+01,
     +0.9631E+00,0.9059E+00,0.8515E+00,0.7997E+00,0.7504E+00,0.7035E+00,
     +0.6589E+00,0.6165E+00,0.5762E+00,0.5380E+00,0.5018E+00,0.4674E+00,
     +0.4348E+00,0.4039E+00,0.3747E+00,0.3471E+00,0.3209E+00,0.2963E+00,
     +0.2730E+00,0.2511E+00,0.2304E+00,0.2110E+00,0.1928E+00,0.1756E+00,
     +0.1596E+00,0.1446E+00,0.1306E+00,0.1175E+00,0.1054E+00,0.9411E-01,
     +0.8368E-01,0.7405E-01,0.6518E-01,0.5706E-01,0.4964E-01,0.4289E-01,
     +0.3679E-01,0.3130E-01,0.2639E-01,0.2204E-01,0.1821E-01,0.1486E-01,
     +0.1197E-01,0.9501E-02,0.7420E-02,0.5690E-02,0.4276E-02,0.3141E-02,
     +0.2250E-02,0.1566E-02,0.1056E-02,0.6862E-03,0.4277E-03,0.2535E-03,
     +0.1792E-03,0.1263E-03,0.8824E-04,0.6080E-04,0.4109E-04,0.2702E-04,
     +0.1713E-04,0.1034E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.4145E+01,0.3948E+01,0.3760E+01,0.3580E+01,0.3407E+01,0.3241E+01,
     +0.3083E+01,0.2931E+01,0.2786E+01,0.2647E+01,0.2515E+01,0.2388E+01,
     +0.2266E+01,0.2150E+01,0.2039E+01,0.1933E+01,0.1832E+01,0.1735E+01,
     +0.1643E+01,0.1555E+01,0.1471E+01,0.1391E+01,0.1314E+01,0.1242E+01,
     +0.1172E+01,0.1106E+01,0.1043E+01,0.9829E+00,0.9258E+00,0.8715E+00,
     +0.8198E+00,0.7707E+00,0.7241E+00,0.6797E+00,0.6376E+00,0.5977E+00,
     +0.5597E+00,0.5238E+00,0.4897E+00,0.4574E+00,0.4268E+00,0.3979E+00,
     +0.3705E+00,0.3447E+00,0.3202E+00,0.2972E+00,0.2754E+00,0.2549E+00,
     +0.2356E+00,0.2174E+00,0.2003E+00,0.1842E+00,0.1691E+00,0.1550E+00,
     +0.1417E+00,0.1293E+00,0.1177E+00,0.1069E+00,0.9685E-01,0.8749E-01,
     +0.7879E-01,0.7073E-01,0.6327E-01,0.5639E-01,0.5006E-01,0.4425E-01,
     +0.3892E-01,0.3407E-01,0.2966E-01,0.2566E-01,0.2206E-01,0.1883E-01,
     +0.1594E-01,0.1339E-01,0.1114E-01,0.9171E-02,0.7466E-02,0.6004E-02,
     +0.4762E-02,0.3719E-02,0.2856E-02,0.2152E-02,0.1588E-02,0.1144E-02,
     +0.8026E-03,0.5462E-03,0.3591E-03,0.2269E-03,0.1367E-03,0.7769E-04,
     +0.5328E-04,0.3630E-04,0.2442E-04,0.1614E-04,0.1042E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.2312E-01,0.2438E-01,0.2571E-01,0.2710E-01,0.2857E-01,0.3012E-01,
     +0.3175E-01,0.3346E-01,0.3527E-01,0.3717E-01,0.3916E-01,0.4126E-01,
     +0.4347E-01,0.4579E-01,0.4823E-01,0.5079E-01,0.5348E-01,0.5631E-01,
     +0.5928E-01,0.6240E-01,0.6567E-01,0.6910E-01,0.7271E-01,0.7649E-01,
     +0.8045E-01,0.8460E-01,0.8895E-01,0.9350E-01,0.9827E-01,0.1033E+00,
     +0.1085E+00,0.1139E+00,0.1196E+00,0.1256E+00,0.1318E+00,0.1383E+00,
     +0.1450E+00,0.1521E+00,0.1594E+00,0.1670E+00,0.1749E+00,0.1831E+00,
     +0.1916E+00,0.2004E+00,0.2095E+00,0.2189E+00,0.2287E+00,0.2387E+00,
     +0.2489E+00,0.2595E+00,0.2703E+00,0.2813E+00,0.2926E+00,0.3040E+00,
     +0.3156E+00,0.3272E+00,0.3390E+00,0.3507E+00,0.3623E+00,0.3738E+00,
     +0.3851E+00,0.3961E+00,0.4066E+00,0.4166E+00,0.4258E+00,0.4343E+00,
     +0.4417E+00,0.4480E+00,0.4530E+00,0.4563E+00,0.4579E+00,0.4575E+00,
     +0.4549E+00,0.4499E+00,0.4423E+00,0.4318E+00,0.4184E+00,0.4019E+00,
     +0.3823E+00,0.3596E+00,0.3340E+00,0.3058E+00,0.2752E+00,0.2429E+00,
     +0.2096E+00,0.1760E+00,0.1432E+00,0.1120E+00,0.8360E-01,0.5875E-01,
     +0.4580E-01,0.3513E-01,0.2644E-01,0.1946E-01,0.1394E-01,0.9672E-02,
     +0.6440E-02,0.4069E-02,0.2397E-02,0.1282E-02,0.5952E-03,0.2199E-03,
     +0.5282E-04,0.0000E+00/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1311E-01,0.1382E-01,0.1457E-01,0.1536E-01,0.1619E-01,0.1706E-01,
     +0.1798E-01,0.1895E-01,0.1996E-01,0.2103E-01,0.2215E-01,0.2333E-01,
     +0.2457E-01,0.2588E-01,0.2725E-01,0.2868E-01,0.3019E-01,0.3178E-01,
     +0.3344E-01,0.3518E-01,0.3701E-01,0.3893E-01,0.4094E-01,0.4305E-01,
     +0.4525E-01,0.4756E-01,0.4998E-01,0.5251E-01,0.5515E-01,0.5791E-01,
     +0.6079E-01,0.6380E-01,0.6694E-01,0.7021E-01,0.7362E-01,0.7717E-01,
     +0.8086E-01,0.8469E-01,0.8867E-01,0.9280E-01,0.9707E-01,0.1015E+00,
     +0.1061E+00,0.1108E+00,0.1156E+00,0.1206E+00,0.1258E+00,0.1310E+00,
     +0.1364E+00,0.1419E+00,0.1474E+00,0.1531E+00,0.1588E+00,0.1645E+00,
     +0.1703E+00,0.1760E+00,0.1816E+00,0.1872E+00,0.1926E+00,0.1979E+00,
     +0.2029E+00,0.2076E+00,0.2120E+00,0.2159E+00,0.2192E+00,0.2220E+00,
     +0.2241E+00,0.2254E+00,0.2258E+00,0.2253E+00,0.2236E+00,0.2208E+00,
     +0.2167E+00,0.2112E+00,0.2044E+00,0.1961E+00,0.1864E+00,0.1753E+00,
     +0.1628E+00,0.1491E+00,0.1345E+00,0.1191E+00,0.1032E+00,0.8729E-01,
     +0.7173E-01,0.5696E-01,0.4343E-01,0.3151E-01,0.2150E-01,0.1357E-01,
     +0.9810E-02,0.6942E-02,0.4793E-02,0.3214E-02,0.2082E-02,0.1293E-02,
     +0.7612E-03,0.4188E-03,0.2106E-03,0.9344E-04,0.3449E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2099E+03,0.1996E+03,0.1897E+03,0.1802E+03,0.1712E+03,0.1626E+03,
     +0.1543E+03,0.1464E+03,0.1389E+03,0.1317E+03,0.1249E+03,0.1183E+03,
     +0.1121E+03,0.1062E+03,0.1005E+03,0.9508E+02,0.8992E+02,0.8501E+02,
     +0.8034E+02,0.7588E+02,0.7165E+02,0.6761E+02,0.6378E+02,0.6013E+02,
     +0.5666E+02,0.5337E+02,0.5024E+02,0.4726E+02,0.4444E+02,0.4176E+02,
     +0.3922E+02,0.3682E+02,0.3453E+02,0.3237E+02,0.3032E+02,0.2838E+02,
     +0.2655E+02,0.2481E+02,0.2317E+02,0.2162E+02,0.2016E+02,0.1877E+02,
     +0.1747E+02,0.1624E+02,0.1508E+02,0.1399E+02,0.1296E+02,0.1200E+02,
     +0.1109E+02,0.1024E+02,0.9435E+01,0.8684E+01,0.7980E+01,0.7320E+01,
     +0.6704E+01,0.6127E+01,0.5589E+01,0.5087E+01,0.4620E+01,0.4185E+01,
     +0.3781E+01,0.3406E+01,0.3059E+01,0.2738E+01,0.2442E+01,0.2170E+01,
     +0.1920E+01,0.1691E+01,0.1482E+01,0.1292E+01,0.1120E+01,0.9640E+00,
     +0.8242E+00,0.6992E+00,0.5880E+00,0.4898E+00,0.4036E+00,0.3286E+00,
     +0.2639E+00,0.2086E+00,0.1619E+00,0.1230E+00,0.9107E-01,0.6538E-01,
     +0.4516E-01,0.2969E-01,0.1824E-01,0.1014E-01,0.4738E-02,0.1430E-02,
     +0.2125E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.4357E+02,0.4159E+02,0.3970E+02,0.3788E+02,0.3614E+02,0.3447E+02,
     +0.3287E+02,0.3134E+02,0.2987E+02,0.2847E+02,0.2712E+02,0.2583E+02,
     +0.2459E+02,0.2341E+02,0.2228E+02,0.2120E+02,0.2016E+02,0.1917E+02,
     +0.1822E+02,0.1732E+02,0.1645E+02,0.1563E+02,0.1484E+02,0.1408E+02,
     +0.1336E+02,0.1267E+02,0.1201E+02,0.1139E+02,0.1079E+02,0.1022E+02,
     +0.9674E+01,0.9155E+01,0.8660E+01,0.8188E+01,0.7738E+01,0.7310E+01,
     +0.6902E+01,0.6514E+01,0.6144E+01,0.5792E+01,0.5457E+01,0.5138E+01,
     +0.4835E+01,0.4547E+01,0.4272E+01,0.4011E+01,0.3763E+01,0.3527E+01,
     +0.3303E+01,0.3090E+01,0.2887E+01,0.2695E+01,0.2512E+01,0.2338E+01,
     +0.2173E+01,0.2016E+01,0.1867E+01,0.1726E+01,0.1592E+01,0.1465E+01,
     +0.1344E+01,0.1230E+01,0.1122E+01,0.1020E+01,0.9236E+00,0.8331E+00,
     +0.7481E+00,0.6685E+00,0.5942E+00,0.5252E+00,0.4613E+00,0.4024E+00,
     +0.3485E+00,0.2995E+00,0.2551E+00,0.2153E+00,0.1798E+00,0.1484E+00,
     +0.1209E+00,0.9707E-01,0.7656E-01,0.5915E-01,0.4459E-01,0.3263E-01,
     +0.2305E-01,0.1561E-01,0.1006E-01,0.6121E-02,0.3495E-02,0.1866E-02,
     +0.1235E-02,0.8199E-03,0.5442E-03,0.3599E-03,0.2358E-03,0.1516E-03,
     +0.9465E-04,0.5650E-04,0.3163E-04,0.1616E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.7841E+01,0.7496E+01,0.7165E+01,0.6848E+01,0.6544E+01,0.6252E+01,
     +0.5973E+01,0.5705E+01,0.5448E+01,0.5201E+01,0.4965E+01,0.4739E+01,
     +0.4522E+01,0.4315E+01,0.4116E+01,0.3926E+01,0.3744E+01,0.3570E+01,
     +0.3403E+01,0.3244E+01,0.3091E+01,0.2945E+01,0.2805E+01,0.2672E+01,
     +0.2544E+01,0.2422E+01,0.2306E+01,0.2194E+01,0.2088E+01,0.1986E+01,
     +0.1889E+01,0.1797E+01,0.1708E+01,0.1624E+01,0.1543E+01,0.1466E+01,
     +0.1392E+01,0.1322E+01,0.1255E+01,0.1190E+01,0.1129E+01,0.1071E+01,
     +0.1015E+01,0.9614E+00,0.9104E+00,0.8615E+00,0.8148E+00,0.7701E+00,
     +0.7273E+00,0.6863E+00,0.6470E+00,0.6093E+00,0.5731E+00,0.5384E+00,
     +0.5051E+00,0.4731E+00,0.4423E+00,0.4127E+00,0.3842E+00,0.3568E+00,
     +0.3305E+00,0.3052E+00,0.2810E+00,0.2577E+00,0.2354E+00,0.2142E+00,
     +0.1940E+00,0.1747E+00,0.1566E+00,0.1395E+00,0.1235E+00,0.1085E+00,
     +0.9471E-01,0.8200E-01,0.7039E-01,0.5985E-01,0.5037E-01,0.4191E-01,
     +0.3441E-01,0.2782E-01,0.2210E-01,0.1717E-01,0.1299E-01,0.9517E-02,
     +0.6701E-02,0.4496E-02,0.2847E-02,0.1683E-02,0.9199E-03,0.4626E-03,
     +0.2936E-03,0.1869E-03,0.1195E-03,0.7660E-04,0.4906E-04,0.3111E-04,
     +0.1929E-04,0.1150E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.7667E+01,0.7322E+01,0.6992E+01,0.6675E+01,0.6371E+01,0.6079E+01,
     +0.5800E+01,0.5532E+01,0.5275E+01,0.5028E+01,0.4793E+01,0.4567E+01,
     +0.4350E+01,0.4143E+01,0.3945E+01,0.3755E+01,0.3573E+01,0.3399E+01,
     +0.3232E+01,0.3073E+01,0.2921E+01,0.2775E+01,0.2636E+01,0.2503E+01,
     +0.2376E+01,0.2255E+01,0.2139E+01,0.2028E+01,0.1922E+01,0.1821E+01,
     +0.1725E+01,0.1633E+01,0.1546E+01,0.1462E+01,0.1382E+01,0.1306E+01,
     +0.1234E+01,0.1165E+01,0.1099E+01,0.1037E+01,0.9769E+00,0.9201E+00,
     +0.8661E+00,0.8147E+00,0.7657E+00,0.7191E+00,0.6748E+00,0.6327E+00,
     +0.5926E+00,0.5544E+00,0.5182E+00,0.4837E+00,0.4509E+00,0.4198E+00,
     +0.3902E+00,0.3621E+00,0.3354E+00,0.3100E+00,0.2860E+00,0.2631E+00,
     +0.2415E+00,0.2210E+00,0.2016E+00,0.1833E+00,0.1660E+00,0.1498E+00,
     +0.1345E+00,0.1202E+00,0.1069E+00,0.9449E-01,0.8302E-01,0.7244E-01,
     +0.6276E-01,0.5394E-01,0.4596E-01,0.3879E-01,0.3240E-01,0.2675E-01,
     +0.2180E-01,0.1750E-01,0.1381E-01,0.1067E-01,0.8054E-02,0.5903E-02,
     +0.4180E-02,0.2841E-02,0.1840E-02,0.1129E-02,0.6515E-03,0.3529E-03,
     +0.2359E-03,0.1582E-03,0.1061E-03,0.7079E-04,0.4674E-04,0.3028E-04,
     +0.1902E-04,0.1142E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.7551E+01,0.7206E+01,0.6876E+01,0.6559E+01,0.6255E+01,0.5964E+01,
     +0.5684E+01,0.5416E+01,0.5159E+01,0.4913E+01,0.4677E+01,0.4452E+01,
     +0.4235E+01,0.4028E+01,0.3830E+01,0.3640E+01,0.3459E+01,0.3285E+01,
     +0.3119E+01,0.2960E+01,0.2808E+01,0.2662E+01,0.2523E+01,0.2391E+01,
     +0.2264E+01,0.2143E+01,0.2027E+01,0.1917E+01,0.1812E+01,0.1711E+01,
     +0.1615E+01,0.1524E+01,0.1437E+01,0.1354E+01,0.1275E+01,0.1200E+01,
     +0.1128E+01,0.1060E+01,0.9954E+00,0.9338E+00,0.8753E+00,0.8197E+00,
     +0.7669E+00,0.7167E+00,0.6692E+00,0.6241E+00,0.5814E+00,0.5410E+00,
     +0.5027E+00,0.4665E+00,0.4323E+00,0.4000E+00,0.3695E+00,0.3407E+00,
     +0.3136E+00,0.2881E+00,0.2641E+00,0.2416E+00,0.2205E+00,0.2007E+00,
     +0.1822E+00,0.1649E+00,0.1488E+00,0.1337E+00,0.1198E+00,0.1069E+00,
     +0.9492E-01,0.8391E-01,0.7379E-01,0.6453E-01,0.5608E-01,0.4841E-01,
     +0.4148E-01,0.3525E-01,0.2969E-01,0.2477E-01,0.2043E-01,0.1666E-01,
     +0.1340E-01,0.1063E-01,0.8289E-02,0.6349E-02,0.4765E-02,0.3496E-02,
     +0.2500E-02,0.1738E-02,0.1170E-02,0.7591E-03,0.4724E-03,0.2796E-03,
     +0.1974E-03,0.1391E-03,0.9714E-04,0.6691E-04,0.4520E-04,0.2973E-04,
     +0.1885E-04,0.1138E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.7337E+01,0.6999E+01,0.6675E+01,0.6365E+01,0.6067E+01,0.5782E+01,
     +0.5509E+01,0.5247E+01,0.4995E+01,0.4755E+01,0.4525E+01,0.4304E+01,
     +0.4093E+01,0.3891E+01,0.3697E+01,0.3512E+01,0.3335E+01,0.3166E+01,
     +0.3004E+01,0.2849E+01,0.2701E+01,0.2560E+01,0.2425E+01,0.2296E+01,
     +0.2173E+01,0.2055E+01,0.1943E+01,0.1836E+01,0.1734E+01,0.1637E+01,
     +0.1544E+01,0.1456E+01,0.1371E+01,0.1291E+01,0.1215E+01,0.1142E+01,
     +0.1073E+01,0.1008E+01,0.9452E+00,0.8859E+00,0.8296E+00,0.7762E+00,
     +0.7255E+00,0.6774E+00,0.6318E+00,0.5886E+00,0.5477E+00,0.5090E+00,
     +0.4725E+00,0.4379E+00,0.4053E+00,0.3745E+00,0.3455E+00,0.3181E+00,
     +0.2924E+00,0.2682E+00,0.2455E+00,0.2242E+00,0.2042E+00,0.1856E+00,
     +0.1681E+00,0.1519E+00,0.1367E+00,0.1227E+00,0.1096E+00,0.9760E-01,
     +0.8648E-01,0.7626E-01,0.6689E-01,0.5833E-01,0.5055E-01,0.4350E-01,
     +0.3716E-01,0.3148E-01,0.2643E-01,0.2197E-01,0.1806E-01,0.1467E-01,
     +0.1176E-01,0.9283E-02,0.7210E-02,0.5498E-02,0.4107E-02,0.2999E-02,
     +0.2134E-02,0.1475E-02,0.9872E-03,0.6367E-03,0.3934E-03,0.2308E-03,
     +0.1620E-03,0.1133E-03,0.7850E-04,0.5361E-04,0.3587E-04,0.2333E-04,
     +0.1462E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.5333E+01,0.5074E+01,0.4826E+01,0.4588E+01,0.4361E+01,0.4144E+01,
     +0.3936E+01,0.3737E+01,0.3548E+01,0.3366E+01,0.3193E+01,0.3028E+01,
     +0.2870E+01,0.2719E+01,0.2575E+01,0.2438E+01,0.2307E+01,0.2182E+01,
     +0.2063E+01,0.1950E+01,0.1841E+01,0.1738E+01,0.1640E+01,0.1547E+01,
     +0.1458E+01,0.1374E+01,0.1294E+01,0.1217E+01,0.1145E+01,0.1076E+01,
     +0.1010E+01,0.9483E+00,0.8894E+00,0.8335E+00,0.7805E+00,0.7303E+00,
     +0.6828E+00,0.6378E+00,0.5952E+00,0.5549E+00,0.5169E+00,0.4809E+00,
     +0.4470E+00,0.4150E+00,0.3848E+00,0.3564E+00,0.3296E+00,0.3044E+00,
     +0.2807E+00,0.2585E+00,0.2376E+00,0.2180E+00,0.1997E+00,0.1826E+00,
     +0.1666E+00,0.1516E+00,0.1377E+00,0.1247E+00,0.1127E+00,0.1015E+00,
     +0.9118E-01,0.8162E-01,0.7281E-01,0.6470E-01,0.5725E-01,0.5044E-01,
     +0.4423E-01,0.3858E-01,0.3347E-01,0.2885E-01,0.2471E-01,0.2101E-01,
     +0.1772E-01,0.1482E-01,0.1228E-01,0.1007E-01,0.8157E-02,0.6528E-02,
     +0.5152E-02,0.4003E-02,0.3057E-02,0.2291E-02,0.1680E-02,0.1203E-02,
     +0.8379E-03,0.5660E-03,0.3691E-03,0.2311E-03,0.1378E-03,0.7731E-04,
     +0.5254E-04,0.3545E-04,0.2360E-04,0.1542E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
