{if="$edit"}
    <a class="button action color green" onclick="Rooms_ajaxDisplay(false)">
        <i class="material-icons">check</i>
    </a>
{/if}

{$previousConnected = true}

{if="!$c->supported('anonymous') && $c->getView() != 'room'"}
    <ul class="list divided spaced middle {if="!$edit"}active{/if}">
        <li class="subheader" title="{$c->__('page.configuration')}">
            {if="$conferences->isNotEmpty() && !$edit"}
            <span class="control icon active gray" onclick="Rooms_ajaxDisplay(true);">
                <i class="material-icons">edit</i>
            </span>
            <span class="control icon active gray" onclick="Rooms_ajaxAdd()">
                <i class="material-icons">add</i>
            </span>
            {/if}
            <p>
                <span class="info">{$conferences|count}</span>
                {$c->__('chatrooms.title')}
            </p>
        </li>
        {loop="$conferences"}
            {$connected = $value->presence}
            {if="!$connected && $previousConnected"}
                </ul>
                <ul class="list divided thin spaced {if="!$edit"}active{/if}">
            {/if}
            {$previousConnected = $connected}
            <li {if="!$edit"} data-jid="{$value->conference}" {/if}
                {if="$value->nick != null"} data-nick="{$value->nick}" {/if}
                class="room {if="$connected"}online{/if}"
                title="{$value->conference}">
                {$url = $value->getPhoto()}
                {if="$url"}
                    <span class="primary
                        {if="!$connected"}disabled small{/if} icon bubble color
                        {$value->name|stringToColor}"
                        id="{$value->conference|cleanupId}-rooms-primary"
                        style="background-image: url({$url});">
                        <span data-key="chat|{$value->conference}" class="counter"></span>
                    </span>
                {else}
                    <span class="primary
                        {if="!$connected"}disabled small{/if} icon bubble color
                        {$value->name|stringToColor}"
                        id="{$value->conference|cleanupId}-rooms-primary">
                        <span data-key="chat|{$value->conference}" class="counter"></span>
                        {autoescape="off"}
                            {if="$connected"}
                                {$value->name|firstLetterCapitalize|addEmojis}
                            {else}
                                {$value->name|firstLetterCapitalize:true|addEmojis}
                            {/if}
                        {/autoescape}
                    </span>
                {/if}

                {$info = $value->info}
                {if="$edit"}
                    <span class="control icon active gray" onclick="Rooms_ajaxRemoveConfirm('{$value->conference}');">
                        <i class="material-icons">delete</i>
                    </span>
                    <span class="control icon active gray" onclick="Rooms_ajaxAdd('{$value->conference}');">
                        <i class="material-icons">edit</i>
                    </span>
                {/if}

                <p class="normal line">
                    {$value->name}
                    {if="$connected"}
                        <span class="second">{$value->conference}</span>
                    {else}
                        –
                    {/if}
                {if="$connected"}
                </p>
                <p class="line"
                    {if="isset($info) && $info->description"}title="{$info->description}"{/if}>
                {/if}
                    {if="$connected"}
                        {$count = $value->presences()->count()}
                        <span title="{$c->__('communitydata.sub', $count)}"
                            {if="$connected && $connected->mucrole == 'moderator'"}
                                class="moderator"
                            {/if}>
                            {$count} <i class="material-icons">people</i>
                            {if="$value->info && !$value->info->mucsemianonymous"}
                                <i class="material-icons">wifi_tethering</i>
                            {/if}
                        </span>  –
                    {elseif="isset($info) && $info->occupants > 0"}
                        <span title="{$c->__('communitydata.sub', $info->occupants)}"
                            {if="$connected && $connected->mucrole == 'moderator'"}
                                class="moderator"
                            {/if}>
                            {$info->occupants} <i class="material-icons">people</i>
                            {if="$value->info && !$value->info->mucsemianonymous"}
                                <i class="material-icons">wifi_tethering</i>
                            {/if}
                        </span>  –
                    {/if}
                    {if="$connected"}
                        {if="isset($info) && $info->description"}
                            {$info->description}
                        {else}
                            {$value->conference}
                        {/if}
                    {else}
                        <span class="second">{$value->conference}</span>
                    {/if}
                </p>
            </li>
        {/loop}
    </ul>
    {if="$conferences->isEmpty()"}
    <ul class="list thick spaced">
        <li>
            <span class="primary icon green">
                <i class="material-icons">people_outline</i>
            </span>
            <p>{$c->__('rooms.empty_text1')}</p>
            <p>{$c->__('rooms.empty_text2')}</p>
        </li>
    </ul>
    {/if}

    <ul class="list thick spaced active {if="$edit"}disabled{/if}">
        <li onclick="Rooms_ajaxAdd()">
            <span class="primary icon bubble color green">
                <i class="material-icons">group_add</i>
            </span>
            <p class="normal">{$c->__('rooms.add')}</p>
        </li>
    </ul>
{else}
    {if="$c->getView() == 'room' && $room != false"}
        <div class="placeholder">
            <i class="material-icons">people</i>
            <h1>{$c->__('room.anonymous_title')}</h1>
            <h4>{$c->__('room.anonymous_login', $room)}</h4>
        </div>
        <ul class="list thick">
            <li>
                <form
                    name="loginanonymous">
                    <div>
                        <input type="text" name="nick" id="nick" required
                            placeholder="{$c->__('room.nick')}"/>
                        <label for="nick">{$c->__('room.nick')}</label>
                    </div>
                    <div>
                        <input
                            type="submit"
                            value="{$c->__('page.login')}"
                            class="button flat oppose"/>
                    </div>
                </form>
            </li>
        </ul>

        <script type="text/javascript">
            Rooms.anonymous_room = '{$room}';
        </script>
    {elseif="$c->getView() == 'room'"}
        <div class="placeholder">
            <i class="material-icons">people</i>
            <h1>{$c->__('room.anonymous_title')}</h1>
            <h4>{$c->__('room.no_room')}</h4>
        </div>
    {else}
        <div class="placeholder">
            <i class="material-icons">people</i>
            <h1>{$c->__('room.anonymous_title')}</h1>
            <h4>{$c->__('room.anonymous_text1')}</h4>
            <h4>{$c->__('room.anonymous_text2')}</h4>
        </div>
    {/if}
{/if}
