/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.parse;

import com.jclark.util.Hashtable;
import com.jclark.xml.parse.ApplicationException;
import com.jclark.xml.parse.AttributeDefinition;
import com.jclark.xml.parse.CharacterDataEvent;
import com.jclark.xml.parse.CommentEvent;
import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.ElementType;
import com.jclark.xml.parse.EndCdataSectionEvent;
import com.jclark.xml.parse.EndDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.EndElementEvent;
import com.jclark.xml.parse.EndEntityReferenceEvent;
import com.jclark.xml.parse.EndPrologEvent;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.EntityManager;
import com.jclark.xml.parse.MarkupDeclarationEvent;
import com.jclark.xml.parse.NotWellFormedException;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.ParseLocation;
import com.jclark.xml.parse.ProcessingInstructionEvent;
import com.jclark.xml.parse.StartCdataSectionEvent;
import com.jclark.xml.parse.StartDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.StartEntityReferenceEvent;
import com.jclark.xml.parse.base.Application;
import com.jclark.xml.tok.Buffer;
import com.jclark.xml.tok.ContentToken;
import com.jclark.xml.tok.EmptyTokenException;
import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.EndOfPrologException;
import com.jclark.xml.tok.ExtensibleTokenException;
import com.jclark.xml.tok.InvalidTokenException;
import com.jclark.xml.tok.PartialTokenException;
import com.jclark.xml.tok.Position;
import com.jclark.xml.tok.PrologParser;
import com.jclark.xml.tok.PrologSyntaxException;
import com.jclark.xml.tok.StringConversionCache;
import com.jclark.xml.tok.TextDecl;
import com.jclark.xml.tok.Token;
import com.jclark.xml.tok.TokenException;
import com.jclark.xml.tok.XmlDecl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

class EntityParser
extends ContentToken
implements StartElementEvent,
EndElementEvent,
CharacterDataEvent,
ProcessingInstructionEvent,
EndPrologEvent,
CommentEvent,
StartCdataSectionEvent,
EndCdataSectionEvent,
StartEntityReferenceEvent,
EndEntityReferenceEvent,
ParseLocation {
    private static final boolean forceStandalone = false;
    private static final int READSIZE = 8192;
    private static final StartEntityReferenceEvent startExternalSubsetEvent = new StartExternalSubsetEvent();
    private EntityParser parent;
    private String internalEntityName;
    private boolean isParameterEntity;
    private byte[] buf;
    private int bufStart;
    private int bufEnd;
    private int currentTokenStart;
    private InputStream in;
    private URL baseURL;
    private String location;
    private Position pos = new Position();
    private int posOff;
    private long bufEndStreamOffset;
    private Encoding enc;
    private boolean ignoreDeclEnc;
    private int minBPC;
    private int fixBPC;
    private StringConversionCache stringCache;
    private Encoding internalEnc;
    private StringConversionCache internalStringCache;
    private Application app;
    private DTDImpl dtd;
    private EntityManager entityManager;
    private Locale locale;
    private int nameStart;
    private Buffer valueBuf;
    private char[] data;
    private static final int INIT_DATA_BUF_SIZE = 65;
    private int dataLength;
    private char[] dataBuf;
    private boolean dataIsRef;
    private String[] attValues;
    private String[] attNames;
    private int nAttributes;
    private int idAttributeIndex;
    private boolean[] defaultSpecified;

    private final void storeAtts() throws NotWellFormedException {
        int n = this.getAttributeSpecifiedCount();
        ElementTypeImpl elementTypeImpl = null;
        boolean bl = false;
        while (n != 0) {
            boolean bl2;
            String string;
            if (this.isAttributeNormalized(--n)) continue;
            this.valueBuf.clear();
            if (!bl) {
                elementTypeImpl = (ElementTypeImpl)this.dtd.elementTypeTable.get(this.stringCache.convert(this.buf, this.bufStart + this.minBPC, this.getNameEnd(), true));
            }
            if (elementTypeImpl != null) {
                string = this.stringCache.convert(this.buf, this.getAttributeNameStart(n), this.getAttributeNameEnd(n), true);
                bl2 = elementTypeImpl.isAttributeCdata(string);
            } else {
                bl2 = true;
            }
            string = this.makeAttributeValue(bl2, this.buf, this.getAttributeValueStart(n), this.getAttributeValueEnd(n));
            this.setAttributeValue(n, string);
        }
    }

    private void buildAttributes() {
        int n;
        ElementTypeImpl elementTypeImpl = (ElementTypeImpl)this.dtd.elementTypeTable.get(this.getName());
        int n2 = n = this.getAttributeSpecifiedCount();
        if (elementTypeImpl != null) {
            n2 += elementTypeImpl.getDefaultAttributeCount();
        }
        if (this.attNames == null || n2 > this.attNames.length) {
            this.attNames = new String[n2];
        }
        n2 = n;
        while (--n2 >= 0) {
            this.attNames[n2] = this.stringCache.convert(this.buf, this.getAttributeNameStart(n2), this.getAttributeNameEnd(n2), true);
        }
        this.nAttributes = n;
        this.idAttributeIndex = -1;
        if (elementTypeImpl != null) {
            int n3;
            n2 = elementTypeImpl.getDefaultAttributeCount();
            if (this.defaultSpecified == null || n2 > this.defaultSpecified.length) {
                this.defaultSpecified = new boolean[n2];
            } else {
                n3 = 0;
                while (n3 < n2) {
                    this.defaultSpecified[n3] = false;
                    ++n3;
                }
            }
            n3 = n;
            while (--n3 >= 0) {
                int n4 = elementTypeImpl.getAttributeDefaultIndex(this.attNames[n3]);
                if (n4 >= 0) {
                    this.defaultSpecified[n4] = true;
                    continue;
                }
                if (n4 != -2) continue;
                this.idAttributeIndex = n3;
            }
            n3 = 0;
            while (n3 < n2) {
                if (!this.defaultSpecified[n3]) {
                    this.setAttributeValue(this.nAttributes, elementTypeImpl.getDefaultAttributeValue(n3));
                    this.attNames[this.nAttributes] = elementTypeImpl.getDefaultAttributeName(n3);
                    ++this.nAttributes;
                }
                ++n3;
            }
        }
    }

    private final int tokenizeProlog() throws IOException, EmptyTokenException, EndOfPrologException {
        while (true) {
            try {
                int n = this.enc.tokenizeProlog(this.buf, this.bufStart, this.bufEnd, this);
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.getTokenEnd();
                return n;
            }
            catch (EmptyTokenException emptyTokenException) {
                if (this.fill()) continue;
                throw emptyTokenException;
            }
            catch (PartialTokenException partialTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                this.fatal("UNCLOSED_TOKEN");
                continue;
            }
            catch (ExtensibleTokenException extensibleTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                return extensibleTokenException.getTokenType();
            }
            catch (InvalidTokenException invalidTokenException) {
                this.bufStart = this.currentTokenStart = invalidTokenException.getOffset();
                this.reportInvalidToken(invalidTokenException);
                continue;
            }
            break;
        }
    }

    public int getLengthMax() {
        if (this.data != null) {
            return this.dataLength;
        }
        return (this.getTokenEnd() - this.bufStart) / this.minBPC;
    }

    private boolean fill() throws IOException {
        int n;
        if (this.in == null) {
            return false;
        }
        if (this.bufEnd == this.buf.length) {
            this.enc.movePosition(this.buf, this.posOff, this.bufStart, this.pos);
            n = this.bufEnd - this.bufStart;
            if (n == 0) {
                this.bufEnd = 0;
            } else if (n + 8192 <= this.buf.length) {
                this.bufEnd = this.buf.length - (this.buf.length - n) / 8192 * 8192;
                int n2 = 0;
                while (n2 < n) {
                    this.buf[this.bufEnd - n + n2] = this.buf[this.bufStart + n2];
                    ++n2;
                }
            } else {
                byte[] byArray = new byte[this.buf.length << 1];
                this.bufEnd = this.buf.length;
                System.arraycopy(this.buf, this.bufStart, byArray, this.bufEnd - n, n);
                this.buf = byArray;
            }
            this.posOff = this.bufStart = this.bufEnd - n;
        }
        if ((n = this.in.read(this.buf, this.bufEnd, this.buf.length - this.bufEnd)) < 0) {
            this.in.close();
            this.in = null;
            return false;
        }
        this.bufEnd += n;
        this.bufEndStreamOffset += (long)n;
        return true;
    }

    public final String getInstruction() {
        return this.normalizeNewlines(this.stringCache.convert(this.buf, this.enc.skipS(this.buf, this.getNameEnd(), this.getTokenEnd()), this.getTokenEnd() - 2 * this.minBPC, false));
    }

    public final String getComment() {
        return this.normalizeNewlines(this.stringCache.convert(this.buf, this.currentTokenStart + 4 * this.minBPC, this.getTokenEnd() - 3 * this.minBPC, false));
    }

    public int getColumnNumber() {
        return this.pos.getColumnNumber();
    }

    void parseDocumentEntity() throws IOException, ApplicationException {
        block8: {
            try {
                try {
                    this.app.startDocument();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new ApplicationException(exception);
                }
                this.parseDecls((byte)0);
                this.parseContent(true);
                this.parseMisc();
                try {
                    this.app.endDocument();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new ApplicationException(exception);
                }
                Object var3_5 = null;
                if (this.in == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var3_6 = null;
                    if (this.in == null) break block9;
                    this.in.close();
                    this.in = null;
                }
                throw throwable;
            }
            this.in.close();
            this.in = null;
        }
    }

    public int getLength() {
        if (this.data == null) {
            if (this.fixBPC != 0) {
                return (this.getTokenEnd() - this.bufStart) / this.fixBPC;
            }
            this.convertData(this.bufStart, this.getTokenEnd());
        }
        return this.dataLength;
    }

    public int copyChars(char[] cArray, int n) {
        if (this.data != null) {
            System.arraycopy(this.data, 0, cArray, n, this.dataLength);
            return this.dataLength;
        }
        return this.enc.convert(this.buf, this.bufStart, this.getTokenEnd(), cArray, n);
    }

    public long getByteIndex() {
        return this.getEntityByteIndex(this.currentTokenStart);
    }

    public final String getAttributeValue(int n) {
        if (this.nAttributes < 0) {
            this.buildAttributes();
        }
        if (n < this.getAttributeSpecifiedCount()) {
            if (this.isAttributeNormalized(n)) {
                return this.stringCache.convert(this.buf, this.getAttributeValueStart(n), this.getAttributeValueEnd(n), false);
            }
        } else if (n >= this.nAttributes) {
            throw new IndexOutOfBoundsException();
        }
        return this.attValues[n];
    }

    public final String getAttributeValue(String string) {
        if (this.nAttributes < 0) {
            this.buildAttributes();
        }
        int n = 0;
        while (n < this.nAttributes) {
            if (this.attNames[n].equals(string)) {
                if (n < this.getAttributeSpecifiedCount() && this.isAttributeNormalized(n)) {
                    return this.stringCache.convert(this.buf, this.getAttributeValueStart(n), this.getAttributeValueEnd(n), false);
                }
                return this.attValues[n];
            }
            ++n;
        }
        return null;
    }

    private void appendAttributeValue(boolean bl, int n, int n2, Buffer buffer) throws NotWellFormedException {
        Token token = new Token();
        try {
            while (true) {
                int n3;
                int n4;
                try {
                    n4 = this.enc.tokenizeAttributeValue(this.buf, n, n2, token);
                    n3 = token.getTokenEnd();
                }
                catch (ExtensibleTokenException extensibleTokenException) {
                    n4 = extensibleTokenException.getTokenType();
                    n3 = n2;
                }
                this.currentTokenStart = n;
                switch (n4) {
                    case 0: {
                        buffer.append(this.enc, this.buf, n, token.getTokenEnd());
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (!bl && token.getRefChar() == ' ' && (buffer.length() <= 0 || buffer.charAt(buffer.length() - 1) == ' ')) break;
                        buffer.append(token.getRefChar());
                        break;
                    }
                    case 12: {
                        buffer.appendRefCharPair(token);
                        break;
                    }
                    case 1: 
                    case 16: {
                        if (!bl && (buffer.length() <= 0 || buffer.charAt(buffer.length() - 1) == ' ')) break;
                        buffer.append(' ');
                        break;
                    }
                    case 9: {
                        String string = this.stringCache.convert(this.buf, n + this.minBPC, token.getTokenEnd() - this.minBPC, true);
                        EntityImpl entityImpl = (EntityImpl)this.dtd.generalEntityTable.get(string);
                        if (entityImpl == null) {
                            if (!this.dtd.complete && !this.dtd.standalone) break;
                            this.fatal("UNDEF_REF", string);
                            break;
                        }
                        if (entityImpl.systemId != null) {
                            this.fatal("EXTERN_REF_ATTVAL");
                        }
                        try {
                            EntityParser entityParser = this.makeParserForEntity(entityImpl, string, false);
                            entityImpl.open = true;
                            entityParser.appendAttributeValue(bl, 0, entityParser.bufEnd, buffer);
                            entityImpl.open = false;
                            break;
                        }
                        catch (NotWellFormedException notWellFormedException) {
                            throw notWellFormedException;
                        }
                        catch (IOException iOException) {
                            throw new Error("unexpected IOException");
                        }
                    }
                    default: {
                        throw new Error("attribute value botch");
                    }
                }
                n = n3;
            }
        }
        catch (PartialTokenException partialTokenException) {
            this.currentTokenStart = n2;
            this.fatal("NOT_WELL_FORMED");
            return;
        }
        catch (InvalidTokenException invalidTokenException) {
            this.currentTokenStart = invalidTokenException.getOffset();
            this.reportInvalidToken(invalidTokenException);
            return;
        }
        catch (EmptyTokenException emptyTokenException) {
            return;
        }
    }

    private void fatal(String string) throws NotWellFormedException {
        this.doFatal(string, null);
    }

    private void fatal(String string, Object object) throws NotWellFormedException {
        this.doFatal(string, new Object[]{object});
    }

    private void fatal(String string, Object object, Object object2) throws NotWellFormedException {
        this.doFatal(string, new Object[]{object, object2});
    }

    private final void setAttributeValue(int n, String string) {
        if (this.attValues == null) {
            this.attValues = new String[n + 10];
        } else if (n >= this.attValues.length) {
            String[] stringArray = new String[n << 1];
            System.arraycopy(this.attValues, 0, stringArray, 0, this.attValues.length);
            this.attValues = stringArray;
        }
        this.attValues[n] = string;
    }

    private void convertData(int n, int n2) {
        if (this.dataBuf == null || this.dataBuf.length * this.minBPC < n2 - n) {
            this.dataBuf = new char[(n2 - n) / this.minBPC];
        }
        this.dataLength = this.enc.convert(this.buf, n, n2, this.dataBuf, 0);
        this.data = this.dataBuf;
    }

    private void handleXmlDecl(boolean bl) throws NotWellFormedException {
        try {
            TextDecl textDecl;
            if (bl) {
                textDecl = new TextDecl(this.enc, this.buf, this.currentTokenStart, this.bufStart);
            } else {
                XmlDecl xmlDecl = new XmlDecl(this.enc, this.buf, this.currentTokenStart, this.bufStart);
                this.dtd.standalone = xmlDecl.isStandalone();
                textDecl = xmlDecl;
            }
            if (!this.ignoreDeclEnc) {
                this.enc = this.enc.getEncoding(textDecl.getEncoding());
                if (this.enc == null) {
                    this.fatal("UNSUPPORTED_ENCODING");
                }
                if (this.enc.getMinBytesPerChar() != this.minBPC) {
                    this.fatal("BAD_DECL_ENCODING");
                }
                this.stringCache.setEncoding(this.enc);
                this.fixBPC = this.enc.getFixedBytesPerChar();
                return;
            }
        }
        catch (InvalidTokenException invalidTokenException) {
            this.currentTokenStart = invalidTokenException.getOffset();
            this.fatal("INVALID_XML_DECLARATION");
        }
    }

    private void reportInvalidToken(InvalidTokenException invalidTokenException) throws NotWellFormedException {
        switch (invalidTokenException.getType()) {
            case 2: {
                this.fatal("DUPLICATE_ATTRIBUTE");
            }
            case 1: {
                this.fatal("XML_TARGET");
            }
        }
        this.fatal("ILLEGAL_CHAR");
    }

    private final void startEntityDecl(Hashtable hashtable, DeclState declState) {
        String string = this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true);
        declState.entity = (EntityImpl)hashtable.get(string);
        if (declState.entity == null) {
            declState.entity = new EntityImpl();
            hashtable.put(string, declState.entity);
            declState.declName = string;
            return;
        }
        declState.entity = null;
        declState.declType = -1;
    }

    private final String normalizeNewlines(String string) {
        int n = string.indexOf(13);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\r') {
                stringBuffer.append('\n');
                if (n + 1 < string.length() && string.charAt(n + 1) == '\n') {
                    ++n;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getEntityLocation() {
        return this.location;
    }

    void prologAction(int n, PrologParser prologParser, DeclState declState) throws IOException, ApplicationException {
        switch (n) {
            case 1: {
                this.handleXmlDecl(false);
                return;
            }
            case 2: {
                this.handleXmlDecl(true);
                return;
            }
            case 7: 
            case 15: 
            case 19: {
                try {
                    String string;
                    declState.entity.publicId = string = this.enc.getPublicId(this.buf, this.currentTokenStart, this.bufStart);
                    return;
                }
                catch (InvalidTokenException invalidTokenException) {
                    this.currentTokenStart = invalidTokenException.getOffset();
                    this.fatal("PUBID_CHAR");
                    return;
                }
            }
            case 5: {
                this.dtd.name = this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true);
                declState.entity = this.dtd.externalSubset = new EntityImpl();
                return;
            }
            case 17: {
                declState.declType = 4;
                this.startEntityDecl(this.dtd.notationTable, declState);
                return;
            }
            case 10: {
                declState.declType = 2;
                this.startEntityDecl(this.dtd.generalEntityTable, declState);
                return;
            }
            case 11: {
                declState.declType = 3;
                this.startEntityDecl(this.dtd.paramEntityTable, declState);
                return;
            }
            case 12: 
            case 13: {
                byte[] byArray = this.makeReplacementText(n == 12);
                if (declState.entity == null) break;
                declState.entity.text = byArray;
                return;
            }
            case 6: 
            case 14: 
            case 18: {
                if (declState.entity == null) break;
                declState.entity.systemId = this.stringCache.convert(this.buf, this.currentTokenStart + this.minBPC, this.bufStart - this.minBPC, false);
                declState.entity.baseURL = this.baseURL;
                return;
            }
            case 16: {
                if (declState.entity == null) break;
                declState.entity.notationName = this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true);
                return;
            }
            case 8: {
                this.dtd.hasInternalSubset = true;
                this.reportStartDocumentTypeDeclaration(declState);
                return;
            }
            case 9: {
                if (!this.dtd.hasInternalSubset) {
                    this.reportStartDocumentTypeDeclaration(declState);
                }
                if (this.dtd.externalSubset != null && this.dtd.externalSubset.systemId != null) {
                    OpenEntity openEntity;
                    if (!this.dtd.standalone && (openEntity = this.entityManager.open(this.dtd.externalSubset.systemId, this.baseURL, this.dtd.externalSubset.publicId)) != null) {
                        try {
                            this.app.startEntityReference(startExternalSubsetEvent);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new ApplicationException(exception);
                        }
                        new EntityParser(openEntity, this.entityManager, this.app, this.locale, this).parseDecls((byte)1);
                        this.reportEndEntityReference();
                        this.reportEndDocumentTypeDeclaration(declState);
                        return;
                    }
                    this.dtd.complete = false;
                }
                this.reportEndDocumentTypeDeclaration(declState);
                return;
            }
            case 51: 
            case 52: {
                this.nameStart = this.currentTokenStart + this.minBPC;
                String string = this.stringCache.convert(this.buf, this.nameStart, this.getNameEnd(), true);
                EntityImpl entityImpl = (EntityImpl)this.dtd.paramEntityTable.get(string);
                if (entityImpl == null) {
                    if (!this.dtd.complete) break;
                    this.fatal("UNDEF_PEREF", string);
                    return;
                }
                EntityParser entityParser = this.makeParserForEntity(entityImpl, string, true);
                if (entityParser == null || this.dtd.standalone) {
                    this.dtd.complete = false;
                    return;
                }
                entityImpl.open = true;
                if (n == 51) {
                    this.reportStartEntityReference();
                    entityParser.parseDecls(entityImpl.text != null ? (byte)2 : 1);
                    this.reportEndEntityReference();
                } else {
                    entityParser.parseInnerParamEntity(prologParser, declState);
                }
                entityImpl.open = false;
                return;
            }
            case 31: {
                String string = this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true);
                declState.declType = 0;
                declState.declName = string;
                declState.elementType = (ElementTypeImpl)this.dtd.elementTypeTable.get(string);
                if (declState.elementType != null) break;
                declState.elementType = new ElementTypeImpl();
                this.dtd.elementTypeTable.put(string, declState.elementType);
                return;
            }
            case 20: {
                declState.attributeName = this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true);
                declState.allowedValues = null;
                return;
            }
            case 21: {
                declState.attributeType = 0;
                return;
            }
            case 22: {
                declState.attributeType = 1;
                return;
            }
            case 23: {
                declState.attributeType = (byte)2;
                return;
            }
            case 24: {
                declState.attributeType = (byte)3;
                return;
            }
            case 25: {
                declState.attributeType = (byte)4;
                return;
            }
            case 26: {
                declState.attributeType = (byte)5;
                return;
            }
            case 27: {
                declState.attributeType = (byte)6;
                return;
            }
            case 28: {
                declState.attributeType = (byte)7;
                return;
            }
            case 32: 
            case 33: {
                if (!declState.elementType.appendAttribute(declState.attributeName, null, null, n == 33, declState.attributeType, declState.allowedValues)) break;
                this.reportMarkupDeclaration(declState);
                return;
            }
            case 34: 
            case 35: {
                if (!declState.elementType.appendAttribute(declState.attributeName, this.makeAttributeValue(declState.attributeType == 0, this.buf, this.currentTokenStart + this.minBPC, this.bufStart - this.minBPC), this.normalizeNewlines(this.stringCache.convert(this.buf, this.currentTokenStart + this.minBPC, this.bufStart - this.minBPC, false)), n == 35, declState.attributeType, declState.allowedValues)) break;
                this.reportMarkupDeclaration(declState);
                return;
            }
            case 29: 
            case 30: {
                declState.attributeType = n == 30 ? (byte)9 : (byte)8;
                if (declState.allowedValues == null) {
                    declState.allowedValues = new Vector();
                }
                declState.allowedValues.addElement(this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true));
                return;
            }
            case 3: {
                this.nameStart = this.currentTokenStart + this.minBPC + this.minBPC;
                this.reportProcessingInstruction();
                return;
            }
            case 4: {
                this.reportComment();
                return;
            }
            case 53: {
                this.skipIgnoreSect();
                return;
            }
            case 36: {
                String string = this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, true);
                declState.elementType = (ElementTypeImpl)this.dtd.elementTypeTable.get(string);
                if (declState.elementType == null) {
                    declState.elementType = new ElementTypeImpl();
                    this.dtd.elementTypeTable.put(string, declState.elementType);
                }
                declState.declName = string;
                declState.declType = 1;
                declState.contentSpec.setLength(0);
                declState.elementType.setContentType((byte)3);
                return;
            }
            case 37: {
                declState.elementType.setContentType((byte)0);
                declState.elementType.setContentSpec("ANY");
                return;
            }
            case 38: {
                declState.elementType.setContentType((byte)2);
                declState.elementType.setContentSpec("EMPTY");
                return;
            }
            case 39: {
                declState.elementType.setContentType((byte)1);
                declState.contentSpec.append("#PCDATA");
                return;
            }
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                declState.contentSpec.append(this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, false));
                return;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                declState.contentSpec.append(this.stringCache.convert(this.buf, this.currentTokenStart, this.bufStart, false));
                if (prologParser.getGroupLevel() != 0) break;
                declState.elementType.setContentSpec(declState.contentSpec.toString());
                return;
            }
            case 54: {
                if (declState.declType >= 0 && declState.declType != 0) {
                    this.reportMarkupDeclaration(declState);
                }
                declState.declType = -1;
                return;
            }
        }
    }

    private final void reportMarkupDeclaration(DeclState declState) throws ApplicationException {
        try {
            this.app.markupDeclaration(declState);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private static final int[] grow(int[] nArray) {
        int[] nArray2 = nArray;
        nArray = new int[nArray2.length << 1];
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        return nArray;
    }

    public final int getAttributeCount() {
        if (this.nAttributes < 0) {
            this.buildAttributes();
        }
        return this.nAttributes;
    }

    private final void parseContent(boolean bl) throws IOException, ApplicationException {
        byte[] byArray = this.buf;
        int n = this.bufEnd;
        int n2 = this.bufStart;
        Encoding encoding = this.enc;
        int n3 = 0;
        Object object = new byte[64];
        int[] nArray = new int[8];
        nArray[0] = 0;
        while (true) {
            try {
                while (true) {
                    switch (encoding.tokenizeContent(byArray, n2, n, this)) {
                        case 3: {
                            this.storeAtts();
                        }
                        case 2: {
                            Object object2;
                            if (n3 + 1 >= nArray.length) {
                                nArray = EntityParser.grow(nArray);
                            }
                            this.nameStart = n2 + this.minBPC;
                            this.nAttributes = -1;
                            this.currentTokenStart = n2;
                            try {
                                this.app.startElement(this);
                            }
                            catch (RuntimeException runtimeException) {
                                throw runtimeException;
                            }
                            catch (Exception exception) {
                                throw new ApplicationException(exception);
                            }
                            int n4 = this.getNameEnd() - this.nameStart;
                            int n5 = nArray[n3];
                            nArray[n3 + 1] = n5 + n4;
                            if (nArray[n3 + 1] > ((byte[])object).length) {
                                object2 = new byte[(((byte[])object).length << 1) + n4];
                                System.arraycopy(object, 0, object2, 0, nArray[n3]);
                                object = object2;
                            }
                            EntityParser.copyBytes(byArray, this.nameStart, object, n5, n4);
                            ++n3;
                            break;
                        }
                        case 5: {
                            this.storeAtts();
                        }
                        case 4: {
                            this.nameStart = n2 + this.minBPC;
                            this.nAttributes = -1;
                            this.currentTokenStart = n2;
                            try {
                                this.app.startElement(this);
                                this.app.endElement(this);
                            }
                            catch (RuntimeException runtimeException) {
                                throw runtimeException;
                            }
                            catch (Exception exception) {
                                throw new ApplicationException(exception);
                            }
                            if (!bl || n3 != 0) break;
                            this.bufStart = this.getTokenEnd();
                            return;
                        }
                        case 6: {
                            Object object3;
                            Object object2;
                            if (n3 == 0) {
                                this.currentTokenStart = n2;
                                this.fatal("INVALID_END_TAG");
                            }
                            this.nameStart = n2 + 2 * this.minBPC;
                            if (!EntityParser.bytesEqual(object, nArray[--n3], nArray[n3 + 1], byArray, this.nameStart, this.getNameEnd())) {
                                object2 = this.stringCache.convert((byte[])object, nArray[n3], nArray[n3 + 1], false);
                                object3 = this.stringCache.convert(byArray, this.nameStart, this.getNameEnd(), false);
                                this.currentTokenStart = n2;
                                this.fatal("MISMATCHED_END_TAG", object3, object2);
                            }
                            try {
                                this.app.endElement(this);
                            }
                            catch (RuntimeException runtimeException) {
                                throw runtimeException;
                            }
                            catch (Exception exception) {
                                throw new ApplicationException(exception);
                            }
                            if (!bl || n3 != 0) break;
                            this.bufStart = this.getTokenEnd();
                            return;
                        }
                        case 0: {
                            this.data = null;
                            this.bufStart = n2;
                            this.reportCharacterData();
                            break;
                        }
                        case 1: {
                            this.dataBuf[0] = 10;
                            this.dataLength = 1;
                            this.data = this.dataBuf;
                            this.reportCharacterData();
                            break;
                        }
                        case 10: 
                        case 11: {
                            this.dataBuf[0] = this.getRefChar();
                            this.dataLength = 1;
                            this.data = this.dataBuf;
                            this.dataIsRef = true;
                            this.reportCharacterData();
                            this.dataIsRef = false;
                            break;
                        }
                        case 12: {
                            this.getRefCharPair(this.dataBuf, 0);
                            this.data = this.dataBuf;
                            this.dataLength = 2;
                            this.dataIsRef = true;
                            this.reportCharacterData();
                            this.dataIsRef = false;
                            break;
                        }
                        case 7: {
                            this.currentTokenStart = n2;
                            try {
                                this.app.startCdataSection(this);
                            }
                            catch (RuntimeException runtimeException) {
                                throw runtimeException;
                            }
                            catch (Exception exception) {
                                throw new ApplicationException(exception);
                            }
                            this.bufStart = this.getTokenEnd();
                            this.parseCdataSection();
                            byArray = this.buf;
                            n2 = this.bufStart;
                            n = this.bufEnd;
                            break;
                        }
                        case 9: {
                            this.nameStart = n2 + this.minBPC;
                            Object object2 = this.stringCache.convert(byArray, this.nameStart, this.getNameEnd(), true);
                            Object object3 = (EntityImpl)this.dtd.generalEntityTable.get(object2);
                            if (object3 == null) {
                                if (!this.dtd.complete && !this.dtd.standalone) break;
                                this.currentTokenStart = n2;
                                this.fatal("UNDEF_REF", object2);
                                break;
                            }
                            EntityParser entityParser = this.makeParserForEntity((EntityImpl)object3, (String)object2, false);
                            if (entityParser == null) break;
                            this.reportStartEntityReference();
                            ((EntityImpl)object3).open = true;
                            if (((EntityImpl)object3).text != null) {
                                this.currentTokenStart = this.bufStart = n2;
                                entityParser.parseContent(false);
                            } else {
                                entityParser.parseExternalTextEntity();
                            }
                            this.reportEndEntityReference();
                            ((EntityImpl)object3).open = false;
                            break;
                        }
                        case 13: {
                            this.nameStart = n2 + this.minBPC * 2;
                            this.currentTokenStart = n2;
                            this.reportProcessingInstruction();
                            break;
                        }
                        case 15: {
                            this.currentTokenStart = n2;
                            this.reportComment();
                            break;
                        }
                        case 14: {
                            this.currentTokenStart = n2;
                            this.fatal("MISPLACED_XML_DECL");
                        }
                    }
                    n2 = this.getTokenEnd();
                }
            }
            catch (EmptyTokenException emptyTokenException) {
                this.bufStart = n2;
                if (!this.fill()) {
                    if (bl || n3 > 0) {
                        this.currentTokenStart = this.bufStart;
                        this.fatal("MISSING_END_TAG");
                    }
                    return;
                }
                byArray = this.buf;
                n2 = this.bufStart;
                n = this.bufEnd;
                continue;
            }
            catch (PartialTokenException partialTokenException) {
                this.bufStart = n2;
                if (!this.fill()) {
                    this.currentTokenStart = this.bufStart;
                    this.fatal("UNCLOSED_TOKEN");
                }
                byArray = this.buf;
                n2 = this.bufStart;
                n = this.bufEnd;
                continue;
            }
            catch (ExtensibleTokenException extensibleTokenException) {
                this.bufStart = n2;
                if (!this.fill()) {
                    if (bl || n3 > 0) {
                        this.currentTokenStart = this.bufStart;
                        this.fatal("MISSING_END_TAG");
                    }
                    switch (extensibleTokenException.getTokenType()) {
                        case 1: {
                            this.dataBuf[0] = 10;
                            this.dataLength = 1;
                            this.data = this.dataBuf;
                            this.reportCharacterData();
                            return;
                        }
                        case 0: {
                            this.data = null;
                            this.setTokenEnd(this.bufEnd);
                            this.reportCharacterData();
                            return;
                        }
                    }
                    throw new Error("extensible token botch");
                }
                byArray = this.buf;
                n2 = this.bufStart;
                n = this.bufEnd;
                continue;
            }
            catch (InvalidTokenException invalidTokenException) {
                this.currentTokenStart = invalidTokenException.getOffset();
                this.reportInvalidToken(invalidTokenException);
                continue;
            }
            break;
        }
    }

    private void handleEntityValueToken(Buffer buffer, int n, int n2, int n3, Token token) throws IOException {
        switch (n) {
            case 0: 
            case 9: 
            case 10: {
                buffer.append(this.enc, this.buf, n2, n3);
                return;
            }
            case 11: {
                buffer.append(token.getRefChar());
                return;
            }
            case 12: {
                buffer.appendRefCharPair(token);
                return;
            }
            case 1: {
                buffer.append('\n');
                return;
            }
            case 17: {
                String string = this.stringCache.convert(this.buf, n2 + this.minBPC, n3 - this.minBPC, true);
                EntityImpl entityImpl = (EntityImpl)this.dtd.paramEntityTable.get(string);
                if (entityImpl == null) {
                    if (!this.dtd.complete) break;
                    this.fatal("UNDEF_PEREF", string);
                    return;
                }
                EntityParser entityParser = this.makeParserForEntity(entityImpl, string, true);
                if (entityParser == null) break;
                entityImpl.open = true;
                entityParser.parseEntityValue(buffer);
                entityImpl.open = false;
                return;
            }
            default: {
                throw new Error("replacement text botch");
            }
        }
    }

    public ParseLocation getLocation() {
        if (this.parent != null) {
            return this.parent.getLocation();
        }
        if (this.posOff > this.currentTokenStart) {
            throw new Error("positioning botch");
        }
        if (this.enc != null) {
            this.enc.movePosition(this.buf, this.posOff, this.currentTokenStart, this.pos);
        }
        this.posOff = this.currentTokenStart;
        return this;
    }

    private final void parseCdataSection() throws IOException, InvalidTokenException, ApplicationException {
        while (true) {
            try {
                while (true) {
                    switch (this.enc.tokenizeCdataSection(this.buf, this.bufStart, this.bufEnd, this)) {
                        case 0: {
                            this.data = null;
                            this.reportCharacterData();
                            break;
                        }
                        case 1: {
                            this.dataBuf[0] = 10;
                            this.dataLength = 1;
                            this.data = this.dataBuf;
                            this.reportCharacterData();
                            break;
                        }
                        case 8: {
                            this.currentTokenStart = this.bufStart;
                            try {
                                this.app.endCdataSection(this);
                                return;
                            }
                            catch (RuntimeException runtimeException) {
                                throw runtimeException;
                            }
                            catch (Exception exception) {
                                throw new ApplicationException(exception);
                            }
                        }
                    }
                    this.bufStart = this.getTokenEnd();
                }
            }
            catch (InvalidTokenException invalidTokenException) {
                throw invalidTokenException;
            }
            catch (TokenException tokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.fatal("UNCLOSED_CDATA_SECTION");
                continue;
            }
            break;
        }
    }

    public int getLineNumber() {
        return this.pos.getLineNumber();
    }

    private final void reportEndDocumentTypeDeclaration(DeclState declState) throws ApplicationException {
        try {
            this.app.endDocumentTypeDeclaration(declState);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private final void skipIgnoreSect() throws IOException {
        while (true) {
            try {
                this.bufStart = this.enc.skipIgnoreSect(this.buf, this.bufStart, this.bufEnd);
                return;
            }
            catch (PartialTokenException partialTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.fatal("UNCLOSED_CONDITIONAL_SECTION");
                continue;
            }
            catch (InvalidTokenException invalidTokenException) {
                this.currentTokenStart = invalidTokenException.getOffset();
                this.fatal("IGNORE_SECT_CHAR");
                continue;
            }
            break;
        }
    }

    public URL getEntityBase() {
        return this.baseURL;
    }

    void parseInnerParamEntity(PrologParser prologParser, DeclState declState) throws IOException, ApplicationException {
        int n = prologParser.getGroupLevel();
        try {
            while (true) {
                int n2 = this.tokenizeProlog();
                this.prologAction(prologParser.action(n2, this.buf, this.currentTokenStart, this.bufStart, this.enc), prologParser, declState);
                if (n2 != 20) continue;
                this.fatal("PE_DECL_NESTING");
            }
        }
        catch (EndOfPrologException endOfPrologException) {
            this.fatal("SYNTAX_ERROR");
        }
        catch (PrologSyntaxException prologSyntaxException) {
            this.fatal("SYNTAX_ERROR");
        }
        catch (EmptyTokenException emptyTokenException) {}
        if (prologParser.getGroupLevel() != n) {
            this.fatal("PE_GROUP_NESTING");
        }
    }

    private EntityParser makeParserForEntity(EntityImpl entityImpl, String string, boolean bl) throws IOException {
        if (entityImpl.open) {
            this.fatal("RECURSION");
        }
        if (entityImpl.notationName != null) {
            this.fatal("UNPARSED_REF");
        }
        if (entityImpl.text != null) {
            return new EntityParser(entityImpl.text, string, bl, this);
        }
        OpenEntity openEntity = this.entityManager.open(entityImpl.systemId, entityImpl.baseURL, entityImpl.publicId);
        if (openEntity == null) {
            return null;
        }
        return new EntityParser(openEntity, this.entityManager, this.app, this.locale, this);
    }

    private final void reportComment() throws ApplicationException {
        try {
            this.app.comment(this);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    public final int getIdAttributeIndex() {
        if (this.nAttributes < 0) {
            this.buildAttributes();
        }
        return this.idAttributeIndex;
    }

    public boolean isReference() {
        return this.dataIsRef;
    }

    public final String getAttributeUnnormalizedValue(int n) {
        if (n >= this.getAttributeSpecifiedCount() || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.normalizeNewlines(this.stringCache.convert(this.buf, this.getAttributeValueStart(n), this.getAttributeValueEnd(n), false));
    }

    private String makeAttributeValue(boolean bl, byte[] byArray, int n, int n2) throws NotWellFormedException {
        int n3 = this.currentTokenStart;
        int n4 = this.getNameEnd();
        this.valueBuf.clear();
        this.appendAttributeValue(bl, n, n2, this.valueBuf);
        if (!bl && this.valueBuf.length() > 0 && this.valueBuf.charAt(this.valueBuf.length() - 1) == ' ') {
            this.valueBuf.chop();
        }
        this.currentTokenStart = n3;
        this.setNameEnd(n4);
        return this.valueBuf.toString();
    }

    private void parseEntityValue(Buffer buffer) throws IOException {
        Token token = new Token();
        while (true) {
            int n;
            try {
                n = this.enc.tokenizeEntityValue(this.buf, this.bufStart, this.bufEnd, token);
                this.currentTokenStart = this.bufStart;
                this.bufStart = token.getTokenEnd();
            }
            catch (EmptyTokenException emptyTokenException) {
                if (this.fill()) continue;
                return;
            }
            catch (PartialTokenException partialTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                this.fatal("UNCLOSED_TOKEN");
                continue;
            }
            catch (ExtensibleTokenException extensibleTokenException) {
                if (this.fill()) continue;
                this.currentTokenStart = this.bufStart;
                this.bufStart = this.bufEnd;
                n = extensibleTokenException.getTokenType();
            }
            catch (InvalidTokenException invalidTokenException) {
                this.currentTokenStart = invalidTokenException.getOffset();
                this.reportInvalidToken(invalidTokenException);
                continue;
            }
            this.handleEntityValueToken(buffer, n, this.currentTokenStart, this.bufStart, token);
        }
    }

    private void doFatal(String string, Object[] objectArray) throws NotWellFormedException {
        if (this.parent != null) {
            this.parent.doFatal(string, objectArray);
        }
        if (this.posOff > this.currentTokenStart) {
            throw new Error("positioning botch");
        }
        if (this.enc != null) {
            this.enc.movePosition(this.buf, this.posOff, this.currentTokenStart, this.pos);
        }
        this.posOff = this.currentTokenStart;
        String string2 = string;
        String string3 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.jclark.xml.parse.Messages", this.locale);
            string2 = resourceBundle.getString(string);
            if (objectArray != null) {
                string2 = MessageFormat.format(string2, objectArray);
            }
            Object[] objectArray2 = new Object[]{string2, this.location, new Integer(this.pos.getLineNumber()), new Integer(this.pos.getColumnNumber()), new Long(this.getEntityByteIndex(this.currentTokenStart))};
            string3 = MessageFormat.format(resourceBundle.getString("MESSAGE_FORMAT"), objectArray2);
        }
        catch (MissingResourceException missingResourceException) {
            string3 = string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string3 = string2;
        }
        throw new NotWellFormedException(string3, string2, this.location, this.baseURL, this.pos.getLineNumber(), this.pos.getColumnNumber(), this.getEntityByteIndex(this.currentTokenStart));
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean bytesEqual(byte[] var0, int var1_1, int var2_2, byte[] var3_3, int var4_4, int var5_5) {
        var6_6 = var2_2 - var1_1;
        if (var5_5 - var4_4 == var6_6) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (var0[var1_1++] != var3_3[var4_4++]) {
                return false;
            }
            --var6_6;
lbl7:
            // 2 sources

            ** while (var6_6 > 0)
        }
lbl8:
        // 1 sources

        return true;
    }

    public DTD getDTD() {
        return this.dtd;
    }

    public String getName() {
        return this.stringCache.convert(this.buf, this.nameStart, this.getNameEnd(), true);
    }

    public final String getAttributeName(int n) {
        if (this.nAttributes < 0) {
            this.buildAttributes();
        }
        if (n >= this.nAttributes) {
            throw new IndexOutOfBoundsException();
        }
        return this.attNames[n];
    }

    private static final void copyBytes(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (--n3 >= 0) {
            byArray2[n2++] = byArray[n++];
        }
    }

    private final void reportProcessingInstruction() throws ApplicationException {
        try {
            this.app.processingInstruction(this);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private final void reportStartDocumentTypeDeclaration(DeclState declState) throws ApplicationException {
        try {
            this.app.startDocumentTypeDeclaration(declState);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    EntityParser(OpenEntity openEntity, EntityManager entityManager, Application application, Locale locale, EntityParser entityParser) throws IOException {
        String string;
        this.in = openEntity.getInputStream();
        this.app = application;
        this.locale = locale;
        this.baseURL = openEntity.getBase();
        this.location = openEntity.getLocation();
        this.entityManager = entityManager;
        this.buf = new byte[16384];
        this.bufEnd = 0;
        this.bufStart = 0;
        this.currentTokenStart = 0;
        while (this.bufEnd - this.bufStart < 4 && this.fill()) {
        }
        this.enc = Encoding.getInitialEncoding(this.buf, this.bufStart, this.bufEnd, this);
        this.currentTokenStart = this.bufStart = this.getTokenEnd();
        this.posOff = this.bufStart;
        if (this.enc == null) {
            this.fatal("BAD_INITIAL_BYTES");
        }
        if ((string = openEntity.getEncoding()) != null) {
            this.ignoreDeclEnc = true;
            this.enc = this.enc.getEncoding(string);
            if (this.enc == null) {
                this.fatal("UNSUPPORTED_ENCODING");
            }
        }
        this.minBPC = this.enc.getMinBytesPerChar();
        this.fixBPC = this.enc.getFixedBytesPerChar();
        this.stringCache = new StringConversionCache(this.enc);
        this.valueBuf = new Buffer();
        this.dataBuf = new char[65];
        this.internalEnc = Encoding.getInternalEncoding();
        this.internalStringCache = new StringConversionCache(this.internalEnc);
        if (entityParser != null) {
            this.dtd = entityParser.dtd;
            return;
        }
        this.dtd = new DTDImpl(this.baseURL);
    }

    private EntityParser(byte[] byArray, String string, boolean bl, EntityParser entityParser) {
        this.internalEntityName = string;
        this.isParameterEntity = bl;
        this.buf = byArray;
        this.parent = entityParser;
        this.baseURL = entityParser.baseURL;
        this.entityManager = entityParser.entityManager;
        this.bufStart = 0;
        this.currentTokenStart = 0;
        this.bufEnd = byArray.length;
        this.app = entityParser.app;
        this.locale = entityParser.locale;
        this.enc = this.internalEnc = entityParser.internalEnc;
        this.stringCache = this.internalStringCache = entityParser.internalStringCache;
        this.minBPC = this.enc.getMinBytesPerChar();
        this.fixBPC = this.enc.getFixedBytesPerChar();
        this.dtd = entityParser.dtd;
        this.valueBuf = entityParser.valueBuf;
        this.dataBuf = entityParser.dataBuf;
    }

    public void writeChars(Writer writer) throws IOException {
        if (this.data == null) {
            this.convertData(this.bufStart, this.getTokenEnd());
        }
        writer.write(this.data, 0, this.dataLength);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseDecls(byte by) throws IOException, ApplicationException {
        block17: {
            PrologParser prologParser = new PrologParser(by);
            DeclState declState = new DeclState(by, this.dtd);
            try {
                try {}
                catch (PrologSyntaxException prologSyntaxException) {
                    this.fatal("SYNTAX_ERROR");
                    break block17;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (by == 1 && this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                throw throwable;
            }
            while (true) {
                int n;
                try {
                    n = this.tokenizeProlog();
                }
                catch (EndOfPrologException endOfPrologException) {
                    if (by != 0) {
                        this.fatal("SYNTAX_ERROR");
                    }
                    prologParser.end();
                    break;
                }
                catch (EmptyTokenException emptyTokenException) {
                    if (by == 0) {
                        this.currentTokenStart = this.bufStart;
                        this.fatal("NO_DOCUMENT_ELEMENT");
                    }
                    prologParser.end();
                    break;
                }
                this.prologAction(prologParser.action(n, this.buf, this.currentTokenStart, this.bufStart, this.enc), prologParser, declState);
            }
        }
        Object var6_7 = null;
        if (by == 1 && this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (by != 0) {
            return;
        }
        try {
            this.app.endProlog(this);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private byte[] makeReplacementText(boolean bl) throws IOException {
        this.valueBuf.clear();
        Token token = new Token();
        int n = this.currentTokenStart + this.minBPC;
        int n2 = this.bufStart - this.minBPC;
        try {
            while (true) {
                int n3;
                int n4;
                try {
                    n4 = this.enc.tokenizeEntityValue(this.buf, n, n2, token);
                    n3 = token.getTokenEnd();
                }
                catch (ExtensibleTokenException extensibleTokenException) {
                    n4 = extensibleTokenException.getTokenType();
                    n3 = n2;
                }
                if (n4 == 17 && !bl) {
                    this.currentTokenStart = n;
                    this.fatal("INTERNAL_PEREF_ENTVAL");
                }
                this.handleEntityValueToken(this.valueBuf, n4, n, n3, token);
                n = n3;
            }
        }
        catch (PartialTokenException partialTokenException) {
            this.currentTokenStart = n2;
            this.fatal("NOT_WELL_FORMED");
        }
        catch (InvalidTokenException invalidTokenException) {
            this.currentTokenStart = invalidTokenException.getOffset();
            this.reportInvalidToken(invalidTokenException);
        }
        catch (EmptyTokenException emptyTokenException) {}
        return this.valueBuf.getBytes();
    }

    private long getEntityByteIndex(int n) {
        return this.bufEndStreamOffset - (long)(this.bufEnd - n);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseMisc() throws IOException, ApplicationException {
        try {
            block8: while (true) {
                int n = 0;
                block9: do {
                    switch (n == 0 ? this.tokenizeProlog() : n) {
                        case 13: {
                            this.nameStart = this.currentTokenStart + this.minBPC + this.minBPC;
                            this.reportProcessingInstruction();
                            n = 18;
                            continue block9;
                        }
                        case 15: {
                            this.reportComment();
                        }
                        case 18: {
                            continue block8;
                        }
                    }
                    break;
                } while (true);
                this.fatal("EPILOG_JUNK");
            }
        }
        catch (EndOfPrologException endOfPrologException) {
            this.currentTokenStart = this.bufStart;
            this.fatal("ELEMENT_AFTER_DOCUMENT_ELEMENT");
            return;
        }
        catch (EmptyTokenException emptyTokenException) {
            return;
        }
    }

    private final void reportEndEntityReference() throws ApplicationException {
        try {
            this.app.endEntityReference(this);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private void parseExternalTextEntity() throws IOException, ApplicationException {
        try {
            while (true) {
                try {
                    if (this.enc.tokenizeContent(this.buf, this.bufStart, this.bufEnd, this) != 14) break;
                    this.currentTokenStart = this.bufStart;
                    this.bufStart = this.getTokenEnd();
                    this.handleXmlDecl(true);
                }
                catch (InvalidTokenException invalidTokenException) {
                }
                catch (TokenException tokenException) {
                    if (this.fill()) continue;
                }
                break;
            }
            this.parseContent(false);
        }
        catch (Throwable throwable) {
            block7: {
                Object var2_2 = null;
                if (this.in == null) break block7;
                this.in.close();
                this.in = null;
            }
            throw throwable;
        }
        Object var2_1 = null;
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    private final void reportCharacterData() throws ApplicationException {
        try {
            this.app.characterData(this);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private final void reportStartEntityReference() throws ApplicationException {
        try {
            this.app.startEntityReference(this);
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ApplicationException(exception);
        }
    }

    private static class DTDImpl
    implements DTD {
        String name;
        EntityImpl externalSubset;
        URL baseURL;
        Hashtable elementTypeTable = new Hashtable();
        Hashtable generalEntityTable = new Hashtable();
        Hashtable paramEntityTable = new Hashtable();
        Hashtable notationTable = new Hashtable();
        boolean complete = true;
        boolean standalone;
        boolean hasInternalSubset;

        public boolean isStandalone() {
            return this.standalone;
        }

        DTDImpl(URL uRL) {
            this.baseURL = uRL;
        }

        public String getDocumentTypeName() {
            return this.name;
        }

        public Enumeration entityNames(byte by) {
            switch (by) {
                case 0: {
                    return this.generalEntityTable.keys();
                }
                case 1: {
                    return this.paramEntityTable.keys();
                }
                case 2: {
                    return this.notationTable.keys();
                }
            }
            throw new IllegalArgumentException();
        }

        public ElementType getElementType(String string) {
            return (ElementType)this.elementTypeTable.get(string);
        }

        public Enumeration elementTypeNames() {
            return this.elementTypeTable.keys();
        }

        public Entity getEntity(byte by, String string) {
            switch (by) {
                case 0: {
                    return (Entity)this.generalEntityTable.get(string);
                }
                case 1: {
                    if (string.equals("#DOCTYPE")) {
                        if (this.externalSubset.systemId == null) {
                            return null;
                        }
                        return this.externalSubset;
                    }
                    return (Entity)this.paramEntityTable.get(string);
                }
                case 2: {
                    return (Entity)this.notationTable.get(string);
                }
            }
            throw new IllegalArgumentException();
        }

        public boolean isComplete() {
            return this.complete;
        }
    }

    private static final class ElementTypeImpl
    implements ElementType {
        static final int ID_DEFAULT_INDEX = -2;
        private final Hashtable attTable = new Hashtable();
        private int nDefaultAtts;
        private Attribute[] defaultAtts = new Attribute[4];
        private byte contentType = (byte)-1;
        private String contentSpec;

        public String getContentSpec() {
            return this.contentSpec;
        }

        void setContentSpec(String string) {
            this.contentSpec = string;
        }

        String getDefaultAttributeValue(int n) {
            if (n >= this.nDefaultAtts) {
                throw new IndexOutOfBoundsException();
            }
            return this.defaultAtts[n].value;
        }

        boolean appendAttribute(String string, String string2, String string3, boolean bl, byte by, Vector vector) {
            if (this.attTable.get(string) != null) {
                return false;
            }
            Attribute attribute = new Attribute();
            this.attTable.put(string, attribute);
            attribute.name = string;
            attribute.value = string2;
            attribute.unnormalizedValue = string3;
            if (string2 == null) {
                attribute.defaultIndex = -1;
            } else {
                if (this.nDefaultAtts == this.defaultAtts.length) {
                    Attribute[] attributeArray = this.defaultAtts;
                    this.defaultAtts = new Attribute[attributeArray.length << 1];
                    System.arraycopy(attributeArray, 0, this.defaultAtts, 0, attributeArray.length);
                }
                this.defaultAtts[this.nDefaultAtts] = attribute;
                attribute.defaultIndex = this.nDefaultAtts++;
            }
            attribute.required = bl;
            attribute.type = by;
            if (by == 1 && string2 == null) {
                attribute.defaultIndex = -2;
            }
            attribute.values = vector;
            return true;
        }

        ElementTypeImpl() {
        }

        public Enumeration attributeNames() {
            return this.attTable.keys();
        }

        String getDefaultAttributeUnnormalizedValue(int n) {
            if (n >= this.nDefaultAtts) {
                throw new IndexOutOfBoundsException();
            }
            return this.defaultAtts[n].unnormalizedValue;
        }

        int getAttributeDefaultIndex(String string) {
            Attribute attribute = (Attribute)this.attTable.get(string);
            if (attribute == null) {
                return -1;
            }
            return attribute.defaultIndex;
        }

        public byte getContentType() {
            return this.contentType;
        }

        public AttributeDefinition getAttributeDefinition(String string) {
            return (AttributeDefinition)this.attTable.get(string);
        }

        void setContentType(byte by) {
            this.contentType = by;
        }

        String getDefaultAttributeName(int n) {
            if (n >= this.nDefaultAtts) {
                throw new IndexOutOfBoundsException();
            }
            return this.defaultAtts[n].name;
        }

        boolean isAttributeCdata(String string) {
            Attribute attribute = (Attribute)this.attTable.get(string);
            return attribute == null || attribute.type <= 0;
        }

        int getDefaultAttributeCount() {
            return this.nDefaultAtts;
        }

        private static class Attribute
        implements AttributeDefinition {
            int defaultIndex = -1;
            boolean required;
            byte type = (byte)-1;
            Vector values;
            String name;
            String value;
            String unnormalizedValue;

            public Enumeration allowedValues() {
                if (this.values == null) {
                    return null;
                }
                return this.values.elements();
            }

            public String getDefaultValue() {
                return this.value;
            }

            Attribute() {
            }

            public String getDefaultUnnormalizedValue() {
                return this.unnormalizedValue;
            }

            public boolean isRequired() {
                return this.required;
            }

            public byte getType() {
                return this.type;
            }
        }
    }

    private static final class EntityImpl
    implements Entity {
        byte[] text;
        String systemId;
        String publicId;
        URL baseURL;
        String notationName;
        boolean open;

        public String getSystemId() {
            return this.systemId;
        }

        EntityImpl() {
        }

        public String getReplacementText() {
            if (this.text == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(this.text.length >> 1);
            int n = 0;
            while (n < this.text.length) {
                stringBuffer.append((char)((this.text[n] & 0xFF) << 8 | this.text[n + 1] & 0xFF));
                n += 2;
            }
            return stringBuffer.toString();
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getNotationName() {
            return this.notationName;
        }

        public URL getBase() {
            return this.baseURL;
        }
    }

    static class DeclState
    implements MarkupDeclarationEvent,
    StartDocumentTypeDeclarationEvent,
    EndDocumentTypeDeclarationEvent {
        final byte type;
        final DTD dtd;
        EntityImpl entity;
        ElementTypeImpl elementType;
        String attributeName;
        byte attributeType;
        StringBuffer contentSpec = new StringBuffer();
        Vector allowedValues;
        String declName;
        int declType = -1;

        DeclState(byte by, DTD dTD) {
            this.type = by;
            this.dtd = dTD;
        }

        public DTD getDTD() {
            return this.dtd;
        }

        public int getType() {
            return this.declType;
        }

        public String getName() {
            return this.declName;
        }

        public String getAttributeName() {
            if (this.declType != 0) {
                return null;
            }
            return this.attributeName;
        }
    }

    private static class StartExternalSubsetEvent
    implements StartEntityReferenceEvent {
        StartExternalSubsetEvent() {
        }

        public String getName() {
            return "#DOCTYPE";
        }
    }
}

