/* $Id: Gene_ref.cpp 103491 2007-05-04 17:18:18Z kazimird $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqfeat.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/seqfeat/Gene_ref.hpp>

#include <objects/general/Dbtag.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CGene_ref::~CGene_ref(void)
{
}

// Appends a label to "label" based on content
void CGene_ref::GetLabel(string* label) const
{
    if (IsSetLocus()) {
        *label += GetLocus();
    } else if (IsSetDesc()) {
        *label += GetDesc();
    } else if (IsSetLocus_tag()) {
        *label += GetLocus_tag();
    } else if (IsSetSyn() && !GetSyn().empty()) {
        *label += *GetSyn().begin();
    } else if (IsSetDb() && GetDb().size() > 0) {
        GetDb().front()->GetLabel(label);
    } else if (IsSetMaploc()) {
        *label += GetMaploc();
    }
}

// Checks for an emtpy Gene-ref used for suppressing /gene by overlap
bool CGene_ref::IsSuppressed(void) const
{
    if ((IsSetLocus() && GetLocus().size() > 0) ||
        (IsSetDesc() && GetDesc().size() > 0) ||
        (IsSetSyn() && ! GetSyn().empty()) ||
        (IsSetLocus_tag() && GetLocus_tag().size() > 0) ||
        (IsSetDb() && GetDb().size() > 0) ||
        (IsSetAllele() && GetAllele().size() > 0) ||
        (IsSetMaploc() && GetMaploc().size() > 0)) {
        return false;
    }
    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1885, CRC32: 1a0ef8cd */
