;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                       ;
;                Copyright (C)  1995                                    ;
;        University Corporation for Atmospheric Research                ;
;                All Rights Reserved                                    ;
;                                                                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   File:       cn03n.ncl
;
;   Author:     David Brown (converted to NCL by Mary Haley)
;           National Center for Atmospheric Research
;           PO 3000, Boulder, Colorado
;
;           Converted to NCL by Ed Stautler
;
;   Date:       Wed Oct 18 16:01:02 MDT 1995
;
;  Description:    Demonstrates basic features of the ContourPlot object.
;          The first frame emulates the contour plot drawn 
;          in cn01n using low-level NCARG calls. 
;          
;

begin

M=73
N=10

T = new((/N,M/),float)
T = (/\
  (/-29.403778, -26.403778, -22.403778, -18.403778, -16.903778, -16.903778, \
  -15.403778, -10.403778, -3.4037781, 1.0962219, 1.5962219, 1.0962219, \
  3.0962219, 6.0962219, 7.5962219, 7.5962219, 8.5962219, 9.5962219, \
  10.096222, 11.096222, 14.096222, 17.596222, 18.596222, 19.096222, \
  21.096222, 22.596222, 23.596222, 24.596222, 25.596222, 25.596222, \
  26.096222, 27.096222, 27.596222, 28.596222, 30.096222, 30.096222, \
  29.596222, 30.147003, 30.397003, 30.147003, 29.647003, 28.397003, \
  26.647003, 26.397003, 29.147003, 32.147003, 31.897003, 28.147003, \
  24.897003, 22.897003, 20.397003, 18.397003, 18.897003, 20.647003, \
  20.897003, 17.647003, 12.397003, 7.6470032, 4.1470032, -0.10299683, \
  -5.3529968, -10.352997, -14.352997, -17.602997, -20.352997, -21.852997, \
  -20.852997, -18.352997, -16.352997, -16.852997, -19.102997, -21.102997,\
  -21.852997/),\
(/-37.708862, -33.208862, -28.208862, -25.708862, -25.708862, -24.708862, \
  -20.208862, -13.708862, -8.7088623, -8.2088623, -10.208862, -10.208862, \
  -7.7088623, -5.7088623, -4.7088623, -3.7088623, -2.2088623, -0.7088623,\
  -0.7088623, 1.7911377, 6.7911377, 9.7911377, 9.7911377, 9.7911377, \
  10.791138, 11.291138, 12.291138, 13.291138, 14.291138, 14.791138, \
  15.791138, 16.791138, 17.291138, 17.791138, 18.791138, 18.791138, \
  18.291138, 18.785187, 18.785187, 18.535187, 18.035187, 18.285187, \
  18.785187, 19.535187, 21.035187, 23.285187, 23.035187, 19.285187, \
  15.785187, 13.535187, 11.285187, 9.5351868, 9.7851868, 11.535187, \
  11.035187, 6.5351868, 0.78518677, -3.7148132, -6.4648132, -8.4648132, \
  -10.714813, -13.714813, -16.214813, -17.714813, -17.464813, -16.214813, \
  -15.714813, -16.464813, -18.714813, -20.714813, -21.214813, -21.714813, \
  -23.964813/),\
(/-43.489822, -35.989822, -29.989822, -27.739822, -28.239822, -27.239822, \
  -23.489822, -18.739822, -15.739838, -15.989838, -17.989822, -19.239822, \
  -18.989822, -17.239822, -14.489838, -11.489838, -9.4898376, -8.7398376, \
  -6.7398376, -2.4898376, 1.7601624, 3.2601624, 3.7601624, 5.0101624, \
  6.2601624, 6.2601624, 6.0101624, 6.0101624, 6.0101624, 7.2601624, \
  8.2601624, 8.5101624, 9.2601624, 10.260162, 10.010162, 9.5101624, \
  9.7601624, 10.061401, 10.061401, 10.311401, 10.811401, 11.061401, \
  10.561401, 10.061401, 10.311401, 10.311401, 8.0614014, 3.3114014, \
  -1.4385986, -3.4385986, -3.4385986, -3.4385986, -3.6885986, -3.6885986, \
  -4.6885986, -7.1885986, -9.6885986, -10.688599, -10.938599, -11.938599, \
  -14.438599, -17.438599, -19.938599, -20.938599, -20.438599, -19.688599, \
  -20.188599, -22.188599, -24.438599, -25.688599, -25.938599, -26.688599, \
  -29.438599/),\
(/-39.566299, -39.066299, -39.316299, -39.566299, -38.816299, -36.816299, \
  -34.816299, -33.066299, -32.066299, -32.066299, -33.066299, -34.316299, \
  -34.066299, -31.566299, -28.066299, -26.066299, -25.066299, -23.566299, \
  -20.816299, -17.566299, -15.316315, -13.566315, -12.566315, -11.316315, \
  -10.316315, -10.066315, -10.566315, -9.8163147, -8.3163147, -6.5663147, \
  -5.8163147, -5.5663147, -4.8163147, -4.3163147, -4.8163147, -5.0663147, \
  -4.3163147, -3.7463684, -3.7463684, -4.2463684, -4.4963684, -5.2463684, \
  -6.7463684, -8.2463684, -8.4963684, -9.2463684, -10.996368, -13.496368, \
  -16.496368, -18.996368, -19.996368, -19.746368, -19.496368, -19.746368, \
  -20.246368, -20.746368, -22.246368, -24.246368, -25.746368, -27.746368, \
  -30.746368, -33.496368, -34.246368, -32.996368, -32.246368, -33.246368, \
  -35.496368, -37.746368, -38.746368, -39.246368, -39.746368, -40.996368, \
  -42.496368/),\
(/-48.972229, -47.972229, -47.222229, -46.222229, -45.222229, -44.222229, \
  -43.222229, -42.972229, -42.722229, -42.722229, -42.722229, -42.972229, \
  -42.222229, -40.472229, -38.472229, -37.472229, -36.222229, -33.972229, \
  -31.222229, -28.472229, -26.222229, -24.722229, -24.222229, -23.472229, \
  -22.222229, -21.472229, -21.222229, -20.472229, -18.972229, -17.972229, \
  -16.972229, -15.972229, -14.972229, -14.972229, -15.472229, -15.472229, \
  -15.472229, -15.274933, -15.024933, -15.024933, -15.774933, -16.524933, \
  -17.774933, -19.524933, -20.524933, -21.524933, -23.274933, -25.024933, \
  -26.524933, -29.024933, -31.274933, -31.774933, -31.774933, -31.774933, \
  -32.024933, -32.524933, -33.274933, -34.524933, -36.524933, -39.024933, \
  -41.274933, -42.524933, -42.774933, -41.774933, -41.274933, -42.524933, \
  -45.024933, -46.774933, -47.524933, -48.024933, -49.274933, -50.774933, \
  -51.024933/),\
(/-55.730057, -53.980057, -52.730057, -52.230057, -52.105057, -52.355057, \
  -52.605057, -52.730057, -52.480057, -51.480057, -50.230057, -49.105057, \
  -48.730057, -48.730057, -48.730057, -48.480057, -47.855057, -46.480057, \
  -44.730057, -42.855057, -41.355057, -40.355057, -39.480057, -38.855057, \
  -38.480057, -37.980057, -36.855057, -35.730057, -34.605057, -33.605057, \
  -32.480057, -31.355057, -30.730057, -30.355057, -30.355057, -30.605057, \
  -30.605057, -30.367264, -30.367264, -30.492264, -30.867264, -31.867264, \
  -32.867264, -34.367264, -36.242264, -37.117264, -37.367264, -38.867264, \
  -41.117264, -43.367264, -45.492264, -46.742264, -46.867264, -47.242264, \
  -48.617264, -49.992264, -50.117264, -49.867264, -50.367264, -50.992264, \
  -50.367264, -48.867264, -47.992264, -48.492264, -49.867264, -51.117264, \
  -51.492264, -51.492264, -51.367264, -51.992264, -53.742264, -55.617264, \
  -56.117264/),\
(/-55.362122, -54.487122, -54.362122, -54.487122, -54.737122, -55.237122, \
  -55.487122, -55.362122, -54.612122, -53.487122, -52.112122, -50.737122, \
  -49.987122, -50.612122, -52.112122, -53.237122, -52.987122, -51.862122, \
  -50.862122, -50.487122, -50.237122, -49.237122, -47.737122, -46.862122, \
  -46.737122, -46.237122, -45.487122, -44.737122, -43.987122, -43.112122, \
  -42.487122, -42.112122, -41.737122, -41.362122, -40.987122, -40.487122, \
  -40.112122, -40.142456, -40.642456, -40.892456, -40.892456, -41.017456, \
  -40.892456, -41.267456, -43.017456, -44.392456, -44.767456, -45.517456, \
  -47.642456, -50.392456, -52.892456, -54.767456, -56.017456, -57.142456, \
  -58.392456, -58.892456, -58.017456, -56.142456, -54.267456, -52.142456, \
  -49.142456, -46.517456, -45.767456, -46.892456, -48.392456, -49.017456, \
  -48.892456, -49.017456, -49.642456, -51.142456, -53.267456, -55.517456, \
  -56.892456/),\
(/-56.54541, -55.79541, -55.04541, -54.79541, -55.17041, -55.67041, -55.79541, \
  -55.29541, -54.67041, -54.04541, -52.92041, -51.67041, -50.79541, \
  -51.54541, -53.67041, -55.79541, -56.67041, -56.29541, -55.54541, \
  -55.54541, -55.92041, -55.79541, -55.42041, -55.79541, -56.17041, \
  -55.54541, -54.67041, -54.29541, -53.67041, -52.92041, -52.79541, \
  -52.79541, -52.67041, -52.54541, -52.42041, -51.79541, -51.54541, \
  -52.014755, -52.389755, -52.514755, -52.389755, -52.014755, -51.514755, \
  -51.264755, -51.889755, -52.639755, -52.514755, -52.389755, -53.764755, \
  -55.514755, -57.139755, -59.389755, -61.139755, -61.264755, -60.514755, \
  -59.139755, -56.889755, -54.514755, -53.014755, -51.264755, -48.639755, \
  -46.014755, -44.639755, -44.764755, -45.514755, -46.264755, -47.139755, \
  -47.889755, -48.889755, -50.014755, -51.764755, -53.889755, -55.639755/),\
(/-55.985275, -56.735275, -56.985275, -56.360275, -55.485275, -55.235275, \
  -55.485275, -55.610275, -55.360275, -54.860275, -53.860275, -52.735275, \
  -52.360275, -53.485275, -55.485275, -57.110275, -57.610275, -57.735275, \
  -58.110275, -59.235275, -60.360275, -61.235275, -62.235275, -63.485275, \
  -63.985275, -63.610275, -63.110275, -62.985275, -63.360275, -64.110275, \
  -65.235275, -66.235275, -66.735275, -66.610275, -66.485275, -66.610275, \
  -66.860275, -67.153748, -67.403748, -66.903748, -66.528748, -66.528748, \
  -65.903748, -64.903748, -64.528748, -63.403748, -60.778748, -58.653748, \
  -58.028748, -57.153748, -56.653748, -57.778748, -59.403748, -59.403748, \
  -57.278748, -54.278748, -52.028748, -51.278748, -50.778748, -49.528748, \
  -47.903748, -46.778748, -46.028748, -46.028748, -46.528748, -47.278748, \
  -48.028748, -48.278748, -48.278748, -48.653748, -50.153748, -52.278748, \
  -54.528748/),\
(/-57.035812, -56.660812, -55.660812, -55.035812, -55.285812, -55.660812, \
  -55.660812, -55.410812, -54.910812, -54.410812, -53.910812, -53.535812, \
  -53.660812, -54.660812, -56.035812, -56.785812, -56.785812, -57.160812, \
  -59.035812, -61.785812, -63.910812, -65.285812, -66.410812, -67.160812, \
  -67.535812, -67.910812, -68.535812, -69.035812, -70.285812, -72.410812, \
  -74.410812, -76.035812, -77.285812, -77.285812, -76.410812, -76.410812, \
  -77.035812, -77.412979, -77.162979, -76.912979, -76.912979, -76.912979, \
  -76.162979, -74.662979, -74.162979, -74.162979, -72.912979, -69.412979, \
  -65.162979, -62.662979, -60.912979, -58.912979, -56.912979, -56.162979, \
  -55.912979, -55.162979, -53.912979, -52.662979, -51.662979, -50.912979, \
  -50.662979, -50.412979, -49.662979, -49.162979, -48.662979, -48.662979, \
  -48.912979, -48.912979, -48.662979, -48.412979, -48.912979, -50.412979, \
  -52.412979/)/)

level = (/1000, 850, 700, 500, 400, 300, 250, 200, 150, 100/)
labels = (/"90~S~o~N~S", "60~S~o~N~S", "30~S~o~N~S", "EQ", \
            "30~S~o~N~N", "60~S~o~N~N", "90~S~o~N~N"/)

labellocs = (/ -90.0, -60.0, -30.0, 0.0, 30.0, 60.0, 90.0/)

;
; Create an application object.
;
appid = create "cn03" appClass defaultapp
    "appUsrDir"        : "./"
    "appDefaultParent" : True
end create

;
; Default is to display output to an X workstation
;
wks_type = "x11"

if (str_lower(wks_type).eq."ncgm")
;
; Create an NCGM workstation.
;
  wid = create "cn03Work" ncgmWorkstationClass defaultapp
    "wkMetaName" : "./cn03n.ncgm"
  end create
end if
if (str_lower(wks_type).eq."x11") then
;
; Create an X workstation.
;
  wid = create "cn03Work" windowWorkstationClass defaultapp
    "wkPause" : True
  end create
end if
if (str_lower(wks_type).eq."oldps") then
;
; Create an older-style PostScript workstation.
;
  wid = create "cn03Work" psWorkstationClass defaultapp
    "wkPSFileName" : "./cn03n.ps"
  end create
end if
if (str_lower(wks_type).eq."oldpdf") then
;
; Create an older-style PDF workstation.
;
  wid = create "cn03Work" pdfWorkstationClass defaultapp
    "wkPDFFileName" : "./cn03n.pdf"
  end create
end if
if (str_lower(wks_type).eq."pdf".or.str_lower(wks_type).eq."ps") then
;
; Create a cairo PS/PDF workstation.
;
  wid = create "cn03Work" documentWorkstationClass defaultapp
    "wkFileName" : "./cn03n"
    "wkFormat" : wks_type
  end create
end if
if (str_lower(wks_type).eq."png") then
;
; Create a cairo PNG workstation.
;
  wid = create "cn03Work" imageWorkstationClass defaultapp
    "wkFileName" : "./cn03n"
    "wkFormat" : wks_type
  end create
end if

;
; Create a scalar field data object with a linear X dimension representing
; latitude and an irregular Y dimension representing geopotential height.
; Define the start and end points of the data, based on the dataset.
;

dataid = create "mydata" scalarFieldClass appid
    "sfDataArray" : T
    "sfYArray"    : level
    "sfXCStartV"  : -90.0
    "sfXCEndV"    : 90.0
    "sfYCStartV"  : 1000.0
    "sfYCEndV"    : 100.0
end create

;
; Create a ContourPlot object. Since ContourPlot contains a TickMark object by
; default, the non-default TickMark resources can be set in the ContourPlot
; object.
;
cnid = create "ContourPlot1" contourPlotClass wid
    "tiMainString"      : "Profile @ 105~S~o~N~W - Frame 1"
    "cnScalarFieldData" : dataid
    "vpXF"              : 0.125
    "vpYF"              : 0.85
    "vpWidthF"          : 0.6
    "vpHeightF"         : 0.6
    "cnLevelSpacingF"   : 5.0
    "tmXBMode"          : "explicit"
    "tmXBMinorOn"       : False
    "tmXBValues"        : labellocs
    "tmXBLabels"        : labels
end create

draw(cnid)
frame(wid)
;
; Color and add dash patterns to the lines, then display a legend
; listing the line types. The position of the Legend is controlled by
; resources set in the resource file. Thicken lines.
; Note that the Legend and LabelBar are provided to the ContourPlot object
; by its PlotManager (created by default when the ContourPlot object
; is initialized). Therefore the resources to control them have the 
; prefix 'pm' rather than 'cn'. 
;
setvalues cnid
    "tiMainString"         : "Profile @ 105~S~o~N~W - Frame 2"
    "cnMonoLineColor"      : False
    "cnMonoLineDashPattern": False
    "pmLegendDisplayMode"  : "always"
end setvalues

draw(cnid)
frame(wid)
;
; Turn lines off, and use solid color fill instead.
; Remove the Legend and display a LabelBar.
; Turn off line and high/low labels.
;
setvalues cnid
    "tiMainString"         : "Profile @ 105~S~o~N~W - Frame 3"
    "cnLinesOn"            : False
    "cnFillOn"             : True
    "pmLegendDisplayMode"  : "never"
    "pmLabelBarDisplayMode": "always"
    "cnLineLabelsOn"       : False
    "cnHighLabelsOn"       : False
    "cnLowLabelsOn"        : False
end setvalues

draw(cnid)
frame(wid)

;
; Now show the plot with the Y-Axis linearized, by overlaying the
; plot on a LogLinPlot object. Retrieve the current view coordinates
; of the ContourPlot object and pass them on to the LogLinPlot object.
; Note the LogLinPlot needs to be told the data boundaries. 
;
setvalues cnid
    "tiMainString":          "Profile @ 105~S~o~N~W - Frame 4"
end setvalues

getvalues cnid
    "vpXF"      : xvp
    "vpYF"      : yvp
    "vpWidthF"  : widthvp
    "vpHeightF" : heightvp
end getvalues

llid = create "LogLin1" logLinPlotClass wid
    "vpXF"       : xvp
    "vpYF"       : yvp
    "vpWidthF"   : widthvp
    "vpHeightF"  : heightvp
    "trXMinF"    : -90.0
    "trXMaxF"    : 90.0
    "trYMaxF"    : 1000.0
    "trYMinF"    : 100.0
    "trYReverse" : True
end create
;
; The LogLinPlot becomes the Base Plot, since it controls the coordinate
; system that we are mapping to. Overlay the ContourPlot object on the base,
; then plot the LogLinPlot object. Note that you cannot draw the ContourPlot 
; object directly, once it becomes an overlay Plot.
;
overlay(llid,cnid)
draw(llid)
frame(wid)
    
;
; Destroy the objects created, close the HLU library and exit.
;
delete(wid)

end
