.\"
.\"	$Id: rasview.m,v 1.23 2008-12-23 00:04:16 haley Exp $
.\"
.TH RASVIEW 1NCARG "January 1993" NCARG "NCAR GRAPHICS"
.SH NAME
rasview \- Raster file previewer for the X Window System.
.SH SYNOPSIS
.B rasview
[
.BI \-toolkitoption " ..."
] [
.BI \-ifmt " format"
] [
.B \-movie
] [
.BI \-pal " palette_file"
] [
.B \-quiet
] [
.B \-Version
] [
.I file.ext
|
.B -
]

.SH DESCRIPTION
.LP
.B rasview
displays raster imagery from a file into an X window.
By default rasview determines the format of an image file by looking at
its file name extension. 
For example, an xwd (X11 Window Dump) file might
be named
.BR foo.xwd .
.LP
Raster image file formats come in a variety of flavors. 
.B rasview
attempts to support 8-bit-indexed, and 24-bit-direct encodings of the image
formats listed below. Similarly, only output devices with 8-bit or 24-bit
depth are supported.
.B rasview 
attempts to select an X11 Visual which best matches the encoding
of the image file. A PseudoColor visual class is preferred for 8-bit-indexed
imagery, while a DirectColor visual class is preferred for 24-bit-direct
encoded imagery. In the case of 24-bit-direct encodings, if the output
device only has 8-bit color the imagery is color-quantized down to 8 bits.
.LP
In general raster files contain only a single image. 
.B rasview 
is able to display multiple-image raster files if they 
were created by the concatenation of single-image files with the 
.B rascat(1NCARG)
utility or if they were generated by 
.BR ctrans(1NCARG) . 
Multi-frame image files
generated by other means are not guaranteed to be displayable by 
.BR rasview .
.LP
See 
.B ras_formats(5NCARG)
for a list of supported image formats.
.SH OPTIONS
.B rasview
accepts all of the standard X Toolkit command line options (see X11(7)). 
.B rasview
also accepts the following options:
.TP
.BI \-ifmt " format"
Specify the input file format. 
.I format
is one of the aforementioned file name extensions (without the ".", e.g. 
.BR xwd). 
When this option is 
specified file name extensions are not necessary and are ignored if present.
All input files must have the same format.
.TP
.B \-movie
Normally when processing multi-image raster files,
.B rasview 
waits for a mouse click before proceeding to the next frame. When this
option is used 
.B rasview
immediately advances the frame after 
.B rasview
has completed drawing it.
.TP
.BI \-pal " palette_file"
Use the color palette contained in the file
.IR palette_file .
for displaying images. This palette will override the color palette stored
with the image.
.IP
See 
.B ras_palette(5NCARG)
for a description of palette file forats.
.TP
.B \-quiet
Operate in quiet mode.
.TP
.B \-Version
Print the version number and then exit.
.TP
.B \-
Read rasterfile from standard input (-ifmt option required).
.SH "SEE ALSO"
.BR ctrans (1NCARG),
.BR rascat (1NCARG),
.BR ras_formats (5NCARG),
.BR ras_palette (5NCARG),
.BR xwd (1),
.BR xwud (1)
.BR X11 (7)
.br
.ne 5
.sp
Hardcopy:
NCAR Graphics Fundamentals, UNIX Version
.SH BUGS/CAVEATS
.B rasview 
does not respond to redraw events.
.SH COPYRIGHT
Copyright (C) 1987-2009
.br
University Corporation for Atmospheric Research
.br

The use of this Software is governed by a License Agreement.
