#nec_radiation_pattern.py

#header generated by SWIG

import _PyNEC

def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name) or (name == "thisown"):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types

#end of the header generated by SWIG



import numarray
import math
import exceptions

#some utility functions

def _get_gain(arg0):
	"""
	Returns the array of gains in dB used in the averaging process.
	"""
	return _reshape(_PyNEC.nec_radiation_pattern_get_gain(arg0),arg0)


def _get_n_theta(arg0):
	"""
	Returns the number of theta angles (or of z values if the calculation mode chosen is mode 1 ).
	"""
    	return _PyNEC.nec_radiation_pattern_get_ntheta(arg0)


def _get_n_phi(arg0):
	"""
	Returns the number of phi angles.
	"""
    	return _PyNEC.nec_radiation_pattern_get_nphi(arg0)


def _get_theta_start(arg0):
	"""
	Returns the first value of theta in degrees (or of z in meters if the calculation mode chosen is mode 1 ).
	"""
	return _PyNEC.nec_radiation_pattern_get_theta_start(arg0)


def _get_delta_theta(arg0): 
	"""
	Returns the increment for theta in degrees (or for z in meters if the calculation mode chosen is mode 1 ).
	"""
	return _PyNEC.nec_radiation_pattern_get_delta_theta(arg0)

def _get_phi_start(arg0):
	"""
	Returns the first value of phi in degrees.
	"""
	return _PyNEC.nec_radiation_pattern_get_phi_start(arg0)

    
def _get_delta_phi(arg0):
	"""
	Returns the increment for phi in degrees.
	"""
	return _PyNEC.nec_radiation_pattern_get_delta_phi(arg0)


def _get_wavelength(arg0):
	"""
	Returns the wavelength in meters.
	"""
	return (299.8*1e6/arg0.get_frequency())
	

def _get_range(arg0):
	"""
	Returns the radial distance in meters ( or the rho cylindrical coordinate in meters if the calculation mode chosen is mode 1 ).
	"""
	return _PyNEC.nec_radiation_pattern_get_range(arg0) 


def _reshape(arg0,arg1):
	"""
	Changes the shape of the array arg0 to (n_phi, n_theta) to balance the effect of the typemaps which return flat arrays.
	"""
	n_theta=_get_n_theta(arg1)
    	n_phi=_get_n_phi(arg1)
    	return numarray.reshape(arg0,(n_phi,n_theta))



#the following functions precise the results that can be requested from the radiation pattern

def _get_ifar(arg0):
	"""
	Returns the flag (no units) which indicates the calculation mode chosen.
	"""
	return _PyNEC.nec_radiation_pattern_get_ifar(arg0)
	
	
def _get_rp_normalization(arg0):
	"""
	Returns the flag (no units) which indicates the target of the normalization process.
	"""
	return _PyNEC.nec_radiation_pattern_get_rp_normalization(arg0)


def _get_rp_output_format(arg0):
	"""
	Returns the flag (no units) which indicates the output format chosen.
	"""
	return _PyNEC.nec_radiation_pattern_get_rp_output_format(arg0)
	
	
def _get_rp_average(arg0):
	"""
	Returns the flag (no units) which indicates whether the average gain will be computed or not.
	"""
	return _PyNEC.nec_radiation_pattern_get_rp_power_average(arg0)


def _get_rp_ipd(arg0):
	"""
	Returns the flag (no units) which indicates the type of gain computed : power or directive gain.
	"""
	return _PyNEC.nec_radiation_pattern_get_rp_ipd(arg0)



#class "nec_radiation_pattern"

class nec_radiation_pattern(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, nec_radiation_pattern, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, nec_radiation_pattern, name)
    def __init__(self): raise RuntimeError, "No constructor defined"
    def __repr__(self):
        return "<%s.%s; proxy of C++ nec_radiation_pattern instance at %s>" % (self.__class__.__module__, self.__class__.__name__, self.this,)
    
    
    def get_frequency(*args):
    	"""
	Returns the frequency in Herz.
	"""
    	return _PyNEC.nec_radiation_pattern_get_frequency(*args)
    
    
    def get_ground(*args):
    	"""
	Returns the associated ground object.
	"""
    	_ifar = _get_ifar(*args)
	ground = _PyNEC.nec_radiation_pattern_get_ground(*args)
	ground._ifar = _ifar
	return ground


    def get_radial_distance(*args):
    	"""
	Returns the radial distance in meters provided the calculation mode chosen is different from mode 1.
	"""
    	if _get_ifar(*args) != 1 :
		return _get_range(*args)
	else :
		error_msg = " The radial distance is not defined for this calculation mode."
		raise exceptions.Warning(error_msg) 
  	


    def get_radial_attenuation(self):
    	"""
	Returns the radial attenuation (no units) provided the calculation mode chosen is different from mode 1.
	"""
    	if (_get_ifar(self) != 1) :
		_range = _get_range(self)
		if (_range >= 1.0e-20) :
			_wavelength = _get_wavelength(self) 
			exrm = 1.0 / _range;
			exra = _range/ _wavelength;
			exra = -360.0*(exra - math.floor(exra));
			return ("EXP(-JKR)/R : %.5e at phase %.2f degrees" % (exrm, exra))
		else :
			error_msg = "The radial distance value is bellow 1E-20 : the attenuation is ignored."
			raise exceptions.Warning(error_msg)
	else :
		error_msg = "The radial attenuation is not available for this calculation mode."
		raise exceptions.Warning(error_msg)
			
	
    def get_calculation_mode(*args):
    	"""
	Returns the calculation mode.
	"""
    	_ifar = _get_ifar(*args)
	if _ifar == 0 :
		return "Normal mode"
	elif _ifar == 1 :
		return "A surface wave propagating along the ground is added to the normal space wave. The results appear in a special output format."
	elif _ifar == 2 :
		return "Linear cliff with antenna above upper level"
	elif _ifar == 3 :
		return "Circular cliff centered at origin of coordinate system: with antenna above upper level"
	elif _ifar == 4 :
		return "Radial wire ground screen centered at origin"
	elif _ifar == 5 :
		return "Both radial wire ground screen and linear cliff"
	elif _ifar == 6 :
		return "Both radial wire ground screen ant circular cliff"
	else :
		error_msg = "Unknown calculation mode."
		raise exceptions.Warning(error_msg)
    
    
    def get_coordinates(*args):
    	"""
	Returns the array of coordinates of the elements of the other arrays :
		either an array of tuples (theta, phi) or of tuples (rho, phi, z) - either in (degrees, degrees) or in (meters, degrees, meters).
	"""
    	_ifar = _get_ifar(*args)
	n_theta=_get_n_theta(*args)
        n_phi=_get_n_phi(*args)
	theta_start = _get_theta_start(*args)
	delta_theta = _get_delta_theta(*args)
	phi_start = _get_phi_start(*args)
	delta_phi = _get_delta_phi(*args)
	l=[]
	
	if _ifar == 1 :
		rho = _PyNEC.nec_radiation_pattern_get_range(*args)
		for i in range(n_phi) :
			for j in range(n_theta) :
				l.append((rho, phi_start+i*delta_phi,theta_start+j*delta_theta))
		ar = numarray.array(l);
		ar = numarray.reshape(ar, (n_phi,n_theta,3))
	
	else :
		for i in range(n_phi) :
			for j in range(n_theta) :
				l.append((theta_start+j*delta_theta, phi_start+i*delta_phi))
		ar = numarray.array(l);
		ar = numarray.reshape(ar, (n_phi,n_theta,2))
	
	return ar  
		
	
    def get_gain_type(*args):
    	"""
	Returns the type of gain computed : power or directive gain.
	"""
    	if _get_ifar(*args) != 1 :
		ipd = _get_rp_ipd(*args)
		if ipd == 0 :
			return "Power gain"
		elif ipd == 1 :
			return "Directive gain"
		else :
			error_msg = "Unknown gain type."
			raise exceptions.Warning(error_msg)
	else :
		error_msg = "No computing of gain has been requested."
		raise exceptions.Warning(error_msg)


    def get_output_format(*args):
    	"""
	Returns the type of output format.
	"""
	_output_format = _get_rp_output_format(*args)
	if _output_format == 0 :
		return 'major axis, minor axis and total gain computed'
	elif _output_format == 1 :
		return 'vertical, horizontal ant total gain printed'
	else :
		error_msg = "Unknown output format."
		raise exceptions.Warning(error_msg)


    def get_gain_vert(*args):
    	"""
	Returns the array of vertical gains provided the output format chosen is format 1.
	"""
    	if _get_rp_output_format(*args)==1 :
		return _reshape(_PyNEC.nec_radiation_pattern_get_gain_vert(*args),*args)
    	else :
		error_msg="The computing of the vertical gain has not been requested. Try and get the 'major axis' gain instead."
		raise exceptions.Warning(error_msg)


    def get_gain_horiz(*args):
    	"""
	Returns the array of horizontal gains in dB provided the output format chosen is format 1.
	"""
    	if _get_rp_output_format(*args)==1 :
		return _reshape(_PyNEC.nec_radiation_pattern_get_gain_horiz(*args),*args)
	else :
		error_msg="The computing of the horizontal gain has not been requested. Try and get the 'minor axis' gain instead."
		raise exceptions.Warning(error_msg)
    
    
    def get_gain_major_axis(*args):
    	"""
	Returns the array of major axis gains in dB provided the output format chosen is format 0.
	"""
    	if _get_rp_output_format(*args)==0 :
		return _reshape(_PyNEC.nec_radiation_pattern_get_gain_vert(*args),*args)
    	else :
		error_msg="The computing of the 'major axis' gain has not been requested. Try and get the vertical gain instead."
		raise exceptions.Warning(error_msg)


    def get_gain_minor_axis(*args):
    	"""
	Returns the array of minor axis gains in dB provided the output format chosen is format 0.
	"""
    	if _get_rp_output_format(*args)==0 :
		return _reshape(_PyNEC.nec_radiation_pattern_get_gain_horiz(*args),*args)
	else :
		error_msg="The computing of the 'minor axis' gain has not been requested. Try and get the horizontal gain instead."
		raise exceptions.Warning(error_msg)

		
    def get_gain_tot(*args):
    	"""
	Returns the array of total gains in dB.
	"""
    	return _reshape(_PyNEC.nec_radiation_pattern_get_gain_tot(*args),*args)



    def get_normalization_target(*args):
    	"""
	Returns the target of the normalization process.
	"""
    	_rp_normalization = _get_rp_normalization(*args)
	
	if _rp_normalization == 0 :
		return "No normalized gain"
	elif _rp_normalization == 1 :
		return "Major axis gain normalized"
	elif _rp_normalization == 2 :
		return "minor axis gain normalized"
	elif _rp_normalization == 3 :
		return "Vertical gain normalized"     
	elif _rp_normalization == 4 :
		return "Horizontal gain normalized"
	elif _rp_normalization == 5 :
		return "Total gain normalized"
	else :
		error_msg='Unknown normalization target.'
		raise exceptions.Warning(error_msg)

	
    def get_normalization_factor(*args):
    	"""
	Returns the normalization factor in dB provided a normalization has been requested.
	"""
    	if (_get_rp_normalization(*args)) != 0 :
		return _PyNEC.nec_radiation_pattern_get_normalization_factor(*args)
	else :
		error_msg = "No normalization has been requested."
		raise exceptions.Warning(error_msg)
    
    
    def get_normalized_gain(*args):
    	"""
	Returns the array of normalized gains in dB.
	"""
    	return _get_gain(*args)-args[0].get_normalization_factor()
    
	
    def get_pol_axial_ratio(*args):
    	"""
	Returns the array of polarization axial ratio (no units).
	"""
    	return _reshape(_PyNEC.nec_radiation_pattern_get_pol_axial_ratio(*args),*args)
	
	
    def get_pol_tilt(*args):
    	"""
	Returns the array of polarization tilt in degrees.
	"""
    	return _reshape(_PyNEC.nec_radiation_pattern_get_pol_tilt(*args),*args)
	
	
    def get_pol_sense_index(*args):
    	"""
	Returns the array of polarization sense index (no units). The relationship between the index and the actual sense is the following :
		0 : linear
		1 : right 
		2 : left
	"""
    	return _reshape(_PyNEC.nec_radiation_pattern_get_pol_sense_index(*args),*args)
    	
         
    
    def get_e_theta(*args):
    	"""
	Returns the array of complex theta-component of electric field E in Volt/meter.
	"""
    	return _reshape(_PyNEC.nec_radiation_pattern_get_e_theta(*args),*args)
	

    def get_e_phi(*args):
    	"""
	Returns the array of complex phi-component of electric field E in Volt/meter.
	"""
    	return _reshape(_PyNEC.nec_radiation_pattern_get_e_phi(*args),*args)
	

    def get_e_r(*args):
    	"""
	Returns the array of complex radial-component of electric field E in Volt/meter - only available for the calculation mode 1.
	"""
    	if _get_ifar(*args) == 1 :
		return _reshape(_PyNEC.nec_radiation_pattern_get_e_r(*args),*args)
	else :
		error_msg="The radial field is not available for this calculation mode."
		raise exceptions.Warning(error_msg)



    def get_average_gain(*args):
    	"""
	Returns the array of average power gains in dB, provided its computation has been requested.
	"""
    	_rpa=_get_rp_power_average(*args)
	if _rpa==1 or _rpa==2 : 
		return _PyNEC.nec_radiation_pattern_get_average_gain(*args)
	else :
		error_msg="The computing of the average gain has not been requested."
		raise exceptions.Warning(error_msg)
    
    
    def get_average_solid_angle(*args):
    	"""
	Returns the solid angle in steradians used in the averaging process, provided the computation of an average gain has been requested.
	"""
    	_rpa=_get_rp_power_average(*args)
	if _rpa==1 or _rpa==2 :
		return _PyNEC.nec_radiation_pattern_get_average_solid_angle(*args)
	else :
		error_msg="The computing of the average gain has not been requested."
		raise exceptions.Warning(error_msg)
     
    

class nec_radiation_patternPtr(nec_radiation_pattern):
    def __init__(self, this):
        _swig_setattr(self, nec_radiation_pattern, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, nec_radiation_pattern, 'thisown', 0)
        _swig_setattr(self, nec_radiation_pattern,self.__class__,nec_radiation_pattern)
_PyNEC.nec_radiation_pattern_swigregister(nec_radiation_patternPtr)
