/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.values.FunctionSubEvent;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;

class FunctionBreakpointPanel extends BreakpointPanel {

    private FunctionBreakpoint fb;
    
    public void seed(NativeBreakpoint breakpoint) {
	seedCommonComponents(breakpoint);
	fb = (FunctionBreakpoint) breakpoint;

	String function = fb.getFunction();
	if (function != null) {
	    functionText.setText(function);
	}

	FunctionSubEvent fbe = fb.getSubEvent();
	if (fbe == FunctionSubEvent.IN)
	    functionToggle.setSelected(true);
	else if (fbe == FunctionSubEvent.INFUNCTION)
	    functionsToggle.setSelected(true);
	else if (fbe == FunctionSubEvent.RETURNS)
	    returnToggle.setSelected(true);
    }

    /*
     * Constructors
     */

    public FunctionBreakpointPanel() {
	this(new FunctionBreakpoint(NativeBreakpoint.TOPLEVEL), false);
    } 

    public FunctionBreakpointPanel(NativeBreakpoint b) {
	this((FunctionBreakpoint) b, true);
    } 

    private FunctionBreakpointPanel(FunctionBreakpoint breakpoint,
				   boolean customizing) {
	super(breakpoint, customizing);
	fb = breakpoint;

	initComponents();
	initA11y();
	addCommonComponents(4);

	if (!customizing) {
	    String selection = EditorBridge.getCurrentSelection();
	    if (selection != null) {
		breakpoint.setFunction(selection);
	    }
	}

	seed(breakpoint);

	// Arrange to revalidate on changes
	functionText.getDocument().addDocumentListener(this);

	// None of the following seem to have the desired effect
	/*
	functionText.requestDefaultFocus();
	functionText.requestFocus();
	*/
	// functionText.requestFocusInWindow();
    }
    
    public void setDescriptionEnabled(boolean enabled) {
	// functionLabel.setEnabled(false);
	functionText.setEnabled(false);
	functionToggle.setEnabled(false);
	functionsToggle.setEnabled(false);
	returnToggle.setEnabled(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
	java.awt.GridBagConstraints gridBagConstraints;

	buttonGroup1 = new javax.swing.ButtonGroup();
	functionLabel = new javax.swing.JLabel();
	functionText = new javax.swing.JTextField();

	functionToggle = new javax.swing.JRadioButton();
	functionsToggle = new javax.swing.JRadioButton();
	returnToggle = new javax.swing.JRadioButton();

	panel_settings.setLayout(new java.awt.GridBagLayout());

	functionLabel.setText(Catalog.get("Function"));	// NOI18N
	functionLabel.setDisplayedMnemonic(
	    Catalog.getMnemonic("MNEM_Function"));	// NOI18N
	functionLabel.setLabelFor(functionText);
	gridBagConstraints = new java.awt.GridBagConstraints();
	gridBagConstraints.ipadx = 5;
	gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
	panel_settings.add(functionLabel, gridBagConstraints);

	functionText.setEditable(true);
	gridBagConstraints = new java.awt.GridBagConstraints();
	gridBagConstraints.gridwidth = 3;
	gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
	gridBagConstraints.weightx = 1.0;
	panel_settings.add(functionText, gridBagConstraints);


	functionToggle.setMnemonic(
	    Catalog.getMnemonic("MNEM_Func"));		// NOI18N
	functionToggle.setText(FunctionSubEvent.IN.toString());
	functionToggle.setSelected(true);
	buttonGroup1.add(functionToggle);
	gridBagConstraints = new java.awt.GridBagConstraints();
	gridBagConstraints.gridx = 0;
	gridBagConstraints.gridwidth = 4;
	gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
	panel_settings.add(functionToggle, gridBagConstraints);

	functionsToggle.setMnemonic(
	    Catalog.getMnemonic("MNEM_AllFuncs"));	// NOI18N
	functionsToggle.setText(FunctionSubEvent.INFUNCTION.toString());
	buttonGroup1.add(functionsToggle);
	gridBagConstraints = new java.awt.GridBagConstraints();
	gridBagConstraints.gridx = 0;
	gridBagConstraints.gridwidth = 4;
	gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
	panel_settings.add(functionsToggle, gridBagConstraints);

	returnToggle.setMnemonic(
	    Catalog.getMnemonic("MNEM_OnReturn"));	// NOI18N
	returnToggle.setText(FunctionSubEvent.RETURNS.toString());
	buttonGroup1.add(returnToggle);
	gridBagConstraints = new java.awt.GridBagConstraints();
	gridBagConstraints.gridx = 0;
	gridBagConstraints.gridwidth = 4;
	gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
	panel_settings.add(returnToggle, gridBagConstraints);

    }//GEN-END:initComponents

    private void initA11y() {
	    functionToggle.getAccessibleContext().setAccessibleDescription(
		functionToggle.getText()
	    );
	    functionsToggle.getAccessibleContext().setAccessibleDescription(
		functionsToggle.getText()
	    );
	    returnToggle.getAccessibleContext().setAccessibleDescription(
		returnToggle.getText()
	    );
	    Catalog.setAccessibleDescription(functionText,
					     "ACSD_Function"); // NOI18N
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel functionLabel;
    private javax.swing.JTextField functionText;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton functionToggle;
    private javax.swing.JRadioButton functionsToggle;
    private javax.swing.JRadioButton returnToggle;
    // End of variables declaration//GEN-END:variables

    protected void assignProperties() {
	FunctionSubEvent fbe = null;
	if (functionToggle.isSelected()) {
	    fbe = FunctionSubEvent.IN;
	} else if (functionsToggle.isSelected()) {
	    fbe = FunctionSubEvent.INFUNCTION;
	} else if (returnToggle.isSelected()) {
	    fbe = FunctionSubEvent.RETURNS;
	}

	String ff = functionText.getText();
	if (ff != null && !ff.equals(fb.getFunction())) {
	    fb.setFunction(ff);
	    fb.setQfunction(ff);
	}

	if (!fb.getSubEvent().equals(fbe))
	    fb.setSubEvent(fbe);
    }
    
    protected boolean propertiesAreValid() {
	// Actually return whether minimal amount of data has been specified.

	String text = functionText.getText();
	if (IpeUtils.isEmpty(text)) {
	    return false;
	} else {
	    return true;
	}
    }
}
