/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.deployment.wm;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author  Martin Ryzl
 */
public class WindowsMobileCustomizerPanel extends javax.swing.JPanel {
    
    /** Creates new form WindowsMobileCustomizerPanel */
    public WindowsMobileCustomizerPanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        applicationLocation = new javax.swing.JTextField();
        browseApplicationLocation = new javax.swing.JButton();
        noteLabel = new javax.swing.JLabel();

        jLabel1.setLabelFor(applicationLocation);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(WindowsMobileCustomizerPanel.class, "WindowsMobileCustomizerPanel.jLabel1.text")); // NOI18N

        applicationLocation.setText(org.openide.util.NbBundle.getMessage(WindowsMobileCustomizerPanel.class, "WindowsMobileCustomizerPanel.applicationLocation.text")); // NOI18N
        applicationLocation.setName(org.openide.util.NbBundle.getMessage(WindowsMobileCustomizerPanel.class, "WindowsMobileCustomizerPanel.applicationLocation.name")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(browseApplicationLocation, org.openide.util.NbBundle.getMessage(WindowsMobileCustomizerPanel.class, "WindowsMobileCustomizerPanel.browseApplicationLocation.text")); // NOI18N
        browseApplicationLocation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseApplicationLocationActionPerformed(evt);
            }
        });

        noteLabel.setText(org.openide.util.NbBundle.getMessage(WindowsMobileCustomizerPanel.class, "WindowsMobileCustomizerPanel.noteLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(applicationLocation, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 216, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(browseApplicationLocation))
                    .add(noteLabel))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(browseApplicationLocation)
                    .add(applicationLocation, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(noteLabel)
                .addContainerGap(260, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void browseApplicationLocationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseApplicationLocationActionPerformed
// TODO add your handling code here:
        RemoteFilesystemChooser rfc = new RemoteFilesystemChooser(applicationLocation.getText(), true);
        final DialogDescriptor dd = new DialogDescriptor(rfc, org.openide.util.NbBundle.getBundle(WindowsMobileCustomizerPanel.class).getString("TITLE_BrowseAppLocation"));
        dd.setValid(false);
        rfc.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (NotifyDescriptor.PROP_VALID.equals(evt.getPropertyName())){
                    boolean valid = (Boolean)evt.getNewValue();
                    dd.setValid(valid);
                }
            }
        });
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (NotifyDescriptor.OK_OPTION == dd.getValue()){
            applicationLocation.setText(rfc.getSelectedFile());
        }        
    }//GEN-LAST:event_browseApplicationLocationActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField applicationLocation;
    private javax.swing.JButton browseApplicationLocation;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel noteLabel;
    // End of variables declaration//GEN-END:variables
    
}
