/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2009-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2009 - 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.db.sql.history;

import java.util.*;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="history")
public class SQLHistory implements Set<SQLHistoryEntry> {
    @XmlTransient
    private int historyLimit = 100;
    @XmlElement(name="sql")
    private Set<SQLHistoryEntry> history;

    public SQLHistory() {
        history = new HashSet<SQLHistoryEntry>();
    }

    @Override
    public String toString() {
        return history.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return history.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return history.toArray();
    }

    @Override
    public int size() {
        return history.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return history.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return history.removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return history.remove(o);
    }

    @Override
    public Iterator<SQLHistoryEntry> iterator() {
        return history.iterator();
    }
     
    @Override
    public boolean isEmpty() {
        return history.isEmpty();
    }
    
    @Override
    public int hashCode() {
        return history.hashCode();
    }
    
    @Override
    @SuppressWarnings("EqualsWhichDoesntCheckParameterClass")
    public boolean equals(Object o) {
        return history.equals(o);
    }
    
    @Override
    public boolean containsAll(Collection<?> c) {
        return history.containsAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return history.contains(o);
    }

    @Override
    public void clear() {
        history.clear();
    }
     
    @Override
    public boolean addAll(Collection<? extends SQLHistoryEntry> c) {
        boolean changed = false;
        for(SQLHistoryEntry sqe: c) {
            changed |= this.add(sqe);
        }
        return changed;
    }
    
    @Override
    public boolean add(SQLHistoryEntry e) {
        boolean result = history.add(e);
        if(! result) {
            history.remove(e);
            result = history.add(e);
        }
        enforceLimit();
        return result;
    }
    
    public void enforceLimit() {
        if(size() > historyLimit) {
            List<SQLHistoryEntry> list = new ArrayList<SQLHistoryEntry>(history);
            Collections.sort(list, new Comparator<SQLHistoryEntry>() {
                @Override
                public int compare(SQLHistoryEntry o1, SQLHistoryEntry o2) {
                    return o2.getDate().compareTo(o1.getDate());
                }
            });
            history.clear();
            history.addAll(list.subList(0, historyLimit));
        }
    }
    
    @XmlTransient
    public int getHistoryLimit() {
        return historyLimit;
    }

    public void setHistoryLimit(int historyLimit) {
        this.historyLimit = historyLimit;
        enforceLimit();
    }
}
