find_package(PkgConfig)
if (PKG_CONFIG_FOUND)
    if (Pango_FIND_REQUIRED)
        set(_pkgconfig_REQUIRED REQUIRED)
    endif ()
    pkg_search_module(Pango ${_pkgconfig_REQUIRED} pango pangocairo)
    pkg_search_module(PangoFT2 ${_pkgconfig_REQUIRED} pangoft2)
    if (Pango_LINK_LIBRARIES)
        set(Pango_LIBRARIES ${Pango_LINK_LIBRARIES}) # HACK
    endif()
    if (PangoFT2_LINK_LIBRARIES)
        set(PangoFT2_LIBRARIES ${PangoFT2_LINK_LIBRARIES}) # HACK
    endif()
else ()
    # find_path(Pango_INCLUDE_DIRS)
    # find_library(Pango_LIBRARIES)
    if (Pango_INCLUDE_DIRS AND Pango_LIBRARIES)
        set(Pango_FOUND 1)
        if (NOT Pango_FIND_QUIETLY)
            message(STATUS "Found Pango: ${Pango_LIBRARIES}")
        endif ()
    elseif (Pango_FIND_REQUIRED)
        message(SEND_ERROR "Could not find Pango")
    elseif (NOT Pango_FIND_QUIETLY)
        message(STATUS "Could not find Pango")
    endif ()
endif ()
mark_as_advanced(Pango_INCLUDE_DIRS Pango_LIBRARIES)
mark_as_advanced(PangoFT2_INCLUDE_DIRS PangoFT2_LIBRARIES)
