/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class HTMLEmitter
extends XMLEmitter {
    private static final int REP_NATIVE = 0;
    private static final int REP_ENTITY = 1;
    private static final int REP_DECIMAL = 2;
    private static final int REP_HEX = 3;
    private int nonASCIIRepresentation = 0;
    private int excludedRepresentation = 1;
    private int inScript;
    private int version = 4;
    private String elementName;
    private short uriCode;
    static HTMLTagHashSet emptyTags = new HTMLTagHashSet(31);
    private static HTMLTagHashSet booleanAttributes;
    private static HTMLTagHashSet booleanCombinations;
    private static final String[] latin1Entities;

    private static int representationCode(String rep) {
        if (rep.equalsIgnoreCase("native")) {
            return 0;
        }
        if (rep.equalsIgnoreCase("entity")) {
            return 1;
        }
        if (rep.equalsIgnoreCase("decimal")) {
            return 2;
        }
        if (rep.equalsIgnoreCase("hex")) {
            return 3;
        }
        return 1;
    }

    private static void setEmptyTag(String tag) {
        emptyTags.add(tag);
    }

    protected static boolean isEmptyTag(String tag) {
        return emptyTags.contains(tag);
    }

    private static void setBooleanAttribute(String element, String attribute) {
        booleanAttributes.add(attribute);
        booleanCombinations.add(element + '+' + attribute);
    }

    private static boolean isBooleanAttribute(String element, String attribute, String value) {
        return attribute.equalsIgnoreCase(value) && booleanAttributes.contains(attribute) && booleanCombinations.contains(element + '+' + attribute);
    }

    public void open() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        String byteOrderMark;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.started) {
            return;
        }
        this.started = true;
        String versionProperty = this.outputProperties.getProperty("version");
        if (versionProperty != null) {
            if (versionProperty.equals("4.0") || versionProperty.equals("4.01")) {
                this.version = 4;
            } else if (versionProperty.equals("5.0")) {
                this.version = 5;
            } else {
                XPathException err = new XPathException("Unsupported HTML version: " + versionProperty);
                err.setErrorCode("SESU0013");
                throw err;
            }
        }
        if ("yes".equals(byteOrderMark = this.outputProperties.getProperty("byte-order-mark")) && "UTF-8".equalsIgnoreCase(this.outputProperties.getProperty("encoding"))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException err) {
                // empty catch block
            }
        }
        String systemId = this.outputProperties.getProperty("doctype-system");
        String publicId = this.outputProperties.getProperty("doctype-public");
        if ("".equals(systemId)) {
            systemId = null;
        }
        if ("".equals(publicId)) {
            publicId = null;
        }
        if (systemId != null || publicId != null || this.version == 5) {
            this.writeDocType("html", systemId, publicId);
        }
        this.inScript = -1000000;
        String representation = this.outputProperties.getProperty("{http://saxon.sf.net/}character-representation");
        if (representation != null) {
            String excludedRep;
            String nonASCIIrep;
            int semi = representation.indexOf(59);
            if (semi < 0) {
                excludedRep = nonASCIIrep = Whitespace.trim(representation);
            } else {
                nonASCIIrep = Whitespace.trim(representation.substring(0, semi));
                excludedRep = Whitespace.trim(representation.substring(semi + 1));
            }
            this.nonASCIIRepresentation = HTMLEmitter.representationCode(nonASCIIrep);
            this.excludedRepresentation = HTMLEmitter.representationCode(excludedRep);
            if (this.excludedRepresentation == 0) {
                this.excludedRepresentation = 1;
            }
        }
    }

    protected void writeDocType(String type, String systemId, String publicId) throws XPathException {
        if (this.version == 5) {
            try {
                this.writer.write("<!DOCTYPE HTML>\n");
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        } else {
            super.writeDocType(type, systemId, publicId);
        }
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        super.startElement(nameCode, typeCode, locationId, properties);
        this.uriCode = this.namePool.getURICode(nameCode);
        this.elementName = (String)this.elementStack.peek();
        if (this.uriCode == 0 && (this.elementName.equalsIgnoreCase("script") || this.elementName.equalsIgnoreCase("style"))) {
            this.inScript = 0;
        }
        ++this.inScript;
    }

    public void startContent() throws XPathException {
        this.closeStartTag();
    }

    protected void writeAttribute(int elCode, String attname, CharSequence value, int properties) throws XPathException {
        try {
            if (this.uriCode == 0 && HTMLEmitter.isBooleanAttribute(this.elementName, attname, ((Object)value).toString())) {
                this.writer.write(attname);
                return;
            }
            super.writeAttribute(elCode, attname, value, properties);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected void writeEscape(CharSequence chars, boolean inAttribute) throws IOException, XPathException {
        boolean[] specialChars;
        int segstart = 0;
        boolean[] blArray = specialChars = inAttribute ? specialInAtt : specialInText;
        if (chars instanceof CompressedWhitespace) {
            ((CompressedWhitespace)chars).writeEscape(specialChars, this.writer);
            return;
        }
        boolean disabled = false;
        while (segstart < chars.length()) {
            char c;
            int i;
            if (this.nonASCIIRepresentation == 0) {
                for (i = segstart; i < chars.length() && ((c = chars.charAt(i)) < '\u007f' ? !specialChars[c] : this.characterSet.inCharset(c) && c > '\u00a0'); ++i) {
                }
            } else {
                while (i < chars.length() && (c = chars.charAt(i)) < '\u007f' && !specialChars[c]) {
                    ++i;
                }
            }
            if (i == chars.length()) {
                if (segstart == 0) {
                    this.writeCharSequence(chars);
                } else {
                    this.writeCharSequence(chars.subSequence(segstart, i));
                }
                return;
            }
            if (i > segstart) {
                this.writeCharSequence(chars.subSequence(segstart, i));
            }
            if ((c = chars.charAt(i)) == '\u0000') {
                disabled = !disabled;
            } else if (disabled) {
                this.writer.write(c);
            } else if (c <= '\u007f') {
                if (inAttribute) {
                    if (c == '<') {
                        this.writer.write(60);
                    } else if (c == '>') {
                        this.writer.write("&gt;");
                    } else if (c == '&') {
                        if (i + 1 < chars.length() && chars.charAt(i + 1) == '{') {
                            this.writer.write(38);
                        } else {
                            this.writer.write("&amp;");
                        }
                    } else if (c == '\"') {
                        this.writer.write("&#34;");
                    } else if (c == '\n') {
                        this.writer.write("&#xA;");
                    } else if (c == '\t') {
                        this.writer.write("&#x9;");
                    } else if (c == '\r') {
                        this.writer.write("&#xD;");
                    }
                } else if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else if (c == '&') {
                    this.writer.write("&amp;");
                } else if (c == '\r') {
                    this.writer.write("&#xD;");
                }
            } else {
                if (c < '\u00a0') {
                    XPathException err = new XPathException("Illegal HTML character: decimal " + c);
                    err.setErrorCode("SERE0014");
                    throw err;
                }
                if (c == '\u00a0') {
                    this.writer.write("&nbsp;");
                } else if (c >= '\ud800' && c <= '\udbff') {
                    int charval = (c - 55296) * 1024 + (chars.charAt(i + 1) - 56320) + 65536;
                    this.outputCharacterReference(charval);
                    ++i;
                } else if (this.characterSet.inCharset(c)) {
                    switch (this.nonASCIIRepresentation) {
                        case 0: {
                            this.writer.write(c);
                            break;
                        }
                        case 1: {
                            if (c > '\u00a0' && c <= '\u00ff') {
                                this.writer.write(38);
                                this.writer.write(latin1Entities[c - 160]);
                                this.writer.write(59);
                                break;
                            }
                        }
                        case 2: {
                            this.preferHex = false;
                            this.outputCharacterReference(c);
                            break;
                        }
                        case 3: {
                            this.preferHex = true;
                        }
                        default: {
                            this.outputCharacterReference(c);
                            break;
                        }
                    }
                } else {
                    switch (this.excludedRepresentation) {
                        case 1: {
                            if (c > '\u00a0' && c <= '\u00ff') {
                                this.writer.write(38);
                                this.writer.write(latin1Entities[c - 160]);
                                this.writer.write(59);
                                break;
                            }
                        }
                        case 0: 
                        case 2: {
                            this.preferHex = false;
                            this.outputCharacterReference(c);
                            break;
                        }
                        case 3: {
                            this.preferHex = true;
                        }
                        default: {
                            this.outputCharacterReference(c);
                        }
                    }
                }
            }
            segstart = ++i;
        }
    }

    public void endElement() throws XPathException {
        String name = (String)this.elementStack.peek();
        --this.inScript;
        if (this.inScript == 0) {
            this.inScript = -1000000;
        }
        if (HTMLEmitter.isEmptyTag(name) && this.uriCode == 0) {
            this.elementStack.pop();
        } else {
            super.endElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        int options = properties;
        if (this.inScript > 0) {
            options |= 1;
        }
        super.characters(chars, locationId, options);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '>') continue;
            XPathException err = new XPathException("A processing instruction in HTML must not contain a > character");
            err.setErrorCode("SERE0015");
            throw err;
        }
        try {
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(32);
            this.writeCharSequence(data);
            this.writer.write(62);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    static {
        HTMLEmitter.setEmptyTag("area");
        HTMLEmitter.setEmptyTag("base");
        HTMLEmitter.setEmptyTag("basefont");
        HTMLEmitter.setEmptyTag("br");
        HTMLEmitter.setEmptyTag("col");
        HTMLEmitter.setEmptyTag("frame");
        HTMLEmitter.setEmptyTag("hr");
        HTMLEmitter.setEmptyTag("img");
        HTMLEmitter.setEmptyTag("input");
        HTMLEmitter.setEmptyTag("isindex");
        HTMLEmitter.setEmptyTag("link");
        HTMLEmitter.setEmptyTag("meta");
        HTMLEmitter.setEmptyTag("param");
        booleanAttributes = new HTMLTagHashSet(31);
        booleanCombinations = new HTMLTagHashSet(53);
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
        latin1Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }
}

