# -*- coding: utf-8 -*-
#
#  saori_cpuid.py - a saori_cpuid compatible Saori module for ninix
#  Copyright (C) 2003-2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import random
import platform

from ninix.dll import SAORI


class Saori(SAORI):

    entry = {'cpu.num': ['1', '2', '3', '5', '7', '11', '13'],
             'cpu.vender': ['Inte1', 'AM0', 'VlA'],
             'cpu.ptype': ['Lazy'],
             'cpu.family': ['780', 'Bentium', 'A+hlon'],
             'cpu.model': ['Unknown'],
             'cpu.stepping': ['Not Genuine'],
             'cpu.mmx': ['Ready', 'Not Ready'],
             'cpu.sse': ['Ready', 'Not Ready'],
             'cpu.sse2': ['Ready', 'Not Ready'],
             'cpu.tdn': ['Ready', 'Not Ready'],
             'cpu.mmx+': ['Ready', 'Not Ready'],
             'cpu.tdn+': ['Ready', 'Not Ready'],
             'cpu.clock': ['0', '1000000'],
             'cpu.clockex': ['0.001', '1.001'],
             'mem.os': ['100', '10', '44', '50', '77', '99'],
             'mem.phyt': ['0.1', '200000000'],
             'mem.phya': ['0.00000001'],
             'mem.pagt': ['1', '4'],
             'mem.paga': ['1', '4'],
             'mem.virt': ['0'],
             'mem.vira': ['0'],
            }

    def execute(self, argument):
        if not argument:
            return self.RESPONSE[400]
        if len(argument) > 1 and argument[1] == 0:
            return self.RESPONSE[204]
        value = ''
        if argument[0] == 'platform':
            value = 'ninix-aya'
        elif argument[0] == 'os.name':
            value = platform.system()
        elif argument[0] == 'os.version':
            value = platform.release()
        elif argument[0] == 'os.build':
            value = platform.version()
        elif argument[0] in self.entry: ## FIXME
            value = random.choice(self.entry[argument[0]])
        if value:
            return 'SAORI/1.0 200 OK\r\nResult: {0}\r\n\r\n'.format(value)
        else:
            return self.RESPONSE[204]
