#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys

if sys.platform != 'win32':
    raise SystemExit, 'This script is meant to be run by the Windows installer, not directly from the command line.'
if sys.argv[1] == '-install':
    # Important Notice!!
    # From inside the installer scripts MUST NOT call sys.exit() or
    # raise SystemExit, otherwise not only the script but also
    # the installer will terminate and leave things unmaintained.
    prefix = sys.prefix
    python_path = os.path.join(prefix, 'python.exe')
    pythonw_path = os.path.join(prefix, 'pythonw.exe')
#    ninix_dir = os.path.join(prefix, 'Lib/site-packages', 'ninix')
#    ico_path = os.path.join(ninix_dir, 'ninix-aya.ico')
    script_path = os.path.join(prefix, 'Scripts', 'ninix_main.py')
    try:
        desktop_path = get_special_folder_path('CSIDL_COMMON_DESKTOPDIRECTORY')
    except OSError:
        desktop_path = get_special_folder_path('CSIDL_DESKTOPDIRECTORY')
    create_shortcut(pythonw_path,
                    'ninix-aya',
                    os.path.join(desktop_path, 'ninix-aya.lnk'),
                    script_path,
#                    ninix_dir,
#                    ico_path
                    )
    file_created(os.path.join(desktop_path, 'ninix-aya.lnk'))
    try:
        start_path = get_special_folder_path('CSIDL_COMMON_PROGRAMS')
    except OSError:
        start_path = get_special_folder_path('CSIDL_PROGRAMS')
    programs_path = os.path.join(start_path, 'ninix-aya')
    try :
        os.mkdir(programs_path)
    except OSError:
        pass
    directory_created(programs_path)
    create_shortcut(pythonw_path,
                    'ninix-aya',
                    os.path.join(programs_path, 'ninix-aya.lnk'),
                    script_path,
#                    ninix_dir,
#                    ico_path
                    )
    file_created(os.path.join(programs_path, 'ninix-aya.lnk'))
    create_shortcut(python_path,
                    'ninix-aya (with python terminal)',
                    os.path.join(programs_path, 'ninix-aya-wpt.lnk'),
                    script_path,
#                    ninix_dir,
#                    ico_path
                    )
    file_created(os.path.join(programs_path, 'ninix-aya-wpt.lnk'))
    print 'Finished creating shortcuts.'
