/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef NLKT_PROFILE_MANAGER_HPP
#define NLKT_PROFILE_MANAGER_HPP

#include <vector>

#include <QWidget>

using std::vector;

class QPushButton;
class QListWidget;
class QTabWidget;
class QLineEdit;
class QComboBox;
class QTextEdit;

class ProfileManager: public QWidget
{
	Q_OBJECT

 public:
	ProfileManager(QString& profileName);

 private slots:
	void selectProfile();
	void quit();
	void deleteSelectedProfile();
	void renameSelectedProfile();
	void renewOkButtonEnabled();
	void displayTip(int);

 private:
	QString& profile;

	vector<QString> profileTips;

	QTabWidget* tabs;
	QListWidget* existingProfilesList;
	QTextEdit* profileTipWidget;
	QComboBox* layoutsCombo;
	QLineEdit* newProfileName;

	QPushButton* okButton;
	QPushButton* cancelButton;
	QPushButton* deleteProfileButton;
	QPushButton* renameProfileButton;

	void loadExistingProfilesList();
	void loadLayoutsList();

	void writeGuiSettings();
	void readGuiSettings();
};

#endif

